#ifndef __xgl_h__
#define __xgl_h__

#include "config.h"
#include "tool/tool.h"
#include "gool/gool.h"
#include "html/html.h"
#include <stdexcept>

#if defined(SKIA_BACKEND)

#include "xgl/xgl-types.h"
#include "xgl/xgl-graphics.h"
#include "xgl/xgl-window.h"

#if defined(WINDOWLESS)
  #include "lite/lite-view.h"
  #include "lite/lite-application.h"
  typedef lite::view window_processor_t;
  typedef lite::application application_base_t;

#elif defined(WINDOWS)
  #include "win/win-application.h"
  typedef mswin::application application_base_t;
  typedef mswin::window window_processor_t;

#elif defined(OSX)
  #include "osx/osx-sciter-application.h"
  typedef osx::application application_base_t;
  typedef osx::view window_processor_t;
#elif defined(LINUX)
  #include "gtk/gtk-application.h"
  typedef gtk::application application_base_t;
  typedef gtk::view window_processor_t;
#endif


namespace xgl {

  class application : public application_base_t
    , public SkAutoGraphics
  {
    typedef application_base_t super;
  public:

    static application*    instance;

    application();
    virtual ~application();

    virtual bool is_valid() { return true; }
    virtual bool mirrored_bitmaps() const override { return false; }

    virtual gool::font* create_font(const ustring& name
      , float size
      , uint weight = 400
      , bool italic = false
      , gool::FONT_RENDERING  mode = gool::FR_VECTOR) {
        return do_create_font(name, size, weight, italic, mode, nullptr);
      }

    virtual gool::font* do_create_font(const ustring& name
      , float size
      , uint weight
      , bool italic
      , gool::FONT_RENDERING  mode
      , ref<SkTypeface> typeface);

#if defined(OSX)
    virtual gool::font*        register_font( CTFontRef pf );
    virtual CF::ref<CTFontRef> ctfont(gool::font* pf);
#endif
      
    virtual void clear_font_cache() override ;

    virtual bool supports_filters() const { return true; }

    virtual tool::ustring get_supported_font_family(const tool::ustring& family_name_list);

    virtual bool install_font(const tool::ustring& name, int weight, bool italic, tool::bytes data) override
    {
        return install_memory_font(name, weight, italic, data);
    }
    virtual bool construct_font_collection_for(memory_font_variant& fv) override;

    virtual bool get_used_font(
      tool::handle<gool::font>& pf,
      tool::wchars family_name_list, const gool::font* proto,
      tool::wchars lang_id,
      WRITING_SCRIPT script,
      uint char_code = 0);

    virtual window_processor_t* create_window_processor(const window_params& params);

    virtual gool::path*     create_path() override;

    virtual gool::graphics* create_bitmap_graphics(gool::graphics *proto, gool::bitmap *bmp, gool::argb initc) override;
    virtual gool::graphics* create_bitmap_bits_graphics(gool::bitmap* bmp, gool::argb initc, bool high_quality = false) override;

    virtual gool::GRAPHICS_CAPS graphics_caps() const { return gool::SOFTWARE_GRAPHICS; }

    virtual handle<html::view> create_frame(const window_params& params) override;
    virtual handle<html::view> create_dialog(const window_params& params) override;

    //virtual gool::text_layout* create_text_layout(tool::wchars text, const gool::text_format& tf) override;

/*#ifdef WIC_SUPPORT
    virtual IWICImagingFactory*   wic_factory() const override { return nullptr; }
#endif*/
      virtual void      get_system_font(/*inout*/ ustring& name, /*out*/int& size, /*out*/ uint& weight, /*out*/bool& italic) override;

      // list all installed font families:
      virtual bool
        each_font_family(function<bool(wchars name)>  cb, function<void(ucode, ucode)> cb_ranges_or_null);

  protected:

    tool::wchars system_fontname();

    virtual bool init_font(gool::font* pfont) override {
      return do_init_font(pfont,nullptr);
    }
   bool do_init_font(gool::font* pfont, ref<SkTypeface> typeface);
    static wchars fallback_list(wchars lang_id, WRITING_SCRIPT script, bool serif);

    bool get_supported_font_family(wchars family_name_list,
      const function<bool(wchars)>& cb,
      tool::wchars lang_id,
      WRITING_SCRIPT script,
      uint          char_code,
      tristate_v serif = tristate_v()
    ); // cb shall return true if it accepts the family

    handle_pool<xgl::font> _fonts;

  };

  application* app_factory();

}

#endif

#endif


