
#ifndef __XGL_WINDOW_H_INCLUDED__
#define __XGL_WINDOW_H_INCLUDED__

#include "config.h"

#if defined(SKIA_BACKEND)

#include "tool/tool.h"
#include "gool/gool.h"
#include "html/html.h"
#include "xgl-graphics.h"

#if defined(WINDOWLESS)
  #include "lite/lite-view.h"
  typedef lite::view sciter_window_base_t;
  typedef lite::popup sciter_popup_base_t;
#elif defined(WINDOWS)
  #include "win/win-view.h"
  #include "win/win-frame.h"
  typedef mswin::window sciter_window_base_t;
  typedef mswin::popup sciter_popup_base_t;
#elif defined(OSX)
  #include "osx/osx-sciter-view.h"
  #include "osx/osx-sciter-popup.h"
  typedef osx::view sciter_window_base_t;
  typedef osx::popup sciter_popup_base_t;
#elif defined(LINUX)
  #include "gtk/gtk-view.h"
  #include "gtk/gtk-popup.h"
  typedef gtk::view sciter_window_base_t;
  typedef gtk::popup sciter_popup_base_t;
#endif

#include "xgl-window-base.h"

class GrContext;
struct GrGLInterface;
class GrRenderTarget;
class SkCanvas;

namespace xgl {

  using namespace tool;
  using namespace gool;
  using namespace html;

  class window : public sciter_window_base_t
  {
    typedef sciter_window_base_t super;
  public:

    window(const window_params& params);

    static const wchar* class_name_suffix() { return W("-SKIA"); }

    virtual bool needs_opengl() const;
    virtual bool must_use_raster() const;

    virtual bool needs_full_window_refresh() const override { return needs_opengl() && !must_use_raster(); }

    virtual gool::graphics* surface() override;

    virtual GRAPHICS_CAPS graphics_caps() const override;
    virtual ustring       graphics_backend() const override;

    //virtual bool uses_physical_size() const { return true; }

    virtual void on_size( size sz ) override;

    //virtual void attached() override { super::attached(); }

    virtual void detached(HWINDOW hw) override {
      if (_device) {
        _device->detach();
        _device = nullptr;
      }
      super::detached(hw);
    }
      
    virtual void release_backend() {
        if (_device) {
            _device->detach();
            _device = nullptr;
        }
    }

    virtual void start(const window_params& params) override;
    virtual void stop() override {
      release_backend();
      super::stop();
    }

    /*
    virtual void on_start_ui_replacement(tristate_v sizing) {
      super::on_start_ui_replacement(sizing);
      if (sizing) {
        _is_resizing = true;
        if (_device && _device->isGpu() && needs_opengl()) {
          _device->detach();
          _device = nullptr;
          refresh();
        }
      }
    }virtual void on_end_ui_replacement(tristate_v sizing) {
      super::on_end_ui_replacement(sizing);
       if (sizing) {
        _is_resizing = false;
        if (_device && _device->isRaster() && needs_opengl()) {
          _device->detach();
          _device = nullptr;
          refresh();
        }
      }
    } */

    virtual bool render(void* dc, rect client_rc);
    virtual bool render_on( gool::graphics* gfx, rect paint_rc = rect() );
    virtual bool render_layered(void *dc, rect client_rc);
    //virtual bool render(rect paint_rc);
    virtual bool render_element(element* p, bool front_layer);
    virtual bool render_element_on(element* p, gool::graphics* gfx);

    virtual bool render_opengl(element* p, bool front_layer) override;

    //virtual void test_gfx_paint( point pos ); // for testing purposes

    virtual bool get_transparency() const override {
        return !!_is_transparent || is_layered() ;
    }
    virtual void set_transparency ( bool on_off ) override
    {
      if( on_off != !!_is_transparent ) {
        window_frame_updater _(this);
        _is_transparent = on_off;
        _gfx = 0;
        _device = nullptr;
      }
    }

    virtual void  refresh(const rect& area) override {
      if(_device)
        _device->refresh(this,area);
      else
        super::refresh(area);
      //request_render_layered();
    }
    virtual void  refresh() override {
       refresh(rect(client_dim()));
    }

    virtual void on_dpi_changed(size dpi, rect proposed_window_rect) override {
        if(_device)
          _device->on_dpi_change();
        //update_request();
        super::on_dpi_changed(dpi, proposed_window_rect);
        on_size(client_dim());
    }

    void enable_vsync(bool enable) {
        if(_device) _device->enable_vsync(enable);
    }

    bool setup_backend();

    virtual void      set_layered(bool onoff) {
      super::set_layered(onoff);
      _gfx = 0;
      notify_media_change();
      //setup_backend();
/*      if(_device) {
        _device->detach();
        _device = nullptr;
      } */
    }

    virtual bool update_request() {
      if(_device)
         return _device->update_request();
      return false;
    }

    virtual bool      set_frame_type(FRAME_TYPE on) override { _gfx = 0; return super::set_frame_type(on); }

    virtual sciter_popup_base_t* create_popup() override;
    //virtual gool::text_layout*   create_text_layout(tool::wchars text, const gool::text_format& tf) override;

 #if !defined(CORETEXT_LAYOUT)
    virtual void setup_text_flow( html::element* elem, html::tflow::text_flow& tf, tool::slice< tool::handle<html::node> > nodes ) override;
#endif
    virtual void draw_glyph_run( gool::graphics* gfx, const html::tflow::text_flow& tf, const html::tflow::glyph_run& gr, gool::pointf at, argb color, const style* run_style) override;


  protected:
    //sizef                 _dpi_scale; // how much to scale a design that assumes 96-DPI pixels
    handle<graphics>        _gfx;
    tristate_v              _is_transparent;
    //GRAPHICS_CAPS           _used_graphics;
    tristate_v              _done_drawing;
    GRAPHICS_CAPS           _requested_graphics;
    handle<BackendDevice>   _device;
    bool                    _is_resizing = false;

  };

#if defined(WINDOWS) && !defined(WINDOWLESS)
  typedef mswin::frame<window> frame;
  typedef mswin::dialog<window> dialog;
#endif

  class popup: public sciter_popup_base_t
  {
    typedef sciter_popup_base_t super;
    friend class window;
  protected:
    popup() : _surface(nullptr) {}
    virtual ~popup() {}
  public:

    // iwindow stuff:
    virtual graphics* surface() override { return _surface; }

    //virtual bool uses_physical_size() const { return true; }

            bool render_on(gool::graphics* pg, rect paint_rc);
    virtual bool render(void* dc, gool::rect dirty_rc) override;
    virtual bool render_layered(void *dc, rect client_rc) override;

            bool setup_backend();
    virtual void attached(HWINDOW hw) override; // got HWINDOW
    virtual void detached(HWINDOW hw) override; // lost HWINDOW

    //virtual void post_request_render_layered() override {  //osx_iwindow_refresh(this, gool::rect(client_dim()));
    //  this->exec( [this] { this->render_layered(); return true; } );
    //}

  protected:
    handle<BackendDevice>   _device;
    xgl::graphics*          _surface;
  };



}
#endif // SKIA_BACKEND
#endif // __XGL_WINDOW_H_INCLUDED__
