
#include "xgl-window-base.h"
#include "xgl-window.h"

#include "xgl/skia/include/gpu/GrRenderTarget.h"


namespace xgl {

  GRAPHICS_CAPS requested_caps(const window_params& params)
  {
#if defined(WINDOWS)
    if(tool::environment::get_os_version() < environment::WIN_VISTA)
      return GRAPHICS_CAPS::SKIA_GRAPHICS;
#elif defined(ANDROID) || defined(WINDOWLESS) 
    return GRAPHICS_CAPS::SKIA_OPENGL_GRAPHICS;
#endif
    switch (params.window_type) {
      default:
      case UNDEFINED_WINDOW_TYPE:
      case TOOLTIP_WINDOW:
      case CHILD_WINDOW:
      case PRINT_VIEW:         return GRAPHICS_CAPS::SKIA_GRAPHICS;

      case POPUP_WINDOW:
      case TOOL_WINDOW:
      case FRAME_WINDOW:
      case DIALOG_WINDOW:      return app()->requested_gfx_layer == GRAPHICS_CAPS::SKIA_OPENGL_GRAPHICS ? GRAPHICS_CAPS::SKIA_OPENGL_GRAPHICS : GRAPHICS_CAPS::SKIA_GRAPHICS;
    }
  }

  window::window(const window_params& params): super(params), _requested_graphics(requested_caps(params)) {
  }

  void window::start(const window_params& params) {
    super::start(params);
  }

  bool window::needs_opengl() const {
    return _requested_graphics == GRAPHICS_CAPS::SKIA_OPENGL_GRAPHICS;
  }

  bool window::must_use_raster() const {

#if defined(WINDOWS)
    if(get_frame_type() == LAYERED)
        return true;
#endif
    return _requested_graphics != GRAPHICS_CAPS::SKIA_OPENGL_GRAPHICS;
  }
  
  bool window::setup_backend() {
    if(needs_opengl() && !must_use_raster())
    {
      _device = new DeviceOpenGL(this);
      if (!_device)
        return false;
      if (_device->attach())
         return true;
      // no luck, fallback to raster
    }
    _device = new DeviceRaster(this);
    return _device->attach();
    //return false;
  }

  GRAPHICS_CAPS window::graphics_caps() const {
    if (!_device) {
      const_cast<window*>(this)->setup_backend();
      //if(needs_opengl() && !must_use_raster())
      //   return SKIA_OPENGL_GRAPHICS;
      // else
      //   return SKIA_GRAPHICS;
    }

    if (!_device)
      return UNKNOWN_GRAPHICS;
    if (_device->isGpu())
      return SKIA_OPENGL_GRAPHICS;
    return SKIA_GRAPHICS;
  }

  ustring  window::graphics_backend() const {
    switch (graphics_caps()) {
      default:
      case UNKNOWN_GRAPHICS: return ustring(W("{unknown}"));
      case SKIA_OPENGL_GRAPHICS: return ustring(W("skia-opengl"));
      case SKIA_GRAPHICS: return ustring(W("skia"));
    }
  }

  gool::graphics* window::surface()  {
    return _gfx;
  }

  void window::on_size(size sz)
  {
    super::on_size(sz);
    if (_device) {
      float backing_scale = _device->backing_scale();
      _device->resize(int(sz.x * backing_scale), int(sz.y * backing_scale));
    }
  }
    

  bool window::render_on(gool::graphics* pg, rect paint_rc)
  {
    if (!doc())
      return false;

    xgl::graphics* gfx = static_cast<xgl::graphics*>(pg);

    auto_state<bool> _1(is_painting, true);
    auto_state< handle<graphics> > _2(_gfx, gfx);

    //commit_update() WRONG - will do refresh()

    uint level = gfx->push_state();

    {
      gfx->set_clip_rc(dimension());
      //if (GLASSY == get_frame_type())
      //  gfx->text_paint.setLCDRenderText(false);
      paint();

    }

    gfx->restore_state(level);

    return true;
  }

  bool window::render_opengl(element* pel, bool front_layer)
  {
    if (!_device || ! _device->isGpu())
    {
      _device = new DeviceOpenGL(this);
      if (!_device)
        return false;
      if (!_device->attach())
        return false;
    }

    if (_device) {
      rect rc = this->client_dim();
      auto painter = [this, front_layer](graphics* pg, element* pel) {

        xgl::graphics* gfx = static_cast<xgl::graphics*>(pg);

        auto_state<bool> _1(is_painting, true);
        auto_state< handle<graphics> > _2(_gfx, gfx);

        commit_update();

        uint level = gfx->push_state();
    
        this->paint(pel, front_layer);
        
        gfx->restore_state(level);
        return true;
      };
      return _device->render_layer(pel ? pel : doc(),painter, rc);
    }
    return false;
  }

  bool window::render_layered(void *dc, rect client_rc)
  {
    bool r = false;
    if (!_device /*|| ! _device->isGpu()*/)
      setup_backend();

    if (_device) {
      rect rc = this->client_dim();
      auto painter = [this, rc](graphics* gfx) { return this->render_on(gfx, rc); };
      r = _device->render_layered(painter, rc);
    }
    super::render_layered(dc,client_rc);
    return r;
  }
  bool window::render(void* dc, rect client_rc)
  {
      //if( view::get_window_state() == WINDOW_HIDDEN  )
      //    return false;

    if (!_device /*|| !_device->isGpu()*/)
        setup_backend();

/*#if defined(WINDOWS)
    if (has_animations())
      on_animation_tick();
    check_timers_overdue_in_all_views();
#endif

    if(this->is_layered())
      return render_layered();*/

    if (_device) {
        auto painter = [this, client_rc](graphics* gfx) { return this->render_on(gfx, client_rc); };
        return _device->render(painter, client_rc, dc);
    }
    return false;
  }
  bool window::render_element(element* pel, bool front_layer)
  {
    if (!_device || !_device->isGpu())
    {
      _device = new DeviceOpenGL(this);
      if (!_device)
        return false;
      if (!_device->attach())
        return false;
    }

    if (_device) {
      rect rc = this->client_dim();
      auto painter = [this, front_layer](graphics* pg, element* pel) {

        xgl::graphics* gfx = static_cast<xgl::graphics*>(pg);

        auto_state<bool> _1(is_painting, true);
        auto_state< handle<graphics> > _2(_gfx, gfx);

        commit_update();

        uint level = gfx->push_state();

        this->paint(pel, front_layer);

        gfx->restore_state(level);
        return true;
      };
      return _device->render_layer(pel ? pel : doc(), painter, rc);
    }
    return false;
  }
  bool window::render_element_on(element* pel, gool::graphics* pg)
  {
/*
    xgl::graphics* gfx = static_cast<xgl::graphics*>(pg);

    auto_state<bool> _1(is_painting, true);
    auto_state< handle<graphics> > _2(_gfx, gfx);

    commit_update();

    uint level = gfx->push_state();

    this->paint(pel);

    gfx->restore_state(level); */

    assert(false);
    return false;
  }

/*  gool::text_layout* window::create_text_layout(tool::wchars text, const gool::text_format& tf)
  {
    xgl::text_layout* pl = new xgl::text_layout();
    pl->set(*this, text, tf, app);
    return pl;
  } */

}




