#include "xgl-window-base.h"

#include "xgl/skia/include/gpu/gl/GrGLInterface.h"
#include "xgl/skia/include/gpu/GrContext.h"
#include "xgl/skia/src/gpu/gl/GrGLUtil.h"
#include "xgl/skia/include/gpu/SkGr.h"
#include "../gtk/gtk-view.h"

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>

#include <GL/gl.h>
#include <GL/glx.h>

#include <cairo.h>

namespace xgl {


//| "primitive" raster device - rasterization by CPU in memory
  float BackendDevice::backing_scale() const { return 1; }

  void BackendDevice::on_dpi_change() {}


  bool DeviceRaster::render_layered(function<bool(xgl::graphics* gfx)> painter, gool::rect paint_rc, void* hdc)
  {
#if 1
    return false;
 #else
    size dim(this->width(), this->height());

    if (dim.empty())
      return false;

    //if (paint_rc.empty())
    //  return false;

    dib32 dib(dim);

    SkImageInfo info = SkImageInfo::MakeN32Premul(dim.x, dim.y);
    fBitmap.setInfo(info);
    fBitmap.setPixels(dib.bits());

    HWND hwnd = this->getHWnd();

    mswin::layered_window_ctx lwctx(dim);
    {
      xgl::ref<SkCanvas> canvas = new SkCanvas(fBitmap);
      canvas->ref();
      handle<xgl::graphics> gfx = new xgl::graphics(canvas);
      gfx->text_paint.setLCDRenderText(false);
      //gfx->offset(-paint_rc.origin);
      gfx->set_clip_rc(dim);
      painter(gfx);
    }

    lwctx.update(hwnd, dib.DC());
    fBitmap.reset();

    return true;
#endif
  }

  static cairo_format_t
  sk_config_to_format (SkColorType config)
  {
      switch (config) {
        case kRGBA_8888_SkColorType:
        case kBGRA_8888_SkColorType: return CAIRO_FORMAT_ARGB32;
        case kAlpha_8_SkColorType:   return CAIRO_FORMAT_A8;
        default:
        assert(false);
        return (cairo_format_t) -1;
        }
  }

  bool DeviceRaster::present(rect paint_rc, void* hdc)
  {

#if 0
    SkBitmap out;
    SkImageInfo out_info = SkImageInfo::Make(fBitmap.width (), fBitmap.height (), kBGRA_8888_SkColorType,kPremul_SkAlphaType);
    out.setInfo(out_info);
    out.allocPixels();

    fBitmap.copyTo(&out);

	cairo_surface_t * image_surface =
	    cairo_image_surface_create_for_data ( out.getPixels(),
						 CAIRO_FORMAT_ARGB32,
						 out.width (),
						 out.height (),
						 out.rowBytes ());
    cairo_set_source_surface (static_cast<cairo_t*>(hdc) , image_surface, paint_rc.origin.x, paint_rc.origin.y);
    cairo_paint(static_cast<cairo_t*>(hdc));
    cairo_surface_finish (image_surface);
    cairo_surface_destroy(image_surface);
    return true;

#else
    slice<gool::argb> in( (const gool::argb*) fBitmap.getPixels(), fBitmap.width () * fBitmap.height ());

    array<gool::argb> buf = in;

    gool::argb* p = buf.begin();
    gool::argb* pe = buf.end();

    for(; p < pe; ++p )
      swap( p->red, p->blue );


	cairo_surface_t * image_surface =
	    cairo_image_surface_create_for_data ( (byte*) buf.begin(),
						 CAIRO_FORMAT_ARGB32,
						 fBitmap.width (),
						 fBitmap.height (),
						 fBitmap.rowBytes ());
    cairo_set_source_surface (static_cast<cairo_t*>(hdc) , image_surface, paint_rc.origin.x, paint_rc.origin.y);
    cairo_paint(static_cast<cairo_t*>(hdc));
    cairo_surface_finish (image_surface);
    cairo_surface_destroy(image_surface);
    return true;
#endif
  }

//| OpenGL device:

  void  DeviceOpenGL::refresh(iwindow* self, const rect& area)
  {
    //self->iwindow::refresh(area);
    //self->request_render_layered();
    GtkWidget* widget = this->getHWnd();
    gtk_gl_area_queue_render(GTK_GL_AREA(widget));
  }


  void DeviceOpenGL::enable_vsync(bool enable)
  {
    // TODO: GLX_EXT_swap_control, glXSwapIntervalEXT(1)
  }

  bool DeviceOpenGL::init()
  {
    if(!fGLContext)
    {
      GtkWidget* widget = this->getHWnd();
      gtk_gl_area_set_has_depth_buffer (GTK_GL_AREA(widget), FALSE);
      gtk_gl_area_set_has_stencil_buffer (GTK_GL_AREA(widget), FALSE);
      gtk_gl_area_set_has_alpha(GTK_GL_AREA(widget), FALSE);
      //gtk_gl_area_set_use_es(GTK_GL_AREA(widget), TRUE);
      //gtk_gl_area_attach_buffers(GTK_GL_AREA(widget));
      gtk_gl_area_set_auto_render(GTK_GL_AREA(widget),TRUE);

      fGLContext = gtk_gl_area_get_context(GTK_GL_AREA(widget));

      GError *er = nullptr;

      if(fGLContext) {
        gtk_gl_area_make_current (GTK_GL_AREA(widget));
        glViewport(0, 0, width(), height());
        glClearColor(0, 0, 0, 0);
        glClearStencil(0);
        glClear(GL_STENCIL_BUFFER_BIT | GL_COLOR_BUFFER_BIT);
        return true;
      } else {
         er = gtk_gl_area_get_error(GTK_GL_AREA(widget));
      }
      er = er;
      return false;
    }

  }

  bool DeviceOpenGL::attach() {
#if 1
    super::resize(this->width(), this->height());
//    if(!init())
//      return false;

    //SkAutoTUnref<SkSurface> surface(createSurface());
    return true;
#else
    super::resize(this->width(), this->height());
    init();
    HDC hdc = GetDC(getHWnd());
    wglMakeCurrent(HDC(hdc), (HGLRC)fHGLRC);
    ReleaseDC(getHWnd(), hdc);
    SkAutoTUnref<SkSurface> surface(createSurface());
    return true;
#endif
  }

  bool DeviceOpenGL::detach() {
#if 0
    if(fXWindow && fGLContext) {
      auto dpy = GDK_WINDOW_XDISPLAY(fXWindow);
      glXMakeCurrent(dpy, None, nullptr);
      glXDestroyContext(dpy, fGLContext);
    }
#endif
    if(fGLContext) {
      SkSafeUnref(fRenderTarget);
      SkSafeUnref(fContext);
      SkSafeUnref(fInterface);
      fGLContext = nullptr;
    }
    //fXWindow = nullptr;

    return true;
  }

  bool DeviceOpenGL::present() {
    if(fGLContext) {
      glFlush();
      //glXSwapBuffers(GDK_WINDOW_XDISPLAY(fXWindow), GDK_WINDOW_XID(fXWindow));
    }
    return true;
  }

  void DeviceOpenGL::setUpRenderTarget()
  {

    GtkWidget* widget = this->getHWnd();
    gtk_gl_area_make_current (GTK_GL_AREA(widget));

    SkSafeUnref(fRenderTarget);
    GrBackendRenderTargetDesc desc;
    desc.fWidth = (this->width());
    desc.fHeight = (this->height());
    desc.fConfig = kSkia8888_GrPixelConfig;
    desc.fOrigin = kBottomLeft_GrSurfaceOrigin;
    desc.fSampleCnt = fAttachmentInfo.fSampleCount;
    desc.fStencilBits = fAttachmentInfo.fStencilBits ? fAttachmentInfo.fStencilBits : 8;
    GrGLint buffer;
    GR_GL_GetIntegerv(fInterface, GR_GL_FRAMEBUFFER_BINDING, &buffer);
    desc.fRenderTargetHandle = buffer;
    this->fRenderTarget = fContext->textureProvider()->wrapBackendRenderTarget(desc);

    //gtk_gl_area_attach_buffers(GTK_GL_AREA(widget));
    //gtk_gl_area_queue_render(GTK_GL_AREA(widget));

  }

  bool DeviceOpenGL::update_request() { return false; }

  void DeviceOpenGL::start_drawing() { }

  bool DeviceOpenGL::render(function<bool(xgl::graphics* gfx)> painter, gool::rect paint_rc, void* hdc) {
    if (paint_rc.empty()) {
      assert(false);
      return false;
    }

    //glClearColor (0, 0, 0, 0);
    //glClearStencil(0);
    //glClear (GL_STENCIL_BUFFER_BIT | GL_COLOR_BUFFER_BIT);
    SkAutoTUnref<SkSurface> surface(createSurface());
    if(!surface)
      return false;
    SkCanvas* canvas = surface->getCanvas();
    if(!canvas) {
      //glXMakeCurrent(GDK_WINDOW_XDISPLAY(fXWindow), None, nullptr);
      //puts("no canvas!");
      return false;
    }

    SkAutoCanvasRestore acr(canvas, true);

    SkIRect ir;  ir.set(0, 0, this->width(), this->height());

    //SkRegion dirty(ir);
    //canvas->clipRegion(dirty);

    //canvas->clear(SK_ColorRED);

    {
      handle<xgl::graphics> gfx = new xgl::graphics(canvas);
      gfx->set_clip_rc(paint_rc);
      gfx->begin_drawing();
      painter(gfx);
      gfx->end_drawing();
    }

    //SkRect rr = SkRect::MakeXYWH(0,0,this->width()/2, this->height()/2);
    //SkPaint paint;
    //paint.setColor(SK_ColorRED);
    //canvas->drawRect(rr,paint);
    //canvas->clear(SK_ColorRED);

    fContext->flush();

    present();

    return true;
  }


}
