//
//  xgl-window-base-mac.m
//  
//
//  Created by Andrew Fedoniouk on 2016-06-25.
//
//

#ifndef WINDOWLESS

#import <Foundation/Foundation.h>

#include <OpenGL/gl.h>
#include <OpenGL/glu.h>
#include <OpenGL/glext.h>
#include <GLUT/glut.h>

#include "xgl-window-base.h"
#include "xgl/skia/include/gpu/gl/GrGLInterface.h"
#include "xgl/skia/include/gpu/GrContext.h"
#include "xgl/skia/src/gpu/gl/GrGLUtil.h"
#include "xgl/skia/include/gpu/SkGr.h"
#include "xgl/skia/include/utils/mac/SkCGUtils.h"

namespace xgl
{
    
  float BackendDevice::backing_scale() const
  {
     NSView* nsv = (NSView*)fWindow->get_hwnd();
     NSWindow* nsw = [nsv window];
     return [nsw backingScaleFactor];
  }
  void BackendDevice::on_dpi_change()
  {
      NSView* nsv = (NSView*)fWindow->get_hwnd();
      NSWindow* nsw = [nsv window];
      
      if( nsv.layer )
          nsv.layer.contentsScale = [nsw backingScaleFactor];
  }

    
  void CGDrawSkBitmap(CGContextRef cg, const SkBitmap& bm, float x, float y, float scaling) {
      CGImageRef img = SkCreateCGImageRef(bm);
        
      if (img) {
            CGRect r = CGRectMake(0, 0, bm.width() / scaling, bm.height() / scaling );
            
            CGContextSaveGState(cg);
            CGContextTranslateCTM(cg, x, r.size.height + y);
            CGContextScaleCTM(cg, 1, -1);
            CGContextDrawImage(cg, r, img);
            
            CGContextRestoreGState(cg);
            
            CGImageRelease(img);
        }
    }
    
  bool DeviceRaster::render_layered(function<bool(xgl::graphics* gfx)> painter, gool::rect paint_rc, void* hdc)
  {
      size dim(this->width(), this->height());
      return render(painter, rect::make_xywh(0,0,dim.x,dim.y), hdc);
  }

  bool DeviceRaster::present(rect paint_rc, void* hdc)
  {
    CGContextRef cg = (CGContextRef) [[NSGraphicsContext currentContext] graphicsPort];
    CGDrawSkBitmap(cg,fBitmap,paint_rc.s.x,paint_rc.s.y, backing_scale());
    return true;
  }

  CGLContextObj createGLContext(int msaaSampleCount)
  {
      GLint major, minor;
      CGLGetVersion(&major, &minor);
      
      /*static const CGLPixelFormatAttribute attributes[] = {
          kCGLPFAStencilSize, (CGLPixelFormatAttribute) 8,
          kCGLPFAAccelerated,
          kCGLPFADoubleBuffer,
          kCGLPFAOpenGLProfile, (CGLPixelFormatAttribute) kCGLOGLPVersion_3_2_Core,
          //kCGLPFABackingStore,
          (CGLPixelFormatAttribute)0
      };*/
      static const CGLPixelFormatAttribute attributes[] = {
      #if MAC_OS_X_VERSION_10_7
         kCGLPFAOpenGLProfile, (CGLPixelFormatAttribute) kCGLOGLPVersion_3_2_Core,
      #endif
         kCGLPFADoubleBuffer,
         kCGLPFAAllowOfflineRenderers,
         (CGLPixelFormatAttribute)0
      };
      
      CGLPixelFormatObj format = nullptr;
      GLint npix = 0;
      if (msaaSampleCount > 0) {
          static const int kAttributeCount = SK_ARRAY_COUNT(attributes);
          CGLPixelFormatAttribute msaaAttributes[kAttributeCount + 5];
          memcpy(msaaAttributes, attributes, sizeof(attributes));
          SkASSERT(0 == msaaAttributes[kAttributeCount - 1]);
          msaaAttributes[kAttributeCount - 1] = kCGLPFASampleBuffers;
          msaaAttributes[kAttributeCount + 0] = (CGLPixelFormatAttribute)1;
          msaaAttributes[kAttributeCount + 1] = kCGLPFAMultisample;
          msaaAttributes[kAttributeCount + 2] = kCGLPFASamples;
          msaaAttributes[kAttributeCount + 3] =
          (CGLPixelFormatAttribute)msaaSampleCount;
          msaaAttributes[kAttributeCount + 4] = (CGLPixelFormatAttribute)0;
          CGLChoosePixelFormat(msaaAttributes, &format, &npix);
      }
      if (!npix) {
          CGLChoosePixelFormat(attributes, &format, &npix);
      }
      if(format) {
        CGLContextObj ctx;
        auto r = CGLCreateContext(format, NULL, &ctx);
        CGLReleasePixelFormat(format);
        if( r == kCGLNoError ) {
          GLint interval = 1;
          CGLSetParameter(ctx, kCGLCPSwapInterval, &interval);
          CGLSetCurrentContext(ctx);
        }
        return ctx;
      }
      return nullptr;
  }
      
  bool DeviceOpenGL::init()
  {
      NSView *nsview = (NSView *)this->getHWnd();
      
      assert(nsview);
      
      //[[nsview superview]setAutoresizingMask:NSViewWidthSizable|NSViewHeightSizable];

      detach();
      
      int sampleCount = 0;
      CGLContextObj ctx = createGLContext(sampleCount);
      SkASSERT(ctx);
      fGLContext = [[NSOpenGLContext alloc] initWithCGLContextObj:ctx];
      CGLDestroyContext(ctx);
      if (!fGLContext)
        return false;
      
      [(NSOpenGLContext*)fGLContext setView: nsview];
      
      [(NSOpenGLContext*)fGLContext makeCurrentContext];
      CGLPixelFormatObj format = CGLGetPixelFormat((CGLContextObj)[(NSOpenGLContext*)fGLContext CGLContextObj]);
      CGLDescribePixelFormat(format, 0, kCGLPFASamples, &fAttachmentInfo.fSampleCount);
      CGLDescribePixelFormat(format, 0, kCGLPFAStencilSize, &fAttachmentInfo.fStencilBits);
      NSSize size;
      size.width = this->width();
      size.height = this->height();
      glViewport(0, 0, (int) size.width, (int) size.height);
      glClearColor(0, 0, 0, 0);
      glClearStencil(0);
      glClear(GL_COLOR_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);
 
      GLint opacity = 0;
      [(NSOpenGLContext*)fGLContext setValues:&opacity forParameter:NSOpenGLCPSurfaceOpacity];

      return true;
  }

    bool DeviceOpenGL::render(function<bool(xgl::graphics* gfx)> painter, gool::rect paint_rc, void* hdc) {
        
       if (this->width() == 0 || this->height() == 0)
            return false;
        
        [(NSOpenGLContext*)fGLContext makeCurrentContext];
        
        
        //GLint opacity = 0;
        //[(NSOpenGLContext*)fGLContext setValues:&opacity forParameter:NSOpenGLCPSurfaceOpacity];
          //glClearColor(0, 0, 0, 0);
          //glClearStencil(0);
          //glClear(GL_COLOR_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);
        
        SkAutoTUnref<SkSurface> surface(createSurface());
        SkCanvas* canvas = surface->getCanvas();
        
        if (!canvas) {
            [NSOpenGLContext clearCurrentContext];
            return false;
        }
        
        SkAutoCanvasRestore acr(canvas, true);
        
        float scale = this->backing_scale();
        
        {
            rect area = rect::make_xywh(0,0, this->width(), this->height() );
            handle<xgl::graphics> gfx = new xgl::graphics(canvas,fIsTransparent);
            gfx->set_clip_rc(area);
            gfx->scale(scale);
            //gfx->fill(argb(0,0,0,0), area);
            gfx->begin_drawing();
            painter(gfx);
            gfx->end_drawing();
        }
        fContext->flush();
        
        present();
        
        [NSOpenGLContext clearCurrentContext];
        
        return true;
    }
    
    
  bool DeviceOpenGL::present() {
      if (fGLContext)
         [(NSOpenGLContext*)fGLContext flushBuffer];
      return true;
  }


  #define OS_VERSION(ma,mi) ( (ma << 16) | mi )
  
  static int os_version() {
      static int v = 0;
      if( !v ) {
          NSProcessInfo *pinfo = [NSProcessInfo processInfo];
          if([pinfo respondsToSelector : @selector(operatingSystemVersion)])
          {
            NSOperatingSystemVersion pver = [pinfo operatingSystemVersion];
            v = OS_VERSION(pver.majorVersion,pver.minorVersion);
          }
          else
              v = OS_VERSION(10,10);
      }
      return v;
  }


  void  DeviceOpenGL::refresh(iwindow* self, const rect& area)
  {
    if( os_version() <= OS_VERSION(10,13) || fWindow->is_layered() )
      fWindow->request_render();
    else
        super::refresh(self,area);
  }
    
  bool DeviceOpenGL::attach() {

    NSView *nsview = (NSView *)this->getHWnd();
      
    [nsview setWantsBestResolutionOpenGLSurface:YES];
      
    super::resize(this->width(),this->height());
    return init();
  }
      
  bool DeviceOpenGL::detach() {
      if(fGLContext) {
        SkSafeUnref(fRenderTarget); fRenderTarget = nullptr;
        SkSafeUnref(fContext);      fContext = nullptr;
        SkSafeUnref(fInterface);    fInterface = nullptr;
        [NSOpenGLContext clearCurrentContext];
        [(NSOpenGLContext*)fGLContext clearDrawable];
        [(NSOpenGLContext*)fGLContext release];
        fGLContext = nullptr;
      }
      return true;
  }

  void DeviceOpenGL::start_drawing()
  {
    NSOpenGLContext* context = (NSOpenGLContext*)fGLContext;
    if ([context view] != getHWnd()) {
        [context setView: (NSView*) getHWnd()];
    }
    [context makeCurrentContext];
  }

  bool DeviceOpenGL::update_request()
  {
      [(NSOpenGLContext*)fGLContext update];
      return true;
  }
      
  void DeviceOpenGL::enable_vsync(bool enable)
  {
      if (fGLContext) {
          GLint interval = enable ? 1 : 0;
          CGLContextObj ctx = (CGLContextObj)[(NSOpenGLContext*)fGLContext CGLContextObj];
          CGLSetParameter(ctx, kCGLCPSwapInterval, &interval);
      }
  }

  void DeviceOpenGL::setUpRenderTarget()
  {
      SkSafeUnref(fRenderTarget);

      GrBackendRenderTargetDesc desc;
      desc.fWidth = this->width();
      desc.fHeight = this->height();
      // TODO: Query the actual framebuffer for sRGB capable. However, to
      // preserve old (fake-linear) behavior, we don't do this. Instead, rely
      // on the flag (currently driven via 'C' mode in SampleApp).
      //
      // Also, we may not have real sRGB support (ANGLE, in particular), so check for
      // that, and fall back to L32:
      //
      // ... and, if we're using a 10-bit/channel FB0, it doesn't do sRGB conversion on write,
      // so pretend that it's non-sRGB 8888:
      
      desc.fConfig =
      //  fContext->caps()->srgbSupport() &&
      //  SkImageInfoIsGammaCorrect(info()) &&
      //  (fAttachmentInfo.fColorBits != 30)
      //    ? kSkiaGamma8888_GrPixelConfig : kSkia8888_GrPixelConfig;
        kSkia8888_GrPixelConfig;
      desc.fOrigin = kBottomLeft_GrSurfaceOrigin;
      desc.fSampleCnt = fAttachmentInfo.fSampleCount;
      desc.fStencilBits = fAttachmentInfo.fStencilBits;
      GrGLint buffer;
      GR_GL_GetIntegerv(fInterface, GR_GL_FRAMEBUFFER_BINDING, &buffer);
      desc.fRenderTargetHandle = buffer;
      fRenderTarget = this->fContext->wrapBackendRenderTarget(desc);
      if (fGLContext) {
          //glClear(GL_COLOR_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);
          GLint wh[2] = { width(), height() };
          [(NSOpenGLContext*)fGLContext setValues: wh forParameter: NSOpenGLCPSurfaceBackingSize];
          [(NSOpenGLContext*)fGLContext update];
          //this->fWindow->request_render_layered();
      }
      
  }
}

#endif
