#ifndef __xgl_ref_h__
#define __xgl_ref_h__

#include "config.h"
#include "tool/tool.h"
#include "xgl/skia/include/core/SkRefCnt.h"
#include "xgl/skia/include/core/SkSurface.h"

namespace xgl {

#if 0

  template<typename T>
    using ref = sk_sp<T>;

#else
	template <class T> class ref
	{
	public:

		// Function Members ----------------------------------------------------------------------

		ref(T* cfo = nullptr) : _ref(cfo) { }
		// Construct a temporary reference for 'cfo' or NIL.
		// This constructor does NOT raise the use count of 'cfo'. It is assumed that
		// 'cfo' already carries a use count (which is the case when the object was
		// just created and returned by an AcquireXXX method).

		ref(const ref& src)
			// Copy constructor. This constructor DOES raise the use count.
			: _ref(src._ref) {
			if (_ref)
				_ref->ref();
		}

		~ref() {
			// Free the reference. To avoid any chance of recursive access to the
			// reference while it is being freed, the pointer is set to NIL first.
			T* cfo = _ref;
			_ref = nullptr;
			if (cfo)
				cfo->unref();
		}

		ref& operator = (T* cfo) {
			// Assign a new reference to be owned and free the old reference.
			// Does NOT raise the use count of 'cfo', see comment for TempC_ref (T cfo)
			// above.
			T* old = _ref;
			_ref = cfo;
			if (old)
				old->unref();
			return *this;
		}

		ref& operator= (const ref& src) {
			// Assign the source reference to be owned and free the old reference.
			// This assignment operator DOES raise the use count.
			T* old = _ref;
			if ((_ref = src._ref) != nullptr)
				_ref->ref();
			if (old)
				old->unref();
			return *this;
		}

		T* detach() {
			// Detach the reference from the owner, ownership is released.
			T* cfo = _ref;
			_ref = nullptr;
			return cfo;
		}

		T* acquire() {
			// Return the reference with an additional use count.
			if (_ref)
				_ref->ref();
			return _ref;
		}

		operator T*() const { return _ref; }
		// Return the pointer.

		T* ptr() const { return _ref; }
		// If the operator above it not triggered automatically, writing
		// "temp.Data()" is probably more readable than "(T) temp",
		// especially if another cast is present.

    T* operator-> () const  { assert(_ref); return _ref; }

		operator bool() const { return _ref != 0; }

		// This operator is used to pass a pointer to the CF reference to some API
		// which will return a CF reference via pointer. To guarantee reference count
		// consistency, any old contents is release first.


		// Data Members --------------------------------------------------------------------------
	private:
		T* _ref;	// The object reference
	};
#endif

}



#endif


