#include "xgl.h"

namespace xgl {    

    SkBitmap& sk_bitmap(gool::bitmap* pbm);

    bitmap_graphics::bitmap_graphics(SkBitmap& bmp, bool transparent) : _canvas(bmp), graphics(&_canvas, transparent)
    {
       //text_paint.setLCDRenderText(false);
    }

	  bitmap_graphics* bitmap_graphics::create(gool::graphics* pg, gool::bitmap* pb, argb initc)
	  {
      auto_ptr<bitmap_graphics> pbg = auto_ptr<bitmap_graphics>(new bitmap_graphics(sk_bitmap(pb), !initc.is_opaque()));
      if (pbg) {
        pbg->set_clip_rc(pb->dim());
        if (initc != argb::undefined())
          pbg->fill(initc, rect(pb->dim()));
        return pbg.release();
      }
		  return nullptr;
	  }

    
	  bitmap_bits_graphics* bitmap_bits_graphics::create(gool::bitmap* pb, argb initc)
	  {
      auto_ptr<bitmap_bits_graphics> pbg = auto_ptr<bitmap_bits_graphics>(new bitmap_bits_graphics(sk_bitmap(pb),!initc.is_opaque()));
      if (pbg) {
        pbg->pbmp = pb;
        pbg->set_clip_rc(pb->dim());
        if (initc != argb::undefined())
          pbg->fill(initc, rect(pb->dim()));
        return pbg.release();
      }
      return nullptr;

	  }

	  bitmap_bits_graphics::~bitmap_bits_graphics() 
    {
      pbmp->sk_bitmap.lockPixels();
      
      if (pbmp->sk_bitmap.colorType() == kRGBA_8888_SkColorType)
      {
        // mac ?
        BGR32_space_converter cvt( pbmp->dim() );
        tool::slice<byte> src((const byte*) pbmp->sk_bitmap.getPixels(), pbmp->sk_bitmap.getSize());
        pbmp->set_bits(src,&cvt);
      } else {
        tool::slice<gool::argb> src((gool::argb*) pbmp->sk_bitmap.getPixels(), pbmp->dim().x * pbmp->dim().y);
        pbmp->set_bits(src);
      }
    }




}
