#ifndef __XGL_VIEW_H_INCLUDED__
#define __XGL_VIEW_H_INCLUDED__


#include "xgl-sciter.h"
#include "xgl-graphics.h"

namespace xgl {

  using namespace tool;
  using namespace gool;
  using namespace html;

  class view : public tis::xview, public SkOSWindow
  {
  public:
    typedef tis::xview view_type_t;
    typedef tis::xview super;

    enum { MOUSE_IDLE_TIMER_ID = 1};

    view(void* init_ctx, const html::view_creation_params& params)
    : super(params)
    //, _idle_id(0)
    , SkOSWindow(init_ctx)
    , _delegate(0)
    , _delegate_param(0)
    , _gfx(0)
    , _mouse_idle_timer_id(0)
    , _window_state( WINDOW_STATE_NA )
    {
      _app_holder = gool::app();
      init_media_vars();
    }
    virtual ~view() {
      //if(_idle_id) {
      // g_source_remove (_idle_id);
      //  _idle_id = 0;
      //}
    }

    //void attach(SDL_Window* sdlwin) { _sdl_window = sdlwin; _window_state = WINDOW_HIDDEN; attached(); } // this object got HWND to it, _hwnd field is valid, ctor
    //void detach() { stop(); _sdl_window = nullptr; } // detaching the instance from NSView

    virtual HWINDOW get_hwnd() const override { return (HWINDOW) getHandle(); }
    virtual html::VIEW_TYPE view_type() const override { return type == html::DIALOG_WINDOW ? html::VIEW_DIALOG: html::VIEW_WINDOW; }

    virtual void set_transparency( bool on_off ) { _is_transparent = on_off; }
    virtual bool get_transparency() const { return _is_transparent; }

    virtual void set_glassy( bool on_off ) { _is_glassy = on_off; }
    virtual bool get_glassy() const { return _is_glassy; }

    virtual gool::graphics* surface() override;

    virtual bool add_animation(element* b, animation* pba, const style* new_style, const style* old_style ) override;
    virtual void on_animation_tick() override;
            bool on_animation_tick(uint atick);
    virtual bool request_animation_frame(uint delay = 0) override;
    virtual void stop_animation_frames() override;
    virtual uint get_animation_ticks() override;

    virtual bool is_active() const override;
    virtual bool set_focus(element* b, FOCUS_CAUSE cause, bool postfactum) override;

    virtual size pixels_per_inch() override;
    virtual element* element_under_cursor(/* out, view related */ gool::point& cursor_pos ) override;
    virtual void          set_cursor(gool::cursor* pcur) override;
    virtual gool::cursor* get_cursor() override;

    virtual void  do_request_idle() override;
    virtual void  set_timer(uint_ptr id, uint ms, uint_ptr& sys_id) override;
    virtual bool  on_timer(uint_ptr uid) override;

            void  setup_mouse_idle(bool on, point pt = point());

    virtual bool ask_close_window() override;
    virtual bool close_window() override;
    virtual bool ask_file_name(bool to_save, const ustring& caption, ustring& filename, const wchar* def_ext, const wchar* filter) override;
    virtual bool ask_folder_name(const ustring& caption, ustring& foldername) override { return false; }

    virtual void         replace_windowed() override;
    virtual rect         window_decoration() const override;
    virtual void         move_window(const rect& spos) override;
    virtual WINDOW_STATE get_window_state() const override;
    virtual bool         set_window_state( WINDOW_STATE ws ) override;
    virtual ustring      get_window_title() const override;
    virtual bool         set_window_title(const wchar* title) override;

    //virtual bool         show() override;
    virtual bool         show_modal() override;

    virtual bool         do_event( DO_EVENT_MANNER m, bool& result ) override;

    virtual void setup_text_flow( html::element* elem, html::tflow::text_flow& tf, tool::slice< tool::handle<html::node> > nodes ) override;
    virtual void draw_glyph_run( gool::graphics* gfx, const html::tflow::text_flow& tf, const html::tflow::glyph_run& gr, gool::pointf at, argb color, const style* run_style) override;

    virtual gool::text_layout* create_text_layout(wchars text, const text_format& tf) override;

    virtual iwindow*  create_window( html::element* forel, html::element* anchor, html::WINDOW_TYPE wt, function<rect(html::view&,html::element*,html::element*)> setup_and_calc_place, ELEMENT_WINDOW_MODE mode = ELEMENT_WINDOW_AUTO ) override;
	  virtual  bool     close_popup(element* b, bool set_auto_focus) override;

    //virtual GRAPHICS_CAPS graphics_caps() const override { return SOFTWARE_GRAPHICS; }

    virtual void init_media_vars() override;

    void draw(graphics* pg,gool::rect dirty_rc);

    void post_posted_callback(uint_ptr wp, uint_ptr lp);

/*    static gboolean idle_callback (gpointer user_data);
    static gboolean mouse_idle_timer_callback(gpointer user_data); */

    void update_window_state(WINDOW_STATE st) {
      if(_window_state != st) {
        _window_state = st;
        on_state_changed();
      }
    }

    virtual void update() override;

    static view* get_view_of(HWINDOW hw) {
      SkOSWindow* pw = xgl::view::GetOSWindowForHWND(hw);
      if (pw)
        return static_cast<view*>(pw);
      return nullptr;
    }

protected:
    SciterWindowDelegate* _delegate;
    LPVOID                _delegate_param;

    html::WINDOW_STATE    _window_state;

    handle<cursor>        _cursor;

    bool                  _is_glassy;
    bool                  _is_transparent;

    handle<gool::application> _app_holder;
    //guint                  _idle_id;
    uint_v                 _animation_ticker;
    uint_ptr               _mouse_idle_timer_id;
    point                  _mouse_idle_pos;
    //static gboolean gv_on_animation_tick(GtkWidget *widget, GdkFrameClock *frame_clock, gpointer user_data);
public:
    tool::event            posted_callback_complete;
    handle<graphics>       _gfx;
    tristate_v             _got_mouse_up;
  };

}

template <typename ET>
inline uint get_alts(ET* ev) {
    uint alts = 0;
    if(ev->state & GDK_CONTROL_MASK) alts |= html::ALT_CONTROL;
    if(ev->state & GDK_MOD1_MASK) alts |= html::ALT_ALT;
    if(ev->state & GDK_SHIFT_MASK) alts |= html::ALT_SHIFT;
    if(ev->state & GDK_MOD2_MASK) alts |= html::ALT_COMMAND;
    return alts;
}

template <typename ET>
inline uint get_mouse_buttons(ET *ev) {

    uint buttons = 0;
    if( ev->state & GDK_BUTTON1_MASK ) buttons |= html::MAIN_BUTTON;
    if( ev->state & GDK_BUTTON2_MASK ) buttons |= html::PROP_BUTTON;
    if( ev->state & GDK_BUTTON3_MASK ) buttons |= html::MIDDLE_BUTTON;
    return buttons;
}

/*inline uint get_mouse_buttons(GdkEventButton *ev) {

    uint buttons = 0;
    if( ev->button & (1 << 0) ) buttons |= html::MAIN_BUTTON;
    if( ev->button & (1 << 1) ) buttons |= html::PROP_BUTTON;
    if( ev->button & (1 << 2) ) buttons |= html::MIDDLE_BUTTON;
    return buttons;
}*/


extern xgl::view* xglview(HWINDOW hw);
extern SkOSWindow* xglwindow(const xgl::view* pv);

#endif __XGL_VIEW_H_INCLUDED__
