#include "config.h"
#include "xgl-view.h"
#include "xgl-graphics.h"

#include "SkEvent.h"
#include "SkTypes.h"
#include "SkApplication.h"
#include "SkOSWindow_Win.h"

namespace xgl {

  static const char gIdleEventType[] = "sciterIdleEvent";
  static const char gIdleEventPtr[] = "sciterIdlePtr";

  static bool IdleCallback(const SkEvent& evt)
  {
    xgl::view* pv = 0;
    if (evt.findPtr(gIdleEventPtr, (void**)&pv))
      pv->on_idle();
    return true;
  }

  void view::post_posted_callback(uint_ptr wp, uint_ptr lp)
  {
#pragma TODO("complete this")    
    SkEvent* evt = new SkEvent(gIdleEventType);
    evt->setTargetProc(IdleCallback);
    evt->setPtr(gIdleEventPtr,this);
    evt->post();

    //evt->setTargetProc()


    /*    posted_callback_info* pcb = new posted_callback_info();
    pcb->add_ref();
    pcb->pv = this;
    pcb->wp = wp;
    pcb->lp = lp;

    g_idle_add( view_posted_callback , pcb ); */

  }

  gool::graphics* view::surface()
  {
    return _gfx;
  }

  bool view::is_active() const
  {
    //return xgl_window_is_active(xglwindow(this));
    return true;
  }
  bool view::set_focus(element* b, FOCUS_CAUSE cause, bool postfactum)
  {
    //xgl_widget_grab_focus(get_hwnd());
    return super::set_focus(b, cause, postfactum);
  }

  void  view::setup_mouse_idle(bool on, point pt)
  {
    /*
    if( on )
    {
      if(_mouse_idle_timer_id) {
        g_source_remove(_mouse_idle_timer_id);
        _mouse_idle_timer_id = 0;
      }

      static uint tooltip_ms = 0;
      if( !tooltip_ms ) {
        GtkSettings* settings = xgl_settings_get_default();
        g_object_get(settings, "xgl-tooltip-timeout", &tooltip_ms, NULL);
        if(!tooltip_ms)
          tooltip_ms = 500;
      }

      //GtkSettings* gs = xgl_settings_get_default();
      _mouse_idle_pos = pt;
      _mouse_idle_timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, tooltip_ms, mouse_idle_timer_callback, this, NULL);

    } else if( _mouse_idle_timer_id ) // off
    {
      g_source_remove(_mouse_idle_timer_id);
      _mouse_idle_timer_id = 0;
    }*/
  }

	bool  view::on_timer(uint_ptr uid)
	{
	return super::on_timer(uid);
	}

    size view::pixels_per_inch()
    {
      if(dpi.x.is_defined())
        return dpi;

      gool::size r(96,96);

      return r;

    }
    element* view::element_under_cursor(/* out, view related */ gool::point& cursor_pos )
    {
      if( rect(client_dim()) && cursor_pos )
        return find_element(cursor_pos);
      return nullptr;
      //return ( client_screen_place() && cursor_pos )? doc() : nullptr;
    }
    void     view::set_cursor(gool::cursor* pcur)
    {
        _cursor = pcur;
        //GdkWindow* win = xgl_widget_get_parent_window(get_hwnd());
        //if(win)
        //   gdk_window_set_cursor(win, _cursor? _cursor->pcur: nullptr);
    }
    gool::cursor* view::get_cursor()
    {
       return _cursor;
    }

    /*gboolean view::idle_callback (gpointer user_data) {
       view* pv = static_cast<view*>(user_data);
       pv->_idle_id = 0;
       pv->on_idle();
       return FALSE;
    }*/

    void  view::do_request_idle()
    {
      SkEvent* evt = new SkEvent(gIdleEventType);
      evt->setTargetProc(IdleCallback);
      evt->setPtr(gIdleEventPtr, this);
      evt->post();
      //if(!_idle_id)
      //  _idle_id = g_idle_add(idle_callback,this);
    }

    /*struct timer_task: resource
    {

      view*    pv;
      uint_ptr id;

      static void create(view* pv, uint_ptr id, uint ms, uint_ptr& sys_id)
      {
        timer_task* tt = new timer_task();
        tt->pv = pv;
        tt->id = id;
        tt->add_ref();

        sys_id = g_timeout_add_full (G_PRIORITY_DEFAULT,ms, timer_callback, tt, timer_destroyed);
      }
      static void remove( uint_ptr sys_id ) {
        g_source_remove (guint(sys_id));
      }

      static gboolean timer_callback(gpointer user_data)
      {
        timer_task* tt = static_cast<timer_task*>(user_data);
        tt->pv->on_timer( tt->id );
        return FALSE;
      }
      static void  timer_destroyed(gpointer data)
      {
        timer_task* tt = static_cast<timer_task*>(data);
        tt->release();
      }
    };*/

    void  view::set_timer(uint_ptr id, uint ms, uint_ptr& sys_id)
    {
      //if(ms)
      //  timer_task::create(this,id,ms,sys_id);
      //else
      //  timer_task::remove(sys_id);
    }

    bool  view::ask_close_window()
    {
      auto gw = xglwindow( this );
      //if( gw )
      //   xgl_window_close( gw );
      return true;
    }
    bool  view::close_window()
    {
      auto gw = xglwindow( this );
      //xgl_widget_destroy ( GTK_WIDGET(gw) );
      return true;
    }

    rect view::window_decoration() const { 
      return rect(0,0,0,0); // return width of window decorations
    } 

    void         view::move_window(const rect& spos)
    {
      super::move_window(spos);
      auto gw = xglwindow( this );
      //if( gw ) {
      //  xgl_window_move( gw, spos.left(),spos.top() );
      //  //xgl_window_resize( gw, spos.width(),spos.height() );
      //  xgl_widget_set_size_request (GTK_WIDGET(gw), spos.width(),spos.height());
      //}
    }
    WINDOW_STATE view::get_window_state() const
    {
       return _window_state;
    }
    bool         view::set_window_state( WINDOW_STATE ws )
    {
/*       GtkWindow *gw = xglwindow(this);
       if(!gw)
         return false;

       if( _window_state == ws)
         return;

       _window_state = ws;

       switch(ws) {
         case WINDOW_HIDDEN: xgl_widget_hide (GTK_WIDGET(gw)); return true;
         case WINDOW_SHOWN: xgl_widget_show (GTK_WIDGET(gw)); return true;
         case WINDOW_MAXIMIZED: xgl_window_maximize (gw); return true;
         case WINDOW_MINIMIZED: xgl_window_iconify(gw); return true;
         case WINDOW_FULL_SCREEN: xgl_window_fullscreen(gw); return true;
       } */
       return false;
    }

    bool         view::show_modal()
    {
		/*
       GtkWindow* gw = xglwindow(this);

       if( parent() )
         xgl_window_set_transient_for(gw, xglwindow( (xgl::view*)parent() ));

       handle<view> self = this;

       xgl_widget_show(GTK_WIDGET(gw));
       xgl_window_set_modal(gw,TRUE);
       self->update_window_state(gool::WINDOW_SHOWN);

       while( self->get_hwnd() )
       {
          if(self->_window_state == WINDOW_HIDDEN) break;
          if(self->_window_state == WINDOW_STATE_NA) break;
          if( xgl_main_iteration_do (true) )
             return false;
       }
       return dialog_retval != NOTHING_VALUE;
	   */
return false;
    }


    /*static GdkFilterReturn GdkMouseUpFilter(GdkXEvent *xevent, GdkEvent *event, gpointer data)
    {
       if( ((XButtonEvent*)xevent)->type == ButtonRelease)
         *((bool*)data) = false;
       return GDK_FILTER_CONTINUE;
    }*/

    bool         view::do_event( DO_EVENT_MANNER m, bool& result )
    {
      result = true;
      /*
      switch( m )  {
        case DO_EVENT_WAIT:   return !xgl_main_iteration_do (true);
        case DO_EVENT_NOWAIT: return !xgl_main_iteration_do (false);
        case DO_EVENT_ALL:
        {
           handle<xgl::view> self = this;
           while( self->get_hwnd() ) {
             if(self->_window_state == WINDOW_HIDDEN) break;
             if(self->_window_state == WINDOW_STATE_NA) break;
             if( xgl_main_iteration_do (true) )
               return false;
           }
           return true;
        }
        case DO_EVENT_UNTIL_MOUSE_UP:
        {
          //bool  running = true;
          //bool* prunning = &running;
          //gdk_window_add_filter(nullptr, GdkMouseUpFilter, prunning);
          //ON_SCOPE_EXIT(gdk_window_remove_filter(nullptr, GdkMouseUpFilter, prunning));
          handle<xgl::view> self = this;
          self->_got_mouse_up = false;

          while( self->get_hwnd() && !self->_got_mouse_up) {
            if(self->_window_state == WINDOW_HIDDEN) break;
            if(self->_window_state == WINDOW_STATE_NA) break;
            if( xgl_main_iteration_do (false) )
              return false;
            yield();
          }
          return true;
        }
      }
      */
      return false;
    }

    gool::text_layout* view::create_text_layout(wchars text, const text_format& tf)
    {
      xgl::text_layout* pl =  new xgl::text_layout();
      pl->set( *this,text, tf );
      return pl;
    }

    void      view::init_media_vars()
    {
      super::init_media_vars();
      /*

      GdkScreen *screen = gdk_screen_get_default();
      GdkVisual *visual = gdk_screen_get_rgba_visual(screen);

      gool::size min_w_size(0,0);
      gool::size max_w_size = screen_workarea().size();
      gool::size w_size = max_w_size;
      gool::size device_size = max_w_size;

      uint bits_per_pixel = 0;
      uint num_colors = 0;

      gool::size dpi = pixels_per_inch();
      gool::size dpcm;

      bool high_contrast = false;
      bool has_pen = false;
      bool has_mouse = false;
      bool has_mouse_wheel = false;
      bool has_horizontal_mouse_wheel = false; //GetSystemMetrics(SM_MOUSEHORIZONTALWHEELPRESENT) != 0;
      bool screen_reader = false;
      bool slow_machine = false;

    #if defined(PLATFORM_DESKTOP)
      //has_pen = GetSystemMetrics(SM_PENWINDOWS) != 0;
      has_mouse = true;
      has_mouse_wheel = true;
      //slow_machine = GetSystemMetrics(SM_SLOWMACHINE) != 0;
    #endif

        num_colors = gdk_visual_get_best_depth();

        dpcm.x = (dpi.x * 254) / 100;
        dpcm.y = (dpi.y * 254) / 100;


        if( get_hwnd() )
        {
          w_size = client_dim();
        }
        _media_vars["width"] = tool::value::make_length(w_size.x,tool::value::px);
        _media_vars["height"] = tool::value::make_length(w_size.y,tool::value::px);
        _media_vars["min-width"] = tool::value::make_length(min_w_size.x,tool::value::px);
        _media_vars["min-height"] = tool::value::make_length(min_w_size.y,tool::value::px);
        _media_vars["max-width"] = tool::value::make_length(max_w_size.x,tool::value::px);
        _media_vars["max-height"] = tool::value::make_length(max_w_size.y,tool::value::px);
        _media_vars["aspect-ratio"] = tool::value(double(w_size.x)/double(w_size.y));

        _media_vars["monitors"] = tool::value( gdk_screen_get_n_monitors(screen) );
        _media_vars["device-width"] = tool::value::make_length(device_size.x,tool::value::px);
        _media_vars["device-height"] = tool::value::make_length(device_size.y,tool::value::px);
        _media_vars["device-aspect-ratio"] = tool::value(double(device_size.x)/double(device_size.y));

        _media_vars["orientation-portrait"] = device_size.y > device_size.x;
        _media_vars["orientation-landscape"] = device_size.y < device_size.x;
        _media_vars["color"] = int(bits_per_pixel);
        _media_vars["color-index"] = int(num_colors);
        //monochrome ???

        if(dpi.x == dpi.y) // dots per inch
        {
          _media_vars["resolution"] = dpi.x;
          _media_vars["min-resolution"] = dpi.x;
          _media_vars["max-resolution"] = dpi.x;
        }
        else
        {
          // A \91resolution\92 (without a "min-" or "max-" prefix) query never matches a device with non-square pixels.
          _media_vars["min-resolution"] = min(dpi.x,dpi.y);
          _media_vars["max-resolution"] = max(dpi.x,dpi.y);
        }

        if(dpcm.x == dpcm.y) // dots per sentimeter
        {
          _media_vars["resolution-dpcm"] = dpcm.x;
          _media_vars["min-resolution-dpcm"] = dpcm.x;
          _media_vars["max-resolution-dpcm"] = dpcm.x;
        }
        else
        {
          // A \91resolution\92 (without a "min-" or "max-" prefix) query never matches a device with non-square pixels.
          _media_vars["min-resolution-dpcm"] = min(dpcm.x,dpcm.y);
          _media_vars["max-resolution-dpcm"] = max(dpcm.x,dpcm.y);
        }

        _media_vars["high-contrast"] = high_contrast;
        _media_vars["contrast-screen"] = high_contrast; // Symantec's var.

        _media_vars["has-pen"] = has_pen;
        _media_vars["has-mouse"] = has_mouse;
        _media_vars["has-mouse-wheel"] = has_mouse_wheel;
        _media_vars["has-horizontal-mouse-wheel"] = has_horizontal_mouse_wheel;
        _media_vars["screen-reader"] = screen_reader;
        _media_vars["slow-machine"] = slow_machine;

        _media_vars["engine"] = ustring(WTEXT("sciter"));
        _media_vars["engine-version-minor"] = (int)module_version(false);
        _media_vars["engine-version-major"] = (int)module_version(true);

        static uint ver[4] = { SCITER_VERSION };

        _media_vars["sciter"] = value(ver[0]);

        _media_vars["os"] = ustring(tool::environment::get_os_version_name());
        _media_vars["platform"] = ustring("Linux");

        _media_vars["old-themes"] = environment::get_os_version() < environment::WIN_VISTA;
        _media_vars["new-themes"] = environment::get_os_version() >= environment::WIN_VISTA;

        bool composited = false;

        if (visual != NULL && gdk_screen_is_composited(screen))
           composited = true;

        _media_vars["composition-supported"] = tool::value(composited);
        _media_vars["on-glass"] = tool::value(get_transparency());

        _media_vars["graphics-layer"] = tool::value(graphics_caps());
        */
    }

    void view::draw(graphics* gfx,gool::rect dirty_rc)
    {
      _gfx = gfx;

      /*if( _is_glassy ) {
        cairo_save(gfx->target());
        cairo_set_source_rgba(gfx->target(), 0.4, 0.4, 0.4,0.75);
        cairo_set_operator(gfx->target(), CAIRO_OPERATOR_SOURCE);
        cairo_paint(gfx->target());
        cairo_restore(gfx->target());
      } else if( _is_transparent ) {
        cairo_save(gfx->target());
        cairo_set_source_rgba(gfx->target(), 0, 0, 0, 0);
        cairo_set_operator(gfx->target(), CAIRO_OPERATOR_SOURCE);
        cairo_paint(gfx->target());
        cairo_restore(gfx->target());
      }*/

      //auto_state<graphics*>       _1(_gfx,gfx);
      auto_state<bool>            _2(is_painting,true);
      auto_state<gool::graphics*> _3(drawing_surface, _gfx);

      gfx->set_clip_rc(dirty_rc);
      html::view::paint(gool::point(0,0));
    }

    bool view::ask_file_name(bool to_save, const ustring& caption, ustring& filename, const wchar* def_ext, const wchar* filter)
    {
      /*
       auto add_filter =[](GtkWidget *file_chooser,tool::string title, tool::string pattern)
       {
          GtkFileFilter *f = xgl_file_filter_new();
          xgl_file_filter_set_name(f, title);
          //pattern.replace(';','\n');
          pattern.to_lower();
          chars pat = pattern();
          while( !!pat ) {
            tool::chars glob = pat.chop(';');
            if( !glob )
              break;
            xgl_file_filter_add_pattern(f,string(glob));
          }
          xgl_file_chooser_add_filter(GTK_FILE_CHOOSER(file_chooser), f);
       };

       auto add_filters=[&add_filter](GtkWidget *file_chooser, tool::chars filters )
       {
          while( !!filters ) {
            tool::chars name = filters.chop('|');
            tool::chars filt = filters.chop('|');
            if( !!name && !!filt )
              add_filter( file_chooser, name, filt );
          }
       };

      string u8filter = filter;

      if( !to_save ) {

        tool::string cap = caption.length()? caption.utf8(): string("Open File");

        GtkFileChooserAction action = GTK_FILE_CHOOSER_ACTION_OPEN;

        auto parent = xglwindow(this);

        assert(GTK_IS_WINDOW(parent));

        GtkWidget *dialog = xgl_file_chooser_dialog_new ( cap,
                                      parent,
                                      action,
                                      "Cancel",
                                      GTK_RESPONSE_CANCEL,
                                      "Open",
                                      GTK_RESPONSE_ACCEPT,
                                      NULL);

        add_filters(dialog, tool::string(filter));

        //xgl_widget_realize(dialog);

        xgl_window_set_transient_for(GTK_WINDOW (dialog), xglwindow(this));
        xgl_window_set_position( GTK_WINDOW( dialog ), GTK_WIN_POS_CENTER_ON_PARENT );
        xgl_window_set_modal ( GTK_WINDOW (dialog), TRUE );

        gint res = xgl_dialog_run (GTK_DIALOG (dialog));
        if (res == GTK_RESPONSE_ACCEPT)
        {
          GtkFileChooser *chooser = GTK_FILE_CHOOSER (dialog);
          char *selected_filename = xgl_file_chooser_get_filename (chooser);
          //open_file (filename);
          filename = selected_filename;
          g_free (selected_filename);
        }
        xgl_widget_destroy (dialog);

        return res == GTK_RESPONSE_ACCEPT;

      } else {
        // save

        tool::string cap = caption.length()? caption.utf8(): string("Save File");

        GtkFileChooserAction action = GTK_FILE_CHOOSER_ACTION_SAVE;
        GtkWidget *dialog = xgl_file_chooser_dialog_new (cap,
                                      xglwindow(this),
                                      action,
                                      "Cancel",
                                      GTK_RESPONSE_CANCEL,
                                      "Save",
                                      GTK_RESPONSE_ACCEPT,
                                      NULL);

        xgl_window_set_transient_for(GTK_WINDOW (dialog), xglwindow(this));
        xgl_window_set_modal ( GTK_WINDOW (dialog), true );

        GtkFileChooser *chooser = GTK_FILE_CHOOSER (dialog);

        xgl_file_chooser_set_do_overwrite_confirmation (chooser, TRUE);

        add_filters(dialog, tool::string(filter));

        if (filename.length() == 0)
          xgl_file_chooser_set_current_name (chooser, "Untitled document");
        else
          xgl_file_chooser_set_filename (chooser, filename.utf8());

        gint res = xgl_dialog_run (GTK_DIALOG (dialog));
        if (res == GTK_RESPONSE_ACCEPT)
        {
          char *selected_filename;
          selected_filename = xgl_file_chooser_get_filename (chooser);

          filename = selected_filename;
          if(def_ext && def_ext[0] && !filename.like(WSTR("*.???"))) {
            filename += '.';
            filename += def_ext;
          }
          g_free (selected_filename);
        }

        xgl_widget_destroy (dialog);
        return res == GTK_RESPONSE_ACCEPT;
      }
      */
      return false;
   }

   ustring view::get_window_title() const {

/*     GtkWindow* pw = xglwindow(this);
     if( pw )
       return xgl_window_get_title (pw); */
     return ustring();
   }
   bool view::set_window_title(const wchar* title) {
     /*GtkWindow* pw = xglwindow(this);
     if( pw ) {
       xgl_window_set_title (pw, string(title));
       return true;
     }*/
     return false;
   }

    bool view::add_animation(element* b, animation* pba, const style* new_style, const style* old_style )
    {
      if(!get_hwnd())
        return false;

      //request_animation_frame(ANIMATION_TIMER_SPAN);
      if(!super::add_animation(b, pba, new_style,old_style))
        return false;
      return true;
    }

    uint view::get_animation_ticks()
    {
      return 0;
      /*
      GtkWidget *widget = get_hwnd();
      if(!widget)
        return 0;

      gint64 mcs = g_get_monotonic_time();

      return uint(mcs / 1000u); // milliseconds
      */
    }

    void view::on_animation_tick()
    {
       on_animation_tick( get_animation_ticks() );
    }

    bool view::on_animation_tick(uint ticks)
    {
      if( !ticks || !check_visibility() ) {
        stop_animation_frames();
        return false;
      }

      uint delay = 0;
      uint delta = 0;

      if( !doc() )
        goto STOP;

      if( animating.size() == 0 )
        goto STOP;

      delay = do_animation(ticks);

      if( animating.size() == 0 || delay == 0 )
        goto STOP;

      //update();
      //while( xgl_events_pending() )
      //  xgl_main_iteration();

      request_animation_frame(delay/*not used*/);


      return true;
STOP:
      remove_all_animations();
      return false;
    }

    static uint prev_animation_tick = 0;


/*    gboolean view::gv_on_animation_tick(GtkWidget *widget, GdkFrameClock *frame_clock, gpointer user_data)
    {
      gint64 mcs = gdk_frame_clock_get_frame_time (frame_clock);

      uint animation_tick = uint(mcs / 1000u); // milliseconds

      //if(prev_animation_tick)
      //{
      //  printf("animation delta %d\n", animation_tick - prev_animation_tick  );
      //}
      //prev_animation_tick = animation_tick;

      view* pv = static_cast<view*>(user_data);

      if( pv->on_animation_tick(animation_tick) )
        return G_SOURCE_CONTINUE;

      pv->_animation_ticker.clear();
      return G_SOURCE_REMOVE;

    }*/

    void view::stop_animation_frames()
    {
       if( _animation_ticker.is_undefined() )
         return;

       /*GtkWidget *widget = get_hwnd();
       if(!widget)
         return;

       xgl_widget_remove_tick_callback (widget,_animation_ticker);
       _animation_ticker.clear(); */
    }
    bool      view::request_animation_frame(uint delay)
    {
       if( _animation_ticker.is_defined() )
         return true;

       /*
       GtkWidget *widget = get_hwnd();
       if(!widget)
         return false;

       _animation_ticker = xgl_widget_add_tick_callback (widget, gv_on_animation_tick, this, NULL);
       return true;
       */
       return false;
    }

    void    view::replace_windowed() {
    
    }

    void   view::setup_text_flow(html::element* elem, html::tflow::text_flow& tf, tool::slice< tool::handle<html::node> > nodes)
    {
    }

    void  view::draw_glyph_run(gool::graphics* gfx, const html::tflow::text_flow& tf, const html::tflow::glyph_run& gr, gool::pointf at, argb color, const style* run_style)
    {

    }

    iwindow*  view::create_window(html::element* forel, html::element* anchor, html::WINDOW_TYPE wt, function<rect(html::view&, html::element*, html::element*)> setup_and_calc_place, ELEMENT_WINDOW_MODE mode)
    {
      return nullptr;
    }

    bool     view::close_popup(element* b, bool set_auto_focus)
    {
      return false;
    }

}
