# behavior: richtext

HTML WYSIWYG editing behavior.

The behavior supports document container mode similar to [behavior:frame](behavior-frame.md) - it supports loading full `<html>...</html>` document in it.

## Elements

that have this behavior applied by default:

* `<htmlarea>...</htmlarea>` editor;

## Attributes

that this behavior knows about:

* `readonly` -  declares that element is read only;
* `content-style` - string, URL of .css file to apply to content of the editor. Use it when you need to apply editing specific styling.
* `spellcheck` - boolean, "true" | "false", enable/disable spell checking

## Model

Richtext supports two content models, HTML fragment:

```
<htmlarea>
   <h2>Some HTML content</h2>
   <p>Line 2</p>
   <p>Line 3</p>
</htmlarea>
```

and full document. In this case `<htmlarea>` behaves as a `<frame>` containing the document:

```
<htmlarea>
   <html>
      <body>
        <h2>Some HTML content</h2>
        <p>Line 2</p>
        <p>Line 3</p>
      </body>
   </html>
</htmlarea>
```

Content model is determined by content loaded in it.

## Events

Together with the standard set of events (mouse, keyboard, focus) *behavior: richtext* generates:

* `"change"` event - value of the element was changed due to user actions. Posted (asynchronous) event.
* `"changing"` event - sent when value of the element is about to change. Synchronous event.

## Value

string, reflects current status of content DOM - value gets/sets current HTML content.  For the richtext DOM element property *value* is an alias of property *html.*

## Special key combinations

* LEFT, CTRL+LEFT, SHIFT+LEFT, CTRL+SHIFT+LEFT
* RIGHT, CTRL+RIGHT, SHIFT+RIGHT, CTRL+SHIFT+RIGHT
* HOME, SHIFT+HOME
* END, SHIFT+END
* BACKSPACE, ALT+BACKSPACE, CTRL+BACKSPACE
* CTRL+A
* DELETE, SHIFT+DELETE, CTRL+DELETE
* INSERT, SHIFT+INSERT, CTRL+INSERT
* CTRL+X
* CTRL+V
* CTRL+Z

Formatting commands:
* `CTRL+D` \- wraps current text run into `<code>text</code>`;
* `CTRL+NUMPAD1...6` \- converts current text block to `<h1>`...`<h6>`;
* `CTRL+NUMPAD7` - converts current block or text run to `<pre>`;
* `CTRL+NUMPAD0`\- converts current block or text run to `<p>`;
* `CTRL+NUMPAD+` \- indent current selection;
* `CTRL+NUMPAD-` \- unindent current selection;
* `CTRL+NUMPAD.` \- convert current selection to ordered list `<ol>``/<li>`;
* `CTRL+NUMPAD\*` \- convert current selection to unordered list `<ul>``/<li>`;
* `CTRL+NUMPAD/` \- convert current selection to definition list `<dl>``/<dt>/<dd>`;

## Commands

The `htmlarea.execCommand(command,attributes)` method executes undoable editing command. The *command* string identifies command to execute.

Editing commands common to all editable elements ( `<input|text>, <textarea>, <plaintext>, <htmlarea>` ):

* `"edit:cut"` \- cut selection - copy selection to the clipboard and remove it;
* `"edit:copy"` \- copy selection to the clipboard;
* `"edit:paste"` \- paste content of the clipboard;
* `"edit:selectall"` \- select whole content of the element;
* `"edit:undo"` \- undo last editing operation;
* `"edit:redo"` \- redo last operation that was undone;
* `"edit:delete-next"` \- if there is a selection - delete selected content, otherwise delete next character;
* `"edit:delete-prev"` \- if there is a selection - delete selected content, otherwise delete previous character;
* `"edit:delete-word-next"` \- if there is a selection - delete selected content, otherwise delete next word;
* `"edit:delete-word-prev"` \- if there is a selection - delete selected content, otherwise delete previous word;

Commands specific to `behavior:richtext` ( `<htmlarea>` ):

* `"edit:insert-break"` \- essentially this is "ENTER" (VK\_RETURN) command, actual DOM modification depends on context;
* `"edit:insert-soft-break"` \- "SHIFT+ENTER" command, inserts `<br>` separator but actual DOM modification depends on context;
* `"format:apply-span:{tag-list}"` \- wrap selection into span element, if the selection contains one of tags they will be removed.
  * `{tag-list}` is a pipe (`|`)  separated list of tag names. Example:
  `execCommand("format:apply-span:b|strong")` \- will wrap selection into `<b>...</b>` while removing any other `<b>` and `<strong>` elements from the selection.
  * Additional map parameter may contain list of DOM attributes to add to wrapping element, Example:
  `execCommand("format:apply-span:font",{color:"#F00"})` \- will wrap selection into `<font color="#F00">...</font>` element.
* `"format:toggle-span:{tag-list}"` \- if selection contains one of the tags - removes them, otherwise it does `"format:apply-span:..."` action.
* `"format:toggle-list:{list-tag}"` \- converts paragraphs in selection into a list. If selection is already a list of that type then items of the list will be converted tp simple paragraphs;
  * `{list-tag}` can be either `ul`, `ol` or `dl`.
* `"format:toggle-pre"` \- converts selection to or from `<pre>` block.
* `"format:indent"` \-  wraps selected paragraphs into `<blockquote>` or sub-list.
* `"format:unindent"` \-  unwraps selected paragraphs from `<blockquote>` or moves sub-list to one level up.
* `"format:morph-block:{tag}"` \- changes tags of selected block elements. This way current `<blockquote>`  can be changed to `<p>` for example. Only block element that do not contain other `display:block` elements can be morphed.
* `"format:unwrap-element:{tag}"` \- moves content of the element to element's parent and removes (now empty) element from the DOM.

Table editing operations. These operations are available only if selection is inside a table:

* `edit:insert-table-row:{before|after}` \- inserts row before of after selected cells;
* `edit:insert-table-column:{before|after}` \- inserts column before of after selected cells;
* `edit:merge-table-cells` \- merge selected cell range into single cell (will add rowspan/colspan to the cell);
* `edit:delete-table-rows` \- deletes selected rows;
* `edit:delete-table-columns` \- deletes selected columns;
* `edit:split-table-cells` \- splits spanned cell into multiple cells.

## Properties

* `richtext.url` - r/w, string, url of loaded document.

## Methods

* `richtext.load(url:string): true|false`
  
  loads file from URL into the editor;

* `richtext.load(html: string | ArrayBuffer, url: string): true|false`
  
  loads content from bytes or string (html source) into the editor; *url* is used to resolve relative URLs (if any).

* `richtext.save(fileUrl:string): true|false`
  
  saves content to a file;

* `richtext.loadEmpty(): true|false`
  
  initializes the editor by empty document;

* `richtext.sourceToContent(html:string, url:string, selStart:integer, selEnd:integer): true|false`
  
  The method sets content from the *html* and selection from given *selStart* and *selEnd*.

* `richtext.contentToSource() : \[html:string, url:string, selStart:integer, selEnd:integer\]`
  
  returns content and selection as an array of three elements;

* #### `richtext.update(mutator:function(tctx) {}) : bool`
  
  Transactional update (mutation) of the content. Multiple mutations made through *tctx* transactional context interface are combined into single transaction that is undoable as a single operation. Tctx is an object that has following content mutation methods:

  *  `tctx.removeAttribute(element,attributeName:string)` - removes one attribute; 
  *  `tctx.setAttribute(element,attributeName:string,attributeValue:string)` - adds or changes value of one attribute;
  *  `tctx.setTag(element,tagName:string)` - changes tag of the element, used to change `<p>` to `<li>` for example;
  *  `tctx.setText(node,text:string)` - change node text;
  *  `tctx.insertHTML(node,offset, html:string): [nodes...]` - insert HTML at given node/offset position, retuns list of nodes inserted;
  *  `tctx.insertText(node,offset, text:string): [node,offset]` - insert text at given node/offset position;
  *  `tctx.insertNode(node,offset, node): [node,offset]` - insert node at given node/offset position;
  *  `tctx.deleteSelection(): [node,offset]` - delete current selected range (if any);
  *  `tctx.deleteRange(node1,offset1,node2,offset2): [node,offset]` - delete given range;
  *  `tctx.deleteNode(node)` - delete given node or element;
  *  `tctx.split(node,offset,until:element): [node,offset]` - splits node at offset position until the parent element. Similar to pressing ENTER in the middle of paragraph - text node and p[aragraph] element will be split in two paragraphs; 
  *  `tctx.wrap(node1,offset1,node2,offset2,element)` - wraps the range into element. Similar to wrapping selection into `b` element; 
  *  `tctx.unwrap(element)` - opposite operation to wrap; 
  *  `tctx.execCommand(command:string [,params])` - same as `element.execCommand()` above but all mutations will go into this transaction;

  The mutator function shall return *true* to commit transaction or *false* to discard all changes.