

newoption {
   trigger     = "monolithic",
   description = "Will create monolithic libraries (without sublibraries)"
}

newoption {
   trigger     = "windowsxp",
   description = "Will add Windows XP support"
}

newoption {
    trigger     = "nolinkoptimization",
    description = "Disable Whole Program Optimization"
}

newoption {
    trigger     = "windowssdk",
    description = "Define used Windows SDK"
}

newoption {
    trigger     = "cppdialect",
    description = "C++ Language Standard",
    default     = "C++17"
}

newoption {
   trigger     = "device",
   value       = "DESKTOP|HANDHELD|IOT",
   description = "target device",
   default     = "DESKTOP",
   allowed = {
      { "DESKTOP",   "Desktop machine" },
      { "HANDHELD",  "Mobile device" },
      { "IOT",       "IoT device" }
   }
}

newoption {
   trigger     = "javascript",
   description = "Will build Sciter.JS"
}

newoption {
    trigger     = "norevision",
    description = "Will not try to fetch SVN revision",
}

TIS = 1
QJS = 2

SDKDIR = "sdk"
BUILDDIR = "build"

MONOLITHIC = _OPTIONS["monolithic"]
USE_SKIA_BY_DEFAULT = false

if os.target() == "macosx" or os.target() == "android" then
  USE_SKIA_BY_DEFAULT = true
end  

if _TARGET_OS == "linux" or _TARGET_OS == "macosx" then
  MONOLITHIC = true -- posix (GCC) this is the only way unfortunately
end  

if MONOLITHIC then 
  print "generating monolithic projects"
end

configurations { "Debug", "Release" }

staticruntime "on"  

defines { 
  "DEVICE=" .. _OPTIONS["device"] 
}

if _OPTIONS["javascript"] then 
  SCRIPT = QJS
  SDKDIR = "sdk.js"
  BUILDDIR = "build.js"
  defines { 
    "SCITERJS", 
    "JS_STRICT_NAN_BOXING", 
    "CONFIG_BIGNUM", 
    "CONFIG_JSX", 
    "CONFIG_JSX_SCITER",
    "CONFIG_DEBUGGER",
    "CONFIG_STORAGE",
    "CONFIG_OBJECT_LITERAL_CALL"
  }
else   
  SCRIPT = TIS
  SDKDIR = "sdk"
  BUILDDIR = "build"
  defines { "SCITER" }
end

require "config"

if MONOLITHIC then
  defines "MONOLITHIC"
end    

if _OPTIONS["javascript"] then -- SCITERJS 

  function osabbr() 
    return _TARGET_OS
  end

  -- function that setups target dir according to configuration
  function settargetdir(basedir) 
    basedir = basedir or ""
    if _TARGET_OS == "macosx" then
      targetdir (basedir .. "bin/" .. osabbr())
    else
      targetdir (basedir .. "bin/" .. osabbr() .."/%{cfg.platform}")
      filter "configurations:*Skia" 
        targetdir (basedir .. "bin/" .. osabbr() .."/%{cfg.platform}skia")
      filter {}
    end  
  end


  filter "system:windows"
    buildoptions "-Zm200"
    location(BUILDDIR .. "/" .. osabbr())  
    platforms { "x32", "x64", "arm64" }  
    configurations { "DebugSkia", "ReleaseSkia" }
  filter "system:macosx"
    location(BUILDDIR .. "/" .. osabbr())  
    platforms { "x64" }  
  filter "system:linux"
    location(BUILDDIR .. "/" .. osabbr() .. "/" .. string.lower(_OPTIONS["device"]))
    platforms { "x32", "x64", "arm32", "arm64" }  
  filter "system:android"
    location(BUILDDIR .. "/" .. osabbr())  
    platforms { "x32", "x64", "arm32", "arm64" }  
  filter {}

else -- SCITER.TIS

  function osabbr() 
    if( _TARGET_OS == "macosx") then return "osx" 
    elseif( _TARGET_OS == "windows") then return "win"
    elseif( _TARGET_OS == "linux") then return "lnx"
    elseif( _TARGET_OS == "android") then return "android"
    else return "unk"
    end
  end

  -- function that setups target dir according to configuration
  function settargetdir(basedir) 
    basedir = basedir or ""
    if _TARGET_OS == "macosx" then
      targetdir (basedir .. "bin." .. osabbr())
    else
      targetdir (basedir .. "bin." .. osabbr() .."/%{cfg.platform}")
      filter "configurations:*Skia" 
        targetdir (basedir .. "bin." .. osabbr() .."/%{cfg.platform}skia")
      filter {}
    end  
  end

  filter "system:windows"
    buildoptions "-Zm200"
    location(BUILDDIR .. ".windows")
    platforms { "x32", "x64", "arm64" }  
    configurations { "DebugSkia", "ReleaseSkia", "DebugMD", "ReleaseMD" }
  filter "system:macosx"
    location (BUILDDIR .. ".macosx")
    platforms { "x64" }  
  filter "system:linux"
    location(BUILDDIR .. ".linux/" .. string.lower(_OPTIONS["device"]))
    platforms { "x32", "x64", "arm32", "arm64" }  
  filter "system:android"
    location(BUILDDIR .. ".android")
    platforms { "x32", "x64", "arm32", "arm64" }  
  filter {}

end  

staticruntime "on"

filter { "system:windows", "configurations:*MD" }
  staticruntime "off"
filter{}

filter "not system:linux"
  flags { "MultiProcessorCompile" } -- does not work reliably on Linux, why?
filter{}

cppdialect (_OPTIONS["cppdialect"])

filter "platforms:x32"
  architecture "x86"
filter "platforms:x64"
  architecture "x86_64"  
filter "platforms:arm64"
  architecture "ARM64"  
filter "platforms:arm32"
  architecture "ARM"  

filter "system:windows"
  removeplatforms { "arm32" }  

filter {"platforms:x32", "system:windows"}
  defines { "WIN32" }
filter {"platforms:x64", "system:windows"}
  defines { "WIN32","WIN64" }      
filter {"platforms:arm64", "system:windows"}
  defines { "WIN32","WIN64", "ARM64", "__ARM_NEON" }      


filter "configurations:Debug*"
  defines { "DEBUG", "_DEBUG", "DUMP_LEAKS" }
  symbols "On"

filter "configurations:Release*"
  defines { "NDEBUG"}  
  optimize "Size"
  --symbols "Off"
  if not _OPTIONS["nolinkoptimization"] then
    flags { "LinkTimeOptimization" }
  end

filter {"system:windows"}
  defines { "_CRT_SECURE_NO_WARNINGS" } 
  systemversion "latest"

if _OPTIONS["windowsxp"] then 

  defines "SUPPORT_WINDOWSXP"

  -- get list of SDK dirs/versions
  matches = os.matchdirs("C:/Program Files (x86)/Windows Kits/10/Include/*")
  -- sort from most to least recent
  table.sort(matches, function (left, right) return left > right; end);

  -- get most recent SDK version if exists
  if #matches > 0 and os.isdir(matches[1] .. "/um") then
    WINDOWS_SDK_INCLUDE = matches[1] .. "/"
    WINDOWS_SDK_LIB = "C:/Program Files (x86)/Windows Kits/10/Lib/" .. path.getname(matches[1]) .. "/"
    -- print("WINDOWS_SDK_INCLUDE - " .. WINDOWS_SDK_INCLUDE);
    -- print("WINDOWS_SDK_LIB - " .. WINDOWS_SDK_LIB);
    -- error("STOP");
  else 
    -- allow define WindowsSdk from outside
    if _OPTIONS["windowssdk"] then
      if os.isdir("C:/Program Files (x86)/Windows Kits/10/Include/" .. _OPTIONS["windowssdk"] .. "/um") then
        WINDOWS_SDK_INCLUDE = "C:/Program Files (x86)/Windows Kits/10/Include/" .. _OPTIONS["windowssdk"] .. "/"
        WINDOWS_SDK_LIB = "C:/Program Files (x86)/Windows Kits/10/Lib/" .. _OPTIONS["windowssdk"] .. "/"
      else
    error("Windows 10 SDK not found")
  end 
    else
      error("Windows 10 SDK not found")
    end
  end 

  filter {"system:windows", "action:vs2015", "platforms:not arm64" }
    toolset "v140_xp"
    buildoptions "/Zc:threadSafeInit-"
    sysincludedirs { WINDOWS_SDK_INCLUDE .. "um", 
                     WINDOWS_SDK_INCLUDE .. "shared" }

  filter {"system:windows", "action:vs2017", "platforms:not arm64" }
    toolset "v141_xp"
    buildoptions "/Zc:threadSafeInit-"
    sysincludedirs { WINDOWS_SDK_INCLUDE .. "um", 
                     WINDOWS_SDK_INCLUDE .. "shared" }

  filter {"system:windows", "platforms:x32" }
    syslibdirs { WINDOWS_SDK_LIB .. "um/x86" }

  filter {"system:windows", "platforms:x64" }
    syslibdirs { WINDOWS_SDK_LIB .. "um/x64" }

  filter {"system:windows", "platforms:arm64" }
    sysincludedirs { WINDOWS_SDK_INCLUDE .. "um", 
                     WINDOWS_SDK_INCLUDE .. "shared" }
    syslibdirs { WINDOWS_SDK_LIB .. "um/arm64" }
    defines { "DR_MP3_NO_SIMD" }

  filter {}

end    

filter { "system:macosx"}
  xcodebuildsettings { ["MACOSX_DEPLOYMENT_TARGET"] = "10.9" }

filter { "system:macosx", "configurations:Release*" }
  linkoptions { "-s", "-flto=full" }


filter "system:linux"
  defines { "_GNU_SOURCE" }
  buildoptions {
    "`pkg-config gtk+-3.0 --cflags`",      
    "`pkg-config fontconfig --cflags`",
    "-fPIC",
    "-Wno-unknown-pragmas",
    "-Wno-write-strings",
    "-Wno-deprecated-declarations",
    "-ldl",
    "-latomic"
  }
  linkoptions { 
    "-fPIC",
    "-pthread",
    "-static-libstdc++", 
    --"-static-libgcc",
    "-latomic"
  }

filter { "system:linux", "files:*.cpp" }
  buildoptions {
    "-fpermissive",
    "-Wno-reorder",
  }

filter {}

function pch(hfile,cfile,basedir)
  filter "system:windows"
    pchheader(hfile)
    pchsource(basedir .. "/" .. cfile)
  filter "system:not windows"
    pchheader("../" .. basedir .. "/" .. hfile)
  filter{}
end


function defincludes()
  includedirs { 
    ".",
    "engine",
    "engine/tool",
    "engine/gool",
    "engine/html",
    "engine/external/uv/include",
    "engine/external/uv-tls/include",
    "engine/external/zlib",
    BUILDDIR .. ".windows/include", 
  }
end

defines "SCITER_BUILD"

include "premake5-modules.lua"

skia_includes()

workspace "sciter"


--| 
--| Sciter Core libraries
--|

if not MONOLITHIC then 

    -- generate static libraries as separate projects 

    project "tool"
      -- location "build"
      kind "StaticLib"
      language "C++"

      filter {"system:windows", "configurations:Release*"}
        flags { "FatalCompileWarnings" }
      filter{}

      --includedirs { "engine", ".", "engine/tool", "engine/tool/re", "engine/external/zlib" }

      links { "zlib", "uv", "uv-tls" }

      defincludes()      

      include_files_tool()

      pch("tool.h", "tl_basic.cpp", "engine/tool")

      filter {"system:windows", "configurations:Release*"}
        flags { "FatalCompileWarnings" }
      filter{}


    project "gool"
      -- location "build"
      kind "StaticLib"
      language "C++"

      filter {"system:windows", "configurations:Release*"}
        flags { "FatalCompileWarnings" }
      filter{}

      links { "tool", "png", "jpeg", "webp" }

      defincludes()
      include_files_gool()

      pch("gool.h", "gool-types.cpp", "engine/gool")

    project "html"
      -- location "build"
      kind "StaticLib"
      language "C++"

      filter {"system:windows", "configurations:Release*"}
        flags { "FatalCompileWarnings" }
      filter{}

      links { "tool", "gool", "rlottie" }

      defincludes()

      include_files_html()

      filter "platforms:*Skia" 
        links { "skia" }
      filter {}    

      pch("html.h", "html-primitives.cpp", "engine/html")

    --| 
    --| Sciter Core libraries - Windows 
    --|

    if _TARGET_OS == "windows" then

      project "d2d"
          kind "StaticLib"
          language "C++"

          filter {"system:windows", "configurations:Release*"}
            flags { "FatalCompileWarnings" }
          filter{}
        
          pch("d2d.h", "d2d.cpp", "engine/d2d")

          defincludes()

          includedirs { "engine/external/zlib" }

          links { "tool", "gool" }

          include_files_d2d()

      project "gdi+"
          kind "StaticLib"
          language "C++"
          filter {"system:windows", "configurations:Release*"}
            flags { "FatalCompileWarnings" }
          filter {}
        
          pch("gdi+.h", "gdi+application.cpp", "engine/gdi+")

          removeconfigurations { "*Skia" }    

          links { "tool", "gool" }

          defincludes()

          include_files_gdi()

      project "win"
          kind "StaticLib"
          language "C++"
          filter {"system:windows", "configurations:Release*"}
            flags { "FatalCompileWarnings" }
          filter{}
        
          pch("win.h", "win-application.cpp", "engine/win")

          links { "tool", "gool", "d2d", "directshow" }

          defincludes()

          include_files_win()
    end 

    if _TARGET_OS == "macosx" then

      project "osx"
        kind "StaticLib"
        language "C++"

        links { "tool", "gool", "skia" }

        pch("osx-sciter.h", "", "osx")

        defincludes()
        include_files_osx()

    end



    if _OPTIONS["javascript"] then 

      project "qjs"
        kind "StaticLib"
        language "C++"

        -- links { "tool", "gool", "dybase" }

        defincludes()
        include_files_qjs()

      project "xdomjs"
        kind "StaticLib"
        language "C++"

        links { "tool", "gool", "html", "qjs" }

        defincludes()
        include_files_xdomjs()

    else

      project "dybase"
        kind "StaticLib"
        language "C++"

        pch("stdtp.h", "dybase.cpp", "engine/tiscript/dybase/src")

        defincludes()      
        include_files_dybase()

      project "tis"
        kind "StaticLib"
        language "C++"
        filter {"system:windows", "configurations:Release*"}
          flags { "FatalCompileWarnings" }
        filter{}

        links { "tool", "gool", "dybase" }

        filter "system:windows"
          pchheader "cs.h"
          pchsource "engine/tiscript/int/cs_heap.cpp"
        filter "system:not windows"
          pchheader "../engine/tiscript/include/cs.h"
        filter{}  

        defincludes()
        include_files_tis()

      project "xdom"
        kind "StaticLib"
        language "C++"
        filter {"system:windows", "configurations:Release*"}
          flags { "FatalCompileWarnings" }
        filter{}

        links { "tool", "gool", "html", "tis", "dybase" }

        defincludes()
        include_files_xdom()

        pch("xsciter.h", "xsciter.cpp", "engine/xdom")

    end

    --| 
    --| External libraries (3d party)
    --|

    project "uv"      ; kind "StaticLib"; language "C"; include_files_uv()
    project "uv-tls"  ; kind "StaticLib"; language "C"; include_files_uv_tls()
    project "zlib"    ; kind "StaticLib"; language "C"; symbols "Off"; include_files_zlib()
    project "png"     ; kind "StaticLib"; language "C"; links { "zlib" }; symbols "Off"; include_files_png()
    project "jpeg"    ; kind "StaticLib"; language "C"; symbols "Off"; include_files_jpeg()
    project "webp"    ; kind "StaticLib"; language "C"; symbols "Off"; include_files_webp()
    
    if CONFIG.defines.USE_LOTTIE then
      project "rlottie" ; kind "StaticLib"; include_files_rlottie()
    end  

    if _TARGET_OS == "windows" then project "directshow"; kind "StaticLib"; language "C++"; targetname "direct-show"; include_files_directshow() end
   
    -- and skia + xgl adapter
    project "skia";  
      kind "StaticLib"; language "C++"
      removeplatforms { "Release", "Debug" }
      defincludes()
      include_files_xgl_skia()

end -- MONOLITHIC

filter {}

--|
--| packfolder
--|

project "packfolder"
  kind "ConsoleApp"
  language "C++"

  removedefines { "SCITER", "SCITERJS" }

  defincludes()

  if MONOLITHIC then
    include_files_tool()
    include_files_uv()
    include_files_uv_tls()
    include_files_zlib()
  else
    links { "tool", "uv", "uv-tls" }
  end

  if _OPTIONS["javascript"] then 
    targetdir (SDKDIR .. "/bin/" .. osabbr() .. "/%{cfg.configuration}")
  else 
    targetdir (SDKDIR .. "/bin." .. osabbr() .. "/%{cfg.configuration}")
  end 

  files { "packfolder/packfolder.cpp" }

  filter "system:linux"
    linkoptions { "-fPIC", "-pthread", 
    "`pkg-config --libs glib-2.0`",
    "-Wl,--no-undefined","-ldl" }

  filter "system:windows"
    links { "shell32", "advapi32", "ole32", "oleaut32", "gdi32", "comdlg32" }
    removeplatforms { "x64","arm64" }

  filter{}


if _OPTIONS["javascript"] then 


--|
--| qjsc - quickjs compiler
--|

  project "qjsc"
    language "C++"
    kind "ConsoleApp"
    files {
      "engine/quickjs/qjsc.c"
    }
    removeconfigurations { "*Skia" }
    removedefines { "SCITER", "SCITERJS" }
    targetname "qjsc"

    --if MONOLITHIC then
      include_files_qjs()
    --else  
    --  links { "qjs" }
    --end

    targetdir (SDKDIR .. "/bin/" .. osabbr() .. "/%{cfg.configuration}")  

    filter "system:windows"
      removeplatforms { "x64","arm64" }
    filter "system:linux"
      linkoptions { "-fPIC", "-fexceptions", "-pthread", "-lm", "-Wl,--no-undefined","-ldl" }
    filter {}

--|
--| qjs - quickjs REPL
--|

  project "qjsi"

    language "C++"
    kind "ConsoleApp"

    --if MONOLITHIC then
      include_files_qjs()
    --else  
    --  links { "qjs" }
    --end
    targetdir (SDKDIR .. "/bin/" .. osabbr() .. "/%{cfg.configuration}")  

    targetname "qjs"
    removedefines { "SCITER", "SCITERJS" }
    removeconfigurations { "*Skia" }
    filter "system:windows"
      removeplatforms { "x64","arm64" }
    filter {}

    dependson { "qjsc" }
    
    files {
      "engine/quickjs/qjs.c",
      "engine/quickjs/repl.js",
      "engine/quickjs/repl.c",
      "engine/quickjs/qjscalc.js",
      "engine/quickjs/qjscalc.c"
    }

    filter "system:windows"
      -- Compile repl.js and save bytecode into repl.c
      prebuildcommands { "\"%{cfg.buildtarget.directory}qjsc.exe\" -c -o \"%{cfg.buildtarget.directory}../../../engine/quickjs/repl.c\" -m \"%{cfg.buildtarget.directory}../../../engine/quickjs/repl.js\"" }
      prebuildcommands { "\"%{cfg.buildtarget.directory}qjsc.exe\" -c -o \"%{cfg.buildtarget.directory}../../../engine/quickjs/qjscalc.c\" -m \"%{cfg.buildtarget.directory}../../../engine/quickjs/qjscalc.js\"" }

    filter "system:linux"

      prebuildcommands { "%{cfg.buildtarget.directory}/qjsc -c -o \"%{cfg.buildtarget.directory}/../../../engine/quickjs/repl.c\" -m \"%{cfg.buildtarget.directory}/../../../engine/quickjs/repl.js\"" }
      prebuildcommands { "%{cfg.buildtarget.directory}/qjsc -c -o \"%{cfg.buildtarget.directory}/../../../engine/quickjs/qjscalc.c\" -m \"%{cfg.buildtarget.directory}/../../../engine/quickjs/qjscalc.js\"" }

      linkoptions { "-fPIC", "-pthread", "-fexceptions", "-lm", "-Wl,--no-undefined","-ldl" }

    filter {}

else  

--|
--| tiscript
--|

  project "tiscript"
    kind "ConsoleApp"
    language "C++"

    removeconfigurations { "*Skia" }

    removedefines "SCITER"

    targetname "tiscript"

    defincludes()

    includedirs { 
      "engine/tiscript",
      "engine/tiscript/include", 
      "engine/tiscript/dybase/inc" 
    } 

    if MONOLITHIC then
      include_files_tool()
      include_files_uv()
      include_files_uv_tls()
      include_files_dybase()
      include_files_tis()
      include_files_zlib()
    else  
      include_files_tis()    
      links { "tool", "dybase", "uv", "uv-tls" }
    end

    targetdir (SDKDIR .. "/bin." .. osabbr() .. "/%{cfg.configuration}")

    files { "engine/tiscript/terrascript/terrascript.cpp" }

    filter "system:macosx"
      links { "CoreFoundation.framework","Cocoa.framework" }    
    filter "system:linux"
      linkoptions { 
      "`pkg-config --libs glib-2.0`",
      "-fPIC", "-pthread", "-Wl,--no-undefined","-ldl" }
    filter "system:windows"
      links { "shell32", "advapi32", "ole32", "oleaut32", "gdi32", "comdlg32" }
      removeplatforms { "x64","arm64" }
    filter {}

end  

--|
--| sciter dll per se
--|


project "sciter"
  kind "SharedLib"
  language "C++"

  defines { "SCITER_EXPORTS" }

  dependson { "packfolder","tiscript" }

  settargetdir (SDKDIR .. "/")

  defincludes()
  
  if MONOLITHIC then
    include_files_tool()
    include_files_uv()
    include_files_gool()
    include_files_zlib()
    include_files_png()
    include_files_jpeg()
    include_files_webp()
    include_files_rlottie()
    include_files_html()
    if _TARGET_OS == "linux" then    
      include_files_gtk()
    elseif _TARGET_OS == "macosx" then
      include_files_osx()
    end  
    include_files_uv_tls()
    include_files_xgl_skia()        

    if SCRIPT == TIS then
      includedirs { 
        "engine/tiscript/include", 
        "engine/tiscript/dybase/inc" 
      } 
      include_files_tis()
      include_files_xdom()
      include_files_dybase()
    else 
      includedirs { 
        "engine/quickjs"
      } 
      include_files_qjs()
      include_files_xdomjs()
    end

  else

    links { "tool", "gool", "html", "zlib", "uv", "uv-tls", "png", "jpeg", "webp", "rlottie" }

    if SCRIPT == QJS then
      links { "qjs", "xdomjs" }
    else 
      links { "tis", "dybase", "xdom" }
    end

    filter "configurations:*Skia" 
      links { "skia" }
    filter{}
  end

  files { "engine/*.h" }


  filter {"system:windows", "platforms:x32 or x64"}
       
    if not _OPTIONS["norevision"] then
      if SCRIPT == TIS then  
        prebuildcommands { 
          "subwcrev.exe \"%{wks.location}..\" \"%{wks.location}..\\engine\\sciter-revision-template.h\" \"%{wks.location}..\\engine\\sciter-revision.h\"",
          "\"%{wks.location}..\\sdk\\bin.win\\tiscript.exe\" -o \"%{wks.location}..\\engine\\res\\promise.bc\" -c \"%{wks.location}..\\engine\\lib\\promise.tis\"",
          "\"%{wks.location}..\\sdk\\bin.win\\packfolder.exe\" \"%{wks.location}..\\engine\\res\" \"%{wks.location}..\\engine\\master-css-resources.cpp\"  -v \"master_css_resources\""
        }
      else 
        prebuildcommands { 
          "subwcrev.exe \"%{wks.location}..\\..\" \"%{wks.location}..\\..\\engine\\sciter-revision-template.h\" \"%{wks.location}..\\..\\engine\\sciter-revision.h\"",
          "\"%{wks.location}..\\..\\".. SDKDIR .. "\\bin\\windows\\packfolder.exe\" \"%{wks.location}..\\..\\engine\\res.js\" \"%{wks.location}..\\..\\engine\\master-css-resources-js.cpp\"  -v \"master_css_resources\""
        }
      end
    end

  filter {"system:windows", "configurations:Release or Debug or ReleaseMD or DebugMD"}
    links { "gdi+" }
  filter {}      
 

  filter { "system:windows" }
    targetname "sciter"
    links { "d2d", "win", "directshow", "usp10", "ws2_32", "wininet", "windowscodecs", "shell32", "advapi32", "ole32", "oleaut32", "gdi32", "comdlg32", "winspool" }
    includedirs { "windows/sciter" }
    files { 
      "engine/win/win-sciter-api.cpp",
      "engine/win/dll/dllmain.cpp",       
      "engine/win/dll/sciter.def", 
      "engine/win/dll/sciter.dll.rc", 
    }

  filter { "system:macosx" }
    --targetname "sciter-osx-32"
    links { 
      "CoreFoundation.framework", 
      "Cocoa.framework",
      "Carbon.framework", 
      "AVFoundation.framework",
      "SystemConfiguration.framework",
      "CoreMedia.framework",
      "CoreText.framework",
      "CoreGraphics.framework",
      "CoreData.framework",
      "CoreVideo.framework",
      "IOKit.framework",
      "OpenGL.framework"
    } 
  filter { "system:macosx", "platforms:*64" }
    --targetname "sciter-osx-64"
    --targetprefix "" 

  filter { "system:linux" }
    targetname "sciter-gtk"
    linkoptions { 
       "`pkg-config gtk+-3.0 --libs`",
       "`pkg-config fontconfig --libs`",
       "-fPIC",
       "-pthread",
       "-Wl,--no-undefined",
       "-ldl",
       "-latomic",
       --"-static-libstdc++", 
       --"-static-libgcc",
    }

    
  filter {}  

project "scapp"
  filter "system:macosx"
    kind "ConsoleApp"
  filter "system:not macosx"
    kind "WindowedApp"
  filter{}
  language "C++"

  defincludes()

  if SCRIPT == QJS then
    dependson { "qjsc" }
  else
    includedirs { 
      "engine/tiscripcrt/include", 
      "engine/tiscript/dybase/inc" 
    } 
  end


  defines { "STATIC_LIB" }

  if MONOLITHIC then
    include_files_tool()
    include_files_uv()
    include_files_uv_tls()
    include_files_dybase()
    include_files_gool()
    include_files_zlib()
    include_files_png()
    include_files_jpeg()
    include_files_webp()
    include_files_rlottie()
    include_files_html()
    if SCRIPT == QJS then
      include_files_xdomjs()
      include_files_qjs()
    else 
      include_files_xdom()
      include_files_tis()
    end

    if _TARGET_OS == "linux" then    
      include_files_gtk()
    elseif _TARGET_OS == "macosx" then
      include_files_osx()
      include_files_xgl_skia()
    end  
  else
    links { "zlib", "uv", "uv-tls", "png", "jpeg", "webp","tool","gool","html" }
    if SCRIPT == QJS then
      links { "qjs", "xdomjs" }
    else 
      links { "dybase", "tis", "xdom" }
    end
    filter "configurations:*Skia" 
      links { "skia" }
    filter {}
  end           

  filter {}

  settargetdir (SDKDIR .. "/")

  includedirs { 
    "engine/tiscript/include" 
  }

  files { "scapp/main.cpp" }

  filter "system:windows"
    entrypoint "mainCRTStartup"
    dpiawareness "HighPerMonitor"
    removeconfigurations { "*Skia" }  
    links { "d2d", "win", "directshow", "usp10", "ws2_32", "wininet", "windowscodecs", "shell32", "advapi32", "ole32", "oleaut32", "gdi32", "comdlg32", "winspool", "version" }
    includedirs { "engine/win" }
    files {
       "scapp/windows/plumbing.cpp",
       "scapp/windows/dpi-aware.manifest",
       "scapp/windows/scapp.rc",
    }

  filter { "system:windows", "configurations:Debug or Release or DebugMD or ReleaseMD" } 
    links { "gdi+" }

  filter "system:macosx"
    links { 
      "CoreFoundation.framework", 
      "Cocoa.framework",
      "Carbon.framework", 
      "AVFoundation.framework",
      "SystemConfiguration.framework",
      "CoreMedia.framework",
      "CoreText.framework",
      "CoreGraphics.framework",
      "CoreData.framework",
      "CoreVideo.framework",
      "IOKit.framework",
      "OpenGL.framework"
    } 
    files {
       "scapp/main.cpp",
       "scapp/macosx/plumbing.mm"
    }

  filter "system:linux"
    removeplatforms { "*Skia" } 
    linkoptions { 
       "`pkg-config gtk+-3.0 --libs`",
       "`pkg-config fontconfig --libs`",
       "-fPIC",
       "-pthread",
       "-Wl,--no-undefined",
       "-ldl",
       "-latomic",
       "-static-libstdc++", 
       "-static-libgcc",
    }

    files {
       "scapp/main.cpp",
       "scapp/linux/plumbing.cpp"
    }

  filter{}


workspace "sciter.static"

  defincludes()
  
  project "sciter.static"
    kind "StaticLib"
    language "C++"

    defines { "STATIC_LIB", "MONOLITHIC" }
    
    targetname "sciter.static"

    flags { "OmitDefaultLibrary" }

    if _OPTIONS["javascript"] then 
      filter "configurations:not *Skia" 
        targetdir ("lib/" .. osabbr() .. "/%{cfg.configuration}/%{cfg.platform}")  
      filter "configurations:*Skia" 
        targetdir ("lib/" .. osabbr() .. "/%{cfg.configuration}/%{cfg.platform}-skia")  
      filter {}
    else
      filter "configurations:not *Skia" 
        targetdir ("lib." .. osabbr() .. "/%{cfg.configuration}/%{cfg.platform}")  
      filter "configurations:*Skia" 
        targetdir ("lib." .. osabbr() .. "/%{cfg.configuration}/%{cfg.platform}-skia")  
      filter {}
    end

    includedirs { 
      "engine/tiscript/include" 
    }

  -- if MONOLITHIC then -- static lib is monolithic by definition
    include_files_tool()
    include_files_uv()
    include_files_dybase()
    include_files_gool()
    include_files_zlib()
    include_files_png()
    include_files_jpeg()
    include_files_webp()
    include_files_rlottie()
    include_files_html()

    if SCRIPT == QJS then
      include_files_xdomjs()
      include_files_qjs()
    else 
      include_files_xdom()
      include_files_tis()
    end    

    if _TARGET_OS == "linux" then    
      include_files_gtk()
    elseif _TARGET_OS == "macosx" then
      include_files_osx()
    elseif _TARGET_OS == "windows" then
      include_files_win()
      include_files_d2d()
      include_files_gdi()
      include_files_directshow()
    end  
    include_files_xgl_skia()
    include_files_uv_tls()

    filter "system:windows"
      files { "engine/win/win-sciter-static-lib.cpp", "engine/win/win-sciter-api.cpp" }
      symbolspath '$(OutDir)$(TargetName).pdb'

    filter "system:macosx"
      links { 
        "CoreFoundation.framework", 
        "Cocoa.framework",
        "Carbon.framework", 
        "AVFoundation.framework",
        "SystemConfiguration.framework",
        "CoreMedia.framework",
        "CoreText.framework",
        "CoreGraphics.framework",
        "CoreData.framework",
        "CoreVideo.framework",
        "IOKit.framework",
        "OpenGL.framework"
      } 
    filter {}  


project "sciter.static.app"
  filter "system:macosx"
    kind "ConsoleApp"
  filter "system:not macosx"
    kind "WindowedApp"
  filter{}
  language "C++"

  defincludes()

  if SCRIPT == QJS then
    dependson { "qjsc" }
  end

  defines { "STATIC_LIB" }

  links { "sciter.static" }

  filter {}

  settargetdir (SDKDIR .. "/")

  files { "scapp/main.cpp" }

  filter "system:windows"
    entrypoint "mainCRTStartup"
    dpiawareness "HighPerMonitor"
    removeconfigurations { "*Skia" }  
    links { "usp10", "ws2_32", "wininet", "windowscodecs", "shell32", "advapi32", "ole32", "oleaut32", "gdi32", "comdlg32", "winspool", "version" }
    includedirs { "engine/win" }
    files {
       "scapp/windows/plumbing.cpp",
       "scapp/windows/dpi-aware.manifest",
       "scapp/windows/scapp.rc",
    }

  filter "system:macosx"
    links { 
      "CoreFoundation.framework", 
      "Cocoa.framework",
      "Carbon.framework", 
      "AVFoundation.framework",
      "SystemConfiguration.framework",
      "CoreMedia.framework",
      "CoreText.framework",
      "CoreGraphics.framework",
      "CoreData.framework",
      "CoreVideo.framework",
      "IOKit.framework",
      "OpenGL.framework"
    } 
    files {
       "scapp/main.cpp",
       "scapp/macosx/plumbing.mm"
    }

  filter "system:linux"
    removeplatforms { "*Skia" } 
    linkoptions { 
       "`pkg-config gtk+-3.0 --libs`",
       "`pkg-config fontconfig --libs`",
       "-fPIC",
       "-pthread",
       "-Wl,--no-undefined",
       "-ldl",
       "-latomic",
       --"-static-libstdc++", 
       --"-static-libgcc",
    }

    files {
       "scapp/main.cpp",
       "scapp/linux/plumbing.cpp"
    }

  filter{}


--| 
--| generate "lite" solution
--|

--if _TARGET_OS ~= "macosx" then
--  include "premake5-lite.lua"
--end


