
newoption {
   trigger     = "device",
   value       = "DESKTOP|HANDHELD|IOT",
   description = "target device",
   default     = "DESKTOP",
   allowed = {
      { "DESKTOP",   "Desktop machine" },
      { "HANDHELD",  "Mobile device" },
      { "IOT",       "IoT device" }
   }
}

newoption {
   trigger     = "javascript",
   description = "Will build Sciter.JS"
}

TIS = 1
QJS = 2

SDKDIR = "sdk"
BUILDDIR = "build"

MONOLITHIC = true -- by design
USE_SKIA_BY_DEFAULT = true -- only rendering option on devices
WINDOWLESS = true

defines { "WINDOWLESS", "MONOLITHIC", "SCITER_BUILD",
          "DEVICE=" .. _OPTIONS["device"] }

if _OPTIONS["javascript"] then 
  SCRIPT = QJS
  SDKDIR = "sdk.js"
  BUILDDIR = "build.js"
  defines { "SCITERJS", "JS_STRICT_NAN_BOXING" }
else   
  SCRIPT = TIS
  SDKDIR = "sdk"
  BUILDDIR = "build"
  defines { "SCITER" }
end

require "config"
          
include "premake5-modules.lua"

configurations { "Debug", "Release" }
platforms { "x32", "x64","arm32", "arm64" } 

if _OPTIONS["javascript"] then 

  function osabbr() 
    return os.target()
  end

  filter "system:windows"
    buildoptions "-Zm200"
    location(BUILDDIR .. "/" .. osabbr())  
    platforms { "x32", "x64", "arm32", "arm64" }
    --configurations { "DebugSkia", "ReleaseSkia" }
    defines { "_CRT_SECURE_NO_WARNINGS" } 
    systemversion "latest"

  filter "system:macosx"
    location(BUILDDIR .. "/" .. osabbr())  
    platforms { "x64" }  
  filter "system:linux"
    location(BUILDDIR .. "/" .. osabbr() .. "/" .. string.lower(_OPTIONS["device"]))
    platforms { "x64", "arm32", "arm64" }  
  filter "system:android"
    location(BUILDDIR .. "/" .. osabbr())  
    platforms { "x32", "x64", "arm32", "arm64" }  
  filter {}

else

  function osabbr() 
    if( os.target() == "macosx") then return "osx" 
    elseif( os.target() == "windows") then return "win"
    elseif( os.target() == "linux") then return "lnx"
    elseif( os.target() == "android") then return "android"
    else return os.target()
    end
  end

  filter "system:windows"
    buildoptions "-Zm200"
    location "build.windows"
    symbolspath '$(OutDir)$(TargetName).pdb'
    systemversion "latest"
  filter "system:macosx"
    location "build.macosx"
  filter "system:linux"
    location("build.linux/" .. string.lower(_OPTIONS["device"]))
  filter "system:android"
    location "build.android"
    toolset "clang"
    defines { "ANDROID" }
  filter {}

end

includedirs { 
  ".",     
  "engine",
  "engine/tool",
  "engine/gool",
  "engine/html",
  "engine/external/uv/include",
  "engine/external/uv-tls/include",
  "engine/external/zlib" 
}  

filter "not system:linux"
  flags { "MultiProcessorCompile" } -- does not work reliably on Linux, why?
filter{}

cppdialect "C++14"
cdialect "C99"

staticruntime "On"

filter "platforms:x32"
  architecture "x86"
filter "platforms:x64"
  architecture "x86_64" 
filter "platforms:arm32"
  architecture "ARM" 
filter "platforms:arm64"
  architecture "ARM64" 

filter {"platforms:x32", "system:windows"}
  defines { "WIN32" }
filter {"platforms:x64", "system:windows"}
  defines { "WIN32","WIN64" }      
filter {"platforms:arm64", "system:windows"}
  defines { "WIN32","WIN64","ARM64" }      
  architecture "ARM64" 

filter "configurations:Debug*"
  defines { "DEBUG", "_DEBUG" }
  symbols "On"

filter "configurations:Release*"
  defines { "NDEBUG"}  
  optimize "Full"
  -- symbols "Off"
  flags { "LinkTimeOptimization" }

filter {"system:windows"}
  defines { "_CRT_SECURE_NO_WARNINGS" } 

filter { "system:macosx", "configurations:Release*" }
  linkoptions { "-s", "-flto=full" }

filter "system:linux"
  defines { "_GNU_SOURCE" }
  buildoptions {
    "`pkg-config fontconfig --cflags`",
    "-fPIC",
    "-Wno-unknown-pragmas",
    "-Wno-write-strings",
  }
  linkoptions { 
    "-fPIC",
    "-pthread",
    "-ldl",     
  } 

filter { "system:linux", "platforms:x32 or x64" }
  buildoptions {
    "-march=nehalem",
  }

filter { "system:linux", "platforms:arm32 or arm64" }
  -- rapsberry Pi 2 and above
  buildoptions {
    "-mfpu=neon",
    "-mfloat-abi=hard",
  }
  linkoptions {
    "-mfpu=neon",
    "-mfloat-abi=hard",
  }


filter { "toolset:gcc", "files:*.cpp" }
  buildoptions {
    "-fpermissive",
    "-Wno-reorder",
  }

filter "system:android"
  buildoptions { "-fexceptions" }
  --optimize "Off"


filter {}

skia_includes()


workspace "sciter.lite"

--|
--| sciter dll
--|

project "sciter.lite"
  kind "SharedLib"
  language "C++"

  defines { "SCITER_EXPORTS" }
 
  filter "system:android"
    toolset "clang"
    --optimize "Off"
    defines { "ANDROID" }

  filter{}

  targetname "sciter"

  include_files_lite()
  include_files_tool()
  include_files_uv()
  include_files_uv_tls()  
  include_files_dybase()
  include_files_gool()
  include_files_zlib()
  include_files_png()
  include_files_jpeg()
  include_files_webp()
  include_files_rlottie()
  include_files_html()
  if SCRIPT == QJS then
    include_files_xdomjs()
    include_files_qjs()
  else 
    include_files_xdom()
    include_files_tis()
  end

  if os.target() == "windows" then
    --include_files_directshow()
    include_files_d2d()
  end
  --if os.target() == "linux" then    
  --  include_files_gtk()
  --elseif os.target() == "macosx" then
  --  include_files_osx()
  --end  
  include_files_xgl_skia()
  include_freetype_files()

  configuration "windows"
    if SCRIPT == TIS then   
      prebuildcommands { 
        "subwcrev.exe $(SolutionDir).. $(SolutionDir)..\\engine\\sciter-revision-template.h $(SolutionDir)..\\engine\\sciter-revision.h",
        "$(SolutionDir)..\\sdk\\bin.win\\tiscript.exe -o $(SolutionDir)..\\engine\\res\\promise.bc -c $(SolutionDir)..\\engine\\lib\\promise.tis",
        "$(SolutionDir)..\\sdk\\bin.win\\packfolder.exe $(SolutionDir)..\\engine\\res $(SolutionDir)..\\engine\\master-css-resources.cpp  -v \"master_css_resources\"" }
    else
      prebuildcommands { 
        "subwcrev.exe \"%{wks.location}..\\..\" \"%{wks.location}..\\..\\engine\\sciter-revision-template.h\" \"%{wks.location}..\\..\\engine\\sciter-revision.h\"",
        "\"%{wks.location}..\\..\\".. SDKDIR .. "\\bin\\windows\\packfolder.exe\" \"%{wks.location}..\\..\\engine\\res.js\" \"%{wks.location}..\\..\\engine\\master-css-resources-js.cpp\"  -v \"master_css_resources\"" }
    end
  configuration {}

if _OPTIONS["javascript"] then 
  targetdir (SDKDIR .. "/bin.lite/" .. osabbr() .. "/%{cfg.platform}")
else  
  targetdir (SDKDIR .. "/bin." .. osabbr() .. "/%{cfg.platform}lite")
end


  filter "system:windows"
    links { "usp10", "ws2_32", "wininet", "windowscodecs" }
    files { 
      "engine/lite/windows/dllmain.cpp",       
      "engine/lite/windows/sciter.def", 
      "engine/lite/windows/sciter.dll.rc", 
      "engine/lite/windows/lite-d2d.cpp", 
    }

  filter "system:macosx"
    links { 
      "CoreFoundation.framework", 
      "Cocoa.framework",
      "Carbon.framework", 
      "AVFoundation.framework",
      "SystemConfiguration.framework",
      "CoreMedia.framework",
      "CoreText.framework",
      "CoreGraphics.framework",
      "CoreData.framework",
      "CoreVideo.framework",
      "IOKit.framework",
      "OpenGL.framework"
    } 

  filter "system:linux"
    linkoptions { 
       "`pkg-config fontconfig --libs`",
       "-fPIC",
       "-pthread",
       "-Wl,--no-undefined",
       "-lGL", "-lGLU", "-lX11",
       "-ldl",
       "-latomic",
    }

  filter "system:android"
    buildoptions { "-Wreorder" }
    links {"GLESv2","GLESv1_CM","EGL","m"}

  filter {}  

workspace "sciter.lite.static"

project "sciter.lite.static"
  kind "StaticLib"
  language "C++"

  defines { "STATIC_LIB" }
  
  targetname "sciter.static"

  targetdir (BUILDDIR .. "/lib." .. osabbr() .."/%{cfg.platform}lite")

  includedirs { 
    "engine/tiscript/include" 
  }

  include_files_lite()
  include_files_tool()
  include_files_uv()
  include_files_uv_tls()  
  include_files_dybase()
  include_files_tis()
  include_files_gool()
  include_files_zlib()
  include_files_png()
  include_files_jpeg()
  include_files_webp()
  include_files_rlottie()
  include_files_html()
  include_files_xdom()
  --if os.target() == "windows" then
  --  include_files_directshow()
  --if os.target() == "linux" then    
  --  include_files_gtk()
  --elseif os.target() == "macosx" then
  --  include_files_osx()
  --end  
  include_files_xgl_skia()        
  include_freetype_files()

  filter "system:macosx"
    links { 
      "CoreFoundation.framework", 
      "Cocoa.framework",
      "Carbon.framework", 
      "AVFoundation.framework",
      "SystemConfiguration.framework",
      "CoreMedia.framework",
      "CoreText.framework",
      "CoreGraphics.framework",
      "CoreData.framework",
      "CoreVideo.framework",
      "IOKit.framework",
      "OpenGL.framework"
    } 
  filter {}  

-- include "sdk"

