//|
//|
//| Copyright (c) 2001-2005
//| Andrew Fedoniouk - andrew@terrainformatica.com
//|
//| UXTHEME support
//|

#pragma once

#include "tool/tool.h"
#include "gool/gool-image.h"
#include "gool/gool-theme-parts.h"
#include "gool/gool-theme.h"


namespace gool 
{
  using namespace tool;

  class theme_image_osx;

  class theme_osx: public theme
  {
    typedef theme super;

    array<handle<theme_image_osx>> images;
    //handle<theme_image_XP>  v_scrollbar[24]; // part images
    //handle<theme_image_XP>  h_scrollbar[24]; // part images

  public:

    theme_osx(); 
    virtual ~theme_osx();
    
    virtual gool::image* get_image_impl(uint id) override;

    virtual void  draw_h_scrollbar(gool::graphics* sf, uint pt, uint st, rect rc ) override;
    virtual void  draw_v_scrollbar(gool::graphics* sf, uint pt, uint st, rect rc ) override;

    virtual int   border_width() override { return 1; }
  };


  class theme_image_osx: public image
  {
  public:
    enum _ 
    {
      CACHED_BITMAPS = 4
    };

    uint   image_id;
    circular_buffer< handle<bitmap> > cache;
   
    theme_image_osx( uint ni ): image_id(ni),cache(CACHED_BITMAPS) {}
    virtual ~theme_image_osx(){}

    virtual handle<bitmap> get_bitmap(graphics* sf, size sz); 
        
    virtual bool is_valid() const override { return true; }

    virtual void draw(graphics* gfx, rect dst, rect src, byte opacity) override;

    virtual size dim(const rect& for_dst) const { return for_dst.size(); } 
    virtual size dim() const;
    virtual bool is_spacer() { return false; }
    virtual bool is_transparent()  const; 

    virtual void drop_cache() 
    {
      critical_section _(theme::lock());
      cache.clear();
    }

  };


}
