#include "osx-sciter.h"
#include "osx-sciter-graphics.h"

#include <ApplicationServices/ApplicationServices.h>

//#include "osx-cvt.h"


uint32 osx_default_glyph_for_char(CTFontRef font, uint32 unicode);
CFStringRef cfstr(tool::wchars text);

//CGImageRef osx_image( gool::bitmap* bmp, osx::graphics* gfx);

namespace osx
{

    static CGColorRef cvt( gool::argb color ) {
        return CGColorCreateGenericRGB( color.red / 255.0f, color.green / 255.0f, color.blue / 255.0f, color.alfa / 255.0f );
    }
    
    template <typename CT>
    inline CGPoint cvt (const gool::geom::point_t<CT>& pt) noexcept
    {
        CGPoint r;
        r.x = pt.x;
        r.y = pt.y;
        return r;
    }
    
    template <typename CT>
    inline CGSize cvt (const gool::geom::size_t<CT>& sz) noexcept
    {
        CGSize r;
        r.width = sz.x;
        r.height = sz.y;
        return r;
    }
    
    CGRect cvt (const gool::rect& r)
    {
        return CGRectMake (static_cast <CGFloat> (r.left()),
                           static_cast <CGFloat> (r.top()),
                           static_cast <CGFloat> (r.width()),
                           static_cast <CGFloat> (r.height()));
    }
    
    CGRect cvt (const gool::rectf& r)
    {
        return CGRectMake (static_cast <CGFloat> (r.left()),
                           static_cast <CGFloat> (r.top()),
                           static_cast <CGFloat> (r.width()),
                           static_cast <CGFloat> (r.height()));
    }
    
    
   bool font::has_glyph_for(uint ucodepoint) const {
     return glyph_index(ucodepoint) != 0;
   }
   
   uint font::glyph_index(uint ucodepoint) const {
     return osx_default_glyph_for_char(this->ct_font(),ucodepoint);
   }
    
   bool font::glyph_metrics(::uint16 glyph_index, float em_size, float& width, float& height) const {
       //return osx_default_glyph_for_char(this->ct_font(),ucodepoint);
       uint16 gi[1] = { glyph_index };
       osx_get_glyph_advances( const_cast<font*>(this), tool::slice<uint16>(gi,1), &width );
       height = this->height();
       return true;
   }

   void graphics::fill( image* img, const gool::path* dst)
   {
     #pragma TODO("graphics::fill( image* img, const gool::path* dst)")
     //assert(false);
   }

   void graphics::draw_line(pointf p1, pointf p2 , argb c, int width) 
   {
     #pragma TODO("draw_line(pointf p1, pointf p2 , argb c, int width)")
     assert(false);
   }
    

    point graphics::offset(point noff) {
      point off = _offset;
      //_target.setOrigin(noff.x,noff.y);
      osx_graphics_set_offset(this,noff);
      _offset = noff;
       _clip_rc -= noff;
      return off;
    }

    
    
    solid_brush::solid_brush(gool::argb c) { this->color = cvt(c); }
    
    void solid_brush::draw( graphics* gfx )
    {
        if(gfx->_registers.fill_even_odd)
            CGContextFillPath(gfx->target());
        else
            CGContextEOFillPath(gfx->target());
    }
    
    gradient_brush::gradient_brush( const gool::gradient_brush& bin ) {
        
        mx = bin.transform();
        
        CF::ref<CGColorSpaceRef> colorSpace = CGColorSpaceCreateDeviceRGB();
        
        slice<gool::color_stop>   color_stops = bin.stops();
        
        tool::buffer<CGFloat, 256> colors(color_stops.length * 4);
        tool::buffer<CGFloat, 64> pos(color_stops.length);
        
        uint ci = 0;
        for( uint i = 0; i < color_stops.length; ++i ) {
            auto c = color_stops[i].color;
            colors[ci + 0] = c.red / 255.0;
            colors[ci + 1] = c.green / 255.0;
            colors[ci + 2] = c.blue / 255.0;
            colors[ci + 3] = c.alfa / 255.0;
            ci += 4;
            pos[i] = color_stops[i].position;
        }
        
        gradient = CGGradientCreateWithColorComponents(colorSpace, colors.cbegin(), pos.cbegin(), pos.length());
    }
    
    void linear_gradient_brush::draw( graphics* gfx )
    {
        CGContextSaveGState(gfx->target());
        
        gfx->transform( this->mx );
        
        CGContextDrawLinearGradient(
                                    gfx->target(),
                                    gradient,
                                    cvt(start),
                                    cvt(end),
                                    kCGGradientDrawsBeforeStartLocation | kCGGradientDrawsAfterEndLocation);
        CGContextRestoreGState(gfx->target());
        
    }
    
    void radial_gradient_brush::draw( graphics* gfx )
    {
        CGContextSaveGState(gfx->target());
        
        gfx->transform( this->mx );
        
        if( radius.x == radius.y )
            CGContextDrawRadialGradient(
                                        gfx->target(),
                                        gradient,
                                        cvt(center),
                                        0,
                                        cvt(center),
                                        radius.x,
                                        kCGGradientDrawsBeforeStartLocation | kCGGradientDrawsAfterEndLocation);
        else {
            
            CGContextTranslateCTM(gfx->target(), center.x, center.y);
            CGContextScaleCTM(gfx->target(), radius.x, radius.y);
            CGPoint z; z.x = 0; z.y = 0;
            CGContextDrawRadialGradient(
                                        gfx->target(),
                                        gradient,
                                        z,
                                        0,
                                        z,
                                        1.0,
                                        kCGGradientDrawsBeforeStartLocation | kCGGradientDrawsAfterEndLocation);
        }
        CGContextRestoreGState(gfx->target());

    }
    
    void image_brush::draw( graphics* gfx )
    {
        gool::bitmap *bmp = img->get_bitmap(gfx, img->dim());
        
        CGImageRef cgimg = osx_image( bmp, gfx );
        
        CGContextSetInterpolationQuality(gfx->target(), kCGInterpolationLow);
        
        CGContextScaleCTM(gfx->target(), 1.0, -1.0);
        
        CGRect tile;
        tile.origin = cvt( gool::pointf(0, -img->dim().y));
        tile.size = cvt(bmp->dim());
        
        CGContextDrawTiledImage ( gfx->target(), tile, cgimg );
    }
    
    void graphics::set_stroke( argb c)
    {
        _registers.stroke_brush = new solid_brush(c);
        osx_graphics_set_stroke_color( this, c );
    }
    void graphics::set_stroke( const linear_brush& lb )
    {
        _registers.stroke_brush = new linear_gradient_brush(lb);
        //osx_graphics_set_stroke_color( this, gool::argb(255,0,255) );
    }
    void graphics::set_stroke( const radial_brush& rb ) {
        _registers.stroke_brush = new radial_gradient_brush(rb);
        //osx_graphics_set_stroke_color( this, gool::argb(255,0,255) );
    }
    void graphics::set_stroke_width( float w )
    {
        osx_graphics_set_stroke_width( this, _registers.stroke_width = w );
    }
    
    void graphics::set_fill( argb c )
    {
        _registers.fill_brush = new solid_brush(c);
        osx_graphics_set_fill_color( this, c );
    }
    void graphics::set_fill( const linear_brush& lb )
    {
        _registers.fill_brush = new linear_gradient_brush(lb);
        //osx_graphics_set_fill_brush( this, lb );
    }
    void graphics::set_fill( const radial_brush& rb )
    {
        _registers.fill_brush = new radial_gradient_brush(rb);
        //osx_graphics_set_fill_brush( this, rb );
    }
    void graphics::set_fill( const image* ib )
    {
        _registers.fill_brush = new image_brush(ib);
        //osx_graphics_set_fill_brush( this, ib );
    }
    void graphics::set_fill_even_odd( bool even_odd )
    {
        _registers.fill_even_odd = even_odd;
        //osx_graphics_set_fill_even_odd( this, even_odd );
    }
    
    uint graphics::push_state()
    {
        osx_graphics_push_state( this );
        uint lv = uint(_registers_stack.length());
        _registers_stack.push(_registers);
        return lv;
    }
    bool graphics::pop_state()
    {
        if( !_registers_stack.size() )
            return false;
        _registers = _registers_stack.pop();
        osx_graphics_pop_state( this );
        return true;
    }
    void graphics::restore_state(uint level)
    {
        while( _registers_stack.length() &&
              _registers_stack.length() > level )
            pop_state();
    }
    
    void graphics::render_current_path(bool fill, bool stroke)
    {
      CF::ref<CGPathRef> path;
        
      if( _registers.fill_brush && fill) {
          
        if(_registers.stroke_brush && stroke)
          path = CGContextCopyPath( _target );
          
        if(_registers.fill_brush->is_solid())
            _registers.fill_brush->draw(this);
        else {
            CGContextSaveGState(_target);
            if( _registers.fill_even_odd )
              CGContextEOClip(_target);
            else
              CGContextClip(_target);
            _registers.fill_brush->draw(this);
            CGContextRestoreGState(_target);
        }
      }
      if( _registers.stroke_brush && stroke) {
          if( path )
              CGContextAddPath(_target,path);

          if(_registers.stroke_brush->is_solid())
             CGContextStrokePath(_target);
          else {
              CGContextReplacePathWithStrokedPath(_target);
              CGContextSaveGState(_target);
              CGContextClip(_target);
              _registers.stroke_brush->draw(this);
              CGContextRestoreGState(_target);
          }
      }
    }
    
    void graphics::draw_line(pointf start, pointf end)
    {
        CGContextMoveToPoint ( _target, start.x, start.y );
        CGContextAddLineToPoint ( _target, end.x, end.y );
        CGContextStrokePath( _target );
    }
    
    void graphics::draw_rectangle(pointf org, sizef dim, bool stroke, bool fill)
    {
        CGContextMoveToPoint ( _target, org.x, org.y );
        CGContextAddLineToPoint ( _target, org.x + dim.x, org.y );
        CGContextAddLineToPoint ( _target, org.x + dim.x, org.y + dim.y );
        CGContextAddLineToPoint ( _target, org.x, org.y + dim.y );
        CGContextClosePath( _target );
        render_current_path(fill,stroke);
    }
    
    void graphics::draw_path( const gool::path* dst, bool stroke, bool fill)
    {
        const osx::path* odst = static_cast<const osx::path*>(dst);
        assert(odst->cgpath());
        CGContextAddPath ( _target, odst->cgpath());
        render_current_path(fill,stroke);
    }
    
    void graphics::draw_ellipse(pointf center, sizef radius, bool stroke, bool fill)
    {
        gool::rect rc( center, center ); rc >>= radius;
        CGContextAddEllipseInRect ( _target, cvt( rc ) );
        render_current_path(fill,stroke);
    }
    
    void graphics::draw_arc(pointf center, sizef radius, float angle_start, float angle_sweep, bool stroke, bool fill) {
    
        //CGContextBeginPath(_target);
        
        if(_registers.fill_drawable())
            CGContextMoveToPoint ( _target, center.x, center.y );
       
        if( radius.x == radius.y )
            CGContextAddArc ( _target,
                             center.x,
                             center.y,
                             radius.x,
                             angle_start,
                             angle_start + angle_sweep,
                             angle_sweep < 0 );
        else {
            CGContextSaveGState(_target);
            CGContextTranslateCTM(_target, center.x, center.y);
            CGContextScaleCTM(_target, radius.x, radius.y);
            CGContextAddArc ( _target,
                             0,
                             0,
                             1,
                             angle_start,
                             angle_start + angle_sweep,
                             angle_sweep < 0 );
            
            CGContextRestoreGState(_target);
        }

        if(_registers.fill_drawable())
           CGContextClosePath(_target);
        
        render_current_path(fill,stroke);
    }

    void graphics::image_rendering_mode( IMAGE_RENDERING irm)
    {
        switch( irm ) {
            default:
            case image_rendering_default : CGContextSetInterpolationQuality ( _target, kCGInterpolationDefault ); return;
            case image_rendering_speed   : CGContextSetInterpolationQuality ( _target, kCGInterpolationNone ); return;
            case image_rendering_quality : CGContextSetInterpolationQuality ( _target, kCGInterpolationHigh ); return;
        }
    }
    IMAGE_RENDERING graphics::image_rendering_mode() const
    {
        CGInterpolationQuality iq = CGContextGetInterpolationQuality ( _target );
        switch( iq ) {
            default:
            case kCGInterpolationDefault: /* Let the context decide. */
            case kCGInterpolationMedium:	/* Medium quality, slower than
                                             kCGInterpolationLow. */
                return image_rendering_default;
            case kCGInterpolationNone:	  /* Never interpolate. */
            case kCGInterpolationLow:	  /* Low quality, fast interpolation. */
                return image_rendering_speed;
            case kCGInterpolationHigh:
                return image_rendering_quality; /* Highest quality, slower than */
        }
    }
    
}

gool::argb  osx_sys_color(gool::SYSTEM_COLORS cs);
gool::size  osx_pixels_per_inch(html::iwindow* iw);
gool::size  osx_pixels_per_inch_backing(html::iwindow* iw);


namespace gool 
{

    /*bool is_sys_color(color cs)
    {
      if((0xFF000000 & cs) != 0xFF000000) return false;
      uint idx = cs & 0xFF;
      if( idx > 33 )
        return false;
      return true;
    }*/

    color xcolor(SYSTEM_COLORS cs)
    {
      //uint idx = cs & 0xFF;
      //
      //if( idx > 40 )
      //  return cs;
      return osx_sys_color( cs );
    }

    /*int scrollbar_width() { return 16; }
    int scrollbar_height() { return 16; }
    int small_icon_width() { return 16;  }
    int small_icon_height() { return 16; }
    int border_width()      { return 1; }
    int border_3d_width()   { return 2; } */

    struct _resolution_provider: public resolution_provider
    {
      size _pixels_per_inch;

      _resolution_provider(): _pixels_per_inch(0,0) {}

      void reset_resolution() {
         _pixels_per_inch = osx_pixels_per_inch(0);
         if(!_pixels_per_inch.x)
           _pixels_per_inch = size(96,96);
      }

      size pixels_per_inch()
      {
        if(!_pixels_per_inch.x)
          reset_resolution();
        return _pixels_per_inch;
      }

      void pixels_per_inch(size sz)
      {
        assert(false);// not used in default provider
        _pixels_per_inch = sz;
      }

    };

    resolution_provider& resolution_provider::desktop() {
      static _resolution_provider provider;
      return provider;
    }
    
    
}
