//
//  osx-sciter-application.h
//  sciter-osx
//
//  Created by Andrew Fedoniouk on 2016-06-24.
//  Copyright (c) 2016 andrew fedoniouk. All rights reserved.
//

#ifndef sciter_osx_osx_sciter_application_h
#define sciter_osx_osx_sciter_application_h

#include "osx-sciter-graphics.h"

namespace osx {
    
    class view;
    
    class application: public gool::application
    {
    public:
        
        static application*    instance;
        
        application() {
            html::init();
            behavior::init(true);
        }
        virtual ~application() {
            html::behavior::init(false);
            instance = 0;
        }
        
        virtual bool is_valid() { return true; }
        virtual bool mirrored_bitmaps() const override { return true; }
        
        virtual gool::font* create_font(const ustring& name
                                        , float size
                                        , uint weight = 400
                                        , bool italic = false
                                        , gool::FONT_RENDERING  mode = gool::FR_VECTOR);
        
        virtual gool::font* register_font( CTFontRef pf );
        virtual CF::ref<CTFontRef> ctfont(gool::font* pf);
        
        virtual void clear_font_cache() override ;
        
        virtual tool::ustring get_supported_font_family(const tool::ustring& family_name_list);
        
        static wchars fallback_list(wchars lang_id, WRITING_SCRIPT script, bool serif );
        
        
        bool get_supported_font_family(wchars family_name_list,
                                       const function<bool(wchars)>& cb,
                                       tool::wchars lang_id,
                                       WRITING_SCRIPT script );
        
        virtual bool          get_used_font(
                                            tool::handle<gool::font>& pf,
                                            tool::wchars family_name_list, const gool::font* proto,
                                            tool::wchars lang_id,
                                            WRITING_SCRIPT script,
                                            uint char_code = 0);
        
        virtual gool::path*     create_path();
        
        virtual gool::graphics* create_bitmap_graphics( gool::graphics *proto, gool::bitmap *bmp, gool::argb initc ) override ;
        virtual gool::graphics* create_bitmap_bits_graphics(gool::bitmap* bmp, gool::argb initc, bool high_quality = false) override ;
        
        virtual osx::view*          create_window_processor(const window_params& params);
       
        virtual gool::GRAPHICS_CAPS graphics_caps() const { return gool::UNKNOWN_GRAPHICS; }
        
        virtual handle<html::view>  create_frame(const window_params& params);
        virtual handle<html::view>  create_dialog(const window_params& params);

        virtual bool construct_font_collection_for(memory_font_variant& fv) override;
        
        virtual bool         install_font(const tool::ustring& name,
                                           int        weight,
                                           bool       italic,
                                           tool::bytes data);
        
        virtual void         get_system_font(/*inout*/ ustring& name, /*out*/int& size, /*out*/ uint& weight, /*out*/bool& italic) override;

        virtual bool         each_font_family( function<bool(wchars name)> cb, function<void(ucode,ucode)> cb_ranges_or_null ) override;
        
        
    protected:
        virtual bool init_font(gool::font* pfont);
        
        handle_pool<osx::font> _fonts;
        
    };
    
    application* app_factory();
    
    
}



#endif
