//
//  osx-graphics-font.mm
//  sciter
//
//  Created by andrew on 2014-03-19.
//  Copyright (c) 2014 andrew. All rights reserved.
//

#import  "ApplicationServices/ApplicationServices.h"
#ifdef MAC_OS_X_VERSION_10_8
#include <CoreText/CTFont.h>
#endif
#include <Carbon/Carbon.h>


#include "osx-sciter.h"
#include "osx-sciter-graphics.h"
#include "osx-cvt.h"
#include "osx-ref.h"

//@interface NSFont (PrivateGlyph)
//- (NSGlyph) _defaultGlyphForChar: (unichar) theChar;
//@end

uint32 osx_default_glyph_for_char(CTFontRef font, uint32 unicode) {
    //NSGlyph theGlyph = [font _defaultGlyphForChar: unicode];
    //return theGlyph;
    unichar  t = unichar(unicode);
    
   
    CGGlyph glyphs[16];
    
    bool r = CTFontGetGlyphsForCharacters (
                                       font,
                                       &t,
                                       glyphs,
                                       1);
    //assert(r); r = r;
    return r ? glyphs[0] : 0;
}

//static tool::hash_table<tool::ustring,CTFontRef> installed_fonts;

CTFontRef findMatchingCTFont( const tool::ustring name, int weight, bool italic, float size  );

void osx_init_font(osx::font& f) {
    
    //float px_per_pt = gool::resolution_provider::desktop().pixels_per_inch().y / 72.0f;
    float points = f.size;
    
    tool::ustring family;
    
    //CTFontRef mf = gool::app()->closest_font_collection(f.name, f.weight, f.italic);
    //if( mf ) {
    //    CTFontSymbolicTraits font_traits = CTFontGetSymbolicTraits(mf);
    //    CTFontRef r = CTFontCreateCopyWithSymbolicTraits(mf, points, NULL, font_traits, 0);
    //    f._ct_font = r;
    //} else {
    family = gool::app()->get_supported_font_family(f.name);
    f._ct_font = findMatchingCTFont( family, f.weight, f.italic, points );
    //}

#if 0
    auto leading = floor(0.5 + max(0,CTFontGetLeading(f._ct_font)));
    auto ascent = floor(0.5 + CTFontGetAscent(f._ct_font));
    auto descent = floor(0.5 + CTFontGetDescent(f._ct_font));
    
    auto line_height = ascent + descent + leading;
    auto ascender_delta = (leading > 0) ? 0: floor(0.2 * line_height + 0.5);
    
    line_height += ascender_delta;

    auto ratio = ascent / (ascent + descent);
    
    f.ascent = ceilf(line_height * ratio + 0.5);
    f.descent = line_height - f.ascent;
#else

    CGRect theBounds = CTFontGetBoundingBox(f._ct_font);
    
    auto ascent = floor(0.5 + abs(CGRectGetMaxY(theBounds)));
    auto descent = floor(0.5 + abs(CGRectGetMinY(theBounds)) /*CTFontGetDescent(f._ct_font)*/);
    
    f.ascent = int(ascent);
    f.descent = int(descent);

#endif
}

void osx_find_all_typeface_names(tool::pool<ustring>& names)
{
    //StringArray names;
    
//#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_5 && ! JUCE_IOS
    // CTFontManager only exists on OS X 10.6 and later, it does not exist on iOS
    CF::ref<CFArrayRef> fontFamilyArray = CTFontManagerCopyAvailableFontFamilyNames();
    
    for (CFIndex i = 0; i < CFArrayGetCount (fontFamilyArray); ++i)
    {
        tool::ustring family = cvt ((CFStringRef) CFArrayGetValueAtIndex (fontFamilyArray, i));
        
        if (! family().starts_with(WCHARS("."))) // ignore fonts that start with a '.'
        {
            //puts(family);
            names.intern(family);
        }
    }
    
/*#else IOS
    CTFontCollectionRef fontCollectionRef = CTFontCollectionCreateFromAvailableFonts (nullptr);
    CFArrayRef fontDescriptorArray = CTFontCollectionCreateMatchingFontDescriptors (fontCollectionRef);
    CFRelease (fontCollectionRef);
    
    for (CFIndex i = 0; i < CFArrayGetCount (fontDescriptorArray); ++i)
    {
        CTFontDescriptorRef ctFontDescriptorRef = (CTFontDescriptorRef) CFArrayGetValueAtIndex (fontDescriptorArray, i);
        CFStringRef cfsFontFamily = (CFStringRef) CTFontDescriptorCopyAttribute (ctFontDescriptorRef, kCTFontFamilyNameAttribute);
        
        names.addIfNotAlreadyThere (String::fromCFString (cfsFontFamily));
        
        CFRelease (cfsFontFamily);
    }
    
    CFRelease (fontDescriptorArray);
#endif */
}

bool osx_each_font_family( function<bool(wchars name)> cb, function<void(ucode,ucode)> cb_ranges_or_null )
{
    CF::ref<CFArrayRef> fontFamilyArray = CTFontManagerCopyAvailableFontFamilyNames();
    
    for (CFIndex i = 0; i < CFArrayGetCount (fontFamilyArray); ++i)
    {
        tool::ustring family = cvt ((CFStringRef) CFArrayGetValueAtIndex (fontFamilyArray, i));
        if (! family().starts_with(WCHARS("."))) // ignore fonts that start with a '.'
        {
            if(!cb( family() ))
                break;
        }
    }
    return true;
}

void osx_system_fontname(tool::ustring& name, float& out_points) {
    NSFont* f = [NSFont systemFontOfSize:0];
    name = cvt( [f familyName] );

    //int px_per_inch = gool::resolution_provider::desktop().pixels_per_inch().y;
    CGFloat  points = [f pointSize]; //[NSFont labelFontSize];
    //pixels = ceilf(points * px_per_inch / 96.0);
    out_points = points;
    
    // systemFontSize
    
    
    //dips = [f pointSize] /** 96.0 / 72.0*/;
}

void osx_system_font(tool::ustring& name, float& out_points, uint& weight, bool& italic) {
    NSFont* f = [NSFont controlContentFontOfSize:0];
    
    //auto n1 = [f fontName];
    //auto n2 = [f familyName];
    //auto n3 = [f displayName];
    
    name = //cvt( [f fontName] );
           WCHARS("System Font Regular");
    
    CGFloat  points = [f pointSize]; //[NSFont labelFontSize];
    out_points = points;
    
    NSFontManager *fm = [NSFontManager sharedFontManager];
    if(fm) {
       float mac_fw = float([fm weightOfFont:f]);
       weight = 100 * uint(mac_fw * 7.0f / 9.0f + 0.5f);
       //weight = uint(mac_fw) * 100;
    }
    else
       weight = 400;
    italic = false;
    
    //dips = [f pointSize] /** 96.0 / 72.0*/;
}


#if 0

uint osx_get_glyph_indices( osx::font* pf, slice<wchar> text , uint16* glyphs, uint glyphs_length ) {
    tool::erase(glyphs, glyphs_length);
    STATIC_ASSERT( sizeof(wchar) == 2 );
    
    tool::buffer<wchar, 256> translated( text.length );
    for( int n = 0; n < text.size(); ++n ) {
        wchar c = text[n];
        if( c == '\r' || c == '\n' )
            translated[n] = 0x200b; // zero width space
        else if( c == '\t')
            translated[n] = 0x2000; // 4 width space
        else
            translated[n] = c;
    }
    
    CTFontGetGlyphsForCharacters( pf->ct_font(),
                                 (const UniChar*) translated.cbegin(),
                                 glyphs,
                                 text.length);
    
    
    return (uint) text.length;
}
#else
  uint osx_get_glyph_indices( osx::font* pf, slice<wchar> text , uint16* glyphs, uint glyphs_length ) {
    tool::erase(glyphs, glyphs_length);
    STATIC_ASSERT( sizeof(wchar) == 2 );
    
    CTFontGetGlyphsForCharacters( pf->ct_font(),
                                 (const UniChar*) text.start,
                                 glyphs,
                                 text.length);
    
    
    
    return (uint) text.length;
}
#endif



void osx_get_glyph_advances( osx::font* pf, tool::slice<uint16> glyphs, float* xadvances ) {

  
    tool::buffer<CGSize, 256> advances( glyphs.length );

#if 0
    const wchar* crlf = u"\r\n ";
    uint16 gcrlf[3] = {0,0,0};
    
    CTFontGetGlyphsForCharacters( pf->ct_font(),
                                 (const UniChar*) crlf,
                                 gcrlf,
                                 3);
    
    CTFontGetAdvancesForGlyphs ( pf->ct_font(),
                                 kCTFontHorizontalOrientation,
                                 glyphs.start,
                                 advances.begin(),
                                 glyphs.length);
    for( int n = 0; n < glyphs.size(); ++n ) {
        auto g = glyphs[n];
        if(g == gcrlf[1] || g == gcrlf[0])
            xoffsets[n] = 0;
        else
            xoffsets[n] = (float) advances[n].width;
        
    }
#else 
    
   
    CTFontGetAdvancesForGlyphs ( pf->ct_font(),
                                kCTFontHorizontalOrientation,
                                glyphs.start,
                                advances.begin(),
                                glyphs.length);
    
    for( int n = 0; n < glyphs.size(); ++n ) {
      xadvances[n] = (float) (advances[n].width);
    }
   
    
#endif
}


#if 0

void osx_draw_glyph_run( gool::graphics* gfx, const html::tflow::text_flow& tf, const html::tflow::glyph_run& gr, gool::pointf at, gool::argb color, const html::style* run_style)
{
    osx::graphics* pg = static_cast<osx::graphics*>(gfx);
    osx::font* pf = gr.font.ptr_of<osx::font>();
    
    CF::ref<CGFontRef> cgFont = CTFontCopyGraphicsFont(pf->ct_font(), NULL);
    
    CGContextSaveGState ( pg->target() );
    
    CGContextSetFont(pg->target(), cgFont);
    CGContextSetFontSize(pg->target(), CTFontGetSize(pf->ct_font()));
    
    CGContextSetTextMatrix(pg->target(), CGAffineTransformScale(CGAffineTransformIdentity ,1,-1 ));
    
    CGContextSetTextDrawingMode(pg->target(), kCGTextFill);
    CGContextSetRGBFillColor(pg->target(), color.red / 255.0,color.green / 255.0, color.blue / 255.0, color.alfa / 255.0);
    
    //CGContextShowGlyphsAtPositions( pg->target(),
    //                               (const CGGlyph*)&tf._glyph_indices[gr.glyph_start],
    //                               positions.cbegin(),
    //                               gr.glyph_count);
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdeprecated-declarations"
    
    if( run_style->text_shadow.is_defined() )
        for(html::shadow_def* it = run_style->text_shadow; it; it = it->next) {
            gool::argb c = it->color.val( run_style->font_color );
            CGSize offset; offset.width = it->offset_x.pixels();
                           offset.height = -it->offset_y.pixels();
            CGFloat blur = it->radius.pixels();
            CF::ref<CGColorRef> color = cvt(c);
            CGContextSetShadowWithColor(pg->target(),offset, blur,color);
            CGContextShowGlyphsAtPoint(pg->target(), at.x, at.y, (const CGGlyph*)&tf._glyph_indices[gr.glyph_start], gr.glyph_count);
            CGContextSetShadowWithColor(pg->target(),offset, blur,NULL);
        }
    else {
       //CGContextShowGlyphsAtPoint(pg->target(), at.x, at.y, (const CGGlyph*)&tf._glyph_indices[gr.glyph_start], 0);
       CGContextSetTextPosition(pg->target(), at.x, at.y);
        
       tool::buffer<CGPoint, 256> positions( gr.glyph_count );
        
       CGPoint pt;
       pt.x = 0;
       pt.y = 0;
        
       for( int n = 0; n < gr.glyph_count; ++n ) {
          positions[n] = pt;
          pt.x += tf._glyph_justified_advances[gr.glyph_start + n];
       }
       CGContextShowGlyphsAtPositions(pg->target(), (const CGGlyph*)&tf._glyph_indices[gr.glyph_start], positions.begin(), gr.glyph_count);
    }
    
#pragma clang diagnostic pop
    
    CGContextRestoreGState ( pg->target() );
    
}
#else 

void osx_draw_glyph_run( gool::graphics* gfx, const html::tflow::text_flow& tf, const html::tflow::glyph_run& gr, gool::pointf at, gool::argb color, const html::style* run_style)
{
    osx::graphics* pg = static_cast<osx::graphics*>(gfx);
    osx::font* pf = gr.font.ptr_of<osx::font>();
   
    CGContextSaveGState ( pg->target() );
    
    CGContextSetTextMatrix(pg->target(), CGAffineTransformScale(CGAffineTransformIdentity ,1,-1 ));
    
    CGContextSetTextDrawingMode(pg->target(), kCGTextFill);
    CGContextSetRGBFillColor(pg->target(), color.red / 255.0,color.green / 255.0, color.blue / 255.0, color.alfa / 255.0);
    
    tool::buffer<CGPoint, 256> positions( gr.glyph_count );
    
    CGPoint pt;
    pt.x = 0;
    pt.y = 0;
    
    if( gr.is_rtl() )
        for( int n = gr.glyph_count - 1; n >= 0 ; --n ) {
            positions[n] = pt;
            pt.x += tf._glyph_justified_advances[gr.glyph_start + n];
            at.x -= tf._glyph_justified_advances[gr.glyph_start + n];
        }
    else
        for( int n = 0; n < gr.glyph_count; ++n ) {
            positions[n] = pt;
            pt.x += tf._glyph_justified_advances[gr.glyph_start + n];
        }
    
    CGContextSetTextPosition(pg->target(), at.x, at.y);
    
    if( run_style->text_shadow.is_defined() )
        for(html::shadow_def* it = run_style->text_shadow; it; it = it->next) {
            gool::argb c = it->color.val( run_style->font_color ).to_argb();
            CGSize offset; offset.width = it->offset_x.pixels();
            offset.height = -it->offset_y.pixels();
            CGFloat blur = it->radius.pixels();
            CF::ref<CGColorRef> color = cvt(c);
            CGContextSetShadowWithColor(pg->target(),offset, blur,color);
            CTFontDrawGlyphs(pf->ct_font(), (const CGGlyph*)&tf._glyph_indices[gr.glyph_start], positions.begin(), gr.glyph_count, pg->target());
            CGContextSetShadowWithColor(pg->target(),offset, blur,NULL);
        }
    else
      CTFontDrawGlyphs(pf->ct_font(), (const CGGlyph*)&tf._glyph_indices[gr.glyph_start], positions.begin(), gr.glyph_count, pg->target());
  
    CGContextRestoreGState ( pg->target() );
    
}

#endif

#if defined(USE_CGX)
CTFontRef findMatchingCTFont( const tool::ustring name, int weight, bool italic, float size  )
{
  @autoreleasepool {
    NSFontManager *fm = [NSFontManager sharedFontManager];
    NSFont *nsFont, *dflt = nil;
#define defaultFont (dflt ? dflt : (dflt = [NSFont systemFontOfSize:0]))
    
    
    if (size == 0.0) {
        size = [defaultFont pointSize];
    }
   
    gool::application::memory_font_variant*  mfv = osx::app()->closest_memory_font_collection(name, weight, italic);
    if(mfv) {
        CTFontSymbolicTraits font_traits = CTFontGetSymbolicTraits(mfv->coll);
        CTFontRef r = CTFontCreateCopyWithSymbolicTraits(mfv->coll, size, NULL, font_traits, 0);
        assert(r);
        return r;
    }
    
    NSString *family;
    
    family = [NSString stringWithCharacters: (const unichar *)name.c_str() length: name.size()];
             //[[[NSString alloc] initWithCharacters: (const unichar *)name.c_str() length: name.size() ] autorelease];
    
    NSFontTraitMask traits = 0;
    
    if( weight > 400 )
        traits |= NSBoldFontMask;
    if( italic )
        traits |= NSItalicFontMask;
    
/*  NSItalicFontMask			= 0x00000001,
    NSBoldFontMask			= 0x00000002,
    NSUnboldFontMask			= 0x00000004,
    NSNonStandardCharacterSetFontMask	= 0x00000008,
    NSNarrowFontMask			= 0x00000010,
    NSExpandedFontMask			= 0x00000020,
    NSCondensedFontMask			= 0x00000040,
    NSSmallCapsFontMask			= 0x00000080,
    NSPosterFontMask			= 0x00000100,
    NSCompressedFontMask		= 0x00000200,
    NSFixedPitchFontMask		= 0x00000400,
    NSUnitalicFontMask			= 0x01000000*/
    
    uint mac_fw = (weight * 9) / 700;
    
    nsFont = [fm fontWithFamily:family traits:traits weight:mac_fw size:size];
    
    if (!nsFont) {
        NSArray *availableFamilies = [fm availableFontFamilies];
        NSString *caseFamily = nil;
        
        for (NSString *f in availableFamilies) {
            if ([family caseInsensitiveCompare:f] == NSOrderedSame) {
                caseFamily = f;
                break;
            }
        }
        if (caseFamily) {
            nsFont = [fm fontWithFamily:caseFamily traits:traits weight:0 size:size];
        }
    }
    if (!nsFont) {
        nsFont = [NSFont fontWithName:family size:size];
    }
    if (!nsFont) {
        nsFont = [fm convertFont:defaultFont toFamily:family];
        nsFont = [fm convertFont:nsFont toSize:size];
        nsFont = [fm convertFont:nsFont toHaveTrait:traits];
    }

    if(nsFont)
      [nsFont retain]; // to be returned
    
#undef defaultFont
    
    CTFontRef r = (__bridge CTFontRef) nsFont;
    return r;
 }
    

}

void CGDataProviderReleaseDataCallback_font_data ( void *info, const void *data, size_t size )
{
    // never called, why?
    delete [] (byte*)data;
}



CTFontRef osx_install_font(tool::bytes data)
{
    //NSData* nsdata = [NSData dataWithBytes: data.start length: data.length ];
    
    byte* ldata = new byte[data.length];
    if( !ldata )
        return nullptr;
    tool::target(ldata,data.length).copy(data);

/*
    CF::ref<CGDataProviderRef> data_provider = CGDataProviderCreateWithData(nullptr, ldata, data.length, CGDataProviderReleaseDataCallback_font_data);
    CF::ref<CGFontRef> cgfont = CGFontCreateWithDataProvider(data_provider);
    
    CTFontRef font = CTFontCreateWithGraphicsFont(cgfont, 0, NULL, NULL); */

    CGDataProviderRef data_provider = CGDataProviderCreateWithData(nullptr, ldata, data.length, CGDataProviderReleaseDataCallback_font_data);
    CGFontRef cgfont = CGFontCreateWithDataProvider(data_provider);
    CTFontRef font = CTFontCreateWithGraphicsFont(cgfont, 0, NULL, NULL);
    
    return font;
    
}

#endif

