//
//  SciterPopupView.m
//  sciter-osx
//
//  Created by andrew on 2014-04-03.
//  Copyright (c) 2014 andrew fedoniouk. All rights reserved.
//

#import "SciterPopupView.h"
#include "osx-sciter-view.h"


gool::point get_mouse_pos(NSEvent* e, NSView* view);
uint        get_alts();
uint        get_mouse_buttons();
gool::point osx_iwindow_client_screen_pos(html::iwindow* iw);

NSView* viewUnderMouse = nullptr;

#define TRANSLATE_MOUSE(pt) \
  if(!iwindow || !iwindow->root()) \
    return; \
  tool::handle<html::view> hview = iwindow->root()->pview(); \
  if(!hview) return; \
  pt += osx_iwindow_client_screen_pos(iwindow) - osx_iwindow_client_screen_pos(hview)

@implementation SciterPopupView

- (id)initWithFrame:(NSRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // Initialization code here.
    }
    return self;
}

- (id)initWithIWindow: (html::iwindow*) iwnd
{
    NSRect frame; frame.origin.x = 0; frame.origin.y = 0; frame.size.width = 300; frame.size.height = 150;
    self = [super initWithFrame:frame];
    if (self) {
        iwindow = iwnd;
        iwindow->add_ref();
    }
    return self;
}

-(BOOL)isFlipped {
    return YES;
}

- (void)refresh
{
   [self setNeedsDisplay:TRUE];
}


- (void)drawRect:(NSRect)dirtyRect
{
    //[super drawRect:dirtyRect];
    
    if( !iwindow )
        [super drawRect:dirtyRect];
    else {
        CGContextRef cg = (CGContextRef)[[NSGraphicsContext currentContext] graphicsPort];
        iwindow->draw( cg, fromns<int>(dirtyRect) );
    }
}

// -----------------------------------
// Release the View
// -----------------------------------

- (void)dealloc
{
    if( iwindow ) {
        iwindow->set_hwnd(nullptr);
        iwindow->release();
        iwindow = nullptr;
    }
    //[notificationCenter removeObserver: self];
    
    // call super
    [super dealloc];
}

- (void)windowWillClose:(NSNotification *)notification
{
    if( iwindow ) {
        //iwindow->detach();
        iwindow->set_hwnd(nullptr);
        iwindow->release();
        iwindow = nullptr;
    }
    [self release];
}


// -----------------------------------
// First Responder Methods
// -----------------------------------

- (BOOL)acceptsFirstResponder
{
    return YES;
}


- (void)mouseMoved:(NSEvent *)theEvent
{
    uint        buttons = get_mouse_buttons();
    uint        alts = get_alts();
    gool::point pt = get_mouse_pos(theEvent, self);
    
    TRANSLATE_MOUSE(pt);
    
    //printf("popup::MOUSE_MOVE %d %d\n", pt.x, pt.y);
    if(hview->on_mouse(html::MOUSE_MOVE, buttons, alts, pt))
        return;
    
    [super mouseMoved:theEvent];
}

- (void)mouseEntered:(NSEvent *)theEvent
{
    /*
    uint        buttons = get_mouse_buttons();
    uint        alts = get_alts();
    gool::point pt = get_mouse_pos(theEvent, self);
    
    TRANSLATE_MOUSE(pt);
    
    //printf("MOUSE ENTER %d %d\n", pt.x, pt.y);
    if(hview->on_mouse(html::MOUSE_ENTER, buttons, alts, pt))
        return;
    */
    //[super mouseEntered:theEvent];
    
}

- (void)mouseExited:(NSEvent *)theEvent
{
    /*
    uint        buttons = get_mouse_buttons();
    uint        alts = get_alts();
    gool::point pt = get_mouse_pos(theEvent, self);
    
    TRANSLATE_MOUSE(pt);
    
    //NSLog(@"leaving %d", viewUnderMouse == self);
    viewUnderMouse = nullptr;
    
    //printf("%d %d\n", pt.x, pt.y);
    if(hview->on_mouse(html::MOUSE_LEAVE, buttons, alts, pt))
        return;
    */
    //[super mouseExited:theEvent];
}

- (void)mouseDown:(NSEvent *)theEvent
{
    uint        buttons = html::MAIN_BUTTON;
    uint        alts = get_alts();
    gool::point pt = get_mouse_pos(theEvent, self);
    
    TRANSLATE_MOUSE(pt);
    
    uint click_count = [theEvent clickCount];
    
    hview->windows.remove_by_value(iwindow);
    hview->windows.push(iwindow);
    
    [[self window] orderFront: theEvent];
    //[[self window] addChildWindow:pnw ordered:NSWindowAbove];

    uint cmd = html::MOUSE_DOWN;
    if( click_count <= 1 );
    else if( click_count == 2 ) cmd = html::MOUSE_DCLICK;
    else cmd = html::MOUSE_TCLICK;    //printf("popup::MOUSE_DOWN %d %d\n", pt.x, pt.y);

    if(hview->on_mouse(cmd, buttons, alts, pt))
      return;

    [super mouseDown:theEvent];
}

- (void)mouseUp:(NSEvent *)theEvent
{
    uint        buttons = html::MAIN_BUTTON;
    uint        alts = get_alts();
    gool::point pt = get_mouse_pos(theEvent, self);
    
    TRANSLATE_MOUSE(pt);
    
    //printf("mouseUp:%d %d\n", pt.x, pt.y);
    //uint click_count = [theEvent clickCount];
    
    //uint cmd = html::MOUSE_UP;
    //if( click_count <= 1 );
    //else if( click_count == 2 ) cmd = html::MOUSE_DCLICK;
    //else cmd = html::MOUSE_TCLICK;
    
    if(hview->on_mouse(html::MOUSE_UP, buttons, alts, pt))
        return;
    
    [super mouseUp:theEvent];
}

- (void)mouseDragged:(NSEvent *)theEvent
{
    uint        buttons = html::MAIN_BUTTON;
    uint        alts = get_alts();
    gool::point pt = get_mouse_pos(theEvent, self);
    
    TRANSLATE_MOUSE(pt);
    
    //printf("mouseDragged: %d %d\n", pt.x, pt.y);
    if(hview->on_mouse(html::MOUSE_MOVE, buttons, alts, pt))
        return;
    
    //[super mouseDragged:theEvent];
}

- (void)rightMouseDown:(NSEvent *)theEvent
{
    uint        buttons = html::PROP_BUTTON;
    uint        alts = get_alts();
    gool::point pt = get_mouse_pos(theEvent, self);
    
    TRANSLATE_MOUSE(pt);
    
    //printf("%d %d\n", pt.x, pt.y);
    if(hview->on_mouse(html::MOUSE_DOWN, buttons, alts, pt))
        return;
    
    //[super rightMouseDown:theEvent];
}

- (void)rightMouseUp:(NSEvent *)theEvent
{
    uint        buttons = html::PROP_BUTTON;
    uint        alts = get_alts();
    gool::point pt = get_mouse_pos(theEvent, self);
    
    TRANSLATE_MOUSE(pt);
    
    //printf("%d %d\n", pt.x, pt.y);
    if(hview->on_mouse(html::MOUSE_UP, buttons, alts, pt))
        return;
    
    //[super rightMouseUp:theEvent];
}

- (void)rightMouseDragged:(NSEvent *)theEvent
{
    uint        buttons = html::PROP_BUTTON;
    uint        alts = get_alts();
    gool::point pt = get_mouse_pos(theEvent, self);
    
    TRANSLATE_MOUSE(pt);
    
    //printf("%d %d\n", pt.x, pt.y);
    if(hview->on_mouse(html::MOUSE_MOVE, buttons, alts, pt))
        return;
    
    //[super rightMouseDragged:theEvent];
}

- (void)scrollWheel:(NSEvent *)theEvent {
    //NSLog(@"user scrolled %f horizontally and %f vertically", [theEvent deltaX], [theEvent deltaY]);
    //uint        buttons = get_mouse_buttons();
    
    uint        alts = get_alts();
    gool::point pt = get_mouse_pos(theEvent, self);
    
    TRANSLATE_MOUSE(pt);
    
    uint  phase = (uint)[theEvent momentumPhase];

    if(phase == NSEventPhaseNone) {
      gool::size delta;

      auto fromTouchPad = [theEvent hasPreciseScrollingDeltas];
#ifdef USE_TOUCH
      if(fromTouchPad)
        alts |= html::ALT_TOUCH;
#endif
    
      float deltaY = [theEvent scrollingDeltaY];
      float deltaX = [theEvent scrollingDeltaX];
        
      //NSLog(@"user scrolled %f horizontally and %f vertically", deltaX, deltaY);

      if( !fromTouchPad ) { // mouse wheel
          if( deltaY > 0.0001f ) deltaY = 120.0f;
          else if( deltaY < -0.0001f ) deltaY = -120.0f;
          else deltaY = 0;
          if( deltaX > 0.0001f ) deltaX = 120.0f;
          else if( deltaX < -0.0001f ) deltaX = -120.0f;
          else deltaX = 0;
          delta.x = deltaX;
          delta.y = deltaY;
      } else {
          delta.x = deltaX * self.window.backingScaleFactor;
          delta.y = deltaY * self.window.backingScaleFactor;
      }
        
      if(delta.x || delta.y )
        hview->on_mouse(html::MOUSE_WHEEL, tool::make_dword(short(delta.x), short(delta.y)), alts, pt);
    }
}

- (void)updateTrackingAreas {
    if(trackingArea) {
      [self removeTrackingArea:trackingArea];
      [trackingArea release];
    }
        
    NSTrackingAreaOptions opts =
    //  NSTrackingMouseEnteredAndExited
    NSTrackingMouseMoved
    //| NSTrackingCursorUpdate
    | NSTrackingActiveAlways
    | NSTrackingInVisibleRect;

    trackingArea = [[NSTrackingArea alloc] initWithRect:self.frame
        options: opts
        owner:self userInfo:nil];
    [self addTrackingArea:trackingArea];

}

@end

@implementation SciterPanel
@end


HWINDOW osx_create_popup_nsview(HWINDOW owner, html::WINDOW_TYPE wt, html::iwindow* pup)
{
    SciterPopupView* nv = [ SciterPopupView alloc ];
    if( nv ) {
      [nv initWithIWindow:pup];
    }
    else
      return NULL;
    
    NSPanel* window = [SciterPanel alloc];
    
    unsigned int window_style = NSBorderlessWindowMask  | NSUtilityWindowMask | NSNonactivatingPanelMask;
    NSRect frame; frame.size.width = 100; frame.size.height = 100;
    
    const html::style* cs = pup->root()->get_style();
    bool layered = cs->is_transparent() || cs->opacity != 255
                   || cs->has_rounded_corners() || cs->box_shadow || cs->has_outline();
    
    //if( creationFlags & SW_TITLEBAR )
    //    window_style |= NSTitledWindowMask;
    //if( creationFlags & SW_RESIZEABLE )
    //    window_style |= NSMiniaturizableWindowMask | NSClosableWindowMask | NSResizableWindowMask;
    //[nv setIsMain: ((creationFlags & SW_MAIN) != 0 ? YES : NO)];
    
    [window initWithContentRect:  frame
                      styleMask: window_style
                        backing: NSBackingStoreBuffered
                          defer: TRUE];
    
    [window orderOut: nil];
    [window setDelegate: (id<NSWindowDelegate>) nv];
    
    [window setContentView: nv];
    
    if( layered ) {
      [window setOpaque:NO];
      [window setBackgroundColor:[NSColor clearColor]];
      [window setHasShadow: NO];
    } else {
      [window setOpaque: YES];
      [window setHasShadow: YES]; //((windowStyleFlags & windowHasDropShadow) != 0)];
    }
    
    /*NSTrackingArea* ta = [NSTrackingArea alloc];
    
    NSTrackingAreaOptions opts = NSTrackingMouseEnteredAndExited |
       NSTrackingMouseMoved |
       NSTrackingCursorUpdate |
       NSTrackingActiveAlways |
       NSTrackingInVisibleRect;
    
    [ta initWithRect:frame options:opts owner:nv userInfo:NULL];
    [nv addTrackingArea:ta]; */
    
    //[window setLevel: NSFloatingWindowLevel];
    [window setFloatingPanel: YES];
   
   
    //[window setAutodisplay: YES];

    // We'll both retain and also release this on closing because plugin hosts can unexpectedly
    // close the window for us, and also tend to get cause trouble if setReleasedWhenClosed is NO.
    [window setReleasedWhenClosed: YES];
    //[window retain];
    
    [window setExcludedFromWindowsMenu: YES]; //(windowStyleFlags & windowIsTemporary) != 0];
    
    //[window setIgnoresMouseEvents: YES]; //(windowStyleFlags & windowIgnoresMouseClicks) != 0];
    //[window setAcceptsMouseMovedEvents: YES];
    
    //if ((windowStyleFlags & (windowHasMaximiseButton | windowHasTitleBar)) == (windowHasMaximiseButton | windowHasTitleBar))
    //    [window setCollectionBehavior: NSWindowCollectionBehaviorFullScreenPrimary];
    
    if ([window respondsToSelector: @selector (setRestorable:)])
       [window setRestorable: NO];

    //[nv setWantsLayer: YES];
    
    [window setReleasedWhenClosed:TRUE];
    
    //[window setDisplaysWhenScreenProfileChanges: YES];
  
    return nv;
    
}
void osx_destroy_popup_nsview( HWINDOW hwindow, html::ELEMENT_WINDOW_MODE mode )
{
   SciterPopupView* nsv = (SciterPopupView*) hwindow;
   NSWindow* nsw = [nsv window];
   [nsw retain];
   [nsw close];
   [nsw setDelegate: nullptr];
   [nsw setContentView: nullptr];
   if( mode != html::ELEMENT_WINDOW_DETACHED )
     [[nsw parentWindow] removeChildWindow: nsw];
   [nsw release];
}
void osx_show_popup_nsview_at( HWINDOW hwindow, HWINDOW parent, gool::rect rc, html::ELEMENT_WINDOW_MODE mode )
{
  rc = osx_screen_rect (rc);
  NSView* nsv = (NSView*) hwindow;
  NSWindow* nsw = [nsv window];
  [nsw setFrame: tons(rc) display:NO ];
  if( mode == html::ELEMENT_WINDOW_DETACHED ) {
    [nsw orderFront: (NSView*)parent];
  }
  else if( mode == html::ELEMENT_WINDOW_DETACHED_TOPMOST ) {
    [nsw setLevel: NSPopUpMenuWindowLevel ];
    [nsw orderFront: (NSView*)parent];
  }
  else {
    NSWindow* wowner = [(NSView*)parent window];
   [wowner addChildWindow: nsw ordered:NSWindowAbove];
  }
  //printf("initial position:%d %d\n", rc.origin.x, rc.origin.y );
}

bool osx::popup::render(void* hdc, rect client_rc) {
  CGContextRef cg = (CGContextRef) hdc;
  handle<osx::graphics> context = new osx::graphics(cg,is_layered()); // (float) [view frame].size.height, displayScale
  render( context, client_rc );
  return true;
}


