#include "gtk-view.h"
#include "gtk-graphics.h"
#include "gtk-popup.h"

static HWINDOW gtk_create_popup(HWINDOW owner, html::WINDOW_TYPE wt, gtk::popup* pup);
static void gtk_destroy_popup(HWINDOW hwnd );

//static GtkWindow* gtkwindow(const gtk::view* pv) { return pv->get_hwnd() ? GTK_WINDOW(gtk_widget_get_toplevel(pv->get_hwnd())): nullptr; }

static GtkWidgetClass super_klass;

static gboolean gp_draw(GtkWidget	 *widget, cairo_t *cr);
static void     gp_size_allocate(GtkWidget *widget, GtkAllocation *allocation);
static gboolean gp_button_press_event(GtkWidget	     *widget, GdkEventButton *event);
static gboolean gp_button_release_event(GtkWidget	     *widget, GdkEventButton *event);
static gboolean gp_motion_notify_event(GtkWidget	     *widget, GdkEventMotion *event);
//static gboolean gp_enter_notify_event(GtkWidget	     *widget, GdkEventCrossing    *event);
//static gboolean gp_leave_notify_event(GtkWidget	     *widget, GdkEventCrossing    *event);
static gboolean gp_scroll_event(GtkWidget           *widget, GdkEventScroll      *event);

extern "C" {

#define GTK_SCITER_POPUP(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, sciter_popup_get_type (), SciterPopupObject)
#define GTK_SCITER_POPUP_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, sciter_popup_get_type (), SciterPopupClass)
#define IS_GTK_SCITER_POPUP(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, sciter_popup_get_type ())

struct _SciterPopupObject {
  GtkDrawingArea darea;
  gtk::popup*    pup;
};

struct _SciterPopupClass {
  GtkDrawingAreaClass parent_class;
//
//  void (* command) (struct _SciterObject *ttt);
//  void (* notify) (struct _SciterObject *ttt);
};

typedef struct _SciterPopupObject SciterPopupObject;
typedef struct _SciterPopupClass  SciterPopupClass;

static void sciter_popup_class_init(SciterPopupClass *klass);
static void sciter_popup_init(SciterPopupObject *sci);


GType      sciter_popup_get_type  (void);
void       sciter_popup_release_resources(void);


GType sciter_popup_get_type() {
	static GType sciter_popup_type = 0;

	if (!sciter_popup_type) {
		sciter_popup_type = g_type_from_name("SciterPopup");
		if (!sciter_popup_type) {
			static GTypeInfo sciter_popup_info = {
				(guint16) sizeof (SciterPopupClass),
				NULL, //(GBaseInitFunc)
				NULL, //(GBaseFinalizeFunc)
				(GClassInitFunc) sciter_popup_class_init,
				NULL, //(GClassFinalizeFunc)
				NULL, //gconstpointer data
				(guint16) sizeof (SciterPopupObject),
				0, //n_preallocs
				(GInstanceInitFunc) sciter_popup_init,
				NULL //(GTypeValueTable*)
			};

			sciter_popup_type = g_type_register_static(
				GTK_TYPE_DRAWING_AREA, "SciterPopup", &sciter_popup_info, (GTypeFlags) 0);
		}
	}

	return sciter_popup_type;
}

//static void gp_finalize(GObject *object);
void gp_destroyed(GtkWidget *widget);


void sciter_popup_class_init(SciterPopupClass *klass) {
	GObjectClass *object_class = (GObjectClass*) klass;
	GtkWidgetClass *widget_class = (GtkWidgetClass*) klass;
	GtkDrawingAreaClass *drawing_area_class = (GtkDrawingAreaClass*) klass;

	super_klass = *widget_class;

	// Define default signal handlers for the class:  Could move more
	// of the signal handlers here (those that currently attached to wDraw
	// in Initialise() may require coordinate translation?)
	//object_class->finalize = gp_finalize;
	widget_class->destroy = gp_destroyed;
	widget_class->draw = gp_draw;
	widget_class->size_allocate = gp_size_allocate;
	widget_class->motion_notify_event = gp_motion_notify_event;
	widget_class->button_press_event = gp_button_press_event;
	widget_class->button_release_event = gp_button_release_event;
	widget_class->scroll_event = gp_scroll_event;

}

void sciter_popup_init(SciterPopupObject *sci) {
	gtk_widget_set_can_focus(GTK_WIDGET(sci),FALSE);
}

}

namespace gtk {

    using namespace tool;
    using namespace gool;
    using namespace html;

    void replace_window(iwindow* pw, const gool::rect& rc) {
      auto gw = gtkwindow(pw->get_hwnd());
      if( gw && gtk_widget_is_visible (pw->get_hwnd())) {
        gtk_window_resize (gw,rc.width(), rc.height());
        gtk_window_move (gw,rc.s.x, rc.s.y);
      }
    }

    HWINDOW popup::get_hwnd() const
    {
      auto pw = _hwnd;
      if( _hwnd && GTK_IS_WIDGET(_hwnd) )
         return _hwnd;
      return NULL;
    }

    //virtual graphics* surface() { return 0; }
    //bool popup::render(rect client_rc)
    //{
    //  super::render(client_rc);
    //  assert(!"Not implemented.");
    //}

    bool popup::render(void* dc, rect client_rc)
    {
      if(!_root) return false;

      bool transp = _root->c_style->is_transparent()
                 || _root->c_style->has_rounded_corners()
                 || _root->c_style->box_shadow.is_defined();
      handle<gtk::graphics> gfx = new gtk::graphics( static_cast<cairo_t*>(dc),transp );
      render(gfx,client_rc);
      return true;
    }

    void popup::render(gool::graphics* gfx, rect client_rc) //override
    {
        //if(!_root) return;
        html::view* pv = _root->pview();
        if(!pv || !_root->state.popup()) return;

        auto_state<bool> _(is_painting,true);

        gfx->set_clip_rc(client_rc);
        gfx->set_drawing_root(_root);

        _root->commit_measure(*pv);
        point vp = _root->view_pos(*pv);
        point rp = vp - point(_root->ldata->borpad_left(), _root->ldata->borpad_top());
        rect rc(vp, _root->dim());
        rc >>= rect( _root->ldata->borpad_left(), _root->ldata->borpad_top(), _root->ldata->borpad_right(), _root->ldata->borpad_bottom() );
        gfx->offset(-rp);
        _root->draw(*pv,gfx,vp);
    }

    void popup::dismiss() {
      GtkWidget* gw = get_hwnd();
      if( gw ) {
        gtk_destroy_popup( gw );
      }
    }

    void popup::show_at( gool::rect rc )
    {
        auto gw = gtkwindow(get_hwnd());
        gtk_window_resize (gw,rc.width(), rc.height());
        gtk_window_move (gw,rc.s.x, rc.s.y);
        gtk_window_present(gw);
    }

    void popup::detach()
    {
      if( !_root )
        return;
      html::view* pv = _root->pview();
      if(pv) {
        critical_section _(pv->guard);
        pv->forget_window(this);
      }
      _root = nullptr;
      _anchor = nullptr;
      _pfocus = nullptr;
      _hwnd = nullptr;
    }

    gboolean popup_draw(GtkWidget *widget, cairo_t *cr, gpointer data)
    {
      handle<popup> self = static_cast<popup*>(data);
      if( !self ) return false;

      gool::rectd invalid;
      cairo_clip_extents(cr,&invalid.s.x,&invalid.s.y,&invalid.e.x,&invalid.e.y);

      self->render(cr,rect(invalid));

//#ifdef USE_SKIA
//      gool::rect rc(self->client_dim());
//      self->render(rc);
//#else
//      handle<gtk::graphics> gfx = new gtk::graphics( cr );
//      self->render(gfx,invalid);
//#endif // USE_SKIA

      return true;
    }



    iwindow* view::create_window( html::element* forel, html::element* anchor, html::WINDOW_TYPE wt, function<gool::rect(html::view&,html::element*,html::element*)> setup_and_calc_place, ELEMENT_WINDOW_MODE mode )
    {
      handle<popup> pup = this->create_popup(wt);

      pup->windowing_mode = mode;
      pup->root( forel );
      pup->anchor(anchor);
      pup->pfocus(get_focus_element());

      pup->set_hwnd(gtk_create_popup(get_hwnd(),wt,pup));

      windows.push(pup.ptr());

      gool::rect rc = setup_and_calc_place(*this,forel,anchor);

      if( windows.get_index(pup.ptr()) < 0 )
          return 0;

      pup->show_at(rc);

      return pup;
    }

    gtk::popup* view::create_popup(html::WINDOW_TYPE wt)
    {
      return new gtk::popup(wt);
    }

    bool  view::close_popup( element* b, bool set_auto_focus )
    {
      handle<iwindow> hw = b->window(*this);
      if(!hw)
        return false;
      super::close_popup(b,set_auto_focus);
      if(hw->get_hwnd())
      {
        hw->dismiss();
        check_mouse(true);
        return true;
      }
      return false;
    }

    void view::replace_windowed()
    {
      if( windows.size() == 0 )
        return;

      uint cnt = 0, popups = 0;
      int i;

      for(i = windows.size() - 1; i >= 0; --i)
      {
        auto biw = windows[i];
        element *b = biw->root();
        if( !b ) {
           windows.remove(i);
           continue;
        }

        if( b->state.popup() )
        {
           ++popups;
           continue;
        }

        rect rc = b->content_box(*this,element::TO_VIEW);

        bool visible = b->is_visible(*this);
        bool w_visible = gtk_widget_is_visible(biw->get_hwnd());

            //UINT f = flags;
        bool to_show = false;
        bool to_hide = false;

        if(visible != w_visible)
            {
                if(visible)
                    to_show = true;
                else
                {
                    to_hide = true;
                }
            }
            else
            {
                rect wrc = biw->screen_place();
                if( rc == wrc )
                    continue;
                //rc
            }
            //dbg_printf("DeferWindowPos:%d %d %d %d\n",rc.left(), rc.top(), rc.width(), rc.height());
            //DeferWindowPos(hdwp, biw->get_hwnd(), NULL, rc.left(), rc.top(), rc.width(), rc.height(), f );

            if(!rc.empty())
              replace_window(biw, rc);

            ++cnt;
        }
        //EndDeferWindowPos(hdwp);

        // need this pass to update popup windows (that are not children)

        if( popups )
        {
            //dbg_printf("window::replace_popus ++\n");
            for(i = 0; i < windows.size(); i++)
            {
                auto biw = windows[i];
                element *b = biw->root();
                if(!b->state.popup() || !b->is_visible(*this))
                    continue;

                //if( !b->is_layout_valid() )
                //  measure_out_of_flow(*this, b);
                b->check_layout(*this);
                rect rc = b->border_box(*this, element::TO_SCREEN);
                rect rcw = biw->screen_place();
                if( !rc.empty() && rc != rcw ) {
                    replace_window(biw, rc);
                    //dbg_printf("window::replace_popup %d %d %d %d\n", rc.left(), rc.top(), rc.width(), rc.height());
                }
            }
            //dbg_printf("window::replace_popus --\n");
        }

        if(cnt && !is_painting)
        {
            update();
        }
    }

}

extern void gtk_layered_setup(GtkWidget *win);

HWINDOW gtk_create_popup(HWINDOW owner, html::WINDOW_TYPE wt, gtk::popup* pup)
{
    const html::style* cs = pup->root()->get_style();
    bool layered = cs->is_transparent() || cs->opacity != 255 || cs->has_rounded_corners();

	auto client =  GTK_WIDGET(g_object_new(sciter_popup_get_type(), NULL));
	SciterPopupObject *spo = reinterpret_cast<SciterPopupObject *>(client);

	spo->pup = pup; pup->add_ref();

    gtk_widget_set_events (client,
         GDK_EXPOSURE_MASK
       | GDK_ENTER_NOTIFY_MASK
	   | GDK_LEAVE_NOTIFY_MASK
       | GDK_BUTTON_PRESS_MASK
	   | GDK_BUTTON_RELEASE_MASK
  	   | GDK_POINTER_MOTION_MASK
       | GDK_SCROLL_MASK );

    GtkWidget *window = gtk_window_new(GTK_WINDOW_POPUP);

    gtk_window_set_transient_for (GTK_WINDOW(window), gtkwindow(owner));
    gtk_window_set_attached_to (GTK_WINDOW(window), owner );

    if( layered )
      gtk_layered_setup(window);

    gtk_container_set_border_width (GTK_CONTAINER (window), 0);
    gtk_container_add(GTK_CONTAINER(window), client);

    //g_signal_connect (window, "motion-notify-event", G_CALLBACK (gp_motion_notify_event),NULL);

    //gtk_widget_set_size(client,)

    //gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
    pup->set_hwnd(client);

    gtk_widget_show(client);

    gtk_widget_realize (window);

    //printf("popup created %p\n", window );

    return client;

}


gtk::popup* gtkpopup(HWINDOW hw)
{
	SciterPopupObject *scp = reinterpret_cast<SciterPopupObject *>(hw);
	return scp->pup;
}

//static GtkWindow* gtkwindow(HWINDOW hwnd) { return hwnd ? GTK_WINDOW(gtk_widget_get_toplevel(hwnd)): nullptr; }

gboolean popup_destroy_timeout(gpointer user_data)
{
	gtk_widget_destroy(static_cast<GtkWidget*>(user_data));
	return G_SOURCE_REMOVE;
}

void gtk_destroy_popup( HWINDOW hwnd ) {
   //printf("gtk_destroy_popup\n");
   GtkWindow* gw = gtkwindow(hwnd);
   if(gw) {
     auto pup = gtkpopup(hwnd);
     pup->detach();
     //gtk_window_close (gw);
     // GTK 3.10.8: gtk_widget_destroy call from self motion-notify-event result for glib main context curruption
     //             This can happen when mouse moves over overflow-popup
     g_idle_add( popup_destroy_timeout, GTK_WIDGET(gw) );
    //gtk_widget_destroy( GTK_WIDGET(gw) );
  }
}





void gp_destroyed(GtkWidget *hw)
{
    if(IS_GTK_SCITER_POPUP(hw)) {
        handle<gtk::popup> pup = gtkpopup(hw);
        if (!pup)
            return;

        SciterPopupObject *scp = reinterpret_cast<SciterPopupObject *>(hw);
        scp->pup = nullptr;

        pup->detach();
        pup->release();
    }
    super_klass.destroy(hw);
}

static gboolean gp_draw(GtkWidget	 *widget, cairo_t *cr)
{
  auto pp = gtkpopup(widget);

  gool::rectd invalid;
  cairo_clip_extents(cr,&invalid.s.x,&invalid.s.y,&invalid.e.x,&invalid.e.y);

  //cairo_save(cr);
  //cairo_set_source_rgba(cr, 1, 1, 1,0);
  //cairo_set_operator(cr, CAIRO_OPERATOR_SOURCE);
  //cairo_paint(cr);
  //cairo_restore(cr);

  //handle<gtk::graphics> gfx = new gtk::graphics( cr );

  //pp->render(gfx,invalid);

  pp->render(cr,invalid);

  return true;
}

static void gp_size_allocate(GtkWidget *widget, GtkAllocation *allocation)
{
  super_klass.size_allocate(widget,allocation);
  GtkAllocation allo;
  gtk_widget_get_allocation (widget, &allo);
}

#define TRANSLATE_MOUSE(pt) \
  if(!pp || !pp->root()) \
    return false; \
  tool::handle<gtk::view> hview = static_cast<gtk::view*>(pp->root()->pview()); \
  if(!hview) return false; \
  pt += pp->client_screen_pos() - hview->client_screen_pos()

static gboolean gp_button_press_event(GtkWidget *widget, GdkEventButton *event)
{
  auto pp = gtkpopup(widget);
  gool::point pt(event->x,event->y);
  TRANSLATE_MOUSE(pt);
  //printf("MOUSE_DOWN %d %d\n",pt.x,pt.y);
  return hview->on_mouse(html::MOUSE_DOWN, get_mouse_buttons(event),get_alts(event),pt);
}
static gboolean gp_button_release_event(GtkWidget *widget, GdkEventButton *event)
{
  auto pp = gtkpopup(widget);
  gool::point pt(event->x,event->y);
  TRANSLATE_MOUSE(pt);
  //hview->setup_mouse_idle(false);
  int cmd = html::MOUSE_UP;
  hview->_got_mouse_up = true;
  gboolean r = hview->on_mouse(cmd, get_mouse_buttons(event),get_alts(event),pt);
  if( !r && event->button == GDK_BUTTON_SECONDARY )
  	hview->on_context_menu(pt);
  //printf("event->button %d %d\n",event->button == GDK_BUTTON_SECONDARY, r);
  return r; //hview->on_mouse(html::MOUSE_UP, get_mouse_buttons(event),get_alts(event),pt);
}
static gboolean gp_motion_notify_event(GtkWidget *widget, GdkEventMotion *event)
{
  if( event->is_hint )
    return FALSE;
  auto pp = gtkpopup(widget);
  gool::point pt(event->x,event->y);
  TRANSLATE_MOUSE(pt);
  //hview->setup_mouse_idle(false);
  return hview->on_mouse(html::MOUSE_MOVE, get_mouse_buttons(event),get_alts(event),pt);
}

static gboolean gp_scroll_event(GtkWidget           *widget, GdkEventScroll      *event)
{
    auto pp = gtkpopup(widget);

	int cmd = html::MOUSE_WHEEL;

	gdouble delta_x, delta_y;

	gool::point pt(event->x,event->y);
	TRANSLATE_MOUSE(pt);

	if(gdk_event_get_scroll_deltas ((GdkEvent*)event,&delta_x,&delta_y))
	{
	  delta_x *= MOUSE_WHEEL_UNIT;
	  delta_y *= MOUSE_WHEEL_UNIT;
	  return hview->on_mouse(cmd, int(delta_y), get_alts(event),pt);
	}
	else if( event->type == GDK_SCROLL ) {
      int steps = event->direction ==  GDK_SCROLL_UP? +MOUSE_WHEEL_UNIT:-MOUSE_WHEEL_UNIT;
	  return hview->on_mouse(cmd, steps, 0 /*get_alts(event)*/,pt);
	}
    return false;
}

/*static gboolean gv_enter_notify_event(GtkWidget	     *widget, GdkEventCrossing    *event)
{
  gtk::view* pv = gtkview(widget);
	if (!pv) return false;
	int cmd = html::MOUSE_ENTER;
	return pv->on_mouse(cmd, get_mouse_buttons(event),get_alts(event),gool::point(event->x,event->y));
}
static gboolean gv_leave_notify_event(GtkWidget	     *widget, GdkEventCrossing    *event)
{
  gtk::view* pv = gtkview(widget);
	if (!pv) return false;
	int cmd = html::MOUSE_LEAVE;
	return pv->on_mouse(cmd, get_mouse_buttons(event),get_alts(event),gool::point(event->x,event->y));
}*/


