#define PANGO_ENABLE_BACKEND 1

#include "gtk-graphics.h"
#include "gtk-view.h"


namespace gtk {

  bool font::has_glyph_for(uint ucodepoint) const
  {
    //printf("has_glyph_for glyph %x\n",ucodepoint);
    //if(PANGO_IS_FC_FONT(_pg_font.ptr())) {
    //  PangoFcFontClass* cls = PANGO_FC_FONT_GET_CLASS(_pg_font.ptr());
    //  return cls->has_char(PANGO_FC_FONT(_pg_font.ptr()),ucodepoint);
    //}
    //cairo_scaled_font_t * sf = pango_cairo_font_get_scaled_font (_pg_font);
    //return pango_fc_font_has_char (_pg_font, ucodepoint);
    if( ucodepoint < ' ' ) return true;
    return glyph_index(ucodepoint) != 0;
  }
  uint font::glyph_index(uint ucodepoint) const
  {
    //return pango_fc_font_get_glyph (PANGO_FC_FONT(_pg_font.ptr()), ucodepoint);
    byte u8[4]; uint u8len = 0;
    //to_utf8(ucodepoint, u8, u8len);
    tool::u8::putc(ucodepoint,u8,u8len);
    cairo_glyph_t glyphs_buffer[10];
    cairo_glyph_t *glyphs = glyphs_buffer;
    int num_glyphs = 10;

    cairo_status_t stat =  cairo_scaled_font_text_to_glyphs(pango_cairo_font_get_scaled_font (_pg_font),
                                                         0,//double x,
                                                         0,//double y,
                                                         (char*)u8,
                                                         int(u8len),
                                                         &glyphs,
                                                         &num_glyphs,
                                                         nullptr, //cairo_text_cluster_t **clusters,
                                                         nullptr, //int *num_clusters,
                                                         nullptr //cairo_text_cluster_flags_t *cluster_flags
                                                         );

    //assert( num_glyphs == 1 );

    uint r =  (stat == CAIRO_STATUS_SUCCESS) && (num_glyphs > 0) ? glyphs[0].index : 0;

    if( glyphs != glyphs_buffer )
      cairo_glyph_free(glyphs);

    //if( r == 0 )
    //{
    //   printf("ucodepoint %x %x\n",ucodepoint, r);
    //}

    return r;
  }

  uint font::get_glyph_indices_and_advances( slice<wchar> text , function<void(uint16,float,float)> cb )
  {
    array<byte> u8;
    u8::from_utf16( text, u8);

    u8.push(' '); // to convert to advances

    cairo_glyph_t rglyphs_buffer[255];

    cairo_glyph_t *rglyphs = rglyphs_buffer;
    int num_rglyphs = items_in(rglyphs_buffer);

    cairo_status_t stat =  cairo_scaled_font_text_to_glyphs(pango_cairo_font_get_scaled_font (_pg_font),
                                                         0,//double x,
                                                         0,//double y,
                                                         (const char*)u8.cbegin(),
                                                         u8.size(),
                                                         &rglyphs,
                                                         &num_rglyphs,
                                                         nullptr, //cairo_text_cluster_t **clusters,
                                                         nullptr, //int *num_clusters,
                                                         nullptr //cairo_text_cluster_flags_t *cluster_flags
                                                         );

    //assert( stat == CAIRO_STATUS_SUCCESS && num_rglyphs > 0 );
    if( num_rglyphs )
      --num_rglyphs; // remove tail

    for( int n = 0; n < num_rglyphs; ++n ) {
      auto& gl = rglyphs[n];
      cb( uint16(gl.index), float(rglyphs[n+1].x - gl.x ), float(gl.y) );
    }

    if( rglyphs != rglyphs_buffer )
      cairo_glyph_free(rglyphs);

    return uint(num_rglyphs);

  }

  bool path::is_inside(pointf pt)
  {
     return bounds().contains(pt); // that's not correct
  }

  void path::start(pointf pt, bool filled)
  {
    if(!_path_graphics) {
       _path_surface = cairo_image_surface_create(CAIRO_FORMAT_A1,32,32);
       _path_graphics = cairo_create(_path_surface);
    }
    cairo_move_to(_path_graphics,pt.x,pt.y);
  }
  void path::move_to(pointf pt, bool rel)
  {
    if( !_path_graphics )
      return start(pt,true);
    if( rel )
      cairo_rel_move_to(_path_graphics,pt.x,pt.y);
    else
      cairo_move_to(_path_graphics,pt.x,pt.y);
  }
  void path::line_to(pointf pt, bool rel)
  {
    if( !_path_graphics )
      return start(point(0,0),true);
    assert(_path_graphics );
    if( rel )
      cairo_rel_line_to(_path_graphics,pt.x,pt.y);
    else
      cairo_line_to(_path_graphics,pt.x,pt.y);
  }
  void path::hline_to(float x, bool rel)
  {
    if( !_path_graphics )
      return start(point(0,0),true);
    assert(_path_graphics );
    pointd lastp;
    cairo_get_current_point(_path_graphics, &lastp.x, &lastp.y);
    line_to(pointf(x,rel?0:lastp.y),rel);
  }

  void path::vline_to(float y, bool rel)
  {
    if( !_path_graphics )
      return start(point(0,0),true);
    assert(_path_graphics );
    pointd lastp;
    cairo_get_current_point(_path_graphics, &lastp.x, &lastp.y);
    line_to(pointf(rel?0:lastp.x,y),rel);
  }

  void path::add_arc(pointf c, sizef r, float angle_start, float angle_swipe)
  {
    if( !_path_graphics )
      return start(point(0,0),true);
     assert(_path_graphics );

     if( angle_swipe < 0 )
       cairo_arc_negative (_path_graphics, c.x, c.y, r.x, angle_start, angle_start + angle_swipe);
     else
       cairo_arc(_path_graphics, c.x, c.y, r.x, angle_start, angle_start + angle_swipe);
  }

  pointf path::lastp() {
    //if(opened) pos = lastp;
    pointd _lastp;
    cairo_get_current_point(_path_graphics, &_lastp.x, &_lastp.y);
    return _lastp;
  }

  /*void path::arc_to(pointf p1, sizef r, float rotation_angle, bool large_arc, bool clockwise, bool rel_to)
  {
    cairo_t* cr = _path_graphics;

    double x0, y0;
    cairo_get_current_point(cr, &x0, &y0);
    pointf p0(x0, y0);

    if( rel_to )
      p1 += p0;

    float radius = min(r.x,r.y);

    if ((p1.x == p0.x && p1.y == p0.y) || (p1.x == p2.x && p1.y == p2.y) || radius == 0.f) {
        line_to(p1);
        return;
    }

    pointf p1p0((p0.x - p1.x),(p0.y - p1.y));
    pointf p1p2((p2.x - p1.x),(p2.y - p1.y));
    float p1p0_length = sqrtf(p1p0.x * p1p0.x + p1p0.y * p1p0.y);
    float p1p2_length = sqrtf(p1p2.x * p1p2.x + p1p2.y * p1p2.y);

    double cos_phi = (p1p0.x * p1p2.x + p1p0.y * p1p2.y) / (p1p0_length * p1p2_length);
    // all points on a line logic
    if (cos_phi == -1) {
        line_to(p1);
        return;
    }
    if (cos_phi == 1) {
        // add infinite far away point
        unsigned int max_length = 65535;
        double factor_max = max_length / p1p0_length;
        pointf ep((p0.x + factor_max * p1p0.x), (p0.y + factor_max * p1p0.y));
        line_to(ep);
        return;
    }

    float tangent = radius / tan(acos(cos_phi) / 2);
    float factor_p1p0 = tangent / p1p0_length;
    pointf t_p1p0((p1.x + factor_p1p0 * p1p0.x), (p1.y + factor_p1p0 * p1p0.y));

    pointf orth_p1p0(p1p0.y, -p1p0.x);
    float orth_p1p0_length = sqrt(orth_p1p0.x * orth_p1p0.x + orth_p1p0.y * orth_p1p0.y);
    float factor_ra = radius / orth_p1p0_length;

    // angle between orth_p1p0 and p1p2 to get the right vector orthographic to p1p0
    double cos_alpha = (orth_p1p0.x * p1p2.x + orth_p1p0.y * p1p2.y) / (orth_p1p0_length * p1p2_length);
    if (cos_alpha < 0)
        orth_p1p0 = pointf(-orth_p1p0.x, -orth_p1p0.y);

    pointf p((t_p1p0.x + factor_ra * orth_p1p0.x), (t_p1p0.y + factor_ra * orth_p1p0.y));

    // calculate angles for addArc
    orth_p1p0 = pointf(-orth_p1p0.x, -orth_p1p0.y);
    float sa = acosf(orth_p1p0.x / orth_p1p0_length);
    if (orth_p1p0.y < 0.f)
        sa = 2 * float(M_PI) - sa;

    // anticlockwise logic
    bool anticlockwise = false;

    float factor_p1p2 = tangent / p1p2_length;
    pointf t_p1p2((p1.x + factor_p1p2 * p1p2.x), (p1.y + factor_p1p2 * p1p2.y));
    pointf orth_p1p2((t_p1p2.x - p.x),(t_p1p2.y - p.y));
    float orth_p1p2_length = sqrtf(orth_p1p2.x * orth_p1p2.x + orth_p1p2.y * orth_p1p2.y);
    float ea = acos(orth_p1p2.x / orth_p1p2_length);
    if ((sa > ea) && ((sa - ea) < float(M_PI)))
        anticlockwise = true;
    if ((sa < ea) && ((ea - sa) > float(M_PI)))
        anticlockwise = true;

    line_to(t_p1p0);

    //addArc(p, radius, sa, ea, anticlockwise);
    add_arc(p, sizef(radius), sa, anticlockwise ? ea - sa:sa - ea);
  }*/

  void path::quadratic_to(pointf pt, pointf cp, bool rel)
  {
    if( !_path_graphics )
      return start(point(0,0),true);

     assert(_path_graphics );
     pointd p0, p1 = cp, p2 = pt;
     cairo_get_current_point(_path_graphics, &p0.x, &p0.y);
     if(rel) { p1 += p0; p2 += p0; }
     pointd q0 = p0;
     pointd q1 = (p0 + 2.0 * p1) / 3.0;
     pointd q2 = (p2 + 2.0 * p1) / 3.0;
     pointd q3 = pt;
     cairo_curve_to(_path_graphics, q1.x,q1.y, q2.x,q2.y, q3.x, q3.y);
  }
  void path::cubic_to(pointf pt, pointf cp1, pointf cp2, bool rel) {
    if( !_path_graphics )
      return start(point(0,0),true);

     assert(_path_graphics );
     if(rel)
       cairo_rel_curve_to(_path_graphics, cp1.x,cp1.y, cp2.x,cp2.y, pt.x,pt.y);
     else
       cairo_curve_to(_path_graphics, cp1.x,cp1.y, cp2.x,cp2.y, pt.x,pt.y);
  }

  void path::close()
  {
     cairo_close_path(_path_graphics);
  }

  bool path::is_empty() const {
     return _path_graphics == nullptr;
  }

  void path::reset() {
    if(_path_graphics) {
      cairo_destroy(_path_graphics); _path_graphics = nullptr;
      cairo_surface_destroy (_path_surface); _path_surface = nullptr;
    }
    if( _path ) {
      cairo_path_destroy(_path);
      _path = nullptr;
    }
  }
  void path::seal() {
    if(_path_graphics) {
      if(_path)
        cairo_path_destroy(_path);
      rectd b;
      cairo_path_extents(_path_graphics, &b.s.x,&b.s.y,&b.e.x,&b.e.y);
      _path = cairo_copy_path( _path_graphics );
      _bounds = b;
    }
  }

  void graphics::fill( argb c, const rect& dst) {

    cairo_set_source_rgba(_target, GRGBA(c) );
    cairo_rectangle( _target, GRECT(dst) );
    cairo_fill(_target);
  }

  void graphics::fill( argb c, const rect& dst, const size& radii)
  {
    double x         = dst.left(),
           y         = dst.top(),
           width     = dst.width(),
           height    = dst.height();

    double degrees = M_PI / 180.0;
    double radius = radii.x;

    cairo_new_sub_path (_target);
    cairo_arc (_target, x + width - radius, y + radius, radius, -90 * degrees, 0 * degrees);
    cairo_arc (_target, x + width - radius, y + height - radius, radius, 0 * degrees, 90 * degrees);
    cairo_arc (_target, x + radius, y + height - radius, radius, 90 * degrees, 180 * degrees);
    cairo_arc (_target, x + radius, y + radius, radius, 180 * degrees, 270 * degrees);
    cairo_close_path (_target);

    cairo_set_source_rgba(_target, GRGBA(c) );
    cairo_fill(_target);
  }

  void brush::fill(graphics* gfx)
  {
    cairo_set_source(gfx->target(), pat );
    cairo_fill(gfx->target());
  }

  void brush::stroke(graphics* gfx)
  {
    cairo_set_source(gfx->target(), pat );
    cairo_stroke(gfx->target());
  }


  void graphics::fill( const gool::brush* lb, const rect& dst)
  {

    if(lb->type() != gool::brush::LINEAR && lb->type() != gool::brush::RADIAL)
        return;

    cairo_save(_target);
    cairo_rectangle(_target,GRECT(dst));
    //cairo_clip_preserve(_target);

    switch( lb->type() )
    {
      case gool::brush::LINEAR:
        {
            linear_gradient_brush br( *static_cast<const gool::linear_brush*>(lb));
            br.fill(this);
        }
        break;
      case gool::brush::RADIAL:
        {
            radial_gradient_brush br( *static_cast<const gool::radial_brush*>(lb));
            br.fill(this);
        }
        break;
      default:
        break;
    }

    cairo_restore(_target);
  }

  void graphics::fill( image* img, const gool::path* dst)
  {
  }

  void graphics::do_push_clip(const rect& rc)
  {
    assert(_target);
    cairo_save(_target);
    cairo_rectangle( _target, GRECT(rc) );
    cairo_clip(_target);
  }
  void graphics::do_pop_clip()
  {
    cairo_restore(_target);
  }

  void graphics::image_rendering_mode( IMAGE_RENDERING irm) {
     _image_rendering_mode = irm;
  }
  IMAGE_RENDERING graphics::image_rendering_mode() const {
     return _image_rendering_mode;
  }


  void graphics::draw( const gool::path* dst, argb c, float width ) {
     gtk::path* p = (gtk::path*)dst;

     cairo_set_fill_rule (_target, p->even_odd() ? CAIRO_FILL_RULE_EVEN_ODD : CAIRO_FILL_RULE_WINDING );
     cairo_new_path(_target);
     cairo_append_path(_target, p->gpath());

     cairo_set_source_rgba(_target, GRGBA(c) );

     cairo_set_line_width(_target,width);
     cairo_stroke(_target);
  }
  void graphics::fill( argb c, const gool::path* dst)
  {
     gtk::path* p = (gtk::path*)dst;

     cairo_set_fill_rule (_target, p->even_odd() ? CAIRO_FILL_RULE_EVEN_ODD : CAIRO_FILL_RULE_WINDING );
     cairo_new_path(_target);
     cairo_append_path(_target, p->gpath());

     cairo_set_source_rgba(_target, GRGBA(c) );

     cairo_fill(_target);

  }

  void graphics::draw_line_v(const rect& rc, argb c, int stroke, int step, int_v off)
  {
    if(c.alfa == 0)
        return;
    int s1 = stroke;

    cairo_save(_target);
    cairo_set_source_rgba(_target, GRGBA(c) );

    if(rc.width() == 1)
      cairo_set_line_cap(_target, CAIRO_LINE_CAP_BUTT);
    else
      cairo_set_line_cap(_target, CAIRO_LINE_CAP_ROUND);

    float w = float(rc.width());
    float w2 = w / 2.0f;
    float h2 = rc.width() == 1? 0: w / 2.0f;

    cairo_set_line_width(_target, w );

    gool::pointf pts = {rc.left() + w2,rc.top() + h2};
    gool::pointf pte = {rc.left() + w2,rc.top() + s1 - h2};

    cairo_new_path( _target );

    cairo_move_to( _target, pts.x, pts.y);
    cairo_line_to( _target, pte.x, pte.y);

    int space = rc.height() - step - stroke + 1;
    int num_steps = space / step;
    for(int ly = rc.s.y + step; num_steps > 0;)
    {
        pts.y = ly + h2;
        pte.y = ly + s1 - h2;
        cairo_move_to( _target, pts.x, pts.y);
        cairo_line_to( _target, pte.x, pte.y);
        int delta = space / num_steps;
        ly += delta;
        space -= delta;
        --num_steps;
    }
    pte.y = rc.e.y - h2;
    pts.y = rc.e.y - s1 + h2;
    cairo_move_to( _target, pts.x, pts.y);
    cairo_line_to( _target, pte.x, pte.y);

    cairo_stroke (_target);
    cairo_restore(_target);

  }
  void graphics::draw_line_h(const rect& rc, argb c, int stroke, int step, int_v off)
  {
    if(c.alfa == 0)
        return;
    int s1 = stroke;

    cairo_save(_target);
    cairo_set_source_rgba(_target, GRGBA(c) );

    if(rc.height() == 1)
      cairo_set_line_cap(_target, CAIRO_LINE_CAP_BUTT);
    else
      cairo_set_line_cap(_target, CAIRO_LINE_CAP_ROUND);

    float w = float(rc.height());
    float h2 = w / 2.0f;
    float w2 = rc.height() == 1? 0: w / 2.0f;

    cairo_set_line_width(_target, w );

    gool::pointf pts = {rc.left() + w2,rc.top() + h2};
    gool::pointf pte = {rc.left() + s1 - w2,rc.top() + h2};

    cairo_new_path( _target );

    cairo_move_to( _target, pts.x, pts.y);
    cairo_line_to( _target, pte.x, pte.y);

    int space = rc.width() - step - stroke + 1;
    int num_steps = space / step;
    for(int lx = rc.s.x + step; num_steps > 0;)
    {
        pts.x = lx + w2;
        pte.x = lx + s1 - w2;
        cairo_move_to( _target, pts.x, pts.y);
        cairo_line_to( _target, pte.x, pte.y);
        int delta = space / num_steps;
        lx += delta;
        space -= delta;
        --num_steps;
    }
    pte.x = rc.e.x - w2;
    pts.x = rc.e.x - s1 + w2;
    cairo_move_to( _target, pts.x, pts.y);
    cairo_line_to( _target, pte.x, pte.y);

    cairo_stroke (_target);
    cairo_restore(_target);
  }

  void graphics::draw_line(pointf p1, pointf p2 , argb c, int width)
  {
    cairo_set_source_rgba(_target, GRGBA(c) );

    cairo_set_line_width(_target, width );

    cairo_new_path( _target );

    cairo_move_to( _target, p1.x, p1.y);
    cairo_line_to( _target, p2.x, p2.y);

    cairo_stroke (_target);
  }

  point graphics::offset(point noff)
  {
    point off = _offset;
    _offset = noff;
    _clip_rc -= noff;
    cairo_translate(_target, noff.x,noff.y );
    return off;
  }

  bool graphics::set_antialiasing(bool onoff) {
    bool paa = cairo_get_antialias(_target) != CAIRO_ANTIALIAS_NONE;
    cairo_set_antialias(_target, onoff? CAIRO_ANTIALIAS_DEFAULT: CAIRO_ANTIALIAS_NONE);
    return paa;
  }

  /*uint graphics::push_state()
  {
    cairo_save(_target);
    return _state_level++;
  }
  bool graphics::pop_state()
  {
    if(_state_level == 0)
      return false;
    cairo_restore(_target);
    return true;
  }

  void graphics::restore_state(uint level) {
    while( _state_level > level )
      pop_state();
  }*/

  uint graphics::push_state()
  {
     cairo_save(_target);
     uint lv = uint(_registers_stack.length());
     _registers_stack.push(_registers);
     return lv;
  }

  bool graphics::pop_state()
  {
     if( !_registers_stack.size() )
       return false;
     _registers = _registers_stack.pop();
     cairo_restore(_target);
     return true;
  }

  void graphics::restore_state(uint level)
  {
     while( _registers_stack.length() && _registers_stack.length() > level )
       pop_state();
  }

  /*const text_format& graphics::get_text_format()
  {
    static text_format ss; return ss;
  }
  void  graphics::set_text_format(const text_format& tf)
  {
  }*/

  void graphics::push_layer(const gool::rect& clip, byte opacity, function<bool(filter_graph_builder*)> filters)
  {
    layers_stack_item it; it.opacity = opacity;
    _layers_stack.push(it);
    //super::push_layer(clip, opacity,filters);
    if( opacity < 255 ) // semitransparent layer
      cairo_push_group (_target);
    else
      cairo_save (_target); // just clip
    cairo_rectangle( _target, GRECT(clip) );
    cairo_clip(_target);
  }
  void graphics::push_layer(const gool::path* clip, byte opacity)
  {
    //super::push_layer(clip, opacity);
    layers_stack_item it; it.opacity = opacity;
    _layers_stack.push(it);

    gtk::path* p = (gtk::path*)clip;
    if( opacity < 255 ) // semitransparent layer
      cairo_push_group (_target);
    else
      cairo_save (_target); // just clip
    cairo_new_path(_target);
    cairo_append_path(_target, p->gpath());
    cairo_clip(_target);
  }

  void graphics::push_layer(const bitmap* clip, bool draw1a, byte opacity)
  {
    layers_stack_item it; it.opacity = opacity;

    if(draw1a)
       it.mask = clip;
    else {
      it.mask = new gool::bitmap(clip->dim(),true,true);
      it.mask->set_bits( clip->_pixels() );
      it.mask->foreach_pixel([](argb& p){ p = argb(0,0,0,byte(255) - p.alfa); });
    }
    _layers_stack.push(it);
    cairo_push_group (_target);
  }

  void graphics::pop_layer()
  {
    //assert(_layers.size());
    layers_stack_item it = _layers_stack.pop();
    if( it.opacity < 255 || it.mask)
    {
      cairo_pop_group_to_source (_target);
      if( it.mask ) {
        cairo_surface_t* bmp_surface = cairo_surface(it.mask);
        if(!bmp_surface) {
          //printf("!bmp_surface in graphics::push_layer\n");
          return;
        }
        cairo_mask_surface( _target, bmp_surface, 0,0 );
      }
      else if(it.opacity == 255)
        cairo_paint(_target);
      else
        cairo_paint_with_alpha (_target, it.opacity / 255.0);
    } else {
      cairo_restore(_target);
    }
  }
  CAP_STYLE graphics::cap_style() {
     switch(cairo_get_line_cap(_target)) {
       case CAIRO_LINE_CAP_BUTT:   return CAP_BUTT;
       case CAIRO_LINE_CAP_ROUND:  return CAP_ROUND;
       case CAIRO_LINE_CAP_SQUARE: return CAP_SQUARE;
     }
     return CAP_BUTT;
  }
  void graphics::cap_style(CAP_STYLE ncs) {
      switch(ncs) {
        default:
        case CAP_BUTT: cairo_set_line_cap(_target,CAIRO_LINE_CAP_BUTT); break;
        case CAP_ROUND: cairo_set_line_cap(_target,CAIRO_LINE_CAP_ROUND); break;
        case CAP_SQUARE: cairo_set_line_cap(_target,CAIRO_LINE_CAP_SQUARE); break;
      }
  }
  LINE_JOIN graphics::line_join() {
      switch(cairo_get_line_join(_target)) {
        case CAIRO_LINE_JOIN_MITER: return JOIN_MITER;
        case CAIRO_LINE_JOIN_ROUND: return JOIN_ROUND;
        case CAIRO_LINE_JOIN_BEVEL: return JOIN_BEVEL;
      }
      return JOIN_MITER;
  }
  void graphics::line_join(LINE_JOIN ncs, float mitter_limit) {
      switch(ncs) {
        default:
        case JOIN_MITER : cairo_set_line_join(_target, CAIRO_LINE_JOIN_MITER); break;
        case JOIN_ROUND : cairo_set_line_join(_target, CAIRO_LINE_JOIN_ROUND); break;
        case JOIN_BEVEL : cairo_set_line_join(_target, CAIRO_LINE_JOIN_BEVEL); break;
      }
  }
  DASH_STYLE graphics::dash_style() {
    int dash_count = cairo_get_dash_count(_target);
    if(dash_count == 0 )
      return DASH_STYLE_SOLID;
    if( dash_count != 2 )
      return DASH_STYLE_SOLID;
    double dashes[2];
    double offset;
    cairo_get_dash(_target,dashes,&offset);
    if( dashes[0] == 1.0 && dashes[1] == 1.0)
      return DASH_STYLE_DOT;
    return DASH_STYLE_DASH;
  }
  void graphics::dash_style( DASH_STYLE st ) {
    switch(st) {
      case DASH_STYLE_SOLID: cairo_set_dash(_target, nullptr,0,0); break;
      case DASH_STYLE_DOT: {
        double dashes[] = {1.0,1.0};
        cairo_set_dash(_target,dashes,2,0);
        break;
      }
      case DASH_STYLE_DASH: {
        double dashes[] = {1.0,3.0};
        cairo_set_dash(_target,dashes,2,0);
        break;
      }
    }
  }

  void graphics::custom_dash_style(slice<float> pattern,float offset) {
    array<double> pat; pattern.each([&pat](float f) -> bool { pat.push(f); return false; });
    cairo_set_dash(_target,pat.cbegin(),pat.length(),offset);
  }

  void graphics::set_stroke( argb c)
  {
     if( c == argb::no_color() )
       _registers.stroke_brush = nullptr;
     else
       _registers.stroke_brush = new solid_brush(c);
    /*if( c == argb::no_color() )
      stroke_style( STROKE_NONE );
    else {
      stroke_style( STROKE_SOLID );
      if( c.is_opaque() )
        cairo_set_source_rgb(_target, GRGB(c) );
      else
        cairo_set_source_rgba(_target, GRGBA(c) );
    }*/
  }
  void graphics::set_stroke( const gool::linear_brush& lb )
  {
    _registers.stroke_brush = new linear_gradient_brush(lb);
  }
  void graphics::set_stroke( const radial_brush& rb )
  {
    _registers.stroke_brush = new radial_gradient_brush(rb);
  }
  void graphics::set_stroke_width( float w )
  {
    cairo_set_line_width(_target,w);
  }

  void graphics::set_fill( argb c )
  {
     if( c == argb::no_color() )
       _registers.fill_brush = nullptr;
     else
       _registers.fill_brush = new solid_brush(c);
  }
  void graphics::set_fill( const linear_brush& lb )
  {
    _registers.fill_brush = new linear_gradient_brush(lb);
  }

  void graphics::set_fill( const radial_brush& rb )
  {
    _registers.fill_brush = new radial_gradient_brush(rb);
  }
  void graphics::set_fill( const image* ib )
  {
    _registers.fill_brush = new image_brush(ib);
  }
  void graphics::set_fill_even_odd( bool even_odd )
  {
     cairo_set_fill_rule (_target, even_odd ? CAIRO_FILL_RULE_EVEN_ODD : CAIRO_FILL_RULE_WINDING );
  }

  void gradient_brush::init_stops( const gool::gradient_brush& gb ) {
     slice<gool::color_stop>   color_stops = gb.stops();
     uint ci = 0;
     for( uint i = 0; i < color_stops.length; ++i ) {
        auto c = color_stops[i].color;
        cairo_pattern_add_color_stop_rgba(pat, color_stops[i].position, GRGBA(c) );
     }
  }

  void graphics::render_current_path(bool fill, bool stroke)
  {
    if( _registers.fill_brush && fill) {
      cairo_set_source(_target, _registers.fill_brush->pat );
      if(_registers.stroke_brush && stroke)
        cairo_fill_preserve(_target);
      else
        cairo_fill(_target);
    }
    if( _registers.stroke_brush && stroke) {
      cairo_set_source(_target, _registers.stroke_brush->pat );
      cairo_stroke(_target);
    }
  }

  cairo_surface_t* cairo_surface( gool::bitmap* bmp )
  {
    if( !bmp )
        return nullptr;

    gool::size dim = bmp->dim();

    if( !bmp->cr_surface
         || cairo_image_surface_get_width(bmp->cr_surface) != dim.x
         || cairo_image_surface_get_height(bmp->cr_surface) != dim.y
         || bmp->_generation != bmp->_used_generation
       ) {

        bmp->_used_generation = bmp->_generation;

        /*if( !bmp->_pixels.length() )
        {
          slice<argb> src;
          src.start = (argb*)cairo_image_surface_get_data( cairo_surface(pbmp) );
          src.length = pbmp->dim().x * pbmp->dim().y;
          pbmp->set_bits(src);

        }*/

        if( bmp->_pixels.length() )
        {
          cairo_surface_t *psf = cairo_image_surface_create_for_data ((unsigned char *)bmp->_pixels.head(),
                                                         CAIRO_FORMAT_ARGB32,
                                                         dim.x,
                                                         dim.y,
                                                         bmp->stride());
          if(psf)
            bmp->cr_surface = psf;
        }

    }

    if( !bmp->cr_surface )
    {
        bmp->cr_surface = cairo_image_surface_create(CAIRO_FORMAT_ARGB32, dim.x, dim.y);
        bmp->_used_generation = bmp->_generation;
        assert(bmp->cr_surface);
    }

    return bmp->cr_surface;
  }

  void graphics::draw_ellipse(pointf center, sizef radius, bool stroke, bool fill)
  {
     cairo_save (_target);
     cairo_new_path(_target);
     cairo_translate (_target, center.x, center.y);
     cairo_scale (_target, 1, radius.y / radius.x);
     cairo_arc (_target, 0., 0., radius.x, 0., 2 * M_PI);

     //cairo_arc (_target, center.x, center.y, radius.x, 0., 2 * M_PI);

     render_current_path(true,true);
     cairo_restore (_target);
  }

  void graphics::draw_arc(pointf center, sizef radius, float angle_start, float angle_sweep,bool stroke, bool fill)
  {
     cairo_save (_target);
     cairo_new_path(_target);
     cairo_translate (_target, center.x, center.y);
     cairo_scale (_target, 1, radius.y / radius.x);
     if( _registers.fill_drawable() ) {
       cairo_move_to(_target, 0., 0.);
       cairo_arc (_target, 0., 0., radius.x, angle_start, angle_start + angle_sweep);
       cairo_close_path(_target);
     }
     else
       cairo_arc (_target, 0., 0., radius.x, angle_start, angle_start + angle_sweep);
     render_current_path(true,true);
     cairo_restore (_target);
  }
  void graphics::draw_rectangle(pointf org, sizef dim, bool stroke, bool fill)
  {
    cairo_new_path(_target);
    cairo_rectangle(_target, org.x, org.y, dim.x, dim.y);
    render_current_path(true,true);
  }
  /*void graphics::draw_rectangle(rectf r)
  {
    cairo_new_path(_target);
    cairo_rectangle(_target, GRECT(r));
    render_current_path(true,true);
  }*/

  void graphics::draw_path( const gool::path* dst, bool stroke, bool fill)
  {
    cairo_new_path(_target);
    cairo_append_path(_target, ((gtk::path*)dst)->gpath());
    render_current_path(fill,stroke);
  }
  void graphics::draw_path( const gool::polygonf& p, bool stroke, bool fill)
  {
     path pa; pa.set(p);
     this->draw_path(&pa,stroke,fill);
  }
  void graphics::draw_line(pointf start, pointf end) {
     cairo_move_to(_target,start.x,start.y);
     cairo_line_to(_target,end.x,end.y);
     //cairo_stroke(_target);
     render_current_path(false,true);
  }

  void graphics::translate(pointf pt)
  {
    cairo_translate(_target, pt.x, pt.y);
  }
  void graphics::rotate(float radians, pointf center)
  {
    if(center.x != 0 || center.y != 0) {
       cairo_translate(_target, center.x, center.y);
       cairo_rotate(_target, radians);
       cairo_translate(_target, -center.x, -center.y);
    } else {
       cairo_rotate(_target, radians);
    }
  }

  void graphics::scale(sizef sz, pointf center)
  {
    if(center.x != 0 || center.y != 0) {
       cairo_translate(_target, center.x, center.y);
       cairo_scale(_target, sz.x, sz.y);
       cairo_translate(_target, -center.x, -center.y);
    } else {
       cairo_scale(_target, sz.x, sz.y);
    }
  }
  void graphics::skew(sizef sz, pointf center)
  {
     cairo_matrix_t shear;
     cairo_matrix_init(&shear, 1, real_traits<double>::tan(sz.y), real_traits<double>::tan(sz.x), 1, 0,0);
     if(center.x != 0 || center.y != 0) {
       cairo_translate(_target, center.x, center.y);
       cairo_transform(_target, &shear);
       cairo_translate(_target, -center.x, -center.y);
    } else {
       cairo_transform(_target, &shear);
    }
  }
  void graphics::transform(const affine_mtx_f& m)
  {
     cairo_matrix_t mtx;
     mtx.xx = m.sx;
     mtx.yx = m.shy;
     mtx.xy = m.shx;
     mtx.yy = m.sy;
     mtx.x0 = m.tx;
     mtx.y0 = m.ty;
     cairo_transform(_target,&mtx);
  }

  void graphics::reset_transform() {
     cairo_identity_matrix(_target);
  }

  affine_mtx_f graphics::transform() const
  {
     cairo_matrix_t mtx;
     cairo_get_matrix (_target,&mtx);
     affine_mtx_f m;
     m.sx  = mtx.xx;
     m.shy = mtx.yx;
     m.shx = mtx.xy;
     m.sy  = mtx.yy;
     m.tx  = mtx.x0;
     m.ty  = mtx.y0;
     return m;
  }

// void


  pointf graphics::world_to_screen(pointf pt) const
  {
    pointd d = pt;
    cairo_user_to_device(_target,&d.x,&d.y);
    return d;
  }
  pointf graphics::screen_to_world(pointf pt) const
  {
    pointd d = pt;
    cairo_device_to_user(_target,&d.x,&d.y);
    return d;
  }

  void graphics::do_draw( image* img, const rectf&  dst, const rect& src, byte opacity)
  {
    cairo_save(_target);

    handle<gool::bitmap> bmp = img->get_bitmap(this,src.size());
    //if(!bmp)
    //    pat = cairo_pattern_create_for_surface(cairo_surface(bmp));

    assert(bmp.ptr());

    size src_img_size = img->dim();
    size src_size = src.size();

    cairo_surface_t* bmp_surface = cairo_surface(bmp);
    bool             bmp_surface_owner = false;

    if(!bmp_surface) {
      printf("!bmp_surface && src_img_size %d %d\n", src_img_size.x,src_img_size.y);
      return;
    }

    assert(bmp_surface);

    if( src_img_size != src_size) {
      bmp_surface = cairo_surface_create_for_rectangle(bmp_surface, GRECT(src));
      bmp_surface_owner = true;
    }

    assert(bmp_surface);
    assert(_target);

    cairo_rectangle (_target, GRECT(dst));
    cairo_clip(_target);

    cairo_pattern_t *pat = nullptr;

    if( gool::size(dst.size()) == src_size ) {
       cairo_set_source_surface (_target, bmp_surface, dst.s.x,dst.s.y);
       pat = cairo_get_source(_target);
    }
    else {
       cairo_translate(_target, dst.s.x,dst.s.y );
       cairo_scale(_target, dst.width() / src_size.x,dst.height() / src_size.y );
       cairo_set_source_surface (_target, bmp_surface, 0,0);
       pat = cairo_get_source(_target);
       if(pat)
         cairo_pattern_set_extend (pat, CAIRO_EXTEND_PAD);
    }

    if(pat) {
      switch(_image_rendering_mode) {
        default: break; // CAIRO_FILTER_NEAREST
        case image_rendering_default:  cairo_pattern_set_filter(pat, CAIRO_FILTER_BILINEAR); break;
        case image_rendering_speed:    cairo_pattern_set_filter(pat, CAIRO_FILTER_FAST); break;
        case image_rendering_quality:  cairo_pattern_set_filter(pat, CAIRO_FILTER_GOOD); break;
      }
    }

    cairo_paint (_target);

    /*rect img_rect = rect( img->dim() );
    if( src == img_rect ) {
      cairo_set_source_surface (_target, cairo_surface(bmp), dst.left(), dst.top());
      cairo_paint (_target);
    } else {
      cairo_set_source_surface (_target, cairo_surface(bmp), 0, 0);
      cairo_rectangle (_target, GRECT(dst));
      cairo_fill (_target);
    }*/

    cairo_restore(_target);

    if( bmp_surface_owner )
       cairo_surface_destroy(bmp_surface);

  }

  void graphics::fill( image* img, const rect& dst, const rect& src, point offset, size celldim)
  {
      cairo_save(_target);

      size src_img_size = img->dim();
      size src_size = src.size();


      handle<gool::bitmap> bmp = img->get_bitmap(this,src.size());
      if(!bmp) return;
      cairo_surface_t* bmp_surface = cairo_surface(bmp);
      if(!bmp_surface) return;
      bool             bmp_surface_owner = false;


      if( src_img_size != src_size) {
        bmp_surface = cairo_surface_create_for_rectangle(bmp_surface, GRECT(src));
        bmp_surface_owner = true;
      }

      cairo_rectangle (_target, GRECT(dst));

      cairo_set_source_surface(_target, bmp_surface, dst.s.x + offset.x, dst.s.y + offset.y);

      cairo_pattern_t* pat = cairo_get_source(_target);
      cairo_pattern_set_extend (pat, CAIRO_EXTEND_REPEAT);

      //printf("src_size %d %d celldim %d %d src %d %d %d %d\n", src_size.x, src_size.y, celldim.x, celldim.y, src.left(), src.top(), src.width(), src.height());
      //printf("offset %d %d - %d %d %d %d\n", offset.x, offset.y, src.left(), src.top(), src.width(), src.height());

      if(!celldim.empty() && src_size != celldim)
      {
        //cairo_clip_preserve(_target);
        cairo_matrix_t matrix;
        cairo_matrix_init_scale (&matrix, src_size.x / double(celldim.x), src_size.y / double(celldim.y) );
        cairo_matrix_translate(&matrix,-(dst.s.x + offset.x), -(dst.s.y + offset.y));
        cairo_pattern_set_matrix (pat, &matrix);
      } else {
        cairo_matrix_t matrix;
        cairo_matrix_init_translate(&matrix,-(dst.s.x + offset.x), -(dst.s.y + offset.y));
        cairo_pattern_set_matrix (pat, &matrix);
      }

      cairo_fill(_target);

      cairo_restore(_target);

      if( bmp_surface_owner )
        cairo_surface_destroy(bmp_surface);

  }


  /*
  void graphics::fill( image* img, const rect& dst, const rect& src, point offset, size celldim)
  {
      cairo_save(_target);


      size src_img_size = img->dim();

      size src_size = src.size();

      if(celldim.empty())
        celldim = src_size;

      handle<gool::bitmap> bmp = img->get_bitmap(this,src.size());
      cairo_surface_t* bmp_surface = cairo_surface(bmp);

      if( src_img_size != src_size)
        bmp_surface = cairo_surface_create_for_rectangle(bmp_surface, GRECT(src));

      //cairo_set_source_surface(_target, bmp_surface, dst.s.x, dst.s.y);

      cairo_pattern_t *pattern = cairo_pattern_create_for_surface (bmp_surface);
      cairo_pattern_set_extend (pattern, CAIRO_EXTEND_REPEAT);

      cairo_matrix_t   matrix;
      cairo_matrix_init_translate(&matrix, src.s.x, src.s.y);

      if( celldim != src_size ) {
        //cairo_matrix_init_scale (&matrix, src_size.x/celldim.x , src_size.y/celldim.y);
        cairo_matrix_scale (&matrix, src_size.x/celldim.x , src_size.y/celldim.y);
      }
      cairo_pattern_set_matrix (pattern, &matrix);
      cairo_set_source (_target, pattern);

      //cairo_translate (_target, dst.s.x, dst.s.y);
      cairo_rectangle (_target, GRECT(dst));
      cairo_fill_preserve(_target);
      cairo_set_source_rgb (_target, 0, 127, 0); cairo_stroke (_target);

      cairo_restore(_target);

      if(pattern)
        cairo_pattern_destroy (pattern);

      if( bmp_surface != cairo_surface(bmp) )
        cairo_surface_destroy(bmp_surface);

  } */


#if 0
  PangoAttrList *pango_attr_list (resolution_provider& v, const text_format& tf) {

    PangoAttrList *list = pango_attr_list_new();

    auto fsz = tf.font_size * v.pixels_per_inch().y / 72.0f;

    PangoLanguage *plang = pango_language_from_string ( u8::cvt(tf.locale_name));
    if(plang)
      pango_attr_list_insert( list, pango_attr_language_new(plang) );
    pango_attr_list_insert( list, pango_attr_family_new ( u8::cvt(tf.font_family)) );
    pango_attr_list_insert( list, pango_attr_size_new_absolute( fsz * PANGO_SCALE ));
    pango_attr_list_insert( list, pango_attr_style_new( tf.font_italic ? PANGO_STYLE_ITALIC : PANGO_STYLE_NORMAL ) );
    pango_attr_list_insert( list, pango_attr_weight_new( tf.font_weight ));

    return list;
  }

  void text_layout::set(resolution_provider& v, wchars text, const text_format& tf, gool::application* app)
  {
     gtk::view* pv = static_cast<gtk::view*>(&v);

     PangoContext* pcontext =  gtk_widget_get_pango_context(pv->get_hwnd());

     _layout = pango_layout_new(pcontext);

     _valign = tf.line_progression_alignment;

    tool::string u8 = u8::cvt(text);

    PangoAttrList* attrs = pango_attr_list(v,tf);
    pango_layout_set_attributes (_layout, attrs);

    pango_attr_list_unref (attrs);

    if( tf.line_height )
      pango_layout_set_spacing (_layout, tf.line_height * PANGO_SCALE * 96.0 / 72.0);

    PangoAlignment pa = PANGO_ALIGN_LEFT;

    switch( tf.text_alignment )
    {
      default:
      case ALIGN_START: pa = tf.text_direction == TD_RTL ? PANGO_ALIGN_RIGHT : PANGO_ALIGN_LEFT; break;
      case ALIGN_END:   pa = tf.text_direction == TD_RTL ? PANGO_ALIGN_LEFT : PANGO_ALIGN_RIGHT; break;
      case ALIGN_CENTER:pa = PANGO_ALIGN_CENTER; break;
    }

    pango_layout_set_alignment (_layout, pa);

    pango_layout_set_text(_layout, u8, u8.size());

    int x,y;

    //float       width_min;
    //float       width_max;
    //float       height;    // content height
    //float       ascent;    // content ascent
    //sizef       box;       // box dimensions

    pango_layout_get_pixel_size (_layout, &x, &y);
    _width_min = _width_max = x;
    _height = y;
    _ascent = pango_layout_get_baseline (_layout) / PANGO_SCALE;
  }

  void text_layout::set_width(float width)
  {
    pango_layout_set_width (_layout, width * PANGO_SCALE);
    int x,y;
    pango_layout_get_pixel_size (_layout, &x, &y);
    _box.x = x;
    _height = y;
  }
  void text_layout::set_height(float height)
  {
    _box.y = height;
  }

  uint        text_layout::get_lines_count() const {
    return (uint)pango_layout_get_line_count (_layout);
  }
  array<text_layout::line> text_layout::get_lines() const {
    array<text_layout::line> lines;

    PangoLayoutIter *piter = pango_layout_get_iter (_layout);

    for(;;) {
      text_layout::line ln;

      ln.baseline = pango_layout_iter_get_baseline (piter) / PANGO_SCALE;

      int y0,y1;  pango_layout_iter_get_line_yrange(piter,&y0,&y1);
      ln.y = y0;  ln.height = (y1 - y0) / PANGO_SCALE;

      PangoRectangle  ink_rect; pango_layout_iter_get_line_extents(piter, &ink_rect, NULL);
      ln.length = ink_rect.width / PANGO_SCALE;

      lines.push(ln);

      if(!pango_layout_iter_next_line (piter))
        break;
    }
    pango_layout_iter_free (piter);
    return lines;
  }

  void graphics::draw( gool::text_layout& tl, pointf dst, argb c)
  {
    // TODO: apply color!
    gtk::text_layout* gtl = static_cast<gtk::text_layout*>(&tl);
    cairo_set_source_rgba(_target, GRGBA(c) );
    switch(gtl->_valign) {
      default:
      case ALIGN_START: break;
      case ALIGN_END: dst.y += tl.get_box().y - tl.height(); break;
      case ALIGN_CENTER: dst.y += (tl.get_box().y - tl.height()) / 2; break;
    }
    cairo_move_to (_target, dst.x, dst.y);
    pango_cairo_show_layout (_target, gtl->layout());
  }

  void graphics::draw( gool::text_layout& tl, pointf dst )
  {
    gtk::text_layout* gtl = static_cast<gtk::text_layout*>(&tl);

    cairo_save(_target);

    cairo_new_path(_target);

    switch(gtl->_valign) {
      default:
      case ALIGN_START: break;
      case ALIGN_END: dst.y += tl.get_box().y - tl.height(); break;
      case ALIGN_CENTER: dst.y += (tl.get_box().y - tl.height()) / 2; break;
    }

	cairo_move_to(_target, dst.x, dst.y);

	pango_cairo_layout_path(_target, gtl->layout());

    render_current_path(true,true);

    cairo_restore(_target);

  }
#endif // 0

}
