#include "gtk-sciter.h"
#include <gdk/gdk.h>
#include "gtk-graphics.h"

gool::size gtk_pixels_per_inch(GdkScreen* ds) {

   gool::size r(96,96);

/*   if(ds)
   {
#if 1	   
      GdkRectangle rc;
      gdk_screen_get_monitor_geometry(ds,0,&rc);

      gool::sized in;
      in.x = gdk_screen_get_monitor_width_mm(ds,0) * 0.0393701;
      in.y = gdk_screen_get_monitor_height_mm(ds,0) * 0.0393701;

      if(!in.empty())
      {
        r.x = int(rc.width / in.x + 0.5 );
        r.y = int(rc.height / in.y + 0.5 );
      }
#else
      double d = gdk_screen_get_resolution(ds);
	  if(d > 1) {
	  	r.x /= d; 
		r.y /= d; 
	  } 
#endif	  
      //printf("gtk_pixels_per_inch %d %d\n", r.x,r.y);
   }
*/
   return r;
}

static bool sys_color_table_initialized = false;

static gool::color sc_selection_back;
static gool::color sc_selection_text;

//static gool::color sc_window_back;
//static gool::color sc_window_text;

void gtk_init_sys_colors_table(GtkWidget* pw, bool force)
{
   if( sys_color_table_initialized && !force )
     return;


   sys_color_table_initialized = true;

   GtkStyleContext* sc = gtk_widget_get_style_context (pw);
   GdkRGBA color;

   //gtk_style_context_get_background_color(sc, GTK_STATE_FLAG_NORMAL, &color); sc_window_back = cvt(color);
   //gtk_style_context_get_color(sc, GTK_STATE_FLAG_NORMAL, &color); sc_window_text = cvt(color);

   gtk_style_context_get_background_color(sc, GTK_STATE_FLAG_SELECTED, &color); sc_selection_back = cvt(color);
   gtk_style_context_get_color(sc, GTK_STATE_FLAG_SELECTED, &color); sc_selection_text = cvt(color);

}


namespace gool {

  bool get_system_font(/*inout*/ ustring& name, /*out*/int& size, /*out*/ uint& weight, /*out*/bool& italic)
  {
     const char *param_name = "gtk-font-name";
     gchar *value = NULL;
     GtkSettings* settings = gtk_settings_get_default();
     g_object_get(settings, param_name, &value, NULL);
     chars namesize = chars_of(value);
     chars ssize = namesize.r_tail(' ');
     chars sname = namesize.r_head(' ');
     size = str_to_i(ssize,10);
     //gool::size pxin = resolution_provider::desktop().pixels_per_inch();
     //size *= 96;
     //size /= pxin.y;
     name = ustring(!sname ? CHARS("Sans"): sname);
     weight = 400;
     italic = false;
     return true;
  }

  int scrollbar_width() { return 16; }
  int scrollbar_height() { return 16; }
  int small_icon_width() { return 24;  }
  int small_icon_height() { return 24; }
  int border_width()      { return 1; }
  int border_3d_width()   { return 2; }

  struct _resolution_provider: public resolution_provider
  {
    size _pixels_per_inch;

    _resolution_provider(): _pixels_per_inch(0) {}

    void reset_resolution() {

      GdkScreen* ds = gdk_screen_get_default();
      _pixels_per_inch = gtk_pixels_per_inch(ds);

    }

    size pixels_per_inch()
    {
      if(!_pixels_per_inch.x)
        reset_resolution();
      return _pixels_per_inch;
    }

    void pixels_per_inch(size sz)
    {
      assert(false);// not used in default provider
      _pixels_per_inch = sz;
    }

  };

  resolution_provider& resolution_provider::desktop() {
    static _resolution_provider provider;
    return provider;
  }

  /*bool is_sys_color(color cs)
  {
    if((0xFF000000 & cs) != 0xFF000000) return false;
    uint idx = cs & 0xFF;
    if( idx > 0x30 )
      return false;
    return true;
  }*/




  color xcolor(SYSTEM_COLORS cs)
  {
    //uint idx = cs & 0xFF;

    //if( idx > 0x30 )
    //  return cs;
    switch( cs ) {
      case SC_WINDOW            : return 0xFFFFFF;
      case SC_WINDOW_TEXT       : return 0x000000;
      case SC_DIALOG_BRIGHT     : return 0xFFFFFF;
      case SC_DIALOG_LIGHT      : return 0xE3E3E3;
      case SC_DIALOG_SURFACE    : return 0xF0F0F0;
      case SC_DIALOG_SHADOW     : return 0xA0A0A0;
      case SC_DIALOG_DKSHADOW   : return 0x696969;
//      case SC_SELECTION         : return sys_color_table_initialized ? sc_selection_back : 0xFF9933;
//      case SC_SELECTION_TEXT    : return sys_color_table_initialized ? sc_selection_text : 0xFFFFFF;
//      case SC_MENU_SELECTION      : return sys_color_table_initialized ? sc_selection_back : 0xFF9933;
//      case SC_MENU_SELECTION_TEXT : return sys_color_table_initialized ? sc_selection_text : 0xFFFFFF;

      case SC_ACCENT            :
      case SC_SELECTION         : return 0xFF9933;
      case SC_ACCENT_TEXT       :
      case SC_SELECTION_TEXT    : return 0xFFFFFF;
      case SC_MENU_SELECTION      : return 0xFF9933;
      case SC_MENU_SELECTION_TEXT : return 0xFFFFFF;
      case SC_WORKSPACE         : return 0xABABAB;
      case SC_CAPTION           : return 0xF2E4D7;
      case SC_CAPTION_TEXT      : return 0x544E43;
      case SC_ACTIVE_CAPTION    : return 0xD1B499;
      case SC_ACTIVE_CAPTION_TEXT : return 0x000000;
      case SC_INFO                : return 0xE1FFFF;
      case SC_INFO_TEXT           : return 0x000000;
      case SC_DIALOG_TEXT         : return 0x000000;
      case SC_SCROLLBAR           : return 0xF7F7F7;
      case SC_DESKTOP             : return 0x464646;
      case SC_GRAY_TEXT           : return 0x6D6D6D;
      case SC_WINDOW_BORDER       : return 0xA0A0A0;
      case SC_BORDER              : return 0xA0A0A0;
      case SC_DIALOG_LIGHTSHADOW  : return 0xE9E9E9;
      //case INVERSE_COLOR          : return INVERSE_COLOR;
    }
    return cs;
  }


}
