#include "gtk-sciter.h"

namespace html
{

  bool clipboard::get(ustring& data)
  {
    GtkClipboard *cb = gtk_clipboard_get (GDK_NONE);
    if( !cb )
      return false;
    gchar* text = gtk_clipboard_wait_for_text(cb);
    if( text ) {
      data = u8::cvt(chars_of(text));
      g_free(text);
      return true;
    }
    return false;
  }

  bool clipboard::set_text(wchars us)
  {
    GtkClipboard *cb = gtk_clipboard_get (GDK_NONE);
    if( !cb )
      return false;

    tool::array<byte> data;
    u8::from_utf16(us,data, false);

    gtk_clipboard_clear (cb);
    gtk_clipboard_set_text (cb, (const gchar *)data.cbegin(),data.size());
    return true;
  }

  bool clipboard::_set_text(wchars us)
  {
    GtkClipboard *cb = gtk_clipboard_get (GDK_NONE);
    if( !cb )
      return false;

    tool::array<byte> data;
    u8::from_utf16(us,data);

    gtk_clipboard_set_text (cb, (const gchar *)data.cbegin(),data.size());
    return true;
  }
  void clipboard::_set_html(chars html) {}
  void clipboard::_set_image(const gool::image* data){}
  void clipboard::_set_link(wchars url,wchars caption) {}

  void clipboard::empty() {

    GtkClipboard *cb = gtk_clipboard_get (GDK_NONE);
    if( cb )
      gtk_clipboard_clear (cb);
  }

  void clipboard::set(view& v, html::selection_ctx& sctx)
  {
//   printf("clipboard::set Aa\n");
    GtkClipboard *cb = gtk_clipboard_get (GDK_NONE);
    if( !cb )
      return;
    gtk_clipboard_clear (cb);

    //bookmark start = sctx.caret;
    //bookmark end = sctx.anchor;

    //if( start > end )
    //   swap(start,end);
    //printf("clipboard::set Bb\n");
    array<wchar> text;
    array<char>  html;
    text_cf(v, sctx, text);
    html_cf(v, sctx, html);

    handle<clipboard::data> cbdata = new clipboard::data();

    clipboard::html_item* hi = new clipboard::html_item();
    hi->val = html();
    cbdata->add(hi);

    clipboard::text_item* ti = new clipboard::text_item(text());
    cbdata->add(ti);

    //gtk_clipboard_set_text (cb, (const gchar *)text.cbegin(),text.size());
    //printf("clipboard::set html: %s\n",hi->val.c_str());
    clipboard::set(cbdata);
  }

  static GdkAtom text_html_atom()
  {
     GdkAtom atom = gdk_atom_intern_static_string ("text/html");
     return atom;
  }

  static GdkAtom text_plain_atom()
  {
     GdkAtom atom = gdk_atom_intern_static_string ("text/plain;charset=utf-8");
     return atom;
  }

  void clipboard::available_formats( tool::function<bool(clipboard::clipboard_format cf)> ccb )
  {
    GtkClipboard *cb = gtk_clipboard_get (GDK_NONE);
    if( !cb )
      return;

    int mask = 0;

    if(gtk_clipboard_wait_is_text_available(cb))
      ccb(cf_text);
    if(gtk_clipboard_wait_is_image_available (cb))
      ccb(cf_picture);
    //if(gtk_clipboard_wait_is_rich_text_available (cb) )
    //  ccb(cf_html);
    if( gtk_clipboard_wait_is_target_available(cb,text_html_atom()) )
    {
      //printf("has html\n");
      ccb(cf_html);
    }
    if(gtk_clipboard_wait_is_uris_available (cb))
      ccb(cf_file);

  }

  bool clipboard::get_html(array<byte>& text , string& url)
  {
    //printf("getting html!\n");

    GtkClipboard *cb = gtk_clipboard_get (GDK_NONE);
    if( !cb )
      return false;

    GdkAtom atoms[] = { text_html_atom() };
    gint n_targets = 1;
    GtkSelectionData * sd = gtk_clipboard_wait_for_contents (cb, text_html_atom());
    uint format = gtk_selection_data_get_format(sd);
    if(format == 16)
    {
      gint  length = 0;
      const guchar * data = gtk_selection_data_get_data_with_length(sd,&length);
      tool::ustring us = tool::ustring((const wchar*)data, length / sizeof(wchar));
      text = u8::cvt(us).chars_as_bytes();
      //printf("getting html %s\n", text.cbegin());
      return true;
    }
    else if(format == 8)
    {
      gint  length = 0;
      const guchar * data = gtk_selection_data_get_data_with_length(sd,&length);
      text = bytes((const byte*)data, length);
      //printf("getting html %s\n", text.cbegin());
      return true;
    }
    return false;
  }


  bool clipboard::get_image(handle<image>& data)
  {
    return false;
/*
    if (IsClipboardFormatAvailable(CF_BITMAP))
    {
       if (!OpenClipboard(NULL)) return false;

       HBITMAP hbmp = (HBITMAP)GetClipboardData(CF_BITMAP);
       if(!hbmp)
         return false;

       data = new bitmap(hbmp);

       CloseClipboard();

       return true;
    }
    else
      return false;

   return true; */

  }

  void clipboard::set(const gool::image* data)
  {
  }

  static void GetOp(GtkClipboard* clipboard, GtkSelectionData* selection_data, guint info, gpointer user_data) {
    clipboard::data* cbdata = (clipboard::data*) user_data;

    printf("clipboard::set E\n");


    if(info == html::clipboard::cf_text) {
        html::clipboard::text_item* pt = cbdata->get<html::clipboard::text_item>();
        if(pt) {
            string u8 = u8::cvt(pt->val);
            gtk_selection_data_set (selection_data,
                        text_plain_atom(),
                        8,
                        (const guchar*)(u8.c_str()),
                        u8.length());
            //gtk_selection_data_set_text(selection_data,(const gchar*)(u8.c_str()),u8.size());
        }
    } else if(info == html::clipboard::cf_html) {
        html::clipboard::html_item* pt = cbdata->get<html::clipboard::html_item>();
        if(pt) {
            printf("GetOp %s\n",pt->val.c_str());
            gtk_selection_data_set (selection_data,
                        text_html_atom(),
                        8,
                        (const guchar*)pt->val.c_str(),
                        pt->val.length());
        }
    }
  }

  void ClearOp(GtkClipboard* clipboard, gpointer user_data) {
    clipboard::data* cbdata = (clipboard::data*) user_data;
    printf("clipboard::set D\n");

    cbdata->release();
  }


  bool clipboard::set(clipboard::data* cbdata)
  {

    //static GdkAtom utf8_atom = gdk_atom_intern_static_string ("UTF8_STRING");
    //static GdkAtom text_atom = gdk_atom_intern_static_string ("TEXT");
    //static GdkAtom ctext_atom = gdk_atom_intern_static_string ("COMPOUND_TEXT");
    //static GdkAtom text_plain_atom = gdk_atom_intern_static_string ("text/plain");
    //static GdkAtom text_plain_utf8_atom = gdk_atom_intern_static_string ("text/plain;charset=utf-8");

    //printf("clipboard::set A\n");
    GtkClipboard *cb = gtk_clipboard_get (GDK_NONE);
    //GtkClipboard *cbp = gtk_clipboard_get (GDK_NONE);
    if( !cb )
      return false;

    tool::array<GtkTargetEntry> targets;// = {{"TEXT", 0, 0}, {"IMAGE", 0, 0}};
    //printf("clipboard::set B\n");

    int cnt = 0;
    for (int n = 0; n < cbdata->items.size(); ++n)
    {
      switch (cbdata->items[n]->data_type)
      {
        case clipboard::cf_text: {
        #if 1
          GtkTargetEntry te1 = {"UTF8_STRING", 0,cf_text }; targets.push(te1);
          GtkTargetEntry te2 = {"TEXT", 0,cf_text }; targets.push(te2);
          GtkTargetEntry te3 = {"COMPOUND_TEXT", 0,cf_text }; targets.push(te3);
          GtkTargetEntry te4 = {"STRING", 0,cf_text }; targets.push(te4);
          GtkTargetEntry te5 = {"text/plain", 0,cf_text }; targets.push(te5);
          GtkTargetEntry te6 = {"text/plain;charset=utf-8", 0,cf_text }; targets.push(te6);
        #else
          clipboard::text_item* it = cbdata->items[n].ptr_of<clipboard::text_item>();
          auto data = it->get_data();
          gtk_clipboard_set_text (cb,(const gchar*)data.start,(gint)data.length);
          //return true;

        #endif
          ++cnt;
        } break;
        case clipboard::cf_html: {
          //clipboard::html_item* it = cbdata->items[n].ptr_of<clipboard::html_item>();
          //clipboard::_set_html(it->val());
          GtkTargetEntry te1 = {"text/html", 0,cf_html }; targets.push(te1);
          GtkTargetEntry te2 = {"text/html;charset=utf-8", 0,cf_html }; targets.push(te2);
          GtkTargetEntry te3 = {"HTML", 0,cf_html }; targets.push(te3);
          ++cnt;
        } break;
        case clipboard::cf_picture: {
          clipboard::image_item* it = cbdata->items[n].ptr_of<clipboard::image_item>();
          GtkTargetEntry te = { const_cast<char*>(it->image->mime_type().c_str()) , 0, cf_picture };
          targets.push(te);
          ++cnt;
        } break;
      }
    }

    if( targets.length() == 0)
      return true;

    cbdata->add_ref();

    //printf("clipboard::set C\n");


    gtk_clipboard_set_with_data (cb,
                             targets.cbegin(),
                             targets.length(),
                             GetOp,
                             ClearOp,
                             cbdata);

    gtk_clipboard_set_can_store (cb, NULL, 0);
    //gtk_clipboard_set_can_store (cb,
    //                         targets.cbegin(),
    //                         targets.length());

    gtk_clipboard_store (cb);
    return cnt > 0;
    //return true;
  }



  uint clipboard::get_sequence_num()
  {
    static uint fix_me = 0;
    return ++fix_me;
  }

  bool clipboard::get_link(ustring& url, ustring& caption )
  {
      return false;
  }

  bool clipboard::get_files(array<ustring>& filenames )
  {
    GtkClipboard *cb = gtk_clipboard_get (GDK_NONE);
    if( !cb )
      return false;
    gchar **urls = gtk_clipboard_wait_for_uris (cb);
    for(gchar **ppfn = urls; *ppfn; ++ppfn)
      filenames.push( url::file_url_to_path(tool::ustring(*ppfn)) );

    return true;
  }

}
