#ifndef __xdomjs_xstyle_h__
#define __xdomjs_xstyle_h__

#include "xcontext.h"
#include "xconv.h"

namespace qjs
{
  extern JSClassID Style_class_id;
    
  template <> struct conv<html::style_provider*>
  {
    static html::style_provider* unwrap(JSContext * ctx, JSValueConst v)
    {
      html::element* pe = (html::element*)JS_GetOpaque(v,Style_class_id);
      if (!pe) 
        throw qjs::om::type_error("Element was deleted");
      return static_cast<html::style_provider*>(pe);
    }

    static html::style_provider* try_unwrap(JSContext * ctx, const JSValueConst& v, int argc = 0)
    {
      html::element* pe = (html::element*)JS_GetOpaque(v, Style_class_id);
      if (!pe) return nullptr;
      return static_cast<html::style_provider*>(pe);
    }

    static JSValue wrap(JSContext * ctx, html::style_provider* psp) noexcept
    {
      if (!psp)
        return JS_NULL;
      xcontext c(ctx);
      //JSAtom atom_style = c.known_atoms().style;
      html::element* pe = static_cast<html::element*>(psp);
      //hvalue obj = conv<html::element*>::wrap(ctx, pe);
      //JSPropertyDescriptor desc;
      //if (TRUE == JS_GetOwnProperty(ctx, &desc, obj, atom_style))
        //return JS_DupValue(ctx, desc.value);
      //  return desc.value;
      JSValue style_obj = JS_NewObjectClass(ctx, Style_class_id);
      pe->add_ref();
      JS_SetOpaque(style_obj, pe);
      //JS_DefinePropertyValue(ctx, obj, atom_style, style_obj, JS_PROP_CONFIGURABLE | JS_PROP_ENUMERABLE);
      //return JS_DupValue(ctx, style_obj);
      return style_obj;
    }
    static bool isa(JSContext * ctx, JSValueConst v) { return JS_GetOpaque(v, Style_class_id) != NULL; }
  };

}

#endif