#include "xdom.h"
#include "xom.h"
#include "xstates.h"
#include "html/html-style-enums.h"

namespace html {
  
}

namespace qjs
{
  using namespace tool;
  using namespace html;

  JSClassID ElementState_class_id = 0;

  //string css_to_camel_case(const char* s);
  //html::cssa::symbol_t cssa_from_camel_case(const char* s);

#define JS_STATE(nn, NN)                                     \
  bool state_##nn(xcontext&, element* pe) {                  \
    return pe->state.is_set(ui_state(html::S_##NN));         \
  }                                                          \
  void state_set_##nn(xcontext& c, element* pe,bool on) {    \
    if(on) pe->state_on(*c.pview(), ui_state(html::S_##NN)); \
    else pe->state_off(*c.pview(), ui_state(html::S_##NN));  \
  }

  bool state_focus(xcontext&, element* pe) {
    return pe->state.is_set(ui_state(html::S_FOCUS));
  }
  void state_set_focus(xcontext& c, element* pe, bool on) {
    c.pview()->set_focus(helement(on ? pe : nullptr), html::BY_CODE);
  }
  
  JS_STATE(link, LINK)
  JS_STATE(hover, HOVER)
  JS_STATE(active, ACTIVE)
  //JS_STATE(focus, FOCUS)
  JS_STATE(ownsfocus, OWNS_FOCUS)
  JS_STATE(visited, VISITED)
  JS_STATE(current, CURRENT)
  JS_STATE(checked, CHECKED)
  JS_STATE(selected, SELECTED)
  JS_STATE(disabled, DISABLED)
  JS_STATE(readonly, READONLY)
  JS_STATE(expanded, EXPANDED)
  JS_STATE(collapsed, COLLAPSED)
  JS_STATE(incomplete, INCOMPLETE)
  JS_STATE(invalid, INVALID)
  JS_STATE(animating, ANIMATING)
  JS_STATE(focusable, FOCUSABLE)
  JS_STATE(anchor, ANCHOR)
  JS_STATE(synthetic, SYNTHETIC)
  JS_STATE(ownspopup, OWNS_POPUP)
  JS_STATE(tabfocus, TABFOCUS)
  JS_STATE(empty, EMPTY)
  JS_STATE(busy, BUSY)
  JS_STATE(dragover, DRAG_OVER)
  JS_STATE(droptarget, DROP_TARGET)
  JS_STATE(moving, MOVING)
  JS_STATE(copying, COPYING)
  JS_STATE(dragsource, DRAG_SOURCE)
  JS_STATE(pressed, PRESSED)
  JS_STATE(popup, POPUP)
  JS_STATE(isltr, IS_LTR)
  JS_STATE(isrtl, IS_RTL)
  JS_STATE(ready, READY)
  JS_STATE(unchecked, UNCHECKED)
#undef JS_STATE

  array<float>  content_widths(xcontext& c, element* pe) {
    view* pv = c.pview();
    return array<float> { pv->ppx_to_dip(pe->min_content_width(*pv)), pv->ppx_to_dip(pe->max_content_width(*pv)) };
  }
  float content_height(xcontext& c, element* pe, float_v for_width)
  {
    view* pv = c.pview();
    int height;
    if (for_width.is_defined()) {
      size dim = pe->dim();
      int h = pe->set_width(*pv, pv->dip_to_ppx(for_width.val(0.0f)));
      height = pe->min_content_height(*pv);
      pe->set_width(*pv, dim.x); // return it back
    }
    else {
      height = pe->min_content_height(*pv);
    }
    return pv->ppx_to_dip(height);
  }

  bool set_capture(xcontext& c, element* pe, hvalue p)
  {
    if (p == JS_TRUE)
      c.pview()->set_capture(pe);
    else if (c.get<string>(p) == CHARS("strict"))
      c.pview()->set_capture_strict(pe);
    else
      c.pview()->stop_capture(pe);
    return true;
  }

  bool request_delayed_measure(xcontext& c, element* pe, bool horizontal) {
    return pe->request_delayed_measure(*c.pview(), horizontal);
  }
    
  hvalue element_box(xcontext& c, helement self, string what, string box, string relto, tristate_v as_ppx)
  {
    // DOM element has to have valid positions for that
    if (!self->is_layout_valid())
      c.pview()->commit_update(); //too heavy ?? but MUST be there anyway!

    bool ppx = false;

    if (what == CHARS("intrinsics")) {
      int quad[4] = {
        self->ldata->dim_min.x,
        self->ldata->dim_min.y,
        self->ldata->dim_max.x,
        self->ldata->dim_max.y
      };
      return c.val(items_of(quad));
    }

    rect rc;
    if (box == CHARS("inner") || box.length() == 0) { rc = rect(self->dim()); }
    else if (box == CHARS("border")) { rc = self->border_box(*c.pview()); }
    else if (box == CHARS("padding")) { rc = self->padding_box(*c.pview()); }
    else if (box == CHARS("margin")) { rc = self->margin_box(*c.pview()); }
    else if (box == CHARS("client")) { rc = self->client_box(*c.pview()); }
    else if (box == CHARS("content")) { 
      html::scroll_data sd;
      self->get_scroll_data(*c.pview(), sd);
      rc = sd.content_outline + sd.pos;
    }
    else if (box == CHARS("clip")) { rc = self->clip_box(*c.pview()); }
    else if (box == CHARS("caret")) { rc = rect(); self->get_caret_location(*c.pview(), rc); }
    else if (box == CHARS("icon")) { if (self->ldata) rc = self->ldata->foreground_box; }

    rect inner(self->dim());

    if (relto.length() == 0 || relto == CHARS("this")) { ; }
    else if (relto == CHARS("window")) { rc += self->view_pos(*c.pview()); ppx = true; }
    else if (relto == CHARS("document")) rc += self->doc_pos(*c.pview());
    else if (relto == CHARS("parent")) { if (self->parent) rc += self->doc_pos(*c.pview()) - self->parent->doc_pos(*c.pview()); }
    else if (relto == CHARS("screen")) { rc += self->view_pos(*c.pview()) + c.pview()->client_screen_pos(); ppx = true;   }
    else if (relto == CHARS("content")) { rc += self->doc_pos(*c.pview()) - self->parent->doc_pos(*c.pview()) + self->parent->scroll_pos(); }
    else if (relto == CHARS("container")) { html::element *bp = self->layout_parent(*c.pview()); if (bp) rc += self->doc_pos(*c.pview()) - bp->doc_pos(*c.pview()); }
    else if (relto == CHARS("inner")) goto WIDTHS;
    else if (relto == CHARS("padding")) { inner = self->padding_box(*c.pview()); goto WIDTHS; }
    else if (relto == CHARS("border")) { inner = self->border_box(*c.pview()); goto WIDTHS; }
    else if (relto == CHARS("margin")) { inner = self->margin_box(*c.pview()); goto WIDTHS; }
    else if (relto == CHARS("client")) { inner = self->client_box(*c.pview()); goto WIDTHS; }

    return c.box_part(what(),rc, as_ppx.val(ppx) ? xcontext::AS_PPX: xcontext::AS_PX);

  WIDTHS:

    if (!as_ppx.val(ppx)) {
      rc = c.pview()->ppx_to_dip(rc);
      inner = c.pview()->ppx_to_dip(inner);
    }

    if (what == CHARS("left")) { return c.val(inner.left() - rc.left()); }
    if (what == CHARS("right")) { return c.val(rc.right() - inner.right()); }
    if (what == CHARS("top")) { return c.val(inner.top() - rc.top()); }
    if (what == CHARS("bottom")) { return c.val(rc.bottom() - inner.bottom()); }

    int sides[4] = { inner.left() - rc.left(),
                     inner.top() - rc.top(),
                     rc.right() - inner.right(),
                     rc.bottom() - inner.bottom() };

    return c.val(items_of(sides));
  }

  tool::value state_value(xcontext& c, helement self) {
    tool::value v;
    c.pview()->get_element_native_value(self, v, false);
    return v;
  }

  void state_set_value(xcontext& c, helement self, tool::value v) {
    c.pview()->set_element_native_value(self, v, false);
  }

  bool state_hidden(xcontext& c, helement self) {
    return !self->is_visible(*c.pview());
  }

  bool state_content_editable(xcontext& c, helement self) {
    return self->state.content_editable() && !self->state.content_non_editable();
  }

  bool state_reconciliation(xcontext& c, helement self) {
    return self->allow_reconciliation();
  }

  bool state_set_reconciliation(xcontext& c, helement self, tristate_v v) {
    self->allow_reconciliation(v);
    return true;
  }

  uint state_occluded(xcontext& c, helement self) {

    if (!self->is_layout_valid())
      self->commit_measure(*c.pview()); //too heavy pv->commit_update();

    rect rc = self->border_box(*c.pview(), element::TO_VIEW);
    rect src = rc;
    for (element* pe = self->layout_parent(*c.pview()); pe; pe = pe->layout_parent(*c.pview()))
    {
      if (!pe->get_style(*c.pview())->clip_overflow())
        continue;
      rect crc = pe->border_box(*c.pview(), element::TO_VIEW);
      src &= crc;
    }
    if (rc == src) return 0;
    if (src.empty()) return 0xf;
    uint r = 0; // visible in full
    if( rc.left() != src.left() ) r |= 0x1;
    if (rc.top() != src.top()) r |= 0x2;
    if (rc.right() != src.right()) r |= 0x4;
    if (rc.bottom() != src.bottom()) r |= 0x8;
    return r;
  }

  hvalue state_pixelsIn(xcontext& c, helement pe, ustring len, string direction)
  {
    html::size_v vsz;
    html::from_string(vsz, len());

    if (vsz.is_defined()) {
      html::size_v sz = vsz;
      double px = direction == CHARS("horizontal")
        ? html::dips(*c.pview(), pe, sz, pe->dim()).width_f()
        : html::dips(*c.pview(), pe, sz, pe->dim()).height_f();
      return c.val(px);
    }
    return hvalue();
  }

  float state_dipsIn(xcontext& c, helement pe, int len, string direction)
  {
     gool::size sz = len;
     return c.pview()->ppx_to_dip(sz).x;
     //return c.val(px);
  }

  array<float> state_mapLocalToWindow(xcontext& c, helement pe, float x, float y) {

    if (!pe) return {};

    point pos = c.pview()->dip_to_ppx(pointf(x, y));
    pos = pe->transform_local_to_view(*c.pview(), pos);
    pointf fpos = c.pview()->ppx_to_dip(pos);

    return { fpos.x,fpos.y };
  }

  array<float> state_mapWindowToLocal(xcontext& c, helement pe, float x, float y) {

    if (!pe) return {};

    point pos = c.pview()->dip_to_ppx(pointf(x, y));
    pos = pe->transform_view_to_local(*c.pview(), pos);
    pointf fpos = c.pview()->ppx_to_dip(pos);

    return { fpos.x,fpos.y };
  }



  JSOM_PASSPORT_BEGIN(ElementState_def, html::element)
    JSOM_CONST_STR("[Symbol.toStringTag]", "ElementState", JS_PROP_CONFIGURABLE),

    JSOM_PROP_DEF("link", state_link, state_set_link),
    JSOM_PROP_DEF("hover", state_hover, state_set_hover),
    JSOM_PROP_DEF("active", state_active, state_set_active),
    JSOM_PROP_DEF("focus", state_focus, state_set_focus),
    JSOM_RO_PROP_DEF("ownsfocus", state_ownsfocus),
    JSOM_PROP_DEF("visited", state_visited, state_set_visited),
    JSOM_PROP_DEF("current", state_current, state_set_current),
    JSOM_PROP_DEF("checked", state_checked, state_set_checked),
    JSOM_PROP_DEF("unchecked", state_unchecked, state_set_unchecked),
    JSOM_PROP_DEF("selected", state_selected, state_set_selected),
    JSOM_PROP_DEF("disabled", state_disabled, state_set_disabled),
    JSOM_PROP_DEF("readonly", state_readonly, state_set_readonly),
    JSOM_PROP_DEF("expanded", state_expanded, state_set_expanded),
    JSOM_PROP_DEF("collapsed", state_collapsed, state_set_collapsed),
    JSOM_PROP_DEF("incomplete", state_incomplete, state_set_incomplete),
    JSOM_PROP_DEF("invalid", state_invalid, state_set_invalid),
    JSOM_RO_PROP_DEF("animating", state_animating),
    JSOM_PROP_DEF("focusable", state_focusable, state_set_focusable),
    JSOM_PROP_DEF("anchor", state_anchor, state_set_anchor),
    JSOM_PROP_DEF("synthetic", state_synthetic, state_set_synthetic),
    JSOM_RO_PROP_DEF("ownspopup", state_ownspopup),
    JSOM_PROP_DEF("tabfocus", state_tabfocus, state_set_tabfocus),
    JSOM_RO_PROP_DEF("empty", state_empty),
    JSOM_PROP_DEF("busy", state_busy, state_set_busy),
    JSOM_PROP_DEF("dragover", state_dragover, state_set_dragover),
    JSOM_PROP_DEF("droptarget", state_droptarget, state_set_droptarget),
    JSOM_PROP_DEF("moving", state_moving, state_set_moving),
    JSOM_PROP_DEF("copying", state_copying, state_set_copying),
    JSOM_PROP_DEF("dragsource", state_dragsource, state_set_dragsource),
    JSOM_PROP_DEF("pressed", state_pressed, state_set_pressed),
    JSOM_PROP_DEF("popup", state_popup, state_set_popup),
    JSOM_PROP_DEF("ready", state_ready, state_set_ready),
    JSOM_RO_PROP_DEF("isltr", state_isltr),
    JSOM_RO_PROP_DEF("isrtl", state_isrtl),
    JSOM_RO_PROP_DEF("occluded", state_occluded),

    JSOM_RO_PROP_DEF("contenteditable", state_content_editable),

    JSOM_PROP_DEF("reconciliation", state_reconciliation, state_set_reconciliation),
/*
    VP_METHOD_ENTRY_X("hoverLeft", states_hoverLeft, 0),
    VP_METHOD_ENTRY_X("hoverRight", states_hoverRight, 0),
    VP_METHOD_ENTRY_X("hoverTop", states_hoverTop, 0),
    VP_METHOD_ENTRY_X("hoverBottom", states_hoverBottom, 0),

    VP_METHOD_ENTRY_X("value", states_value, states_set_value),
    VP_METHOD_ENTRY_X("screen", states_screen, 0),
    VP_METHOD_ENTRY_X("awaitsDraw", states_awaitsDraw, states_set_awaitsDraw),
    VP_METHOD_ENTRY_X("delayedLayout", states_delayedLayout, states_set_delayedLayout),
    VP_METHOD_ENTRY_X("allowReconciliation", states_allowReconciliation, states_set_allowReconciliation),

    VP_METHOD_ENTRY_X("flowType", states_flowType, 0), */

    JSOM_FUNC_DEF("box", element_box),
    JSOM_FUNC_DEF("mapWindowToLocal", state_mapWindowToLocal),
    JSOM_FUNC_DEF("mapLocalToWindow", state_mapLocalToWindow),

    JSOM_PROP_DEF("value", state_value, state_set_value),

    JSOM_FUNC_DEF("contentWidths", content_widths),
    JSOM_FUNC_DEF("contentHeight", content_height),
    
    JSOM_FUNC_DEF("pixelsIn", state_pixelsIn),
    JSOM_FUNC_DEF("dipsIn", state_dipsIn),
    
    JSOM_RO_PROP_DEF("hidden", state_hidden),
    //JSOM_RO_PROP_DEF("visible", state_visible),

    JSOM_FUNC_DEF("capture", set_capture),
    JSOM_FUNC_DEF("requestDelayedMeasure", request_delayed_measure),



  JSOM_PASSPORT_END


  void init_ElementState_class(context& c)
  {
    JS_NewClassID(&ElementState_class_id);

    static JSClassDef ElementState_class = {
      "ElementState",
      [](JSRuntime *rt, JSValue val)
      {
        html::element* pe = (html::element*)JS_GetOpaque(val,ElementState_class_id);  //object_of<html::element>(val);
        if (pe)
          pe->release();
      }
    };

    JS_NewClass(JS_GetRuntime(c), ElementState_class_id, &ElementState_class);
    JSValue states_proto = JS_NewObject(c);

    auto list = ElementState_def();
    JS_SetPropertyFunctionList(c, states_proto, list.start, list.length);

    auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
    {
      JSValue obj = JS_UNDEFINED;
      JSValue proto;
      /* using new_target to get the prototype is necessary when the class is extended. */
      proto = JS_GetPropertyStr(ctx, new_target, "prototype");
      if (JS_IsException(proto))
        goto fail;
      obj = JS_NewObjectProtoClass(ctx, proto, ElementState_class_id);
      JS_FreeValue(ctx, proto);
      if (JS_IsException(obj))
        goto fail;
      JS_SetOpaque(obj, 0);
      return obj;
    fail:
      //js_free(ctx, s);
      JS_FreeValue(ctx, obj);
      return JS_EXCEPTION;
    };

    hvalue states_class = JS_NewCFunction2(c, ctor, "ElementState", 2, JS_CFUNC_constructor, 0);

    hvalue element_class = c.get_prop<hvalue>("Element", c.global());
    assert(element_class);
        
    JS_DefinePropertyValueStr(c, element_class, "State", JS_DupValue(c, states_class), JS_PROP_CONFIGURABLE);

    //auto static_list = ElementState_static_def();
    //JS_SetPropertyFunctionList(c, element_class, static_list.start, static_list.length);

    JS_SetConstructor(c, states_class, states_proto);
    JS_SetClassProto(c, ElementState_class_id, states_proto);
  }

}
