#pragma once

#ifndef __xdomjs_xselection_h__
#define __xdomjs_xselection_h__

#include "xcontext.h"
#include "xconv.h"


namespace qjs
{

  typedef html::selection_ctx selection;

  typedef tool::handle<selection> hselection;
  
  extern JSClassID Selection_class_id;

  void init_Selection_class(xcontext& c);

  template <> struct conv<hselection>
  {
    static hselection unwrap(JSContext * ctx, JSValueConst v)
    {
      hselection pr = (selection*)JS_GetOpaque(v, Selection_class_id);
      return pr;
    }

    static JSValue wrap(JSContext * ctx, hselection pr) noexcept
    {
      if (!pr)
        return JS_NULL;
      JSValue selection_obj = JS_NewObjectClass(ctx, Selection_class_id);
      pr->add_ref();
      JS_SetOpaque(selection_obj, pr.ptr());
      return selection_obj;
    }
    static bool isa(JSContext * ctx, JSValueConst v) { return JS_GetOpaque(v, Selection_class_id) != NULL; }
  };

}

#endif