
#include "xselection.h"
#include "xrange.h"
#include "xdom.h"
#include "xom.h"

namespace qjs
{
  using namespace html;

  bool selection_isCollapsed(xcontext& c, hselection selection)
  {
    return selection->anchor == selection->caret;
  }

  helement selection_commonAncestorContainer(xcontext& c, hselection selection) {
    if(selection->anchor.valid() && selection->caret.valid())
      return node::find_common_parent(selection->anchor.node, selection->caret.node);
    return helement();
  }

  hnode selection_anchorNode(xcontext& c, hselection selection) {
    return selection->anchor.node;
  }

  int selection_anchorOffset(xcontext& c, hselection selection) {
    return selection->anchor.linear_pos();
  }

  hnode selection_focusNode(xcontext& c, hselection selection) {
    return selection->caret.node;
  }

  int selection_focusOffset(xcontext& c, hselection selection) {
    return selection->caret.linear_pos();
  }

  int selection_rangeCount(xcontext& c, hselection selection) {
    return selection->get_range_count(*c.pview());
  }

  string selection_type(xcontext& c, hselection selection) {
    switch (selection->get_selection_type(*c.pview())) {
      default:
      case html::NO_SELECTION: return string();
      case html::ONLY_CARET: return CHARS("Caret");
      case html::TEXT_RANGE: return CHARS("Selection");
      case html::SINGLE_BLOCK: return CHARS("Element");
      case html::CELL_RANGE: return CHARS("TableCells");
    }
  }

  enum WHAT {
    Caret,
    Anchor,
    Start,
    End
  };
  
  bool selection_collapse_to(xcontext& c, hselection selection, WHAT to) {
    if (!selection->caret.valid()) return false;
    switch (to) {
      case Caret:  selection->set_caret_to(*c.pview(), selection->caret, false); break;
      case Anchor: selection->set_caret_to(*c.pview(), selection->anchor, false); break;
      case Start:  selection->set_caret_to(*c.pview(), selection->anchor < selection->caret ? selection->anchor : selection->caret, false); break;
      case End:    selection->set_caret_to(*c.pview(), selection->anchor >= selection->caret ? selection->anchor : selection->caret, false); break;
      default: return false;
    }
    return true;
  }

  bool selection_collapse(xcontext& c, hselection selection) {
    return selection_collapse_to(c, selection, Caret);
  }

  ustring selection_text(xcontext& c, hselection selection) {
    return selection->get_selection_text(*c.pview());
  }

  bool selection_collapseToEnd(xcontext& c, hselection selection) {
    return selection_collapse_to(c, selection, End);
  }

  bool selection_collapseToStart(xcontext& c, hselection selection) {
    return selection_collapse_to(c, selection, Start);
  }

  bool selection_containsNode(xcontext& c, hselection selection, hnode n) {
    if (!n) return false;
    return selection->is_on_selection(*c.pview(), n->start_pos()) &&
           selection->is_on_selection(*c.pview(), n->end_pos());
  }
  bool selection_empty(xcontext& c, hselection selection) {
    selection->select(*c.pview(),html::bookmark(), html::bookmark());
    return true;
  }

  bool selection_extend(xcontext& c, hselection selection, hnode n, uint offset) {
    if (!n) return false;
    bookmark caret(n, int(offset), false);
    selection->select(*c.pview(), caret, selection->anchor);
    return true;
  }

  hrange selection_getRangeAt(xcontext& c, hselection selection, uint n) {
    auto pa = selection->get_range(*c.pview(),n);
    hrange hr = new qjs::range();
    hr->start = pa.first;
    hr->end = pa.second;
    return hr;
  }

  bool selection_selectNode(xcontext& c, hselection selection, hnode n) {
    if (!n) return false;
    selection->select(*c.pview(), n->end_pos(), n->start_pos());
    return true;
  }

  bool selection_setBaseAndExtent(xcontext& c, hselection selection, hnode an, uint aoffset, hnode cn, uint coffset) {
    bookmark caret(cn, int(coffset), false); caret.normalize();
    bookmark anchor(an, int(aoffset), false); anchor.normalize();
    selection->select(*c.pview(), caret, anchor);
    return true;
  }

  JSClassID Selection_class_id;

  JSOM_PASSPORT_BEGIN(Selection_def, qjs::selection)
    JSOM_CONST_STR("[Symbol.toStringTag]", "Selection", JS_PROP_CONFIGURABLE),
    JSOM_RO_PROP_DEF("isCollapsed", selection_isCollapsed),
    JSOM_RO_PROP_DEF("commonAncestorContainer", selection_commonAncestorContainer),
    JSOM_RO_PROP_DEF("anchorNode", selection_anchorNode),
    JSOM_RO_PROP_DEF("anchorOffset", selection_anchorOffset),
    JSOM_RO_PROP_DEF("focusNode", selection_focusNode),
    JSOM_RO_PROP_DEF("focusOffset", selection_focusOffset),
    JSOM_RO_PROP_DEF("rangeCount", selection_rangeCount),
    JSOM_RO_PROP_DEF("type", selection_type),

    JSOM_FUNC_DEF("collapse", selection_collapse),
    JSOM_FUNC_DEF("collapseToEnd", selection_collapseToEnd),
    JSOM_FUNC_DEF("collapseToStart", selection_collapseToStart),

    JSOM_FUNC_DEF("containsNode", selection_containsNode),
    JSOM_FUNC_DEF("empty", selection_empty),
    JSOM_FUNC_DEF("extend", selection_extend),
    JSOM_FUNC_DEF("getRangeAt", selection_getRangeAt),

    JSOM_FUNC_DEF("selectNodeContent", selection_selectNode),
    JSOM_FUNC_DEF("selectAllChildren", selection_selectNode),
    JSOM_FUNC_DEF("setBaseAndExtent", selection_setBaseAndExtent),

    JSOM_FUNC_DEF("setPosition", selection_collapse),
    JSOM_FUNC_DEF("toString", selection_text),

  JSOM_PASSPORT_END

    void init_Selection_class(xcontext& c)
    {
      JS_NewClassID(&Selection_class_id);

      static JSClassDef Selection_class = {
        "Selection",
        [](JSRuntime *rt, JSValue val)
        {
          selection* pe = (selection*)JS_GetOpaque(val,Selection_class_id);  //object_of<html::element>(val);
          if (pe) pe->release();
        }
      };

      JS_NewClass(JS_GetRuntime(c), Selection_class_id, &Selection_class);
      JSValue selection_proto = JS_NewObject(c);

      auto list = Selection_def();
      JS_SetPropertyFunctionList(c, selection_proto, list.start, list.length);

      auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
      {
        return JS_EXCEPTION;
      };

      hvalue selection_class = JS_NewCFunction2(c, ctor, "Selection", 2, JS_CFUNC_constructor, 0);
      JS_DefinePropertyValueStr(c, c.global(), "Selection", JS_DupValue(c, selection_class), JS_PROP_CONFIGURABLE);

      hvalue element_class = c.get_prop<hvalue>("Element", c.global());
      assert(element_class);
      JS_DefinePropertyValueStr(c, element_class, "Selection", JS_DupValue(c, element_class), JS_PROP_CONFIGURABLE);

      JS_SetConstructor(c, selection_class, selection_proto);
      JS_SetClassProto(c, Selection_class_id, selection_proto);
    }

}