#pragma once

#include "xdom.h"
#include "xom.h"
#include "xcontext.h"
#include "html/html-dom.h"

typedef tool::array<qjs::hvalue> vnode_array;

namespace qjs {

  using namespace html;
  using namespace tool;

  JSValue reactor_jsx(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv);

  bool is_vnode(xcontext& ctx, JSValueConst obj);
  string vnode_tagname(xcontext& ctx, JSValueConst obj);
  hvalue vnode_props(xcontext& ctx, JSValueConst obj);

  struct element_creator_ctx
  {
    xcontext& c;
    hvalue tuple; // velement
    html::helement b;
    html::helement parent;

    array<html::hnode>    kids;
    html::attribute_bag   atts;
    html::attribute_bag_v states;
    html::dictionary<ustring,hvalue> ehandlers;

    element_creator_ctx(const element_creator_ctx&) = delete;
    element_creator_ctx(html::context& ctx, hvalue velement, html::hnode parent);

    html::helement make(bool prepend = false);

    void make_attributes(helement b = nullptr);

    void crack_attribute(chars name, hvalue val);
    void crack_child(uint n, hvalue val);

  };
    
}

// the morpher interafaces

namespace html
{
  using namespace tool;
  using namespace qjs;

  extern tool::ustring node_key(html::context&, node* pn);
  extern node::NODE_TYPE node_type(html::context&, node* pn);
  extern uint node_tag(html::context&, node* pn);

  extern ustring_chars node_text(html::context& pv, node* pn);
  extern uint          node_size(html::context&, node* pn);
  extern node*         node_child(html::context& pv, node* pn, uint i);
  extern hnode         node_new_to_old(html::context& pv, hnode nn, hnode parent);
  extern void          node_remove_child(html::context&, node* pn, uint i);
  extern node*         node_for_children_update(html::context&, node* pn);
  extern const attribute_bag& node_atts(html::context&, node* pn);
  extern   bool          node_states(html::context&, node* pn, attribute_bag_v&);
  extern node*         node_element_expand(html::context& pv, node* new_node, hnode& old_node, hnode parent);
  extern void          update_element_atts_states(html::context& pv, element* old_node, node* new_node, bool is_root);
  extern uint64        node_factory(html::context& pv, node* pn);
  extern bool          node_equal(html::context& pv, hnode a, hnode b);

  inline node::NODE_TYPE node_type(html::context& hc, qjs::hvalue pn) {
    qjs::xcontext& c = static_cast<qjs::xcontext&>(hc);
    if (qjs::is_vnode(c,pn)) return html::node::ELEMENT;
    return html::node::TEXT;
  }

  inline uint node_tag(html::context& hc, qjs::hvalue pn) {
    qjs::xcontext& c = static_cast<qjs::xcontext&>(hc);
    if (qjs::is_vnode(c, pn)) {
       string tag = vnode_tagname(c,pn);
      return html::tag::symbol(tag, true);
    }
    return 0;
  }
  
  tool::ustring node_key(html::context& hc, qjs::hvalue pn);
  ustring_chars node_text(html::context& pv, qjs::hvalue pn);
  uint          node_size(html::context& pv, qjs::hvalue pn);
  qjs::hvalue   node_child(html::context& pv, qjs::hvalue &pn, uint i);
  void          node_remove_child(html::context& pv, qjs::hvalue pn, uint i);
  attribute_bag node_atts(html::context& pv, qjs::hvalue pn);
  bool          node_states(html::context& pv, qjs::hvalue pn, attribute_bag_v& states);
  uint64        node_factory(html::context& pv, qjs::hvalue pn);

  qjs::hvalue   node_element_expand(html::context& ctx, qjs::hvalue new_node, html::hnode& old_node, html::hnode parent);
  hnode         node_new_to_old(html::context& hc, qjs::hvalue nn, html::hnode parent);
  //bool          node_new_to_old_ex(html::context& hc, qjs::hvalue& vdom_parent, uint child_index, html::hnode dom_parent, hnode& dom_child);
  bool          node_new_to_old_ex(html::context& hc, vnode_array& list, uint list_index, html::hnode dom_parent, hnode& dom_child);

  inline qjs::hvalue node_for_children_update(html::context& pv, qjs::hvalue pn) { return pn; }

  void          update_element_atts_states(html::context& hc, element* pel, qjs::hvalue pn, bool is_root);
  bool          node_equal(html::context& hc, qjs::hvalue a, html::hnode b);


}

