#include "xdom.h"
#include "xom.h"
#include "xcontext.h"
#include "xview.h"
#include "xreactor.h"

#include "dom-patch.h"

namespace html {
  vnode_array vnode_children(html::context& hc, qjs::hvalue vnode, html::hnode parent);
}

namespace qjs {

  using namespace html;
  using namespace tool;

  bool is_vnode(xcontext& ctx, JSValueConst obj) {
    JSValue *parr = 0;
    uint32_t count = 0;
    if (!JS_GetFastArray(ctx, obj, &parr, &count))
      return false;
    if (count != 3) return false;

    //hvalue proto = JS_GetPrototype(ctx, obj);
    //if (proto != context::inst(ctx).vnode_proto)
    //  return false;

    if (JS_GetOpaque(obj, 2) != (void*)0xAFED) 
      return false;

    if ((parr[1] != JS_NULL) && !JS_IsObject(parr[1])) return false;
    if ((parr[2] != JS_NULL) && !JS_IsArray(ctx,parr[2])) return false;
    return true;
  }

  hvalue vnode_tag(xcontext& ctx, JSValueConst obj) {
    JSValue *parr = 0;
    uint32_t count = 0;
    if (!JS_GetFastArray(ctx, obj, &parr, &count))
      return JS_UNINITIALIZED;
    return JS_DupValue(ctx,parr[0]);
  }

  string vnode_tagname(xcontext& ctx, JSValueConst obj) {
    JSValue *parr = 0;
    uint32_t count = 0;
    if (!JS_GetFastArray(ctx, obj, &parr, &count))
      return string();
    return ctx.get<string>(parr[0]);
  }

  hvalue vnode_props(xcontext& ctx, JSValueConst obj) {
    JSValue *parr = 0;
    uint32_t count = 0;
    if (JS_GetFastArray(ctx, obj, &parr, &count)) {
      if (JS_IsObject(parr[1]))
        return JS_DupValue(ctx,parr[1]);
    }
    return JS_UNINITIALIZED;
  }

  hvalue vnode_kids(xcontext& ctx, JSValueConst obj) {
    JSValue *parr = 0;
    uint32_t count = 0;
    if (JS_GetFastArray(ctx, obj, &parr, &count)) {
      if (JS_IsArray(ctx,parr[2]))
        return JS_DupValue(ctx,parr[2]);
    }
    return JS_UNINITIALIZED;
  }

  void vnode_set_props(xcontext& ctx, JSValueConst obj, hvalue props) {
    JSValue *parr = 0;
    uint32_t count = 0;
    if (JS_GetFastArray(ctx, obj, &parr, &count) && count > 2) {
      JS_FreeValue(ctx, parr[1]);
      parr[1] = props.tearoff();
    }
  }


  /*void vnode_set_kids(xcontext& ctx, JSValueConst obj, slice<hvalue> elements) {
    JSValue *parr = 0;
    uint32_t count = 0;
    if (JS_GetFastArray(ctx, obj, &parr, &count) && count > 2) {
      JSValue vkids = JS_NewFastArray(ctx, elements.size(), (JSValueConst*)elements.start);
      JS_FreeValue(ctx, parr[2]);
      parr[2] = vkids;
    }
  }*/

  bool is_fragment(xcontext& c, hvalue tuple) {
    tool::string tagname = vnode_tagname(c, tuple);
    //if (tagname.length() == 0)
    //  throw qjs::om::type_error("undefined tag name");
    return tagname == CHARS("") || tagname == CHARS("fragment");
  }


#define VNODE_OPAQUE_MARKER ((void*)0xAFED)

  JSValue reactor_jsx(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv)
  {
    context& c = context::inst(ctx);
    hvalue vnode = JS_NewFastArray(ctx, argc, argv);
    JS_SetOpaque(vnode, VNODE_OPAQUE_MARKER);
#if 0
    hvalue kids = vnode_kids(c, vnode);
    array<hvalue> expanded;
    uint expansions = 0;
    // flattens kids collection so if a kid is an array of vnodes content of the array gets spliced inplace
    c.each_item(kids, [&](uint i, hvalue item) {
      if (flatten(c, item, expanded, expansions))
        expanded.push(item);
    });
    if (expansions) {
      kids.clear();
      vnode_set_kids(c, vnode, expanded());
    }
#endif
    return vnode.tearoff();
  }

  hvalue rx_make_fragment(xcontext& c, hvalue kids) {
    hvalue elements[3] = { c.val(CHARS("fragment")),JS_NULL, kids };
    hvalue vnode = JS_NewFastArray(c, 3, (JSValueConst*) elements);
    //JS_SetPrototype(c, vnode, c.vnode_proto);
    JS_SetOpaque(vnode, VNODE_OPAQUE_MARKER);
    return vnode;
  }
  
  bool merge_props(xcontext& c, hvalue target, hvalue source,uint& changes)
  {
    auto values_equal = [&](hvalue a, hvalue b) -> bool {
      if (a == b)
        return true;
      else if (c.is_string(target) && c.is_string(source)) {
        if (c.get<string>(target) == c.get<string>(source))
          return true; // doesn't need update
      }
      return false;
    };

    if (target == source)
      return true; // doesn't need update
    if (c.is_array(target) && c.is_array(source)) {
      c.each_item(source, [&](uint idx, hvalue val) {
        hvalue tval = c.get_item<hvalue>(idx, target);
        //if (merge_props(c, tval, val, changes)) - WRONG
        if(values_equal(tval, val))
          return;
        c.set_item(idx, target, val);
        ++changes;
      });
    }
    else if (c.is_object(target) && c.is_object(source)) {
      c.each_key(source, [&](JSAtom key, hvalue val) {
        hvalue tval = c.get_prop<hvalue>(key, target);
        //if (merge_props(c, tval, val, changes)) - WRONG
        if (values_equal(tval, val))
          return;
        c.set_prop(key, target, val);
        ++changes;
      });
      return true; // doesn't need update
    }
    else if (c.is_string(target) && c.is_string(source)) {
      if(c.get<string>(target) == c.get<string>(source)) 
        return true; // doesn't need update
    }
    ++changes;
    return false;
  }
  
  helement rx_component_update(xcontext& c, helement el, hvalue props)
  {
    hvalue inst = c.val(el);
    //if (JS_CopyDataProperties(c, inst, props, JS_NULL, TRUE)) // Object.assign(inst,newinst)
    //{
    //  assert(false);
    //}
    if (c.is_object(props)) {
      uint changes = 0;
      merge_props(c, inst, props, changes);
      if (!changes)
        return el; // nothing has changed - nothing to do
    }
    html::event_behavior evt(el, el, COMPONENT_UPDATE, 0);
    evt.is_bubbling = false;
    c.pview()->post_behavior_event(evt, true);
    return el;
  }

  helement rx_patch(xcontext &c, helement el, hvalue what, tristate_v only_children = tristate_v());

  bool rx_do_component_update(xcontext& c, helement el)
  {
    hvalue obj = c.val(el);
    hvalue render = c.get_prop<hvalue>(c.known_atoms().render, obj);
    if (JS_IsFunction(c, render)) {
      try {
        hvalue vnode;
        //NOTE: we should not call render with (props,kids) on componentUpdate() 
        //      to distinguish render()-as-result-of-componentUpdate
        //      from render()-as-result-of-parent-rendering
        //hvalue vprops = c.get_prop<hvalue>(c.known_atoms().Symbol_props, obj);
        //hvalue vkids = c.get_prop<hvalue>(c.known_atoms().Symbol_kids, obj);
        c.call(vnode, render, obj /*, vprops, vkids*/);
        if (is_vnode(c, vnode))
        {
          rx_patch(c, el, vnode);
          return true;
        }
      }
      catch (qjs::exception) {
        c.report_exception();
      }
    }
    return false;
  }

  bool rx_do_component_error(xcontext& c, helement el, tool::value err, helement context)
  {
    hvalue obj = c.val(el);
    hvalue catcher = c.get_prop<hvalue>(c.known_atoms().componentDidCatch, obj);
    if (c.is_function(catcher)) {
      try {
        hvalue retval;
        c.call(retval, catcher, obj , err, context);
        return retval != JS_FALSE;
      }
      catch (qjs::exception) {
        c.report_exception();
      }
      return true;
    }
    return false;
  }


  element_creator_ctx::element_creator_ctx(html::context& ctx, hvalue velement, html::hnode parent)
    : c(static_cast<xcontext&>(ctx))
  {
    this->tuple = velement;
    this->parent = parent.ptr_of<html::element>();
  }

  void element_creator_ctx::crack_attribute(chars name, hvalue val) {
    if (name == CHARS("value"))
      states.set(name, c.get<value>(val));
    else if (name.starts_with(CHARS("state-")))
      states.set(name(6), c.get<value>(val));
    else if (name.starts_with(CHARS("on")) && JS_IsFunction(c, val))
      ehandlers[u8::cvt(name(2)).to_lower()] = val;
    else if (c.is_undefined(val) || c.is_null(val))
      /*skip, do not add undefined|null attributes*/; 
    else if(c.is_string(val) || c.is_number(val) || c.is_bool(val) )
      atts.set(name, c.get<ustring>(val));
    else {
      tool::string attrname = name;
      tool::string tagname = vnode_tagname(c, tuple);
      tool::string classname = c.value_type(val);
      c.pview()->debug_printf(html::OT_JS, html::OS_WARNING, "JSX:invalid property value of type %s for attribute %s of %s element\n",
        classname.c_str(),
        attrname.c_str(),
        tagname.c_str());
      atts.set(name, c.get<ustring>(val));
    }
  }

  bool is_fragment(xcontext& c, hvalue tuple);

  void element_creator_ctx::crack_child(uint index, hvalue val) {
    //if (!c.get<bool>(val))
    //  return; // falsy value does nothing
    if (is_vnode(c, val)) {

      if (is_fragment(c, val)) {
        val = vnode_kids(c, val);
        if (JS_IsArray(c, val))
          c.each_item(val, [&](uint n, hvalue v) {
            crack_child(n, v);
          });
        return;
      }

      element_creator_ctx ectx(c, val, b);
      html::helement child = ectx.make();
      if(child)
        kids.push(child);
      else
        kids.push(ectx.kids());
    }
    else if (JS_IsArray(c, val)) {
      c.each_item(val, [&](uint n, hvalue v) {
        crack_child(n, v);
      });
    }
    else if (val == JS_NULL || val == JS_UNDEFINED || val == JS_FALSE)
      ; // falsy value does nothing
    else
      kids.push(new html::text( c.get<ustring>(val)));
  }

  html::helement element_creator_ctx::make(bool prepend)
  {
    html::hnode hn;

    hvalue otuple = tuple;

    tuple = node_element_expand(c, tuple, hn, parent);

    if (!is_vnode(c,tuple))
      return nullptr;

    if (!hn) {
      if (is_fragment(c, tuple)) {
        b = parent;
        c.pview()->mutator_rq(b, html::CONTENT_ADDED);
      } else
        b = new html::element(html::tag::symbol(vnode_tagname(c, tuple)));
    }
    else {
      b = hn.ptr_of<html::element>();
    }


    if (b != parent) {
      hvalue obj = c.val(b);
      c.set_prop(c.known_atoms().Symbol_factory, obj, vnode_tag(c, otuple));
      c.set_prop(c.known_atoms().Symbol_props, obj, vnode_props(c,otuple));
      //c.set_prop(c.known_atoms().Symbol_kids, obj, vnode_kids(c, otuple));
    }

    if(b)
      make_attributes();

    vnode_array list = vnode_children(c, tuple, b);
    uint index = 0;
    for (auto kid : list) {
      crack_child(index, kid);
    }
    /*if (hvalue vkids = vnode_kids(c, tuple))
    {
      c.each_item(vkids, [&](uint index, hvalue kid){
        crack_child(index,kid);
      });
    }*/

    if (b) {
      if (prepend)
        b->insert_nodes(0, kids());
      else
        b->append_nodes(kids());
    }

    return b == parent? nullptr : b;
  }

  void element_creator_ctx::make_attributes(helement el)
  {
    if (el) {
      this->b = el;
      if (!is_vnode(c, tuple))
        return;
    }
    if (hvalue props = vnode_props(c, tuple)) {
      c.each_prop(props, [&](chars name, hvalue val) {
        crack_attribute(name, val);
      });
    }
    //if (atts.length()) - WRONG, we need to pass it anyway to remove non-existent
    b->set_attributes(atts, c.pview());
    //if (states.length()) ditto
    b->set_states(states,c.pview());
    for (int n = 0; n < ehandlers.size(); ++n) {
      auto subs = b->get_prop_subscription(ehandlers.key(n), true);
      if (subs)
        subs->fcn = ehandlers.value(n);
    }
  }

  
  bool is_reactor_class(xcontext& c, JSValue v, hvalue& proto, hvalue& render, hvalue& thismethod) {
    if (!JS_IsFunction(c, v)) return false;
    proto = JS_GetProperty(c, v, qjs::JS_ATOM_prototype);
    render = JS_GetProperty(c,proto, c.known_atoms().render);
    thismethod = JS_GetProperty(c, proto, JS_ATOM_this);
    return JS_IsFunction(c, render);
  }
    

  struct vnode_protector {
    vnode_protector(view* pv, qjs::hvalue &n) {}
  };

  typedef html::morph_t<qjs::hvalue, vnode_protector> vnode_morph;

  helement rx_patch(xcontext& c, helement el, hvalue what, tristate_v only_children)
  {
    auto cel = el->logical_container();
    if (!cel) qjs::om::type_error("operation disabled");
    if (cel->is_connected()) qjs::om::type_error("element is not in DOM");
    try
    {
      html::morph_options opts;

      if (!is_vnode(c, what) && c.is_array(what)) {
        what = rx_make_fragment(c, what);
        opts.children_only = true;
      }
      else {
        opts.children_only = only_children.val(0);
      }

      hvalue original_vprops = c.get_prop<hvalue>(c.known_atoms().Symbol_props, el->obj);
      if (c.is_object(original_vprops)) {
          hvalue va_id = c.get_prop<hvalue>(c.known_atoms().id, original_vprops);
          hvalue va_class = c.get_prop<hvalue>(c.known_atoms().klass, original_vprops);
          hvalue va_name = c.get_prop<hvalue>(c.known_atoms().name, original_vprops);
          hvalue va_type = c.get_prop<hvalue>(c.known_atoms().type, original_vprops);
          hvalue va_key = c.get_prop<hvalue>(c.known_atoms().key, original_vprops);
          if (va_id.is_defined() || va_class.is_defined() || va_name.is_defined() || va_type.is_defined() || va_key.is_defined())
          {
            hvalue new_vprops = JS_NewObjectProto(c, JS_NULL);
            //JS_CopyDataProperties(c, new_vprops, existing_vprops, JS_NULL, TRUE); // Object.assign(inst,newinst) WRONG!! can be something
            hvalue vprops = vnode_props(c, what);
            if (c.is_object(vprops))
               JS_CopyDataProperties(c, new_vprops, vprops, JS_NULL, TRUE); // Object.assign(inst,newinst)          like rowstart
            if (va_id.is_defined()) c.set_prop(c.known_atoms().id, new_vprops, va_id.tearoff());
            if (va_name.is_defined()) c.set_prop(c.known_atoms().name, new_vprops, va_name.tearoff());
            if (va_type.is_defined()) c.set_prop(c.known_atoms().type, new_vprops, va_type.tearoff());
            if (va_key.is_defined()) c.set_prop(c.known_atoms().key, new_vprops, va_key.tearoff());
            if (va_class.is_defined()) {
              ustring p_class = c.get_prop<ustring>(c.known_atoms().klass, original_vprops);
              if (p_class.is_defined()) {
                ustring n_class = c.get<ustring>(va_class);
                c.set_prop(c.known_atoms().klass, new_vprops, c.val(ustring::format(W("%s %s"), p_class.c_str(), n_class.c_str())));
              }
              else
                c.set_prop(c.known_atoms().klass, new_vprops, va_class.tearoff());
            }
            vnode_set_props(c, what, new_vprops);
          }

      }

      html::helement res = vnode_morph::exec(c, cel, what, &opts);
      if (res)
        return res;
    }
    catch (qjs::exception) {
      hvalue ex = c.get_exception();

      tool::value  message = c.get_prop<tool::value>("message",ex);
      tool::value  stack = c.get_prop<tool::value>("stack", ex);
      
      value data = value::make_map({{"message",message},{"stack",stack}});

      event_behavior evt_err(el,el,COMPONENT_ERROR,0);
      evt_err.data = data;
      if (c.pview()->send_behavior_event(evt_err))
        return nullptr;
      c.report_exception(JS_DupValue(c,ex));
    }
    return nullptr;
  }

  bool mount_component(xview * pv, html::helement b)
  {
    html::hdocument d = b->doc();
    if (!d) return false;
    string src = b->atts[html::attr::a_src];

    context& c = context::inst(d);

    JSModuleDef* pmod = nullptr;

    if (!src.is_empty()) {
      src = html::combine_url(d->uri().src, src);

      pmod = c.load_script_module(src);

      if (!pmod)
      {
        JS_ThrowTypeError(c, "reactor: module '%s' not found", src.c_str());
        throw qjs::exception();
      }
    }
    tool::string type = b->attr_type();
    bool is_content = false;
    if (type.is_undefined()) {
      is_content = true;
      type = CHARS("content");
    }
    tool::string text = b->get_text(*pv);
    tool::string script;
    tool::string attributes;

    for (auto at : b->atts.items)
    {
      if (at.att_sym == html::attr::a_type)
        continue;

      if (attributes.length())
        attributes.append(CHARS(" "));
      tool::string aname = html::attr::symbol_name(at.att_sym);
      tool::string aval = at.att_value;
      attributes.append(aname());
      if (aval.length())
      {
        attributes.append(CHARS("="));
        if (aval().starts_with('{') && aval().ends_with('}'))
          attributes.append(aval());
        else {
          attributes.append(CHARS("\""));
          attributes.append(xml_escape_seq(aval())());
          attributes.append(CHARS("\""));
        }
      }
    }

    if (text.length())
      script = string::format("<%s %s>%s</%s>", type.c_str(), attributes.c_str(), text.c_str(), type.c_str());
    else
      script = string::format("<%s %s />", type.c_str(), attributes.c_str());

    hvalue vnode;

    try {
      vnode = c.eval(script(), src);
      if (!is_vnode(c,vnode)) // we've got vnode
        return false;

      html::helement p = b->parent;
      element_creator_ctx ectx(c, vnode,p.ptr());
      html::helement mb = ectx.make();
      if (!mb) return false;
      if (is_content) {
        int pos = int(b->node_index);
        b->remove(true);
        p->insert_nodes(pos,mb->nodes(), pv);
      }
      else
        p->replace_child(b, mb, pv);
    }
    catch (qjs::exception) {
      c.report_exception();
    }


    return true;
  }

  hvalue VNode_tagOf(xcontext& ctx, JSValue obj) {
    if (!is_vnode(ctx, obj))
      throw qjs::om::type_error("not VNode");
    return vnode_tag(ctx, obj);
  }

  hvalue VNode_propsOf(xcontext& ctx, JSValue obj) {
    if (!is_vnode(ctx, obj))
      throw qjs::om::type_error("not VNode");
    return vnode_props(ctx, obj);
  }

  hvalue VNode_kidsOf(xcontext& ctx, JSValue obj) {
    if (!is_vnode(ctx, obj))
      throw qjs::om::type_error("not VNode");
    return vnode_kids(ctx, obj);
  }

  hvalue VNode_cloneOf(xcontext& c, hvalue originalVNode, hvalue props, hvalue kids) {
    if (!is_vnode(c, originalVNode))
      throw qjs::om::type_error("not VNode");

    hvalue args[3] = {
      vnode_tag(c,originalVNode),
      vnode_props(c,originalVNode),
      c.is_array(kids) ? kids : vnode_kids(c,originalVNode),
    };
    
    if (c.is_object(props)) {
      args[1] = c.clone(vnode_props(c, originalVNode));
      c.each_prop_atom(props, [&](JSAtom key, hvalue val) {
        if(key != c.known_atoms().key)
          c.set_prop(key, args[1], val);
      });
    }
    return reactor_jsx(c, JS_NULL, 3, (JSValue*)args);
  }

  JSOM_PASSPORT_BEGIN(Reactor_def, xcontext)
    JSOM_GLOBAL_FUNC_DEF("isNode", is_vnode),
    JSOM_GLOBAL_FUNC_DEF("tagOf", VNode_tagOf),
    JSOM_GLOBAL_FUNC_DEF("kidsOf", VNode_kidsOf),
    JSOM_GLOBAL_FUNC_DEF("propsOf", VNode_propsOf),
    JSOM_GLOBAL_FUNC_DEF("cloneOf", VNode_cloneOf),
  JSOM_PASSPORT_END

  void init_Reactor_namespace(context& c)
  {
    JSValue reactor = JS_NewObject(c);

    auto list = Reactor_def();
    JS_SetPropertyFunctionList(c, reactor, list.start, list.length);

    JS_DefinePropertyValueStr(c, c.global(), "Reactor", reactor, JS_PROP_CONFIGURABLE);
  }

}


namespace html
{
  using namespace qjs;

  tool::ustring node_key(html::context& hc, qjs::hvalue pn) {
    qjs::xcontext& c = static_cast<qjs::xcontext&>(hc);
    if (node_type(hc, pn) == html::node::ELEMENT) {
      qjs::hvalue vatts = vnode_props(c, pn);
      if (JS_IsObject(vatts)) {
        ustring key = c.get_prop<ustring>(c.known_atoms().id, vatts,ustring());
        if (key.is_defined())
          return key;
        key = c.get_prop<ustring>(c.known_atoms().key, vatts, ustring());
        if (key.is_defined())
          return key;
        auto tag = node_tag(hc, pn);
        if (tag == html::tag::T_OPTION || tag == html::tag::T_BUTTON) {
          key = c.get_prop<ustring>(c.known_atoms().value, vatts, ustring());
          if (key.is_defined())
            return key;
        }
        key = c.get_prop<ustring>(c.known_atoms().name, vatts, ustring());
        if (key.is_defined())
          return key;
      }
    }
    return ustring();
  }

  tool::ustring node_key_from_props(html::context& hc, hnode pn) {
    qjs::xcontext& c = static_cast<qjs::xcontext&>(hc);
    if (node_type(hc, pn) == html::node::ELEMENT && pn->obj) {
      qjs::hvalue vatts = c.get_prop<hvalue>(c.known_atoms().Symbol_props,pn->obj);
      if (JS_IsObject(vatts)) {
        ustring key = c.get_prop<ustring>(c.known_atoms().id, vatts, ustring());
        if (key.is_defined())
          return key;
        key = c.get_prop<ustring>(c.known_atoms().key, vatts, ustring());
        if (key.is_defined())
          return key;
        auto tag = node_tag(hc, pn);
        if (tag == html::tag::T_OPTION || tag == html::tag::T_BUTTON) {
          key = c.get_prop<ustring>(c.known_atoms().value, vatts, ustring());
          if (key.is_defined())
            return key;
        }
        key = c.get_prop<ustring>(c.known_atoms().name, vatts, ustring());
        if (key.is_defined())
          return key;
      }
    }
    return ustring();
  }


  uint64 node_factory(html::context& hc, node* pn) {
    assert(pn);
    if (!pn->is_element()) return 0;
        
    qjs::xcontext& c = static_cast<qjs::xcontext&>(hc);

    //hvalue factorydef = c.get_prop<hvalue>(c.known_atoms().Symbol_vnode, v);
    //hvalue tag = vnode_tag(c, factorydef);
    hvalue ftag = c.get_prop<hvalue>(c.known_atoms().Symbol_factory, pn->obj);  // vnode_tag(c, factorydef);
    return ftag.v;
  }

  uint64 node_factory(html::context& hc, qjs::hvalue pn) {
    qjs::xcontext& c = static_cast<qjs::xcontext&>(hc);
    if (!is_vnode(c, pn))
      return 0;
    hvalue t = vnode_tag(c, pn);
    return t.v;
  }

  void tunnel_atts(xcontext& c, hvalue vnode, hvalue original_vnode) {
    hvalue atts = vnode_props(c, original_vnode);
    if (atts.is_defined())
    {
      // "tunelling" id,class,name,type and key attributes
      hvalue va_id = JS_GetProperty(c, atts, c.known_atoms().id);
      hvalue va_class = JS_GetProperty(c, atts, c.known_atoms().klass);
      hvalue va_name = JS_GetProperty(c, atts, c.known_atoms().name);
      hvalue va_type = JS_GetProperty(c, atts, c.known_atoms().type);
      hvalue va_key = JS_GetProperty(c, atts, c.known_atoms().key);
      if (va_id.is_defined() || va_class.is_defined() || va_name.is_defined() || va_type.is_defined() || va_key.is_defined())
      {
        JSValue vatts = vnode_props(c, vnode);
        if (va_id.is_defined()) JS_SetProperty(c, vatts, c.known_atoms().id, va_id.tearoff());
        if (va_name.is_defined()) JS_SetProperty(c, vatts, c.known_atoms().name, va_name.tearoff());
        if (va_type.is_defined()) JS_SetProperty(c, vatts, c.known_atoms().type, va_type.tearoff());
        if (va_key.is_defined()) JS_SetProperty(c, vatts, c.known_atoms().key, va_key.tearoff());
        if (va_class.is_defined()) {
          hvalue prev_class = JS_GetProperty(c, vatts, c.known_atoms().klass);
          if (prev_class.is_defined()) {
            ustring p_class = c.get<ustring>(prev_class);
            ustring n_class = c.get<ustring>(va_class);
            JS_SetProperty(c, vatts, c.known_atoms().klass, c.val(ustring::format(W("%s %s"), p_class.c_str(), n_class.c_str())));
          }
          else
            JS_SetProperty(c, vatts, c.known_atoms().klass, va_class.tearoff());
        }
      }
    }
  }

  bool node_element_expand_functors(html::context& ctx, hvalue& new_node, hnode parent)
  {
    xcontext& c = static_cast<xcontext&>(ctx);

    hvalue tag = vnode_tag(c, new_node);
    if (JS_IsString(tag))
      return false;

    hvalue vnode;

    hvalue args[2] = { vnode_props(c,new_node), vnode_kids(c,new_node) };

    hvalue proto, render, thismethod;

    if (is_reactor_class(c, tag, proto, render, thismethod))
    {
      return false;
    }
    else if (JS_IsFunction(c, tag))
    {
      // <Dialog /> - Dialog is a function
      c.call(vnode, tag, hvalue(), vnode_props(c, new_node), vnode_kids(c, new_node), parent);
      if (is_vnode(c, vnode))
        node_element_expand_functors(ctx, vnode, parent);

      if (is_vnode(c, vnode))
        tunnel_atts(c, vnode, new_node);
      new_node = vnode;

      return true;
    }
    else
      assert(false); // neither function nor class

    return false;

  }

  
  hvalue node_element_expand(html::context& ctx, hvalue new_node, html::hnode& old_node, html::hnode parent)
  {
    xcontext& c = static_cast<xcontext&>(ctx);

    hvalue tag = vnode_tag(c, new_node);
    if (JS_IsString(tag))
      return JS_DupValue(c, new_node);

    hvalue inst;
    hvalue vnode;

#ifdef DEBUG
    assert(parent);
    /*auto nk = node_key(ctx, new_node);
    if (nk == WCHARS("test")) {
      dbg_printf("%s\n", c.toJSON(new_node, 2).c_str());
      parent = parent;
    }*/
#endif

    hvalue args[2] = { vnode_props(c,new_node), vnode_kids(c,new_node) };

    hvalue proto, render, thismethod;

    if (is_reactor_class(c, tag, proto, render, thismethod))
    {
      // <Dialog /> - Dialog is a class
      // 1. Create DOM element if needed for the vdom
      if (old_node) {
        // 1.a. handling exisitng element already present in the DOM
        inst = c.val(old_node); // addrefed
        assert(inst);

        if (!JS_IsInstanceOf(c, inst, tag)) {
          c.pxview()->on_unmount_element(c,old_node.ptr_of<html::element>());

          hvalue newinst = JS_CallConstructor(c, tag, 2, (JSValue*)args);
          if (JS_IsException(newinst))
            throw qjs::exception();
        
          old_node.ptr_of<html::element>()->flags.script_reactors_prototype = 1;
          JS_SetOpaque(old_node->obj, 0);
          old_node->obj.clear();
          old_node->obj = inst = newinst;
          JS_SetOpaque(old_node->obj, old_node.ptr());

          //c.set_prop(c.known_atoms().Symbol_props, inst, args[0]);
          //c.set_prop(c.known_atoms().Symbol_kids, inst, args[1]);
          //c.set_prop(c.known_atoms().Symbol_factory, old_node->obj, tag);
          
          //c.pxview()->on_mount_element(c, old_node.ptr_of<html::element>());
          handle<document> pd = c.pdoc();
          c.pview()->post([pd,old_node]()->bool {
            xcontext c(pd);
            c.pxview()->on_mount_element(c, old_node.ptr_of<html::element>());
            return true;
          });

        }
        /*else {
        }*/
      }
      else {

        // 1.b. creating brand new DOM element
        old_node = new html::element(html::tag::T_OBJECT); // tag will be set later
        old_node.ptr_of<html::element>()->flags.script_need_attached_call = 1; // we want attached(), a.k.a. didMount
        old_node.ptr_of<html::element>()->flags.script_reactors_prototype = 1;

        inst = JS_CallConstructor(c, tag, 2, (JSValue*)args);
        if (JS_IsException(inst))
          throw qjs::exception();

        old_node->obj = JS_DupValue(c,inst);
        old_node->add_ref();
        JS_SetOpaque(inst, (node*)old_node.ptr());
        //c.set_prop(c.known_atoms().Symbol_props, inst, args[0]);
        //c.set_prop(c.known_atoms().Symbol_kids, inst, args[1]);
        //c.set_prop(c.known_atoms().Symbol_factory, old_node->obj, tag);
      }

      // 2. invoke "reactor ctor" method:
      //    {this}.this(props,kids) 
      //    with `this` set to `inst`
      if (c.is_function(thismethod))
        c.call(vnode, thismethod, inst, args[0], args[1],parent);
      
      // 3. invoke {this}.render() with `this` set to `inst`
      c.call(vnode, render, inst, args[0],args[1],parent);
      if (!is_vnode(c, vnode))
        throw qjs::om::type_error("render() must return vnode");
      vnode = node_element_expand(ctx, vnode, old_node, parent);
      string tagname = vnode_tagname(c, vnode);
      if( tagname == CHARS("") || tagname == CHARS("fragment"))
        throw qjs::om::type_error("render() must not return fragment");
      old_node.ptr_of<html::element>()->tag = html::tag::symbol(tagname);
      //c.set_prop(c.known_atoms().Symbol_factory, inst, tag);
    }
    else if (JS_IsFunction(c, tag))
    {
      // <Dialog /> - Dialog is a function
      c.call(vnode, tag, old_node, vnode_props(c, new_node), vnode_kids(c, new_node), parent);
      if (is_vnode(c, vnode)) {
        vnode = node_element_expand(ctx, vnode, old_node, parent);
      }      
    }
    else
      assert(false); // neither function nor class

    if (is_vnode(c, vnode))
      goto ATTS_AND_STATES;

    if (JS_IsArray(c, vnode))
      return vnode.tearoff();

    return JS_NULL;

  ATTS_AND_STATES:
    tunnel_atts(c, vnode, new_node);
    return vnode;
  }

  ustring_chars node_text(html::context& hc, qjs::hvalue pn) {
    qjs::xcontext& c = static_cast<qjs::xcontext&>(hc);
    if (JS_IsString(pn))
      return ustring_chars(c.get<ustring>(pn));
    return ustring_chars();
  }

  uint node_size(html::context& hc, qjs::hvalue pn) {
    qjs::xcontext& c = static_cast<qjs::xcontext&>(hc);
    if (is_vnode(c, pn)) {
      hvalue kids = vnode_kids(c, pn);
      return c.get_length(kids);
    }
    return 0;
  }

  bool node_element_expand_functors(html::context& ctx, hvalue& new_node, hnode parent);

  qjs::hvalue   node_child(html::context& hc, qjs::hvalue &pn, uint i) {
    qjs::xcontext& c = static_cast<qjs::xcontext&>(hc);
    if (!is_vnode(c, pn))
      return JS_UNINITIALIZED;
    hvalue kids = vnode_kids(c, pn);
    uint length = c.get_length(kids);
    if (i >= length)
      return JS_UNINITIALIZED;

    qjs::hvalue vchild = c.get_item<qjs::hvalue>(i, kids);
    return vchild;
  }

  // skips falses and expands fragments

  //vnode_array vnode_children(html::context& hc, qjs::hvalue vnode, html::hnode parent)

  vnode_array vnode_flatten_list(qjs::xcontext& c, slice<hvalue> list, html::hnode parent)
  {
    vnode_array out;
    for (qjs::hvalue vchild: list) {

      if (is_vnode(c, vchild))
        node_element_expand_functors(c, vchild, parent);

      uint expansions = 0;

      if (is_vnode(c, vchild)) {
        if (is_fragment(c, vchild))
          out.push(vnode_children(c, vchild, parent)());
        else
          out.push(vchild);
      }
      else if (c.is_array(vchild)) {
        out.push(vnode_flatten_list(c, c.items(vchild), parent));
      }
      else if (JS_IsString(vchild))
        out.push(vchild);
      else if (vchild == JS_UNINITIALIZED)
        continue;
      else if (vchild == JS_UNDEFINED || vchild == JS_FALSE)
        continue;
      else {
        vchild = JS_ToString(c, vchild);
        out.push(vchild);
      }
    }
    return out;
  }

  vnode_array vnode_children(html::context& hc, qjs::hvalue vnode, html::hnode parent)
  {
    qjs::xcontext& c = static_cast<qjs::xcontext&>(hc);
    if (!is_vnode(c, vnode))
      return vnode_array();
    hvalue kids = vnode_kids(c, vnode);
    return vnode_flatten_list(c, c.items(kids), parent);
  }

  /*void node_remove_child(html::context& hc, qjs::hvalue pn, uint i) {
    qjs::xcontext& c = static_cast<qjs::xcontext&>(hc);
    if (!is_vnode(c, pn))
      return;
    hvalue kids = vnode_kids(c, pn);
    uint total = c.get_length(kids);
    if (total && (i < total)) {
      for (uint n = i; n < total - 1; ++n) {
        hvalue vn = c.get_item<hvalue>(n + 1, kids);
        c.set_item<hvalue>(n, kids, vn);
      }
      c.set_item<hvalue>(total - 1, kids, JS_UNINITIALIZED);
      //JS_SetProperty(c,kids,c.known_atoms().length,c.val(total-))
    }
  }*/

  attribute_bag node_atts(html::context& hc, qjs::hvalue pn) {
    qjs::xcontext& c = static_cast<qjs::xcontext&>(hc);
    html::attribute_bag atts;
    if (!is_vnode(c, pn))
      return atts;
    hvalue props = vnode_props(c, pn);
    c.each_prop(props, [&](chars name, hvalue val) {
      if (!name.starts_with(CHARS("state-")) && val.is_defined())
        atts.set(name, c.get<ustring>(val));
    });
    return atts;
  }

  bool node_states(html::context& hc, qjs::hvalue pn, attribute_bag_v& states) {
    qjs::xcontext& c = static_cast<qjs::xcontext&>(hc);
    if (!is_vnode(c, pn))
      return false;
    hvalue props = vnode_props(c, pn);
    int n = 0;
    c.each_prop(props, [&](chars name, hvalue val) {
      if (name.starts_with(CHARS("state-"))) {
        states.set(name(6), c.get<value>(val));
        ++n;
      }
    });
    return n > 0;
  }


  hnode  node_new_to_old(html::context& hc, qjs::hvalue nn, html::hnode parent)
  {
    auto nt = node_type(hc,nn);
    if (nt == html::node::TEXT)
      return new html::text(node_text(hc, nn));

    element_creator_ctx ctx(hc, nn, parent);
    html::helement el = ctx.make();
    return el;
  }

  bool node_new_to_old_ex(html::context& hc, vnode_array& list, uint list_index, html::hnode dom_parent, hnode& dom_child) {
    qjs::xcontext& c = static_cast<qjs::xcontext&>(hc);
    qjs::hvalue nn = list[list_index];
    auto nt = node_type(c,nn);
    if (nt == html::node::TEXT) {
      dom_child = new html::text(node_text(hc, nn));
      return false;
    }

    element_creator_ctx ctx(hc, nn, dom_parent);
    dom_child = ctx.make();
    
    //TODO fragment

#if 0
    if (!dom_child) {

      if (c.is_array(ctx.tuple)) // we've got fragment list
      {
        /*array<hvalue> expanded;
        uint expansions = 0;
        // flattens kids collection so if a kid is an array of vnodes content of the array gets spliced inplace
        c.each_item(kids, [&](uint i, hvalue item) {
          if (flatten(c, item, expanded, expansions))
            expanded.push(item);
          });
        if (expansions) {
          kids.clear();
          vnode_set_kids(c, vnode, expanded());
        }
        */
        return true;
      }
    }
#endif
    return false;
  }

  void update_element_atts_states(html::context& hc, element* pel, qjs::hvalue pn, bool is_root)
  {
    element_creator_ctx ctx(hc, pn, pel->parent.ptr());
    //WTF (pel && is_root)  ctx.atts = pel->atts;
    ctx.make_attributes(pel);
  }

  template<class A, class B>
  bool strong_identity(qjs::xcontext& c,A a, B b) {
    if (node_tag(c,a) != node_tag(c,b))
      return false;
    ustring aid = node_key(c,a);
    ustring bid = node_key(c,b);
    if ((aid.is_defined() || bid.is_defined()) && (aid != bid))
      return false;
    return true;
  }

  bool node_equal(html::context& hc, qjs::hvalue a, html::hnode b)
  {
    qjs::xcontext& c = static_cast<qjs::xcontext&>(hc);
    node::NODE_TYPE nta = node_type(c,a);
    if (nta != node_type(c,b))
      return false;

    if (nta == html::node::NODE_TYPE::TEXT)
      return node_text(hc, a) == node_text(hc, b);

    if (nta != html::node::NODE_TYPE::ELEMENT)
      return false;

    qjs::hvalue vtag = vnode_tag(c,a);
    if (!JS_IsString(vtag))
    {
#ifdef DEBUG
      string svt = c.get<string>(vtag);
#endif
      assert(JS_IsFunction(c,vtag));
      if (b->obj.is_defined())
      {
         //hvalue factorydef = c.get_prop<hvalue>(c.known_atoms().Symbol_vnode, b.ptr_of<element>()->obj);
         hvalue ftag = c.get_prop<hvalue>(c.known_atoms().Symbol_factory, b->obj);  // vnode_tag(c, factorydef);
         if (!JS_AreFunctionsOfSameOrigin(c, vtag, ftag)) {
           //dbg_printf("vtag=%s\n\nftag=%s\n", c.get<string>(vtag).c_str(), c.get<string>(ftag).c_str());
           return false;
         }
          ustring aid = node_key(c,a);
          ustring bid = node_key_from_props(c,b);
          if ((aid.is_defined() || bid.is_defined()) && (aid != bid))
            return false;
          return true;
      }
      return false;
    }
    return strong_identity(c,a, b);
  }

  // SSX stuff:
  namespace behavior {

    struct reactor_ctl_factory : public ctl_factory {
      reactor_ctl_factory() : ctl_factory("reactor") {}
      virtual ctl *create(element *el);
    };

    static reactor_ctl_factory *_reactor_ctl = 0;

    struct reactor_ctl : ctl {

      reactor_ctl() {}

      virtual CTL_TYPE get_type() override { return CTL_UNKNOWN; }
      virtual bool     is_atomic() const override { return true; }

      virtual const string &behavior_name() const {
        return _reactor_ctl->name;
      }

      virtual bool attach(view &v, element *self) override {
        html::hdocument d = self->doc();
        if (!d) return false;
        xview* xv = static_cast<xview*>(&v);
        bool is_loading = !d->state.ready();
        if (is_loading) {
          event_behavior evt(self, self, MOUNT_COMPONENT, 0);
          xv->post_behavior_event(evt, true);
          return true;
        }
        else {
          mount_component(xv, self);
          return true;
        }
      }

      virtual bool on(view &v, element *self, event_behavior &evt) override {
        if (evt.cmd == MOUNT_COMPONENT) {
          xview* xv = static_cast<xview*>(&v);
          mount_component(xv, self);
          return true;
        }
        return false;
      }

    };

    ctl *reactor_ctl_factory::create(element *el) {
      return new reactor_ctl();
    }

    void init_reactor() {
      ctl_factory::add(_reactor_ctl = new reactor_ctl_factory());
    }

  } // namespace behavior


}

