#include "xrange.h"
#include "xdom.h"
#include "xom.h"

namespace qjs
{
  using namespace html;

  html::bookmark xbookmark(xcontext& c, JSValue tuple) {
    html::bookmark r;
    if (c.is_array(tuple)) {
      r.node = c.get_item<hnode>(0, tuple);
      r.pos = c.get_item<int>(1, tuple);
      r.after_it = false;
    }
    return r;
  }

  hvalue xbookmark(xcontext& c, html::bookmark bm) {
    hvalue pair[2] = { c.val(bm.node), c.val(bm.normalized().pos.val(0)) };
    return JS_NewFastArray(c, 2, (JSValue*)pair);
  }
  
  bool range_apply_mark(xcontext& c,hrange range, hvalue marks) {
    
    html::view *pv = c.pview();
    if (!pv || !range) return false;

    array<string> list;

    if (c.is_string(marks))
      list.push(c.get<string>(marks));
    else
      list = c.get<array<string>>(marks);

    uint changes = html::apply_marks(*pv, range->start, range->end, list());

    return changes > 0;
  }

  bool range_clear_mark(xcontext& c, hrange range, hvalue marks) 
  {
    html::view *pv = c.pview();
    if (!pv || !range) return false;

    array<string> list;

    if (c.is_string(marks))
      list.push(c.get<string>(marks));
    else
      list = c.get<array<string>>(marks);

    uint changes = html::clear_marks(*c.pview(), range->start, range->end, list());

    return changes > 0;
  }

  array<string> range_get_marks(xcontext& c, hrange range) {
    if (!range) return array<string>();
    uint m = marks_id_of_range(*c.pview(), range->start, range->end);
    return span_class_names(char_mark_t(m));
  }

  ustring range_to_mark(xcontext& c, hrange range, string mark) {
    if (!range) return ustring();
    ustring word;
    get_marks_span(range->start, range->end, word, mark);
    return word;
  }
  
  

  bool range_collapsed(xcontext& c, hrange range)
  {
    return range->start == range->end;
  }

  helement range_commonAncestorContainer(xcontext& c, hrange range) {
    return node::find_common_parent(range->start.node,range->end.node);
  }

  hnode range_endContainer(xcontext& c, hrange range) {
    return range->end.node;
  }

  hnode range_startContainer(xcontext& c, hrange range) {
    return range->start.node;
  }

  int range_endOffset(xcontext& c, hrange range) {
    return range->end.normalized().pos.val(0);
  }

  int range_startOffset(xcontext& c, hrange range) {
    return range->start.normalized().pos.val(0);
  }

  bool range_setStart(xcontext& c, hrange range, hnode n, int pos) {
    range->start = bookmark(n,pos,false);
    return true;
  }

  bool range_setEnd(xcontext& c, hrange range, hnode n, int pos) {
    range->end = bookmark(n, pos, false);
    return true;
  }

  bool range_setStartBefore(xcontext& c, hrange range, hnode n) {
    if (!n) return false;
    range->start = n->this_pos(false);
    return true;
  }
  bool range_setEndBefore(xcontext& c, hrange range, hnode n) {
    if (!n) return false;
    range->end = n->this_pos(false);
    return true;
  }

  bool range_setStartAfter(xcontext& c, hrange range, hnode n) {
    if (!n) return false;
    range->start = n->this_pos(true);
    return true;
  }

  bool range_setEndAfter(xcontext& c, hrange range, hnode n) {
    if (!n) return false;
    range->end = n->this_pos(true);
    return true;
  }

  bool range_selectNode(xcontext& c, hrange range, hnode n) {
    if (!n) return false;
    range->start = n->this_pos(false);
    range->end = n->this_pos(true);
    return true;
  }

  bool range_selectNodeContents(xcontext& c, hrange range, hnode n) {
    if (!n) return false;
    range->start = n->start_pos();
    range->end = n->end_pos();
    return true;
  }

  bool range_collapse(xcontext& c, hrange range, bool to_start) {
    if(to_start)
      range->start = range->end;
    else 
      range->end = range->start;
    return true;
  }

  hrange range_clone(xcontext& c, hrange rn) {
    hrange nr = new range();
    nr->start = rn->start;
    nr->end = rn->end;
    return nr;
  }

  hvalue range_start(xcontext& c, hrange rn) {
    return xbookmark(c,rn->start);
  }
  hvalue range_end(xcontext& c, hrange rn) {
    return xbookmark(c, rn->end);
  }
  
  JSClassID Range_class_id;

  JSOM_PASSPORT_BEGIN(Range_def, html::range)
    JSOM_CONST_STR("[Symbol.toStringTag]", "Range", JS_PROP_CONFIGURABLE),
    JSOM_RO_PROP_DEF("collapsed", range_collapsed),
    JSOM_RO_PROP_DEF("commonAncestorContainer", range_commonAncestorContainer),
    JSOM_RO_PROP_DEF("endContainer", range_endContainer),
    JSOM_RO_PROP_DEF("startContainer", range_startContainer),
    JSOM_RO_PROP_DEF("endOffset", range_endOffset),
    JSOM_RO_PROP_DEF("startOffset", range_startOffset),
    JSOM_RO_PROP_DEF("start", range_start),
    JSOM_RO_PROP_DEF("end", range_end),

    JSOM_FUNC_DEF("setStart", range_setStart),
    JSOM_FUNC_DEF("setEnd", range_setEnd),

    JSOM_FUNC_DEF("setStartBefore", range_setStartBefore),
    JSOM_FUNC_DEF("setStartAfter", range_setStartAfter),
    JSOM_FUNC_DEF("setEndBefore", range_setEndBefore),
    JSOM_FUNC_DEF("setEndAfter", range_setEndAfter),

    JSOM_FUNC_DEF("selectNode", range_selectNode),
    JSOM_FUNC_DEF("selectNodeContents", range_selectNodeContents),    
    JSOM_FUNC_DEF("collapse", range_collapse),
    JSOM_FUNC_DEF("cloneRange", range_clone),

    JSOM_FUNC_DEF("applyMark", range_apply_mark),
    JSOM_FUNC_DEF("highlight", range_apply_mark),
    JSOM_FUNC_DEF("clearMark", range_clear_mark),
    JSOM_FUNC_DEF("clearHighlight", range_clear_mark),
    JSOM_FUNC_DEF("marks", range_get_marks),
    JSOM_FUNC_DEF("setToMark", range_to_mark),

    JSOM_PASSPORT_END

  void init_Range_class(context& c)
  {
    JS_NewClassID(&Range_class_id);

    static JSClassDef Range_class = {
      "Range",
      [](JSRuntime *rt, JSValue val)
      {
        range* pe = (range*)JS_GetOpaque(val,Range_class_id);  //object_of<html::element>(val);
        if (pe) pe->release();
      }
    };

    JS_NewClass(JS_GetRuntime(c), Range_class_id, &Range_class);
    JSValue range_proto = JS_NewObject(c);

    auto list = Range_def();
    JS_SetPropertyFunctionList(c, range_proto, list.start, list.length);

    auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
    {
      JSValue  obj = JS_UNDEFINED;
      JSValue  proto;
      hrange   hr;
      xcontext c(ctx);
      /* using new_target to get the prototype is necessary when the class is extended. */
      proto = JS_GetPropertyStr(ctx, new_target, "prototype");
      if (JS_IsException(proto))
        goto fail;
      obj = JS_NewObjectProtoClass(ctx, proto, Range_class_id);
      JS_FreeValue(ctx, proto);
      if (JS_IsException(obj))
        goto fail;
      hr = new qjs::range();

      if (argc > 0 && c.is_array(argv[0]))
        hr->start = xbookmark(c, argv[0]);
      else
        hr->start = c.pdoc()->start_pos();

      if (argc > 1 && c.is_array(argv[1]))
        hr->end = xbookmark(c, argv[1]);
      else
        hr->end = c.pdoc()->end_pos();

      JS_SetOpaque(obj, hr.detach());
      return obj;
    fail:
      //js_free(ctx, s);
      JS_FreeValue(ctx, obj);
      return JS_EXCEPTION;
    };

    hvalue range_class = JS_NewCFunction2(c, ctor, "Range", 2, JS_CFUNC_constructor, 0);

    JS_DefinePropertyValueStr(c, c.global(), "Range", JS_DupValue(c, range_class), JS_PROP_CONFIGURABLE);

    JS_SetConstructor(c, range_class, range_proto);
    JS_SetClassProto(c, Range_class_id, range_proto);
  }

}