#include "xdom.h"
#include "xom.h"
#include "xcontext.h"
#include "xview.h"

namespace html
{
  using namespace qjs;

  //script_expando_interface
  bool node::get_expando(context& hc, script_expando& seo) {
    if (!obj)
      return false;
    qjs::xcontext& c = static_cast<qjs::xcontext&>(hc);
    seo = c.val(this);
    return true;
  }

  struct node_proto: public html::comment {
    node_proto() : comment(WCHARS("")) {}
    virtual string    node_def() const override { return string("Node(prototype of)"); }
  };

  struct text_proto : public html::text {
    text_proto() : text(WCHARS("")) {}
    virtual string    node_def() const override { return string("Text(prototype of)"); }
  };

  struct comment_proto : public html::comment {
    comment_proto() : comment(WCHARS("")) {}
    virtual string    node_def() const override { return string("Comment(prototype of)"); }
  };


}

namespace qjs {

  using namespace html;
  using namespace tool;
  
  JSClassID Node_class_id = 0;

  html::node* node_ptr_of(JSContext* ctx, JSValueConst obj) {
    void* opaque = nullptr;
    JSClassID cid = JS_GetClassID(obj, &opaque);
    if (cid == Node_class_id
      || cid == Element_class_id
      || cid == Document_class_id
      || cid == Text_class_id
      || cid == Comment_class_id
      || cid == Style_class_id
      || cid == ElementState_class_id)
      return (html::node*)opaque;

    hvalue cproto = JS_GetClassProto(ctx, Node_class_id);
    if (obj == cproto) {
      static hnode node_proto = new html::node_proto();
      return node_proto;
    }
    return nullptr;
  }

  html::text* text_ptr_of(JSContext* ctx, JSValueConst obj) {
    void* opaque = nullptr;
    JSClassID cid = JS_GetClassID(obj, &opaque);
    if (cid == Text_class_id
      || cid == Node_class_id )
      return (html::text*)(html::node*)opaque;

    hvalue cproto = JS_GetClassProto(ctx, Text_class_id);
    if (obj == cproto) {
      static handle<text> text_proto = new html::text_proto();
      return text_proto;
    }
    return nullptr;
  }



  void set_node_value(xcontext& c, node* pn, ustring val) {
    pn->node_set_value(val(), c.pview());
  }

  string  node_def(xcontext&, node* pn) { return pn->node_def(); }
  node*   first_node(xcontext&, node* pn) {
    return pn->first_node(); 
  }
  node*   last_node(xcontext&, node* pn) { return pn->last_node(); }
  node*   next_node(xcontext&, node* pn) { return pn->next_node(); }
  node*   prev_node(xcontext&, node* pn) { return pn->prev_node(); }
  string  node_name(xcontext&, node* pn) { return pn->node_name(); }
  int     node_type(xcontext&, node* pn) { return pn->node_type(); }
  uint    node_index(xcontext&, node* pn) { return pn->node_index; }
  wchars  node_value(xcontext&, node* pn) { return pn->node_value(); }
  //void    set_node_value(xcontext&, ustring val);
  document* doc(xcontext&, node* pn) { return pn->doc(); }
  element*  parent(xcontext&, node* pn) { return pn->logical_parent(); }
  xview*    parent_window(xcontext&, node* pn) { return static_cast<xview*>(pn->pview()); }

  hvalue node_child_nodes(xcontext& c, node* pn) { return JS_NewArray(c); }

  ustring   get_text(xcontext&, node* pn) { return pn->node_text(); }
  void      set_text(xcontext& c, node* pn, ustring t) { pn->node_set_text(t, c.pview()); }
  
  node*     clone(xcontext&, node* pn, bool/*deep - not used in Sciter*/) { return pn->clone(); }
  bool      contains(xcontext&, node* pn, node* pno) { return pn->node_contains(pno); }

  node*     root_node(xcontext&, node* pn) { return pn->root_node(); } // TODO - shadow DOM!
  bool      has_child_nodes(xcontext&, node* pn) { return pn->node_has_child_nodes(); } // TODO - shadow DOM!

  hvalue    remove(xcontext& c, node* pn, bool detach) { 
    pn->remove(!detach, c.pview()); return hvalue(); 
  }

  bool      is_equal(xcontext&, node* pn, node* other) { return pn->node_is_equal(other); }
  bool      is_same(xcontext&, node* pn, node* other) { return pn->node_is_same(other); }

  uint node_length(xcontext& c, node* pn) { 
    if (pn->is_text() || pn->is_comment())
      return (uint)static_cast<html::text*>(pn)->chars.length();
    else 
      return (uint)static_cast<html::element*>(pn)->nodes.length();
  }
  hvalue    node_data(xcontext& c, node* pn) {
    if (pn->is_text() || pn->is_comment())
      return c.val(static_cast<html::text*>(pn)->chars());
    return hvalue();
  }
  void    node_set_data(xcontext& c, node* pn, ustring text) {
    if (pn->is_text() || pn->is_comment())
      static_cast<html::text*>(pn)->node_set_text(text, c.pview());
  }
 
  
  JSOM_PASSPORT_BEGIN(Node_def, html::node)
    //JSOM_CONST_STR("[Symbol.toStringTag]", "Node", JS_PROP_CONFIGURABLE),
    JSOM_RO_PROP_DEF("[Symbol.toStringTag]", node_def),

    JSOM_RO_PROP_DEF("firstChild", first_node),
    JSOM_RO_PROP_DEF("lastChild", last_node),
    JSOM_RO_PROP_DEF("childNodes", node_child_nodes),
    JSOM_RO_PROP_DEF("nextSibling", next_node),
    JSOM_RO_PROP_DEF("previousSibling", prev_node),

    JSOM_RO_PROP_DEF("nodeName", node_name),
    JSOM_RO_PROP_DEF("nodeType", node_type),
    JSOM_RO_PROP_DEF("nodeIndex", node_index),
    JSOM_PROP_DEF("nodeValue", node_value, set_node_value),
    JSOM_RO_PROP_DEF("ownerDocument", doc),
    JSOM_RO_PROP_DEF("parentNode", parent),
    JSOM_RO_PROP_DEF("parentElement", parent),
    JSOM_RO_PROP_DEF("parentWindow", parent_window),

    JSOM_PROP_DEF("textContent", get_text, set_text),

    //"appendChild" at Element
    JSOM_FUNC_DEF("remove", remove),

    JSOM_FUNC_DEF("cloneNode", clone),
    JSOM_FUNC_DEF("contains", contains),

    //"compareDocumentPosition" - TODO - implement

    JSOM_FUNC_DEF("getRootNode", root_node), // TODO - shadow DOM!
    JSOM_FUNC_DEF("hasChildNodes", has_child_nodes), // TODO - shadow DOM!

    JSOM_FUNC_DEF("isEqualNode", is_equal),
    JSOM_FUNC_DEF("isSameNode", is_same),

    //JSOM_FUNC("normalize", node_normalize), -- TODO!

    //JSOM_FUNC("removeChild", ...), at element

    // CharacterData, sigh - wrong!
    //JSOM_PROP_DEF("data", node_data, node_set_data),
    //JSOM_RO_PROP_DEF("length", node_length),

    JSOM_PASSPORT_END

  void init_Comment_class(context& c);
  void init_Text_class(context& c);

  void init_Node_class(context& c)
  {
    JS_NewClassID(&Node_class_id);

    static JSClassDef Node_class = {
      "Node",
      [](JSRuntime *rt, JSValue val)
      {
        html::node* pe = object_of<html::node>(val);
        if (pe) {
          pe->obj.tearoff();
          pe->release();
        }
      }
    };

    JS_NewClass(JS_GetRuntime(c), Node_class_id, &Node_class);
    JSValue node_proto = JS_NewObject(c);

    auto list = Node_def();
    JS_SetPropertyFunctionList(c, node_proto, list.start, list.length);

    auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
    {
      JSValue obj = JS_UNDEFINED;
      JSValue proto;
      /* using new_target to get the prototype is necessary when the class is extended. */
      proto = JS_GetProperty(ctx, new_target, qjs::JS_ATOM_prototype);
      if (JS_IsException(proto))
        goto fail;
      obj = JS_NewObjectProtoClass(ctx, proto, Node_class_id);
      JS_FreeValue(ctx, proto);
      if (JS_IsException(obj))
        goto fail;
      //JS_SetOpaque(obj, s);
      return obj;
    fail:
      //js_free(ctx, s);
      JS_FreeValue(ctx, obj);
      return JS_EXCEPTION;
    };

#if 0
    JSValue node_class = JS_NewCFunction2(c, ctor, "Node", 2, JS_CFUNC_constructor, 0);

    JS_SetConstructor(c, node_class, node_proto);
    JS_SetClassProto(c, Node_class_id, node_proto);
    //JS_FreeValue(pd->ns, node_proto);
    JS_FreeValue(c, node_class);
#else
    hvalue node_class = JS_NewCFunction2(c, ctor, "Node", 2, JS_CFUNC_constructor, 0);

    JS_DefinePropertyValueStr(c, c.global(), "Node", JS_DupValue(c, node_class), JS_PROP_WRITABLE | JS_PROP_CONFIGURABLE);

    JS_SetConstructor(c, node_class, node_proto);
    JS_SetClassProto(c, Node_class_id, node_proto);
#endif
    init_Comment_class(c);
    init_Text_class(c);

  }

  JSClassID Text_class_id = 0;

  ustring whole_text(xcontext& c, text* pt) {
    array<wchar> buffer;
    for (node* pn = pt->prev_node(); pn && pn->is_text(); pn = pn->prev_node())
      buffer.insert(0, pn->cast<text>()->chars());
    buffer.push(pt->chars());
    for (node* pn = pt->next_node(); pn && pn->is_text(); pn = pn->next_node())
      buffer.push(pn->cast<text>()->chars());
    return buffer();
  }

  JSOM_PASSPORT_BEGIN(Text_def, html::text)
    //JSOM_CONST_STR("[Symbol.toStringTag]", "Node", JS_PROP_CONFIGURABLE),
    JSOM_RO_PROP_DEF("[Symbol.toStringTag]", node_def),

    // CharacterData
    JSOM_PROP_DEF("data", node_data, node_set_data),
    JSOM_RO_PROP_DEF("length", node_length),

    // Text node
    JSOM_RO_PROP_DEF("wholeText", whole_text),
    //JSOM_FUNC_DEF("splitText", whole_text),

  JSOM_PASSPORT_END

  void init_Text_class(context& c)
  {
    JS_NewClassID(&Text_class_id);

    static JSClassDef Text_class = {
      "Text",
      [](JSRuntime *rt, JSValue val)
      {
        html::text* pe = object_of<html::text>(val);
        if (pe) {
          pe->obj.tearoff();
          pe->release();
        }
      }
    };

    JS_NewClass(JS_GetRuntime(c), Text_class_id, &Text_class);
    JSValue text_proto = JS_NewObject(c);

    auto list = Text_def();
    JS_SetPropertyFunctionList(c, text_proto, list.start, list.length);

    auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
    {
      JSValue obj = JS_UNDEFINED;
      JSValue proto;
      /* using new_target to get the prototype is necessary when the class is extended. */
      proto = JS_GetPropertyStr(ctx, new_target, "prototype");
      if (JS_IsException(proto))
        goto fail;
      obj = JS_NewObjectProtoClass(ctx, proto, Text_class_id);
      JS_FreeValue(ctx, proto);
      if (JS_IsException(obj))
        goto fail;
      //JS_SetOpaque(obj, s);
      return obj;
    fail:
      //js_free(ctx, s);
      JS_FreeValue(ctx, obj);
      return JS_EXCEPTION;
    };

    hvalue text_class = JS_NewCFunction2(c, ctor, "Text", 2, JS_CFUNC_constructor, 0);

    JS_DefinePropertyValueStr(c, c.global(), "Text", JS_DupValue(c, text_class), JS_PROP_WRITABLE | JS_PROP_CONFIGURABLE);

    hvalue node_proto = JS_GetClassProto(c, Node_class_id);
    JS_SetPrototype(c, text_proto, node_proto);

    JS_SetConstructor(c, text_class, text_proto);
    JS_SetClassProto(c, Text_class_id, text_proto);
  }

  JSOM_PASSPORT_BEGIN(Comment_def, html::comment)
    //JSOM_CONST_STR("[Symbol.toStringTag]", "Node", JS_PROP_CONFIGURABLE),
    JSOM_RO_PROP_DEF("[Symbol.toStringTag]", node_def),

    // CharacterData
    JSOM_PROP_DEF("data", node_data, node_set_data),
    JSOM_RO_PROP_DEF("length", node_length),

  JSOM_PASSPORT_END

  JSClassID Comment_class_id = 0;
  void init_Comment_class(context& c)
  {
    JS_NewClassID(&Comment_class_id);

    static JSClassDef Comment_class = {
      "Comment",
      [](JSRuntime *rt, JSValue val)
      {
        html::comment* pe = object_of<html::comment>(val);
        if (pe) {
          pe->obj.tearoff();
          pe->release();
        }
      }
    };

    JS_NewClass(JS_GetRuntime(c), Comment_class_id, &Comment_class);
    JSValue comment_proto = JS_NewObject(c);

    auto list = Comment_def();
    JS_SetPropertyFunctionList(c, comment_proto, list.start, list.length);

    auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
    {
      JSValue obj = JS_UNDEFINED;
      JSValue proto;
      /* using new_target to get the prototype is necessary when the class is extended. */
      proto = JS_GetPropertyStr(ctx, new_target, "prototype");
      if (JS_IsException(proto))
        goto fail;
      obj = JS_NewObjectProtoClass(ctx, proto, Comment_class_id);
      JS_FreeValue(ctx, proto);
      if (JS_IsException(obj))
        goto fail;
      //JS_SetOpaque(obj, s);
      return obj;
    fail:
      //js_free(ctx, s);
      JS_FreeValue(ctx, obj);
      return JS_EXCEPTION;
    };

    hvalue comment_class = JS_NewCFunction2(c, ctor, "Comment", 2, JS_CFUNC_constructor, 0);

    JS_DefinePropertyValueStr(c, c.global(), "Comment", JS_DupValue(c, comment_class), JS_PROP_WRITABLE | JS_PROP_CONFIGURABLE);

    hvalue node_proto = JS_GetClassProto(c, Node_class_id);
    JS_SetPrototype(c, comment_proto, node_proto);

    JS_SetConstructor(c, comment_class, comment_proto);
    JS_SetClassProto(c, Comment_class_id, comment_proto);
  }


}
