#include "xdom.h"
#include "xom.h"
#include "xview.h"

namespace qjs
{
  using namespace html;
  using namespace tool;
   

  static bool    cookie_enabled(xcontext&c, hvalue obj) { return true; }
  static hvalue  credentials(xcontext&c, hvalue obj) { return JS_NULL; }
  static hvalue  geolocation(xcontext&c, hvalue obj) { return JS_NULL; }
  static ustring language(xcontext&c, hvalue obj) { 
    tool::ustring lang;
    tool::ustring country;
    tool::environment::used_lang_country(lang, country, true);
    return lang;
  }  

  static string user_agent(xcontext&c, hvalue obj) {
    return html::pump::get_user_agent();
  }

  static void set_user_agent(xcontext&c, hvalue obj, string s) {
    html::pump::set_user_agent(s);
  }
  
  JSOM_PASSPORT_BEGIN(Navigator_def, xcontext)
    //JSOM_PROP_DEF("link", state_link, state_set_link),
    JSOM_RO_PROP_DEF("cookieEnabled", cookie_enabled),
    JSOM_RO_PROP_DEF("credentials", credentials),
    JSOM_RO_PROP_DEF("geolocation", geolocation),
    JSOM_RO_PROP_DEF("language", language),
    JSOM_PROP_DEF("userAgent", user_agent, set_user_agent),
    JSOM_CONST_STR("platform", tool::environment::platform_name(), JS_PROP_CONFIGURABLE),
    JSOM_CONST_STR("vendor", "Sciter.JS", JS_PROP_CONFIGURABLE),
  JSOM_PASSPORT_END

  void init_Navigator_object(context& c)
  {
    JSValue navigator = JS_NewObject(c);

    auto list = Navigator_def();
    JS_SetPropertyFunctionList(c, navigator, list.start, list.length);

    JS_DefinePropertyValueStr(c, c.global(), "navigator", navigator, JS_PROP_CONFIGURABLE);
  }

}