#include "xdom.h"
#include "xom.h"
#include "xview.h"
#include "xcontext.h"

namespace qjs {

  static JSValue js_number_toLocaleString(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv) {

    xcontext c(ctx);
    double d = c.get<double>(this_val);

    bool    as_currency = false;
    int     fract_digits = 0;
    //ustring units;
    ustring locale;

    number_format_def ndef;

    if (argc >= 1)
      locale = c.get<ustring>(argv[0]);
    if (argc >= 2 && JS_IsObject(argv[1])) {
      as_currency = c.get_prop<ustring>(c.known_atoms().style, argv[1], W("")) == WCHARS("currency");
      ndef.num_digits = c.get_prop<uint_v>(c.known_atoms().maximumFractionDigits, argv[1]);
      ndef.currency_symbol = c.get_prop<ustring>(c.known_atoms().currency, argv[1], ustring());
    }
    if (!locale)
      locale = c.pdoc()->get_lang();

    tool::ftow numstr(d, W(""), ndef.num_digits.val(6));

    ustring result = as_currency
      ? format_currency_str(locale, numstr, &ndef)
      : format_number_str(locale, numstr, &ndef);

    return c.retval(result);
  }

  static int64 ms1970() {
    static int64 v = 0;
    if (!v) {
      tool::date_time dt;
      dt.set_date(1970, 1, 1);
      v = dt.absolute_millis();
    }
    return v;
  }

  static JSValue js_date_toLocaleString(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv) {

    xcontext c(ctx);
    double milliseconds_since_1970 = c.get<double>(this_val);

    tool::datetime_t t = tool::datetime_t((ms1970() + milliseconds_since_1970) * 10000);
    tool::date_time dt(t);

    ustring locale;

    bool to_local = true;
    bool long_format = true;

    int optionsIdx = 0;

    if (argc >= 1 && JS_IsString(argv[0])) {
      locale = c.get<ustring>(argv[0]);
      optionsIdx = 1;
    }
    if (argc > optionsIdx && JS_IsObject(argv[optionsIdx])) {
      if (c.get_prop<ustring>("timeZone", argv[1], W("")) == WCHARS("UTC"))
        to_local = false;

      ustring dateStyle = c.get_prop<ustring>("dateStyle", argv[optionsIdx], W(""));
      if (dateStyle == WCHARS("medium") || dateStyle == WCHARS("short"))
        long_format = false;

      ustring timeStyle = c.get_prop<ustring>("timeStyle", argv[optionsIdx], W(""));
      if (dateStyle == WCHARS("medium") || dateStyle == WCHARS("short"))
        long_format = false;
    }
    if (!locale)
      locale = c.pdoc()->get_lang();

    tool::date_time::PARTS parts = tool::date_time::DATE_TIME;

    if (to_local)
      dt.to_local();

    ustring result = dt.default_format(long_format, parts, locale);

    return c.retval(result);
  }

  static JSValue js_date_toLocaleDateString(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv) {

    xcontext c(ctx);
    double milliseconds_since_1970 = c.get<double>(this_val);

    tool::datetime_t t = tool::datetime_t((ms1970() + milliseconds_since_1970) * 10000);
    tool::date_time dt(t);

    ustring locale;

    bool to_local = true;
    bool long_format = true;

    int optionsIdx = 0;

    if (argc >= 1 && JS_IsString(argv[0])) {
      locale = c.get<ustring>(argv[0]);
      optionsIdx = 1;
    }
    if (argc > optionsIdx && JS_IsObject(argv[optionsIdx])) {
      if (c.get_prop<ustring>("timeZone", argv[1], W("")) == WCHARS("UTC"))
        to_local = false;

      ustring dateStyle = c.get_prop<ustring>("dateStyle", argv[optionsIdx], W(""));
      if (dateStyle == WCHARS("medium") || dateStyle == WCHARS("short"))
        long_format = false;

      /*ustring timeStyle = c.get_prop<ustring>("timeStyle", argv[optionsIdx], W(""));
      if (timeStyle == WCHARS("medium") || timeStyle == WCHARS("short"))
        long_format = false;*/
    }
    if (!locale)
      locale = c.pdoc()->get_lang();

    tool::date_time::PARTS parts = tool::date_time::DATE;

    if (to_local)
      dt.to_local();

    ustring result = dt.default_format(long_format, parts, locale);

    return c.retval(result);
  }

  static JSValue js_date_toLocaleTimeString(JSContext *ctx, JSValueConst this_val, int argc, JSValueConst *argv) {

    xcontext c(ctx);
    double milliseconds_since_1970 = c.get<double>(this_val);

    tool::datetime_t t = tool::datetime_t((ms1970() + milliseconds_since_1970) * 10000);
    tool::date_time dt(t);

    ustring locale;

    bool to_local = true;
    bool long_format = true;

    int optionsIdx = 0;

    if (argc >= 1 && JS_IsString(argv[0])) {
      locale = c.get<ustring>(argv[0]);
      optionsIdx = 1;
    }
    if (argc > optionsIdx && JS_IsObject(argv[optionsIdx])) {
      if (c.get_prop<ustring>("timeZone", argv[optionsIdx], W("")) == WCHARS("UTC"))
        to_local = false;

      /*ustring dateStyle = c.get_prop<ustring>("dateStyle", argv[optionsIdx], W(""));
      if (dateStyle == WCHARS("medium") || dateStyle == WCHARS("short"))
        long_format = false;*/

      ustring timeStyle = c.get_prop<ustring>("timeStyle", argv[optionsIdx], W(""));
      if (timeStyle == WCHARS("medium") || timeStyle == WCHARS("short"))
        long_format = false;
    }
    if (!locale)
      locale = c.pdoc()->get_lang();

    tool::date_time::PARTS parts = tool::date_time::TIME;

    if (to_local)
      dt.to_local();

    ustring result = dt.default_format(long_format, parts, locale);

    return c.retval(result);
  }

  void context::init_locale_functions() {
    hvalue number_prototype = JS_GetPrototype(ctx, JS_NewFloat64(ctx, 0.0));
    JSValue number_tolocale = JS_NewCFunction(ctx, js_number_toLocaleString, "toLocaleString", 0);
    JS_SetPropertyStr(ctx, number_prototype, "toLocaleString", number_tolocale);

    hvalue date_prototype = JS_GetPrototypeOfDate(ctx);
    JSValue date_tolocale = JS_NewCFunction(ctx, js_date_toLocaleString, "toLocaleString", 0);
    JSValue date_date_tolocale = JS_NewCFunction(ctx, js_date_toLocaleDateString, "toLocaleDateString", 0);
    JSValue date_time_tolocale = JS_NewCFunction(ctx, js_date_toLocaleTimeString, "toLocaleTimeString", 0);
    JS_SetPropertyStr(ctx, date_prototype, "toLocaleString", date_tolocale);
    JS_SetPropertyStr(ctx, date_prototype, "toLocaleDateString", date_date_tolocale);
    JS_SetPropertyStr(ctx, date_prototype, "toLocaleTimeString", date_time_tolocale);

  }
}