#pragma once


#ifndef __xdomjs_xframe_h__
#define __xdomjs_xframe_h__

#include "xcontext.h"
#include "xconv.h"

namespace qjs
{
  using namespace html;
  extern JSClassID Location_class_id;
  extern JSClassID History_class_id;

  struct frame_location { 
    tool::url url;
  };
  struct frame_history {
    struct state 
    {
      tool::url    url;
      gool::pointf asp; // approximated scroll position
      tool::value  data;
      array<tool::value> input_state;
    };
    array<state> stack;
    int          stack_position;
  };

  struct frame_storage {
    hash_table<string, value> items;
  };

  struct frame : public html::behavior::frame_ctl
    , public frame_history
    , public frame_location
  {
    virtual bool on(view &v, element *self, event_behavior &evt) override {
      if (evt.cmd == html::HYPERLINK_CLICK && evt.source)
        return on_hyperlink_click(v, self, evt);
    }
    bool on_hyperlink_click(view &v, element *self, event_behavior &evt);

    void save_state(view& v);
    void restore_state(view& v);    

    // this method is called in response to user actions  
    bool navigate(view &v, string href, string target = string());

    bool load_url(view &v, string url);

  };

  template <> struct conv<frame_history*>
  {
    static frame_history* unwrap(JSContext * ctx, JSValueConst v)
    {
      frame* pf = (frame*)JS_GetOpaque(v, History_class_id);
      if (!pf) throw qjs::om::type_error("Framew was deleted");
      return pf;
    }

    static JSValue wrap(JSContext * ctx, frame_history* ph) noexcept
    {
      frame* pf = static_cast<frame*>(ph);
      JSValue obj = JS_NewObjectClass(ctx, History_class_id);
      pf->add_ref();
      JS_SetOpaque(obj, pf);
      return obj;
    }
    static bool isa(JSContext * ctx, JSValueConst v) { return JS_GetOpaque(v, History_class_id) != NULL; }
  };

  template <> struct conv<frame_location*>
  {
    static frame_location* unwrap(JSContext * ctx, JSValueConst v)
    {
      frame* pf = (frame*)JS_GetOpaque(v, Location_class_id);
      if (!pf) throw qjs::om::type_error("Framew was deleted");
      return pf;
    }

    static JSValue wrap(JSContext * ctx, frame_location* ph) noexcept
    {
      frame* pf = static_cast<frame*>(ph);
      JSValue obj = JS_NewObjectClass(ctx, Location_class_id);
      pf->add_ref();
      JS_SetOpaque(obj, pf);
      return obj;
    }
    static bool isa(JSContext * ctx, JSValueConst v) { return JS_GetOpaque(v, Location_class_id) != NULL; }
  };


}

#endif