#include "xdom.h"
#include "xom.h"
#include "xview.h"
#include "xcontext.h"
#include "xframe.h"

namespace html
{
  using namespace qjs;
}

namespace qjs 
{
  enum URL_COMPARISON {
    EQUAL = 0,
    HASH_DIFFERENT = 1,
    PARAMS_DIFFERENT = 2,
    PATH_DIFFERENT = 3,
    ORIGIN_DIFFERENT = 4,
  };

  URL_COMPARISON compare(const url& a, const url& b) {
    if (a.port != b.port) return ORIGIN_DIFFERENT;
    if (a.hostname != b.hostname) return ORIGIN_DIFFERENT;
    if (a.protocol != b.protocol) return ORIGIN_DIFFERENT;

    if (a.filename != b.filename) return PATH_DIFFERENT;
    
    if (a.params != b.params) return PARAMS_DIFFERENT;

    if (a.anchor != b.anchor) return HASH_DIFFERENT;
    return EQUAL;
  }
  
  bool frame::on_hyperlink_click(view &v, element *self, event_behavior &evt) 
  {
    handle<document> current_doc = root(v, self);
    if (!current_doc) return false;

    string href = evt.target->atts.get_url(current_doc->uri().src, attr::a_href);

    if (href.is_empty()) return true;
    if (href == CHARS("#")) return true;

    string target = evt.target->atts.get_string("target");

    return navigate(v,href,target);

  }

  void frame::save_state(view &v) {

    pointf asp = _self->scroll_pos(); // approximated scroll position
    sizef vsz = _self->dim();
    asp.x /= max(1.0f, vsz.x);
    asp.y /= max(1.0f, vsz.y);
    stack[stack_position].asp = asp;

    // TODO: persist state of inputs, or at least values
  }

  void frame::restore_state(view &v) {

  }
  
  bool frame::navigate(view &v, string href, string target) {

    handle<document> current_doc = root(v, _self);
    if (!current_doc) return false;
  
    tool::url nurl(href);

    URL_COMPARISON cr = compare(current_doc->uri(), nurl);

    if (cr == EQUAL)
      return true;

    if (cr == HASH_DIFFERENT)
    {
      // event hashchange
      event_behavior ehashchange(WCHARS("hashchange"));
      ehashchange.is_bubbling = false;
      if (current_doc->on(v, ehashchange))
        return true; // handled
      if (ehashchange.is_canceled())
        return true;

      element *anchor = find_first(v, current_doc, ustring::format(W("[name='%S'],[id='%S']"), nurl.anchor.c_str(), nurl.anchor.c_str()));
      if (anchor) // found
      {
        //stack[stack_position].asp = get_asp(v, self);
        save_state(v);
        v.ensure_visible(anchor, true);
        // prune the stack
        stack.size(stack_position + 1);
        frame_history::state nst = { nurl };
        stack.push(nst);
        return true;
      }
    }
    if (!target.is_empty()) {
      if (target.like("_*")) return false;
      element *frame = find_first(v, get_history_root(v, self), ustring::format(W("frame[id='%S'],frame[name='%S'],iframe[id='%S'],iframe[name='%S']"), target.c_str(), target.c_str()));
      if (frame) // frame
      {
        handle<pump::request> prq = new pump::request(href, DATA_HTML);
        prq->dst = frame;
        //prq->initiator = evt.target;
        v.request_data(prq);
        return true;
      }
    }

    //event_behavior ebeforeunload(WCHARS("beforeunload"));
    //ebeforeunload.is_bubbling = false;
    //if (current_doc->on(v, ebeforeunload))
    //  return true;

    save_state(v);
    stack.size(stack_position + 1);
    frame_history::state nst = { nurl };
    stack.push(nst);
    return load_url(v, href);
  }

  bool frame::load_url(view &v, string url)
  {
    _awaiting = new pump::request(url, DATA_HTML);
    _awaiting->dst = _self;
    v.request_data(_awaiting);
    return true;
  }

  static bool history_back(xcontext& c, hvalue ho) {
  }
  static bool history_forward(xcontext& c, hvalue ho) {
  }
  static bool history_go(xcontext& c, hvalue ho, int steps) {
  }

  static bool history_push_state(xcontext& c, hvalue ho, int steps) {
  }
  static bool history_pop_state(xcontext& c, hvalue ho, int steps) {
  }
  
  static int history_length(xcontext& c, hvalue ho) {
  }

  static hvalue history_state(xcontext& c, hvalue ho) {
  }

   
  JSClassID History_class_id;

  JSOM_PASSPORT_BEGIN(History_def, frame)
    JSOM_CONST_STR("[Symbol.toStringTag]", "History", JS_PROP_CONFIGURABLE),
    JSOM_RO_PROP_DEF("length", history_length),
  JSOM_PASSPORT_END


}

