#pragma once

#ifndef __xdomjs_xfetch_h__
#define __xdomjs_xfetch_h__

#include "xcontext.h"
#include "xconv.h"

namespace qjs
{
  extern JSClassID Request_class_id;
  extern JSClassID Response_class_id;

  template <> struct conv<html::request*>
  {
    static html::request* unwrap(JSContext * ctx, JSValueConst v)
    {
      html::request* pe = (html::request*)JS_GetOpaque(v, Request_class_id);
      if (!pe)
        throw qjs::om::type_error("Request was deleted");
      return static_cast<html::request*>(pe);
    }

    static html::request* try_unwrap(JSContext * ctx, const JSValueConst& v, int argc = 0)
    {
      html::request* pe = (html::request*)JS_GetOpaque(v, Request_class_id);
      if (!pe) return nullptr;
      return static_cast<html::request*>(pe);
    }

    static JSValue wrap(JSContext * ctx, html::request* pr) noexcept
    {
      JSValue obj = JS_NewObjectClass(ctx, Request_class_id);
      pr->add_ref();
      JS_SetOpaque(obj, (resource*)pr);
      return obj;
    }
    static bool isa(JSContext * ctx, JSValueConst v) { return JS_GetOpaque(v, Request_class_id) != NULL; }
  };

  template <> struct conv<html::response *> {
    static html::response *unwrap(JSContext *ctx, JSValueConst v) {
      html::request *pe = (html::request *)JS_GetOpaque(v, Response_class_id);
      if (!pe) throw qjs::om::type_error("Response was deleted");
      return static_cast<html::response *>(pe);
    }

    static html::response *try_unwrap(JSContext *ctx, const JSValueConst &v, int argc = 0) {
      html::request *pe = (html::request *)JS_GetOpaque(v, Response_class_id);
      if (!pe) return nullptr;
      return static_cast<html::response *>(pe);
    }

    static JSValue wrap(JSContext *ctx, html::response *prr) noexcept {
      JSValue obj = JS_NewObjectClass(ctx, Response_class_id);
      html::request *pr  = prr->as_request();
      pr->add_ref();
      JS_SetOpaque(obj, (resource *)pr);
      return obj;
    }
    static bool isa(JSContext *ctx, JSValueConst v) { return JS_GetOpaque(v, Response_class_id) != NULL; }
  };

  inline html::request*  request_ptr_of(JSContext * ctx, JSValueConst obj) {
    html::request* pe = (html::request*)JS_GetOpaque(obj, Request_class_id);
    return pe;
  }

  inline html::response *reponse_ptr_of(JSContext *ctx, JSValueConst obj) {
    html::request *pe = (html::request *)JS_GetOpaque(obj, Response_class_id);
    return static_cast<html::response *>(pe);
  }


}

#endif
