
#include "html.h"
#include "xdom.h"
#include "xom.h"
#include "xview.h"
#include "xcontext.h"
#include "xevent.h"

namespace html
{
  using namespace qjs;

  bool event_target::handle_event(context& ctx, event& evt)
  {
    xcontext& c = static_cast<xcontext&>(ctx);
#ifdef DEBUG
#if 1
    element* pe = static_cast<element*>(this);
    //pe->evt().dbg_report("event");
    if (pe->tag == html::tag::T_HTML
      && evt.event_group() == html::HANDLE_BEHAVIOR_EVENT
      && evt.cmd == html::SELECT_VALUE_CHANGED) {
      pe->dbg_report("handling input 1"); //?
      pe = pe;
    }

    if (pe->tag == html::tag::T_PLAINTEXT
      && evt.event_group() == html::HANDLE_COMMAND
      && evt.cmd == (html::event_command::CHECK | EVENT_SINKING)) {
      pe->dbg_report("handling cb 2"); //?
      pe = pe;
    }

#endif
#endif

    hvalue obj;
    if (!get_expando(ctx, obj))
      return false;

    ustring en = evt.event_type_name();
    if (!en.length())
      return false; // not for script

    bool handled = false;
    for (int n = subscriptions.last_index(); n >= 0; --n)
    {
      if (n >= subscriptions.size()) {
        n = subscriptions.size();
        continue;
      }
      tool::handle<subscription> ps = subscriptions[n];
      bool to_remove = ps->once;
      html::helement principal;
      if (ps->fcn && evt.match(*ctx.pview(), *ps, principal))
      {
        bool was_handled = evt.is_handled();
        try {
          hvalue rv;
          if (c.is_function(ps->fcn)) {
            c.call(rv, ps->fcn, obj, &evt, principal);
          }
          else {
            hvalue handleEvent = c.get_prop<hvalue>(c.known_atoms().handleEvent, ps->fcn);
            assert(handleEvent);
            c.call(rv, handleEvent, ps->fcn, &evt, principal);
          }
          if (rv == JS_TRUE)
            evt.stop_propagation();
          if (evt.is_handled() && !was_handled)
            handled = true;
        }
        catch (qjs::exception) {
          c.report_exception();
          to_remove = true;
          break;
        }
      }
      if (to_remove)
        subscriptions.remove(n);
    }

    if (!handled && en.length() && !evt.is_sinking() && !evt.is_canceled() && (evt.is_on_target(this)))
    {
      string onname = string::format("on%S", en.c_str());
      hvalue rv;
      hvalue fcn = c.get_prop<hvalue>(onname.c_str(), obj);
      bool   was_handled = evt.is_handled();
      if (fcn.is_defined())
      {
        try {
          if (c.is_function(fcn)) {
            c.call(rv, fcn, obj, &evt);
          }
          else {
            hvalue handleEvent = c.get_prop<hvalue>(c.known_atoms().handleEvent, fcn);
            if (c.is_function(handleEvent)) {
              assert(handleEvent);
              c.call(rv, handleEvent, fcn, &evt);
            }
          }
          if (rv == JS_TRUE)
            evt.stop_propagation();
          if (evt.is_handled() && !was_handled)
            handled = true;
        }
        catch (qjs::exception) {
          c.report_exception();
        }
      }
    }

    // class handlers
    if (!handled)
    {

      hvalue map = JS_GetPrototype(c, obj);
      JSClassID cid = JS_GetClassID(obj, NULL);
      hvalue class_proto = JS_GetClassProto(c, cid);

      while (map && JS_IsObject(map))
      {
        if (map == class_proto)
          break;
        JSPropertyEnum* tab = nullptr;
        uint32_t len = 0;
        JS_GetOwnPropertyNames(c, &tab, &len, map, JS_GPN_STRING_MASK);
        for (uint32_t n = 0; n < len; ++n) {
          atom_chars pname(c, tab[n].atom);
          //dbg_printf("atom %s\n", pname);
          if (pname.length > 2 && pname[2] == ' ' && pname[0] == 'o' && pname[1] == 'n') {
            chars name = pname(3);
            chars selector;
            int pos = name.index_of(CHARS(" at "));
            if (pos > 0) {
              selector = name(pos + 4);
              name.length = uint(pos);
            }
            html::subscription sub(name);
            sub.event_selector = ustring(selector);

            html::helement principal;
            if (evt.match(*c.pview(), sub, principal, static_cast<element*>(this))) {
              hvalue proto = JS_GetPrototype(c, obj);
              hvalue handler = JS_GetProperty(c, proto, tab[n].atom);
              assert(JS_IsFunction(c, handler));
              try {
                hvalue rv;
                c.call(rv, handler, obj, &evt, principal);
                if (rv == JS_TRUE)
                  evt.stop_propagation();
                if (handled = evt.is_handled())
                  break;
              }
              catch (qjs::exception) {
                c.report_exception();
              }
            }
          }

        }
        js_free_prop_enum(c, tab, len);
        map = JS_GetPrototype(c, map);
      }
    }

    return handled;
  }
}

namespace qjs {

  using namespace html;
  using namespace tool;

  JSClassID Event_class_id = 0;

  /*html::event_proxy*event_ptr_of(JSContext* ctx, JSValueConst obj) {
    void* opaque = nullptr;
    JSClassID cid = JS_GetClassID(obj, &opaque);
    if (cid == Event_class_id)
      return (html::event*)opaque;
    hvalue cproto = JS_GetClassProto(ctx, Event_class_id);
    if (obj == cproto) {
      static handle<html::event_behavior> event_proto = new html::event_behavior();
      return event_proto;
    }
    return nullptr;
  }*/

  uint event_phase(xcontext&, event_proxy* pe) {
    enum PHASE {
      CAPTURING_PHASE = 1,
      AT_TARGET = 2,
      BUBBLING_PHASE = 3
    };
    if (pe->evt().is_sinking()) return CAPTURING_PHASE;
    return BUBBLING_PHASE;
  }
  bool stop_propagation(xcontext&, event_proxy*pe) {
    pe->evt().stop_propagation();
    return true;
  }
  bool prevent_default(xcontext&, event_proxy*pe) {
    pe->evt().prevent_default();
    return true;
  }

  bool bubbles(xcontext&, event_proxy*pe) {
    return pe->evt().event_bubbling();
  }

  bool cancelable(xcontext&, event_proxy*pe) {
    return pe->evt().event_cancelable();
  }

  element* event_target(xcontext&, event_proxy*pe) {
    return pe->evt().target;
  }

  element* event_source(xcontext&, event_proxy*pe) {
    return pe->evt().event_source();
  }

  void event_set_source(xcontext&, event_proxy*pe, element* ps) {
    return pe->evt().event_source(ps);
  }


  element* event_processing_target(xcontext&, event_proxy*pe) {
    return pe->evt().processing_target;
  }

  ustring event_type_name(xcontext&, event_proxy*pe) {
    ustring s = pe->evt().event_type_name();
    if (s.is_undefined())
      return WCHARS("unknown");
    return s;
  }

  tool::value event_data(xcontext&, event_proxy*pe) {
    return pe->evt().event_detail();
  }

  void event_set_data(xcontext&, event_proxy*pe, tool::value val) {
    pe->evt().event_data(val);
  }

  tool::value event_detail(xcontext&, event_proxy*pe) {
    return pe->evt().event_detail();
  }

  void event_set_detail(xcontext&, event_proxy*pe, tool::value val) {
    pe->evt().event_detail(val);
  }


  uint event_reason(xcontext&, event_proxy*pe) {
    return pe->evt().event_reason();
  }
  void event_set_reason(xcontext&, event_proxy*pe, uint val) {
    pe->evt().event_reason(val);
  }


  bool  event_alt_key(xcontext&, event_proxy*pe) { return (pe->evt().get_alt_state() & ALT_ALT) != 0; }
  bool  event_ctrl_key(xcontext&, event_proxy*pe) { return (pe->evt().get_alt_state() & ALT_CONTROL) != 0; }
  bool  event_meta_key(xcontext&, event_proxy*pe) { return (pe->evt().get_alt_state() & ALT_COMMAND) != 0; }
  bool  event_shift_key(xcontext&, event_proxy*pe) { return (pe->evt().get_alt_state() & ALT_SHIFT) != 0; }
  int_v event_button(xcontext&, event_proxy*pe) { return pe->evt().get_mouse_button(); }
  int_v event_buttons(xcontext&, event_proxy*pe) { return pe->evt().get_mouse_buttons(); }
  float event_client_x(xcontext& c, event_proxy*pe) { 
    pointf ppx = pe->evt().get_view_pos() - (pe->evt().target ? pe->evt().target->doc()->view_pos(*c.pview()) : point(0, 0));
    return c.pview()->ppx_to_px(ppx).x; 
  }
  float event_client_y(xcontext& c, event_proxy*pe) {
    pointf ppx = pe->evt().get_view_pos() - (pe->evt().target ? pe->evt().target->doc()->view_pos(*c.pview()) : point(0, 0));
    return c.pview()->ppx_to_px(ppx).y;
  }
  int   event_screen_x(xcontext& c, event_proxy*pe) { 
    // not clear what is that: screen pixels or "CSS pixels" ?
    return pe->evt().get_view_pos().x + c.pview()->client_screen_pos().x; 
  }
  int   event_screen_y(xcontext& c, event_proxy*pe) { 
    // not clear what is that: screen pixels or "CSS pixels" ?
    return pe->evt().get_view_pos().y + c.pview()->client_screen_pos().y; 
  }
  float   event_window_x(xcontext& c, event_proxy*pe) {
    point ppx = pe->evt().get_view_pos();
    return c.pview()->ppx_to_px(ppx).x;
  }
  float   event_window_y(xcontext& c, event_proxy*pe) {
    point ppx = pe->evt().get_view_pos();
    return c.pview()->ppx_to_px(ppx).y;
  }


  float event_x(xcontext& c, event_proxy*pe) { 
    pointf ppx = pe->evt().get_pos();
    // NOTE: non standard
    return c.pview()->ppx_to_px(ppx).x;
  }
  float event_y(xcontext& c, event_proxy*pe) {
    pointf ppx = pe->evt().get_pos();
    // NOTE: non standard
    return c.pview()->ppx_to_px(ppx).y;
  }

  hvalue event_delta_x(xcontext& c, event_proxy*pe) {
    if (html::event_mouse* me = pe->evt().cast<html::event_mouse>()) {
      if (me->cmd_no_flags() == mouse_events::MOUSE_WHEEL)
        return c.val(me->wheel_delta_xy().x);
    }
    return JS_UNDEFINED;
  }
  hvalue event_delta_y(xcontext& c, event_proxy*pe) {
    if (event_mouse* me = pe->evt().cast<event_mouse>()) {
      if (me->cmd_no_flags() == mouse_events::MOUSE_WHEEL)
        return c.val(-me->wheel_delta_xy().y);
    }
    return JS_UNDEFINED;
  }

  hvalue event_delta_z(xcontext& c, event_proxy*pe) { return JS_UNDEFINED; }

  hvalue event_delta_mode(xcontext& c, event_proxy*pe) {
    if (event_mouse* me = pe->evt().cast<event_mouse>()) {
      if (me->cmd_no_flags() == mouse_events::MOUSE_WHEEL)
#ifdef USE_TOUCH
        return me->is_touch()? c.val(0)/*DOM_DELTA_PIXEL*/ : c.val(1/*DOM_DELTA_LINE*/);
#else
        return c.val(1/*DOM_DELTA_LINE*/);
#endif
    }
    return JS_UNDEFINED;
  }

  hvalue event_is_on_icon(xcontext& c, event_proxy*pe) {
    if (event_mouse* me = pe->evt().cast<event_mouse>()) {
      return c.val(me->is_on_icon);
    }
    return JS_UNDEFINED; 
  }

  string  event_key_code_str(xcontext& c, event_proxy*pe) {
    if (pe->evt().event_group() == html::HANDLE_KEY) {
      if (pe->evt().event_type() == html::KEY_DOWN || pe->evt().event_type() == html::KEY_UP) {
        ustring s = get_key_name(pe->evt().get_key_code());
        return string::format("Key%S", s.c_str());
      }
    }
    return string();
  }

  uint_v event_key_code_code(xcontext& c, event_proxy*pe) {
    if (pe->evt().event_group() == html::HANDLE_KEY) {
      if (pe->evt().event_type() == html::KEY_DOWN || pe->evt().event_type() == html::KEY_UP) {
        return pe->evt().get_key_code();
      }
    }
    return uint_v();
  }

  ustring event_key_char(xcontext& c, event_proxy*pe) {
    if (pe->evt().event_group() == html::HANDLE_KEY) {
      if (pe->evt().event_type() == html::KEY_CHAR) {
        wchar W[3] = { 0 };
        u16::putc(uint(pe->evt().get_key_code()), W);
        return W;
      }
    }
    return ustring();
  }

  hvalue Event_keyState(xcontext& c, string key_name) {
    chars name = key_name;
    if (name.starts_with(CHARS("Key"))) name.prune(3);
    uint kc = get_key_code_by_name(key_name);
    if (!kc) return hvalue();
    return c.val(html::event::get_key_state(kc));
  }

  JSOM_PASSPORT_BEGIN(Event_def, html::event)
    JSOM_CONST_STR("[Symbol.toStringTag]", "Event", JS_PROP_CONFIGURABLE),
    JSOM_RO_PROP_DEF("bubbles", bubbles),
    JSOM_RO_PROP_DEF("cancelable", cancelable),
    JSOM_RO_PROP_DEF("currentTarget", event_processing_target),
    //JSOM_RO_PROP("defaultPrevented", bubbles), TODO
    JSOM_RO_PROP_DEF("eventPhase", event_phase),
    //JSOM_RO_PROP("isTrusted", bubbles), TODO
    JSOM_RO_PROP_DEF("target", event_target),
    JSOM_RO_PROP_DEF("type", event_type_name),

    JSOM_PROP_DEF("detail", event_detail, event_set_detail),
    JSOM_PROP_DEF("data", event_data, event_set_data),
    JSOM_PROP_DEF("reason", event_reason, event_set_reason),
    JSOM_PROP_DEF("source", event_source, event_set_source),

    JSOM_RO_PROP_DEF("altKey", event_alt_key),
    JSOM_RO_PROP_DEF("ctrlKey", event_ctrl_key),
    JSOM_RO_PROP_DEF("metaKey", event_meta_key),
    JSOM_RO_PROP_DEF("shiftKey", event_shift_key),
    JSOM_RO_PROP_DEF("button", event_button),
    JSOM_RO_PROP_DEF("buttons", event_buttons),
    JSOM_RO_PROP_DEF("clientX", event_client_x),
    JSOM_RO_PROP_DEF("clientY", event_client_y),
    JSOM_RO_PROP_DEF("screenX", event_screen_x),
    JSOM_RO_PROP_DEF("screenY", event_screen_y),
    JSOM_RO_PROP_DEF("windowX", event_window_x),
    JSOM_RO_PROP_DEF("windowY", event_window_y),
    JSOM_RO_PROP_DEF("x", event_x),
    JSOM_RO_PROP_DEF("y", event_y),
    JSOM_RO_PROP_DEF("isOnIcon", event_is_on_icon),

    JSOM_RO_PROP_DEF("deltaX", event_delta_x),
    JSOM_RO_PROP_DEF("deltaY", event_delta_y),
    JSOM_RO_PROP_DEF("deltaZ", event_delta_z),
    JSOM_RO_PROP_DEF("deltaMode", event_delta_mode),

    JSOM_RO_PROP_DEF("code", event_key_code_str),
    JSOM_RO_PROP_DEF("keyCode", event_key_code_code),
    JSOM_RO_PROP_DEF("key", event_key_char),

    JSOM_FUNC_DEF("preventDefault", prevent_default),
    JSOM_FUNC_DEF("stopImmediatePropagation", stop_propagation),  // but ptrobably is OK
    JSOM_FUNC_DEF("stopPropagation", stop_propagation),           // but ptrobably is OK

    JSOM_PASSPORT_END

    JSOM_PASSPORT_BEGIN(Event_static_def, qjs::xcontext)

      JSOM_GLOBAL_FUNC_DEF("keyState", Event_keyState),

    JSOM_PASSPORT_END


  void init_Event_class(context& c)
  {
    JS_NewClassID(&Event_class_id);

    static JSClassDef Event_class = {
      "Event",
      [](JSRuntime *rt, JSValue val)
      {
        html::event_proxy* pe = (html::event_proxy*)JS_GetOpaque(val,Event_class_id);
        if (pe) {
          pe->release();
        }
      }
    };

    JS_NewClass(JS_GetRuntime(c), Event_class_id, &Event_class);
    JSValue event_proto = JS_NewObject(c);

    auto list = Event_def();
    JS_SetPropertyFunctionList(c, event_proto, list.start, list.length);

    auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
    {
      if (argc == 0 || !JS_IsString(argv[0]))
        return JS_ThrowTypeError(ctx, "expecting event type name");
#if 1
      JSValue obj = JS_UNDEFINED;
      JSValue init = JS_UNINITIALIZED;
      JSValue proto;
      handle<html::event_proxy> ppe;
      ustring eventype;
      html::subscription subs;

      /* using new_target to get the prototype is necessary when the class is extended. */
      proto = JS_GetPropertyStr(ctx, new_target, "prototype");
      if (JS_IsException(proto))
        goto fail;
      obj = JS_NewObjectProtoClass(ctx, proto, Event_class_id);
      JS_FreeValue(ctx, proto);
      if (JS_IsException(obj))
        goto fail;

      if (argc > 1 && JS_IsObject(argv[1]))
        init = argv[1];

      eventype = conv<ustring>::unwrap(ctx, argv[0]);
      subs.parse(eventype);
      switch (subs.event_group.val(0))
      {
      case html::HANDLE_BEHAVIOR_EVENT: {
        html::event_behavior *pevt = new html::event_behavior();
        pevt->cmd = subs.event_type;
        pevt->name = subs.event_name;
        pevt->ns = subs.event_ns;
        pevt->event_bubbling(false);
        pevt->event_cancelable(false);
        ppe = new event_proxy(pevt);
      }
      break;
      case html::HANDLE_MOUSE: {
        html::event_mouse* pevt = new html::event_mouse();
        pevt->cmd = subs.event_type;
        pevt->ns = subs.event_ns;
        pevt->event_bubbling(false);
        pevt->event_cancelable(false);

        if (init)
        {
          xcontext c(ctx);
          bool flag;
          if (c.check_prop("ctrlKey", init, flag) && flag) pevt->alt_state |= ALT_CONTROL;
          if (c.check_prop("shiftKey", init, flag) && flag) pevt->alt_state |= ALT_SHIFT;
          if (c.check_prop("altKey", init, flag) && flag) pevt->alt_state |= ALT_ALT;
          if (c.check_prop("metaKey", init, flag) && flag) pevt->alt_state |= ALT_COMMAND;

          pointf pt;
          if (c.check_prop("screenX", init, pt.x) && c.check_prop("screenY", init, pt.y)) {
            // map 
          }
          if (c.check_prop("clientX", init, pt.x) && c.check_prop("clientY", init, pt.y)) {
            // map 
          }
          int n;
          if (c.check_prop("button", init, n)) {
#pragma TODO("Am I right here")
            pevt->button_state = 1 << n; 
          }
          if (c.check_prop("buttons", init, n)) pevt->button_state = n;
          //helement target;  ????
          //if (c.get_prop("relatedTarget", init, target)) pevt->target = target;
        }
        ppe = new event_proxy(pevt);
      }
      break;
      case html::HANDLE_KEY: {
        html::event_key* pevt = new html::event_key();
        pevt->cmd = subs.event_type;
        pevt->ns = subs.event_ns;

        if (init)
        {
          xcontext c(ctx);
          bool flag;
          if (c.check_prop("ctrlKey", init, flag) && flag) pevt->alt_state |= ALT_CONTROL;
          if (c.check_prop("shiftKey", init, flag) && flag) pevt->alt_state |= ALT_SHIFT;
          if (c.check_prop("altKey", init, flag) && flag) pevt->alt_state |= ALT_ALT;
          if (c.check_prop("metaKey", init, flag) && flag) pevt->alt_state |= ALT_COMMAND;

          string k;
          if (c.check_prop("key", init, k) && (pevt->cmd == html::KEY_CHAR)) {
            bytes b = k.chars_as_bytes();
            pevt->key_code = u8::getc(b);
          }
          else if (c.check_prop("code", init, k) && (pevt->cmd == html::KEY_DOWN || pevt->cmd == html::KEY_UP)) {
            string justcode = k()(3);
            if (justcode)
              for (uint n = 1; n <= 0xFF; ++n) {
                string s = get_key_name(n);
                if (justcode == s) {
                  pevt->key_code = n;
                  break;
                }
              }
          }
        }
        ppe = new event_proxy(pevt);
      }
      break;
      default:
        return JS_ThrowTypeError(ctx, "unsupported event type");
      }

      if (init)
      {
        xcontext c(ctx);
        ppe->evt().event_bubbling(c.get_prop<bool>("bubbles", init, false));
        ppe->evt().event_cancelable(c.get_prop<bool>("cancelable", init, false));
        tool::value data;
        if (c.check_prop<tool::value>("detail", init, data))
          ppe->evt().event_data(data);
        else if (c.check_prop<tool::value>("data", init, data))
          ppe->evt().event_data(data);
      }
#else
      JSValue obj = JS_UNDEFINED;
      /* using new_target to get the prototype is necessary when the class is extended. */
      JSValue proto = JS_GetPropertyStr(ctx, new_target, "prototype");
      if (JS_IsException(proto))
        goto fail;
      obj = JS_NewObjectProto(ctx, proto);
      JS_FreeValue(ctx, proto);
      if (JS_IsException(obj))
        goto fail;
      {
        xcontext c(ctx);
        ustring eventype = conv<ustring>::unwrap(ctx, argv[0]);
        c.set_prop(c.known_atoms().type, obj, eventype);
        if (argc > 1 && JS_IsObject(argv[1]))
          c.set_prop(c.known_atoms().init, obj, JS_DupValue(ctx, argv[1]));
      }
#endif
      JS_SetOpaque(obj, ppe.detach());

      return obj;
    fail:
      JS_FreeValue(ctx, obj);
      return JS_EXCEPTION;
    };

    hvalue event_class = JS_NewCFunction2(c, ctor, "Event", 2, JS_CFUNC_constructor, 0);

    JS_DefinePropertyValueStr(c, c.global(), "Event", JS_DupValue(c, event_class), JS_PROP_WRITABLE | JS_PROP_CONFIGURABLE);
    JS_DefinePropertyValueStr(c, c.global(), "CustomEvent", JS_DupValue(c, event_class), JS_PROP_WRITABLE | JS_PROP_CONFIGURABLE);
    
    auto Event_statics = Event_static_def();
    JS_SetPropertyFunctionList(c, event_class, Event_statics.start, Event_statics.length);

    JS_SetConstructor(c, event_class, event_proto);
    JS_SetClassProto(c, Event_class_id, event_proto);
  }

}
