#include "xdom.h"
#include "xom.h"
#include "xview.h"
#include "xcontext.h"
#include "xclasslist.h"
#include "xattributeslist.h"
#include "xnodelist.h"
#include "xchildren.h"
#include "xreactor.h"
#include "xrange.h"
#include "xevent.h"
#include "xselection.h"

#ifdef DEBUG
extern "C" void show_opaque(void* p) {
  //((html::element*)p)->dbg_report("leak");
}
#endif

namespace html
{
  using namespace qjs;

  //script_expando_interface
  bool element::get_expando(context& hc, script_expando& seo) {
    if (!obj)
      return false;
    qjs::xcontext& c = static_cast<qjs::xcontext&>(hc);
    seo = c.val(this);
    return true;
  }

  struct element_proto : public html::element {
    element_proto() : element(html::tag::T__UNKNOWN) {}
    virtual string    node_def() const override { return string("Element(prototype of)"); }
  };

}

namespace qjs {

  using namespace html;
  using namespace tool;

  JSClassID Element_class_id = 0;

  html::element* element_ptr_of(JSContext* ctx, JSValueConst obj) {
    void* opaque = nullptr;
    JSClassID cid = JS_GetClassID(obj, &opaque);
    if (cid == Element_class_id
      || cid == Document_class_id
      || cid == Style_class_id
      || cid == ElementState_class_id
      || cid == NodeList_class_id
      || cid == ElementList_class_id)
      return (html::element*)(html::node*)opaque;

    hvalue cproto = JS_GetClassProto(ctx, Element_class_id);
    if (obj == cproto) {
      static helement element_proto = new html::element_proto();
      return element_proto;
    }
    return nullptr;
  }

  bool can_get_element_from(JSContext* ctx, JSValueConst obj) {
    JSClassID cid = JS_GetClassID(obj, NULL);
    if (cid == Element_class_id
      || cid == Document_class_id
      || cid == Style_class_id
      || cid == ElementState_class_id
      || cid == NodeList_class_id
      || cid == ElementList_class_id)
      return true;
    return false;
  }

  inline helement logical_container(element* el) { return el->logical_container(); }

  string    node_def(xcontext& c, element *el) { return el->node_def(); }

  ustring   get_text(xcontext& c, element *el) { return el->get_text(*c.pview());   }
  void      set_text(xcontext& c, element *el, ustring text) { 
    auto cel = logical_container(el);
    if (!cel) qjs::om::type_error("operation disabled");
    cel->set_text(*c.pview(), text); /*?????*/ 
  }

  tool::string inner_html(xcontext&, element *el) {
    html::ostream_8 os;
    el->emit_content(os);
    return os.data();
  }

  tool::string outer_html(xcontext& c, element *el) {
    html::ostream_8 os;
    el->emit(os);
    return os.data();
  }

  ustring   attr_class(xcontext& c, element *el) { return el->attr_class(); }
  void      set_attr_class(xcontext& c, element *el, ustring cls) { el->set_attr(attr::a_class, cls, c.pview()); }
  
  ustring   attr_id(xcontext& c, element *el) { return el->attr_id(); }
  void      set_attr_id(xcontext& c, element *el, ustring id) { el->set_attr(*c.pview(),attr::a_id,id); }

  ustring   attr_name(xcontext& c, element *el) { return el->attr_name(); }
  void      set_attr_name(xcontext& c, element *el, ustring nm) { el->set_attr(*c.pview(), attr::a_name, nm); }

  string    tag_upper(xcontext& c, element *el) { return el->node_name().to_upper(); }
  string    tag(xcontext& c, element *el) { return el->node_name(); }
  uint      element_index(xcontext& c, element *el) { return uint(el->index()); }

  element* next_element(xcontext&, element *el) { return el->next_element(); }
  element* prev_element(xcontext&, element *el) { return el->prev_element(); }
  element* first_element(xcontext&, element *el) { auto cel = logical_container(el); return cel ? cel->first_element() : nullptr; }
  element* last_element(xcontext&, element *el) { auto cel = logical_container(el); return cel? cel->last_element() : nullptr; }
  uint     element_count(xcontext&, element *el) { auto cel = logical_container(el); return cel? cel->n_children() : 0; }
  element* element_child(xcontext&, element *el, int n) { auto cel = logical_container(el); return cel? cel->child(n) : nullptr; }

  bool     append_child(xcontext& c, element *el, node *n) { 
    auto cel = logical_container(el);
    if (!cel) qjs::om::type_error("operation disabled");
    cel->append(n, c.pview());
    return true; 
  }
  hvalue   remove_child(xcontext& c, element *el, node* child) { 
    if (!child || child->parent != logical_container(el))
      throw om::type_error("node is not a child of the element");
    child->remove(true,c.pview()); 
    return hvalue();
  }
  hnode    replace_child(xcontext& c, element *el, hnode new_child, hnode old_child) {
    auto cel = logical_container(el);
    if (!cel) qjs::om::type_error("operation disabled");
    if (!new_child || new_child->parent != cel) return nullptr;
    if (!old_child || old_child->parent != cel) return nullptr;
    if (old_child == new_child) return new_child;
    cel->replace_child(old_child, new_child, c.pview());
    return old_child;
  }
  value   get_attribute(xcontext& c, element *el, string name) {
    ustring v;
    if (el->atts.exist(name_or_symbol(name), v))
      return value(v);
    return value::null_val();
  }

  array<string> get_attribute_names(xcontext& c, element *el) {
    array<string> list;
    el->atts.names(list);
    return list;
  }

  bool remove_attribute(xcontext& c, element *el, string name) {
    return el->remove_attr(name_or_symbol(name), c.pview());
  }

  bool set_attribute(xcontext& c, element *el, string name, ustring val) {
    el->check_layout(*c.pview());
    return el->set_attr(name_or_symbol(name), val, c.pview());
  }

  bool has_attribute(xcontext& c, element *el, string name) {
    return el->atts.exist(name);
    //return el->set_attr(name_or_symbol(name), val, c.pview());
  }
  bool has_attributes(xcontext& c, element *el) {
    return el->atts.length() > 0;
  }

  attribute_list_provider* get_attributes(xcontext& c, element *el) {
    return el;
  }

  class_list_provider* get_classlist(xcontext& c, element *el) {
    return el;
  }

  style_provider* get_style_provider(xcontext&, element *el) {
    //if(el && el->doc())
    //  return el; // style of removed element, does it make sense ?
    return el; 
  }

  state_provider* get_state_provider(xcontext&, element *el) {
    if (el && el->doc())
      return el;
    return nullptr;
  }

  //int  get_width(xcontext&, element *el) { return el->dim().x; }
  //int  get_height(xcontext&, element *el) { return el->dim().y; }

  node* insert_before(xcontext& c, helement pe, hnode other, hnode reference_child) {
    hnode holder = other;
    auto cel = logical_container(pe);
    if (!cel) qjs::om::type_error("operation disabled");
    if (!reference_child || (reference_child->parent != pe))
      cel->append(other, c.pview());
    else
      cel->insert(reference_child->node_index, other, c.pview());
    return other;
  }

  node* insert_after(xcontext& c, helement pe, hnode other, hnode reference_child) {
    hnode holder = other;
    auto cel = logical_container(pe);
    if (!cel) qjs::om::type_error("operation disabled");
    if (!reference_child || (reference_child->parent != pe))
      cel->append(other, c.pview());
    else
      cel->insert(reference_child->node_index + 1, other, c.pview());
    return other;
  }

  bool element_swapWith(xcontext& c, helement self, helement other) {

    if (!self || !other) return false;

    if (!html::element::swap_locations(self, other, c.pview()))
      throw qjs::om::type_error("swapWith: incompatible locations");
    
    return true;
  }


  tool::ustring inner_text(xcontext& c, element* pe)
  {
    behavior_h pc = pe->behavior;
    if (pc) {
      ustring us;
      while (pc) {
        if (pc->get_text(*c.pview(), pe, us))
          return us;
        pc = pc->next;
      }
    }

    if (pe->nodes.size() == 0) return wchars();
    if (pe->nodes.size() == 1 && pe->nodes[0]->is_text())
      // simple element containing one text node
      return pe->nodes[0].ptr_of<text>()->chars();
    array<wchar> text_buffer;
    pe->emit_text(text_buffer, true);
    return text_buffer();
  }

  bool set_inner_text(xcontext& c, element* pe, ustring t)
  {
    auto cel = logical_container(pe);
    if (!cel) qjs::om::type_error("operation disabled");

    behavior_h pc = cel->behavior;

    cel->refresh(*c.pview());

    if (pc) {
      while (pc) {
        if (pc->set_text(*c.pview(), pe, t)) return true;
        pc = pc->next;
      }
    }
    cel->nodes.clear();
    cel->append(new text(t), c.pview());
    return true;
  }

  bool set_inner_html(xcontext& c, element* pe, string html) {
    auto cel = logical_container(pe);
    if (!cel) qjs::om::type_error("operation disabled");

    c.pview()->set_element_html(cel, html.chars_as_bytes(), html::SE_REPLACE, c.pdoc()->uri().src);
    return true;
  }

  bool rx_content(xcontext& c, helement el, hvalue what)
  {
    auto cel = logical_container(el);
    if (!cel) qjs::om::type_error("operation disabled");

    if (JS_IsString(what))
      return set_inner_html(c, cel, c.get<string>(what));
    if (is_vnode(c, what)) {
      element_creator_ctx ectx(c, what, el);
      html::mutator_ctx _(el, c.pview());
      cel->clear(c.pview());
      helement he = ectx.make();
      if (he)
        cel->append(he,c.pview());
      return true;
    }
    else if (c.is_array(what))
    {
      html::mutator_ctx _(el, c.pview());
      cel->clear(c.pview());
      array<hnode> nodes;
      c.each_item(what, [&](uint i, hvalue item) {
        if (is_vnode(c, item)) {
          element_creator_ctx ectx(c, item, cel);
          nodes.push(ectx.make(false));
        }
        else if (node* pn = node_ptr_of(c, item)) {
          nodes.push(pn);
        }      
      });
      cel->append_nodes(nodes(), c.pview());
      return true;
    }
    else if (node* pn = node_ptr_of(c, what)) {
      cel->clear(c.pview());
      cel->append(pn, c.pview());
      return true;
    }
    else
      return set_inner_text(c, cel, c.get<ustring>(what));
  }

  bool rx_append(xcontext& c, helement el, hvalue what)
  {
    auto cel = logical_container(el);
    if (!cel) qjs::om::type_error("operation disabled");

    if (is_vnode(c, what)) {
      element_creator_ctx ectx(c, what, cel);
      html::mutator_ctx _(cel, c.pview());
      helement he = ectx.make(false);
      if (he)
        cel->append(he, c.pview());
      return true;
    }
    else if(c.is_array(what))
    {
      html::mutator_ctx _(cel, c.pview());
      array<hnode> nodes;
      c.each_item(what, [&](uint i, hvalue item) {
        if (is_vnode(c, item)) {
          element_creator_ctx ectx(c, item, cel);
          nodes.push(ectx.make(false));
        }
        else if(node* pn = node_ptr_of(c,item)) {
          nodes.push(pn);
        }
      });
      cel->append_nodes(nodes(), c.pview());
      return true;
    }
    else if (node* pn = node_ptr_of(c, what)) {
      cel->append(pn, c.pview());
      return true;
    }
    string html = c.get<string>(what);
    return c.pview()->set_element_html(cel, html.chars_as_bytes(), html::SE_TYPE::SE_APPEND, c.pdoc()->uri().src);
  }

  helement rx_component_update(xcontext& c, helement el, hvalue props);

  bool rx_prepend(xcontext& c, helement el, hvalue what)
  {
    auto cel = logical_container(el);
    if (!cel) qjs::om::type_error("operation disabled");

    if (is_vnode(c, what)) {
      element_creator_ctx ectx(c, what, el);
      html::mutator_ctx _(cel, c.pview());
      helement he = ectx.make(true);
      if (he)
        cel->append(he, c.pview());
      return true;
    } else if (c.is_array(what)) {
      html::mutator_ctx _(cel, c.pview());
      array<hnode> nodes;
      c.each_item(what, [&](uint i, hvalue item) {
        if (is_vnode(c, item)) {
          element_creator_ctx ectx(c, item, cel);
          nodes.push(ectx.make(false));
        }
        else if (node* pn = node_ptr_of(c, item)) {
          nodes.push(pn);
        }
      });
      el->insert_nodes(0,nodes(), c.pview());
      return true;
    }
    else if (node* pn = node_ptr_of(c, what)) {
      cel->insert(0, pn, c.pview());
      return true;
    }
    string html = c.get<string>(what);
    return c.pview()->set_element_html(cel, html.chars_as_bytes(), html::SE_TYPE::SE_INSERT, c.pdoc()->uri().src);
  }

  helement rx_patch(xcontext &c, helement el, hvalue what, tristate_v only_children = tristate_v());

  bool set_outer_html(xcontext&c, element* pe, string html) {
    handle<element> self = pe;
    c.pview()->set_element_html(self, html.chars_as_bytes(), html::SE_OUTER_REPLACE, c.pdoc()->uri().src);
    return true;
  }

  bool insert_adjacent_html(xcontext& c, element* pe, string where, string html) {
    if (html.length() == 0)
      return false;
    auto cel = logical_container(pe);
    if (!cel) qjs::om::type_error("operation disabled");

    html::SE_TYPE position = html::SE_TYPE::SE_APPEND;
    if (lexical::ci::eq(where(), CHARS("beforebegin")))
      position = html::SE_TYPE::SE_OUTER_INSERT_BEFORE;
    else if (lexical::ci::eq(where(), CHARS("afterbegin")))
      position = html::SE_TYPE::SE_INSERT;
    else if (lexical::ci::eq(where(), CHARS("beforeend")))
      position = html::SE_TYPE::SE_APPEND;
    else if (lexical::ci::eq(where(), CHARS("afterend")))
      position = html::SE_TYPE::SE_OUTER_INSERT_AFTER;
    c.pview()->set_element_html(cel, html.chars_as_bytes(), position, c.pdoc()->uri().src);
    return true;
  }

  tool::value element_value(xcontext& c,element* pe) {
    tool::value r;
    pe->get_value(*c.pview(), r, true);
    return r;
    //c.pview()->get_element_native_value(pe, r, true);
    //return r;
  }
  bool set_element_value(xcontext& c, element* pe, tool::value v)
  {
    pe->allow_reconciliation(false); // content is governed by internal state
    if (pe->set_value(*c.pview(), v, true))
      return true;
    return false;
    //return c.pview()->set_element_native_value(pe, v, true);
  }

  helement query_selector(xcontext& c, element* pe, ustring selector) {
    return html::find_first(*c.pview(), pe, selector);
  }

  helement query_parent_selector(xcontext& c, element* pe, ustring selector) {
    return html::find_first_parent(*c.pview(), pe, selector);
  }

  helement query_owner_selector(xcontext& c, element* pe, ustring selector) {
    return html::find_first_ui_parent(*c.pview(), pe->doc(), pe, selector, 0);
  }

  bool query_matches(xcontext& c, element* pe, ustring selector) {
    return !!html::find_first_parent(*c.pview(), pe, selector,1);
  }


  array<helement> query_selector_all(xcontext& c, element* pe, ustring selector) {
    array<helement> r;
    find_all(*c.pview(), r, pe, selector);
    return r;
  }

  array<helement> elements_by_tag_name(xcontext& c, element* pe, ustring tagname) {
    array<helement> r;
    find_all(*c.pview(), r, pe, tagname);
    return r;
  }

  array<helement> elements_by_class_name(xcontext& c, element* pe, ustring classname) {
    array<helement> r;
    ustring selector;
    wchars cn = classname;
    while (cn) {
      wchars one = cn.chop(' ');
      selector += WCHARS(".");
      selector += one;
    }
    find_all(*c.pview(), r, pe, selector);
    return r;
  }

  array<helement> elements_by_name(xcontext& c, element* pe, ustring names) {
    array<helement> r;
    ustring selector;
    wchars cn = names;
    while (cn) {
      wchars one = cn.chop(' ');
      selector += WCHARS("[name='");
      selector += one;
      selector += WCHARS("']");
    }
    find_all(*c.pview(), r, pe, selector);
    return r;
  }


  element* subscribe(xcontext& c, helement pe, ustring name, qjs::hvalue fcn, subscription::flags fs)
  {
    if (!c.is_event_handler(fcn)) {
      string sn = conv<string>::unwrap(c, fcn);
      throw qjs::om::type_error(string::format("%s is not an event handler", sn.c_str()));
    }
    pe->subscribe(fcn, name, ustring(), fs);
    return pe;
  }

  element* unsubscribe(xcontext& c, helement pe, ustring name, qjs::hvalue fcn, subscription::flags fs)
  {
    if (!c.is_event_handler(fcn)) {
      //string sn = conv<string>::unwrap(c, fcn);
      //throw qjs::om::type_error(string::format("%s is not an event handler", sn.c_str()));
      fcn = hvalue();
    }
    pe->unsubscribe(name, fcn, ustring(), fs);
    return pe;
  }


  element* on(xcontext& c, helement pe, ustring name, qjs::hvalue vselector, qjs::hvalue fcn)
  {
#ifdef DEBUG
    //if (pe->is_document()) {
    //  pe->dbg_report("change");
    //  name = name;
    //}
#endif
    ustring selector;
    if (fcn.is_nothing()) {
      fcn = vselector;
    }
    else {
      selector = conv<ustring>::unwrap(c, vselector);
    }
    if (!c.is_event_handler(fcn)) {
      string sn = conv<string>::unwrap(c, fcn);
      throw qjs::om::type_error(string::format("%s is not an event handler", sn.c_str()));
    }
    pe->subscribe(fcn, name, selector);
    return pe;
  }

  element* off(xcontext& c, helement pe, qjs::hvalue what)
  {
    if (c.is_event_handler(what))
      pe->unsubscribe(what);
    else
      pe->unsubscribe(conv<ustring>::unwrap(c, what));
    return pe;
  }

  element* on_global(xcontext& c, element* pe, ustring name, qjs::hvalue fcn)
  {
    if (!c.is_event_handler(fcn)) {
      string sn = conv<string>::unwrap(c, fcn);
      throw qjs::om::type_error(string::format("%s is not an event handler", sn.c_str()));
    }
    if(!c.pview())
      throw qjs::om::type_error(string::format("element is not in DOM"));

    pe->flags.has_global_subscriptions = 1;
    c.pxview()->subscribe(fcn, name, pe);
    return pe;
  }

  element* off_global(xcontext& c, element* pe, qjs::hvalue what)
  {
    if (!c.pview())
      return pe;
    if (c.is_event_handler(what))
      c.pxview()->unsubscribe(what,pe);
    else if(c.is_string(what))
      c.pxview()->unsubscribe(conv<ustring>::unwrap(c, what), pe);
    else
      c.pxview()->unsubscribe(pe);
    return pe;
  }

  bool do_click(xcontext& c, element* pe)
  {
    event_behavior evt(pe, pe, html::ACTIVATE_CHILD, 0);
    if (c.pview()->send_behavior_event(evt)) 
      return true;
    else {
      event_behavior evt(pe, pe, html::CLICK, 0);
      return c.pview()->send_behavior_event(evt);
    }
  }

  bool dispatch_event(xcontext& c, element* pe, event_proxy* pevt, bool post)
  {
#if 0
    event_behavior evt(*(event_behavior*)cevt);

    evt.target = pe;
    evt.source = pe;

    if (post) {
      c.pview()->post_behavior_event(evt, true);
      return true;
    }
    else {
      bool r = c.pview()->send_behavior_event(evt);
      return (r || evt.is_handled()) ? false : true; /* note inverse logic */
    }
#else
    if (post) {
      switch (pevt->evt().event_group()) {
        case html::HANDLE_BEHAVIOR_EVENT: {
          event_behavior& be = static_cast<event_behavior&>(pevt->evt());
          be.target = pe;
          be.source = pe;
          c.pview()->post_behavior_event(be);
          return false;
        } break;
        default:
          assert(false);
          return false;
      }
    }
    else {
      if (c.pxview()->dispatch_event_level > 32)
        throw qjs::om::range_error("cyclic event");
      auto_state<uint> _(c.pxview()->dispatch_event_level, c.pxview()->dispatch_event_level + 1);

      switch (pevt->evt().event_group())
      {
        case html::HANDLE_MOUSE: 
          if(pevt->evt().event_bubbling())
            return !c.pview()->traverse_mouse(pe,static_cast<event_mouse&>(pevt->evt()));
          else 
            return !pe->on(*c.pview(), static_cast<event_mouse&>(pevt->evt()));
        case html::HANDLE_KEY:
          //if (pevt->evt().event_bubbling())
          //  return !c.pview()->traverse_key(pe, static_cast<event_key&>(pevt->evt()));
          //else
          return !pe->on(*c.pview(), static_cast<event_key&>(pevt->evt()));
        case html::HANDLE_BEHAVIOR_EVENT: {
          event_behavior& be = static_cast<event_behavior&>(pevt->evt());
          be.target = pe;
          be.source = pe;
          return c.pview()->send_behavior_event(be);
        }
        default:
          assert(false);
      }
    }
    return false;
#endif
  }

  bool post_event(xcontext& c, element* pe, event_proxy* pevt)
  {
    switch (pevt->evt().event_group()) {
      case html::HANDLE_BEHAVIOR_EVENT: {
        event_behavior& be = static_cast<event_behavior&>(pevt->evt());
        be.target = pe;
        be.source = pe;
        c.pview()->post_behavior_event(be);
        return false;
      } break;
      default:
        assert(false);
        return false;
    }
    return false;
  }

  bool do_post(xcontext& c, element* pe, hvalue what, tristate_v only_if_not_there)
  {
    if (c.is_function(what)) {

      html::posted_event be;
      be.target = pe;
      be.cbf = what;
      be.is_bubbling = false;
      c.pxview()->post_event(be, only_if_not_there.val(1));
      /*
      auto same_origin = [what,&c](html::timer_id id, html::TIMER_KIND kind) -> bool {
        if (JS_AreFunctionsOfSameOrigin(c, id, what)) return true;
        if (kind != html::SCRIPT_ELEMENT_TIMER) return false;
        return false;
      };

      if(only_if_not_there.val(0))
        c.pview()->stop_timer_if(pe, same_origin);
      html::timer_def &td = c.pview()->start_timer(pe, 16, what, html::SCRIPT_ELEMENT_TIMER);
      timer_callback* pcb = new timer_callback();
      pcb->fun = what;
      td.pcb = pcb;*/
      return true;
    }
    else
      return post_event(c, pe, c.get<event_proxy*>(what));
    return false;
  }

  tool::value query_command(xcontext& c, element* pe, ustring cmd, tool::value params)
  {
    html::view *pv = c.pview();
    if (pv) {
      tool::pair<bool, tool::value> r = html::query_command(*pv, pe, pe, cmd, params.isolate());
      if (r.first) return r.second;
    }
    return tool::value();
  }

  tool::value execute_command(xcontext& c, element* self, ustring cmd, tool::value params)
  {
    if (!cmd.length()) return value();
    html::view *pv = self->pview();
    if (pv) {
      auto pf = self->flags.suppress_change_event;
      self->flags.suppress_change_event = 1;
      bool r = html::exec_command(*pv, self, self, cmd, params);
      self->flags.suppress_change_event = pf;
      return value(r);
    }
    return value();
  }

  bool element_timer(xcontext& c, element* self, uint ms, hvalue fun) 
  {
    //html::view *pv = self->pview();
    //if (!pv) return false;

    if (!JS_IsFunction(c, fun))
      return false;

    auto same_origin = [fun,&c](html::timer_id id, html::TIMER_KIND kind) -> bool {
      //if (id == fun) return true;
      if (JS_AreFunctionsOfSameOrigin(c, id, fun)) return true;
      if (kind != html::SCRIPT_ELEMENT_TIMER) return false;
      return false;
    };

    if (ms) {
      c.pview()->stop_timer_if(self, same_origin);
      html::timer_def &td = c.pview()->start_timer(self, ms, fun, html::SCRIPT_ELEMENT_TIMER);
      timer_callback* pcb = new timer_callback();
      pcb->fun = fun;
      td.pcb = pcb;
    }
    else {
      c.pview()->stop_timer_if(self, same_origin);
    }
    return true;
  }

  bool element_clear(xcontext& c, element* el)
  {
    auto cel = logical_container(el);
    if (!cel) qjs::om::type_error("operation disabled");
    cel->clear(c.pview());
    return true;
  }

  static node_list_provider* element_child_nodes(xcontext& c, element* el)
  {
    auto cel = logical_container(el);
    return cel;
  }

  static child_list_provider* element_children(xcontext& c, element* el)
  {
    auto cel = logical_container(el);
    return cel;
  }

  bool set_focus(xcontext& c, element* self)
  {
    self->check_layout(*c.pview());
    return c.pview()->set_focus(self, FOCUS_CAUSE::BY_CODE);
  }

  string get_src(xcontext& c, element* self)
  {
    return self->atts.get_url(c.pdoc()->doc_url(), attr::a_src);
  }
  void set_src(xcontext& c, element* self, string url)
  {
    self->check_layout(*c.pview()); // need this in order behaviors to be in effect
    self->atts.remove(attr::a_src); // to trigger notify_attribute_change.
    self->set_attr(*c.pview(), attr::a_src, url);
  }

  bool get_disabled(xcontext& c, element* self)
  {
    return self->state.disabled();
  }
  void set_disabled(xcontext& c, element* self, bool disabled)
  {
    if (disabled)
      self->state_on(*c.pview(), S_DISABLED);
    else
      self->state_off(*c.pview(), S_DISABLED);
  }
  bool get_readonly(xcontext& c, element* self)
  {
    return self->state.readonly();
  }
  void set_readonly(xcontext& c, element* self, bool readonly)
  {
    if (readonly)
      self->state_on(*c.pview(), S_READONLY);
    else
      self->state_off(*c.pview(), S_READONLY);
  }

  bool get_checked(xcontext& c, element* self)
  {
    return self->state.checked();
  }
  void set_checked(xcontext& c, element* self, bool checked)
  {
    if (checked)
      self->state_on(*c.pview(), S_CHECKED);
    else
      self->state_off(*c.pview(), S_CHECKED);
  }


  hselection get_selection(xcontext& c, element* self)
  {
    return self->get_selection_ctx();
  }
  
  bool scroll_to(xcontext& c, element* self, hvalue x, int y) {
    point sp = self->scroll_pos();
    if (c.is_object(x)) {
      sp.x = c.get_prop<int>("left", x, sp.x);
      sp.y = c.get_prop<int>("top", x, sp.y);
      string bh = c.get_prop<string>("behavior", x, string());
      self->set_scroll_pos(*c.pview(), sp, bh == CHARS("smooth"),false);
    }
    else {
      sp.x = c.get<int>(x);
      sp.y = y;
      self->set_scroll_pos(*c.pview(), sp, false, false);
    }
    return sp != self->scroll_pos();
  }

  bool scroll_into_view(xcontext& c, element* self, hvalue opts) {
    if (JS_IsBool(opts))
      return c.pview()->ensure_visible(self, opts == JS_TRUE, html::SCROLL); //   animate ? html::SCROLL_SMOOTH : html::SCROLL
    else if (c.is_object(opts)) {
      string bh = c.get_prop<string>("behavior", opts, string());
#pragma TODO("better scrollIntoViewOptions handling please")
      string y = c.get_prop<string>("block", opts, string());
      return c.pview()->ensure_visible(self, y == CHARS("start"), bh == CHARS("smooth") ? html::SCROLL_SMOOTH : html::SCROLL);
    } else
      return c.pview()->ensure_visible(self, false, html::SCROLL);
  }

  rectf bounding_client_rect(xcontext& c, element* self) {
    rect r = self->border_box(*c.pview(), element::TO_VIEW);
    return c.pview()->ppx_to_dip(r);
  }

  float offset_height(xcontext& c, element* self) { return self->w3_offset_size(*c.pview()).y; }
  float offset_width(xcontext& c, element* self) { return self->w3_offset_size(*c.pview()).x; }
  float offset_top(xcontext& c, element* self) { return self->w3_offset_origin(*c.pview()).y; }
  float offset_left(xcontext& c, element* self) { return self->w3_offset_origin(*c.pview()).x; }

  float client_height(xcontext& c, element* self) { return self->w3_client_size(*c.pview()).y; }
  float client_width(xcontext& c, element* self) { return self->w3_client_size(*c.pview()).x; }
  float client_top(xcontext& c, element* self) { return self->w3_client_origin(*c.pview()).y; }
  float client_left(xcontext& c, element* self) { return self->w3_client_origin(*c.pview()).x; }

  float scroll_height(xcontext& c, element* self) { return self->w3_scroll_size(*c.pview()).y; }
  float scroll_width(xcontext& c, element* self) { return self->w3_scroll_size(*c.pview()).x; }
  float scroll_top(xcontext& c, element* self) { return self->w3_scroll_position(*c.pview()).y; }
  float scroll_left(xcontext& c, element* self) { return self->w3_scroll_position(*c.pview()).x; }

  void set_scroll_top(xcontext& c, element* self, float v) { 
    pointf sp = self->w3_scroll_position(*c.pview());
    sp.y = v;
    self->w3_scroll_position(*c.pview(),sp); 
  }
  void set_scroll_left(xcontext& c, element* self, float v) { 
    pointf sp = self->w3_scroll_position(*c.pview());
    sp.x = v;
    self->w3_scroll_position(*c.pview(), sp);
  }

  tool::value behavior_call(xcontext& c, element* self, tool::string name, tool::array<tool::value> args) { 
    html::scripting_params params;
    params.method_name = name.c_str();
    params.argv = args.cbegin();
    params.argc = uint(args.length());
    if (!self->call_behavior_method(*c.pview(), &params))
      throw qjs::om::type_error(string::format("unknown name '%s'",name.c_str()));
    return params.retval;
  }

  bool request_paint(xcontext& c, element* self) {
    self->refresh(*c.pview());
    return true;
  }

  hvalue get_paint_background(xcontext& c, element* self) { return JS_NULL; }
  void   set_paint_background(xcontext& c, element* self, JSValue func)
  {
    self->flags.script_draws_background = c.is_function(func);
    JS_DefinePropertyValue(c, self->obj, c.known_atoms().paintBackground, JS_DupValue(c, func), JS_PROP_C_W_E);
  }
  hvalue get_paint_foreground(xcontext& c, element* self) { return JS_NULL; }
  void   set_paint_foreground(xcontext& c, element* self, JSValue func)
  {
    self->flags.script_draws_foreground = c.is_function(func);
    JS_DefinePropertyValue(c, self->obj, c.known_atoms().paintForeground, JS_DupValue(c, func), JS_PROP_C_W_E);
  }
  hvalue get_paint_content(xcontext& c, element* self) { return JS_NULL; }
  void   set_paint_content(xcontext& c, element* self, JSValue func)
  {
    self->flags.script_draws_content = c.is_function(func);
    JS_DefinePropertyValue(c, self->obj, c.known_atoms().paintContent, JS_DupValue(c,func), JS_PROP_C_W_E);
  }
  hvalue get_paint_outline(xcontext& c, element* self) { return JS_NULL; }
  void   set_paint_outline(xcontext& c, element* self, JSValue func)
  {
    self->flags.script_draws_outline = c.is_function(func);
    JS_DefinePropertyValue(c, self->obj, c.known_atoms().paintOutline, JS_DupValue(c, func), JS_PROP_C_W_E);
  }

  bool popup_at(xcontext& c, element* popup, int x, int y, int_v placement) {
    return c.pview()->show_popup(popup, c.pdoc(), html::POPUP_WINDOW, placement.val(7) | 0xFFFF0000, point(x, y));
  }

  bool popup_for(xcontext& c, element* popup, helement anchor, int_v placement, int_v placementPopup ) {
    return c.pview()->show_popup(popup, anchor, html::POPUP_WINDOW, placement.val(1 | (7 << 16)) | (placementPopup.val(0) << 16));
  }

  helement popup(xcontext& c, helement el, hvalue what, hvalue options) {

    uint anchor_ref = 1;
    uint popup_ref = 7;

    int_v x,y;

    helement popup;
    if (is_vnode(c, what)) {
      element_creator_ctx ectx(c, what, el);
      html::mutator_ctx _(el, c.pview());
      popup = ectx.make(false);
      c.pdoc()->register_service_block(popup);
      popup->parent = el;
      if (!c.is_object(options))
        options = vnode_props(c, what);
    }
    else if (c.isa<element*>(what))
      popup = c.get<element*>(what);
    else
      throw qjs::om::type_error("expecting element to popup");

    if (c.is_object(options)) {
      anchor_ref = c.get_prop<uint>("anchorAt", options,1);
      popup_ref = c.get_prop<uint>("popupAt", options,7);
      x = c.get_prop<int_v>("x", options);
      y = c.get_prop<int_v>("y", options);
      if (x.is_defined() && y.is_defined()) {
        anchor_ref = popup_ref;
        popup_ref = 0xFFFF;
      }
    }
    c.pview()->show_popup(popup, el, html::POPUP_WINDOW, anchor_ref | (popup_ref << 16),point(x.val(0),y.val(0)));
    return popup;
  }

  bool take_off(xcontext& c, element* self, hvalue params) {

    if (!c.is_object(params) || !self->parent) {
      c.pview()->stop_move_element(self);
      return true;
    }

    pointf pt(INT_MIN, INT_MIN);

    pt.x = c.get_prop<float>("x", params, 0);
    pt.y = c.get_prop<float>("y", params, 0);

    size *psz = nullptr;
    size  sz;

    float_v w = c.get_prop<float_v>("width", params);
    float_v h = c.get_prop<float_v>("height", params);

    if (w.is_defined() && h.is_defined()) {
      sizef szf;
      szf.x = w;
      szf.y = h;
      psz = &sz;
      sz = c.pview()->dip_to_ppx(szf);
    }

    string relative_to = c.get_prop<string>("relativeTo", params);

    if (relative_to == CHARS("screen")) {
      pt -= c.pview()->client_screen_pos();
    }
    else if (relative_to == CHARS("document")) {
      pt = c.pview()->dip_to_ppx(pt);
      pt += self->doc()->view_pos(*c.pview());
    }
    else if (relative_to == CHARS("window")) {
      pt = c.pview()->dip_to_ppx(pt);
    }
    else if (relative_to == CHARS("parent")) {
      pt = c.pview()->dip_to_ppx(pt);
      pt += self->parent->view_pos(*c.pview());
    }
    //else if (relative_to == CHARS("self"))
    //;

    html::ELEMENT_WINDOW_MODE wmode = html::ELEMENT_WINDOW_AUTO;

    string mode = c.get_prop<string>("window", params);

    if (mode == CHARS("attached"))
       wmode = html::ELEMENT_WINDOW_ATTACHED;
    else if (mode == CHARS("detached"))
       wmode = html::ELEMENT_WINDOW_DETACHED;
    else if (mode == CHARS("popup"))
       wmode = html::ELEMENT_WINDOW_DETACHED_TOPMOST;
    else 
       wmode = html::ELEMENT_WINDOW_AUTO;
    
    int ref_point = c.get_prop<int>("alignment", params,7);
   
    c.pview()->move_element(self, point(pt), psz, wmode, ref_point);

    return true;
  }
  
  static hvalue element_animate(xcontext& c, element* self, hvalue how, hvalue params, hvalue onEnd)
  {
    uint_v duration;
    ustring easef = WCHARS("linear");
    handle<animation> pa;
    handle<html::animated_effect> panidef;
    html::effect_animator::STATE state = html::effect_animator::FORWARD;

    hcontext hc = c.pdoc()->ns;

    if (c.is_function(how)) 
    {
      if (c.is_object(params))
      {
        duration = c.get_prop<uint_v>("duration", params);
        easef = c.get_prop<ustring>("ease", params, WCHARS("linear"));
        ustring effect = c.get_prop<ustring>("effect", params, WCHARS(""));
        ustring direction = c.get_prop<ustring>("direction", params, WCHARS("forward"));
        static html::enum_item_def dirs[] = {
          { html::effect_animator::FORWARD, W("forward") },
          { html::effect_animator::ROLLBACK_FORWARD, W("rollback-forward") },
          { html::effect_animator::BACKWARD, W("backward") },
          { html::effect_animator::ROLLBACK_BACKWARD, W("rollback-backward") },
        };
        enum_v dir = html::effect_animator::FORWARD;
        parse_enum(dir, direction(), dirs);

        if (!effect)
          goto STEP_ANIMATE;

        panidef = new html::animated_effect();
        panidef->easef = html::ease::get_ease_func(tool::value(easef));
        parse_effect_type(effect, panidef->etype);
        panidef->duration = duration.val(200);

        state = (html::effect_animator::STATE)dir.val(html::effect_animator::FORWARD);

        if (!panidef->easef || !panidef->duration || !panidef->etype)
          panidef = nullptr;
      }

      auto worker = [&](html::view &v, html::element *el) -> bool {
        try {
          hvalue ret;
          c.call(ret, how, el);
          return true;
        }
        catch (qjs::exception) {
          c.report_exception();
          return false;
        }
      };

      pa = self->animated_update(*c.pview(), worker, panidef, state);

      goto RETURN_PROMISE;

    } // is_function
    else
      return hvalue();

  STEP_ANIMATE:

    pa = new script_animator();
    {
      uint_v fps = c.get_prop<uint_v>("FPS", params);
      if (fps.is_defined())
        pa.ptr_of<script_animator>()->frame_duration = 1000 / fps.val(0);
    }
    pa.ptr_of<script_animator>()->easef = html::ease::get_ease_func(tool::value(easef));
    pa.ptr_of<script_animator>()->duration = duration;
    pa.ptr_of<script_animator>()->cbf = [hc,how](html::view &v, html::element *el, double progress) -> bool {
      xcontext c(hc);
      try {
        bool r = false;
        c.call(r, how, el, progress);
        return r;
      }
      catch (qjs::exception) {
        c.report_exception();
        return false;
      }
    };

    c.pview()->add_animation(self, pa);

  RETURN_PROMISE:

    if (c.is_function(onEnd)) {
      if (pa)
        pa->on_end.push([onEnd, hc](view& v, element* pe, animation* pa) {
          xcontext c(hc);
          try {
            bool r;
            c.call(r, onEnd, JS_UNDEFINED, true);
          }
          catch (qjs::exception) {
            c.report_exception();
          }
        });
      else {
          xcontext c(hc);
          try {
            bool r;
            c.call(r, onEnd, JS_UNDEFINED, false);
          }
          catch (qjs::exception) {
            c.report_exception();
          }
      }
      return hvalue();
    }
    else {
      JSValue resolving_callbacks[2] = { JS_UNINITIALIZED, JS_UNINITIALIZED };
      hvalue promise = JS_NewPromiseCapability(c, resolving_callbacks);

      hvalue   resolver = resolving_callbacks[0];
      hvalue   rejector = resolving_callbacks[1];

      if (pa)
        pa->on_end.push([resolver, rejector, hc](view& v, element* pe, animation* pa) {
        xcontext c(hc);
        try {
          bool r;
          c.call(r, resolver, JS_UNDEFINED, true);
        }
        catch (qjs::exception) {
          c.report_exception();
        }
        return true; // consumed
          });
      else {
        // satify promise:
        try {
          bool r;
          c.call(r, resolver, JS_UNDEFINED, false);
        }
        catch (qjs::exception) {
          c.report_exception();
        }
      }
      return promise;
    }
  }

  static hrange element_range_from_point(xcontext& c, element* self, float x, float y)
  {
    point pos = c.pview()->dip_to_ppx(pointf(x, y));
    hrange hr = new range();
    hr->start = hr->end = self->find_text_pos(*c.pview(), pos);
    return hr->start.valid() ? hr : nullptr;
  }

  int element_get_own_property(JSContext *ctx, JSPropertyDescriptor *desc, JSValueConst obj, JSAtom prop)
  {
    html::element* pthis = element_ptr_of(ctx,obj);
    if (!pthis)
      return FALSE;

    xcontext c(ctx);
    if (c.pview())
      pthis->get_style(*c.pview());

    hvalue val;
    atom_chars pname(ctx, prop);
    for (html::ctl *pbh = pthis->behavior; pbh; pbh = pbh->next) {
      if (pbh->get_expando(c, val))
        return JS_GetOwnProperty(ctx, desc, val, prop);
      if (auto apsp = pbh->asset_get_passport()) {
        if (apsp->name == prop) {
          if (desc) {
            desc->flags = JS_PROP_C_W_E;
            desc->getter = JS_UNDEFINED;
            desc->setter = JS_UNDEFINED;
            desc->value = JS_UNDEFINED;
            som_asset_t* pass = pbh->as_asset();
            desc->value = conv<som_asset_t*>::wrap(ctx, pass);
          }
          return TRUE;
        }
      }
    }
#if 0 // PReact needs this - logic moved to element_has_property
    if (pname.length > 2 && pname.starts_with(CHARS("on"))) {
      auto wname = u8::cvt(pname(2));
      /*if (auto subs = pthis->get_prop_subscription(wname)) {
        if (desc) {
          desc->flags = JS_PROP_C_W_E;
          desc->getter = JS_UNDEFINED;
          desc->setter = JS_UNDEFINED;
          desc->value = JS_DupValue(ctx, subs->fcn);
        }
        return TRUE;
      }
      else */
      if (known_element_event_name(wname)) {
        if (desc) {
          desc->flags = JS_PROP_C_W_E;
          desc->getter = JS_UNDEFINED;
          desc->setter = JS_UNDEFINED;
          desc->value = JS_UNDEFINED;
        }
        return TRUE;
      }
    }
#endif
    return FALSE;
  }

  int element_define_own_property(JSContext *ctx, JSValueConst this_obj, JSAtom prop, JSValueConst val, JSValueConst getter, JSValueConst setter, int flags)
  {

    html::element* pthis = element_ptr_of(ctx,this_obj);
    if (!pthis)
      return JS_PROCEED_WITH_DEFAULT;
    xcontext c(ctx);
    if (prop == c.known_atoms().onsizechange)
      pthis->flags.has_on_size_script = 1;
    if (prop == c.known_atoms().onvisibilitychange)
      pthis->flags.has_on_visibility_changed_script = 1;

    return JS_PROCEED_WITH_DEFAULT;

#if 0
    atom_chars pname(ctx, prop);
    if (pname.starts_with(CHARS("on")) && (val != JS_UNINITIALIZED)) {
      if (!JS_IsFunction(ctx, val) && val != JS_NULL)
        return -1;
      auto wname = u8::cvt(pname(2));
      if (auto subs = pthis->get_prop_subscription(wname,true))
        subs->fcn = JS_DupValue(ctx, val);
      return TRUE;
    }
    return JS_DefineProperty(ctx, this_obj, prop, val, getter, setter, flags | JS_PROP_NO_EXOTIC);;
#endif
  }

  //  PReact needs this for "evtname in element"
  int element_has_property(JSContext *ctx, JSValueConst obj, JSAtom atom) {
    atom_chars pname(ctx, atom);
    if (pname.length > 2 && pname.starts_with(CHARS("on"))) {
      auto wname = u8::cvt(pname(2));
      if (known_element_event_name(wname))
        return 1;
    }
    return JS_PROCEED_WITH_DEFAULT;
  }

  JSClassExoticMethods Element_exotic_methods =
  {
    &element_get_own_property, // int(*get_own_property)(JSContext *ctx, JSPropertyDescriptor *desc, JSValueConst obj, JSAtom prop);
    NULL, // int(*get_own_property_names)(JSContext *ctx, JSPropertyEnum **ptab, uint32_t *plen, JSValueConst obj);
    /* return < 0 if exception, or TRUE/FALSE */
    NULL, //&element_delete_property,
    &element_define_own_property,
    &element_has_property, //&element_has_property,
    NULL, //&element_get_property,
    NULL, //&element_set_property, //&element_set_property
  };

  html::subscription::flags conv<html::subscription::flags>::unwrap(JSContext * ctx, const JSValueConst& v, int argc) {
    html::subscription::flags fs;
    if (JS_IsBool(v)) {
      fs.capture = conv<bool>::unwrap(ctx, v);
    }
    else if (JS_IsObject(v)) {
      xcontext c(ctx);
      fs.once = c.get_prop<bool>("once", v);
      fs.capture = c.get_prop<bool>("capture", v);
      fs.passive = c.get_prop<bool>("passive", v);
    }
    return fs;
  }

  helement Element_create(xcontext& c, hvalue what) {
    helement he;
    if (is_vnode(c, what)) {
      element_creator_ctx ectx(c, what, c.pdoc());
      he = ectx.make(false);
    }
    else if (c.is_string(what)) {
      he = new element(tag::symbol(c.get<string>(what)));
    }
    if(he)
      c.add_airborn_node(he);
    return he;
  }
  
  JSOM_PASSPORT_BEGIN(Element_static_def, qjs::xcontext)
    JSOM_GLOBAL_FUNC_DEF("create", Element_create)
  JSOM_PASSPORT_END
  

  JSOM_PASSPORT_BEGIN(Element_def, html::element)
    //JSOM_CONST_STR("[Symbol.toStringTag]", "Element", JS_PROP_CONFIGURABLE),
    JSOM_RO_PROP_DEF("[Symbol.toStringTag]", node_def),

    JSOM_PROP_DEF("className", attr_class, set_attr_class),

    JSOM_FUNC_DEF("getBoundingClientRect", bounding_client_rect),
    JSOM_RO_PROP_DEF("offsetHeight", offset_height),
    JSOM_RO_PROP_DEF("offsetLeft", offset_left),
    JSOM_RO_PROP_DEF("offsetTop", offset_top),
    JSOM_RO_PROP_DEF("offsetWidth", offset_width),

    JSOM_RO_PROP_DEF("clientHeight", client_height),
    JSOM_RO_PROP_DEF("clientLeft", client_left),
    JSOM_RO_PROP_DEF("clientTop", client_top),
    JSOM_RO_PROP_DEF("clientWidth", client_width),

    JSOM_PROP_DEF("scrollLeft", scroll_left, set_scroll_left),
    JSOM_PROP_DEF("scrollTop", scroll_top, set_scroll_top),
    JSOM_RO_PROP_DEF("scrollHeight", scroll_height),
    JSOM_RO_PROP_DEF("scrollWidth", scroll_width),

    JSOM_PROP_DEF("id", attr_id, set_attr_id),
    JSOM_PROP_DEF("name", attr_name, set_attr_name),
    JSOM_RO_PROP_DEF("tag", tag),
    JSOM_RO_PROP_DEF("tagName", tag_upper),
    JSOM_PROP_DEF("innerHTML", inner_html, set_inner_html),
    JSOM_PROP_DEF("outerHTML", outer_html, set_outer_html),

    JSOM_PROP_DEF("innerText", inner_text, set_inner_text),
    JSOM_RO_PROP_DEF("elementIndex", element_index),

    JSOM_PROP_DEF("value", element_value, set_element_value),

    JSOM_RO_PROP_DEF("firstElementChild", first_element),
    JSOM_RO_PROP_DEF("lastElementChild", last_element),
    JSOM_RO_PROP_DEF("nextElementSibling", next_element),
    JSOM_RO_PROP_DEF("previousElementSibling", prev_element),
    JSOM_RO_PROP_DEF("childElementCount", element_count),
    JSOM_FUNC_DEF("childElement", element_child),

    JSOM_RO_PROP_DEF("children", element_children),

    JSOM_RO_PROP_DEF("style", get_style_provider),
    JSOM_RO_PROP_DEF("elementStyle", get_style_provider), // synonim, in case of state is overriden by React for example
    JSOM_RO_PROP_DEF("state", get_state_provider),
    JSOM_RO_PROP_DEF("elementState", get_state_provider), // synonim, in case of state is overriden by React for example

    JSOM_FUNC_DEF("appendChild", append_child),
    JSOM_FUNC_DEF("insertBefore", insert_before),
    JSOM_FUNC_DEF("insertAfter", insert_after), // non-standard
    JSOM_FUNC_DEF("swapWith", element_swapWith), // non-standard

    JSOM_FUNC_DEF("removeChild", remove_child),
    JSOM_FUNC_DEF("replaceChild", replace_child),

    JSOM_RO_PROP_DEF("childNodes", element_child_nodes),

    JSOM_FUNC_DEF("addEventListener", subscribe),
    JSOM_FUNC_DEF("removeEventListener", unsubscribe),
    JSOM_FUNC_DEF("dispatchEvent", dispatch_event),
    JSOM_FUNC_DEF("postEvent", post_event),
    JSOM_FUNC_DEF("requestPaint", request_paint),

    JSOM_FUNC_DEF("insertAdjacentHTML", insert_adjacent_html),
    JSOM_FUNC_DEF("querySelector", query_selector),
    JSOM_FUNC_DEF("querySelectorAll", query_selector_all),
    JSOM_FUNC_DEF("closest", query_parent_selector),
    JSOM_FUNC_DEF("matches", query_matches),
    JSOM_FUNC_DEF("getElementsByClassName", elements_by_class_name),
    JSOM_FUNC_DEF("getElementsByTagName", elements_by_tag_name),
    JSOM_FUNC_DEF("getElementsByName", elements_by_name),

    JSOM_FUNC_DEF("getAttribute", get_attribute),
    JSOM_FUNC_DEF("getAttributeNames", get_attribute_names),
    JSOM_FUNC_DEF("removeAttribute", remove_attribute),
    JSOM_FUNC_DEF("setAttribute", set_attribute),
    JSOM_RO_PROP_DEF("classList", get_classlist),

    JSOM_FUNC_DEF("hasAttributes", has_attributes),
    JSOM_FUNC_DEF("hasAttribute", has_attribute),
    JSOM_RO_PROP_DEF("attributes", get_attributes),
   
    JSOM_PROP_DEF("disabled", get_disabled, set_disabled),
    JSOM_PROP_DEF("readonly", get_readonly, set_readonly),
    JSOM_PROP_DEF("checked", get_checked, set_checked),

    //JSOM_RO_PROP_DEF("width", get_width),
    //JSOM_RO_PROP_DEF("height", get_height),

    JSOM_FUNC_DEF("click", do_click),
    JSOM_FUNC_DEF("focus", set_focus),

    JSOM_PROP_DEF("src", get_src, set_src),

    JSOM_FUNC_DEF("scrollTo", scroll_to),
    JSOM_FUNC_DEF("scrollIntoView", scroll_into_view),

// sciter specific

    JSOM_FUNC_DEF("$", query_selector),
    JSOM_FUNC_DEF("$$", query_selector_all),
    JSOM_FUNC_DEF("$p", query_parent_selector),
    JSOM_FUNC_DEF("$o", query_owner_selector),
    JSOM_FUNC_DEF("$is", query_matches),

    JSOM_FUNC_DEF("xcall", behavior_call),
    JSOM_FUNC_DEF("post", do_post),

    JSOM_FUNC_DEF("on", on),
    JSOM_FUNC_DEF("off", off),
    JSOM_FUNC_DEF("queryCommand", query_command),
    JSOM_FUNC_DEF("execCommand", execute_command),

    JSOM_FUNC_DEF("onGlobalEvent", on_global),
    JSOM_FUNC_DEF("offGlobalEvent", off_global),

    JSOM_FUNC_DEF("timer", element_timer),
    JSOM_FUNC_DEF("clear", element_clear),

    JSOM_FUNC_DEF("content", rx_content),
    JSOM_FUNC_DEF("prepend", rx_prepend),
    JSOM_FUNC_DEF("append", rx_append),
    JSOM_FUNC_DEF("patch", rx_patch),
    JSOM_FUNC_DEF("componentUpdate", rx_component_update),

    JSOM_PROP_DEF("paintBackground", get_paint_background, set_paint_background),
    JSOM_PROP_DEF("paintContent", get_paint_content, set_paint_content),
    JSOM_PROP_DEF("paintForeground", get_paint_foreground, set_paint_foreground),
    JSOM_PROP_DEF("paintOutline", get_paint_outline, set_paint_outline),

    JSOM_FUNC_DEF("popupAt", popup_at),
    JSOM_FUNC_DEF("popupFor", popup_for),

    JSOM_FUNC_DEF("popup", popup),

    JSOM_FUNC_DEF("takeOff", take_off),

    JSOM_FUNC_DEF("animate", element_animate),

    JSOM_RO_PROP_DEF("selection", get_selection),

    JSOM_FUNC_DEF("rangeFromPoint", element_range_from_point),

  JSOM_PASSPORT_END

  void init_Element_class(context& c)
  {
    JS_NewClassID(&Element_class_id);

    static JSClassDef Element_class = {
      "Element",
      [](JSRuntime *rt, JSValue val)
      {
        html::element* pe = object_of<html::element>(val);
        if (pe) {
          pe->obj.tearoff();
          //pe->dbg_report("dtor");
          pe->release();
        }
      },
      NULL,
      NULL,
      &Element_exotic_methods
    };

    JS_NewClass(JS_GetRuntime(c), Element_class_id, &Element_class);
    JSValue element_proto = JS_NewObject(c);

    auto list = Element_def();
    JS_SetPropertyFunctionList(c, element_proto, list.start, list.length);

    hvalue node_proto = JS_GetClassProto(c, Node_class_id);
    JS_SetPrototype(c, element_proto, node_proto);

    auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
    {
      JSValue obj = JS_UNDEFINED;
      JSValue proto;
      /* using new_target to get the prototype is necessary when the class is extended. */
      proto = JS_GetPropertyStr(ctx, new_target, "prototype");
      if (JS_IsException(proto))
        goto fail;
      obj = JS_NewObjectProtoClass(ctx, proto, Element_class_id);
      JS_FreeValue(ctx, proto);
      if (JS_IsException(obj))
        goto fail;
      JS_SetOpaque(obj, 0);
      return obj;
    fail:
      //js_free(ctx, s);
      JS_FreeValue(ctx, obj);
      return JS_EXCEPTION;
    };

    hvalue element_class = JS_NewCFunction2(c, ctor, "Element", 2, JS_CFUNC_constructor, 0);

    JS_DefinePropertyValueStr(c, c.global(), "Element", JS_DupValue(c, element_class), JS_PROP_CONFIGURABLE);

    auto static_list = Element_static_def();
    JS_SetPropertyFunctionList(c, element_class, static_list.start, static_list.length);

    JS_SetConstructor(c, element_class, element_proto);
    JS_SetClassProto(c, Element_class_id, element_proto);
    /////???JS_FreeValue(pd->ns, element_proto);
    //JS_FreeValue(c, element_class);

    init_ClassList_class(c);
    init_AttributeList_class(c);

  }

}
