#ifndef __xdomjs_xdom_h__
#define __xdomjs_xdom_h__

#include "xcontext.h"
#include "xstyle.h"
#include "xstates.h"

namespace qjs
{
  extern JSClassID Document_class_id;
  extern JSClassID Element_class_id;
  extern JSClassID Node_class_id;
  extern JSClassID Text_class_id;
  extern JSClassID Comment_class_id;
  extern JSClassID Event_class_id;
  extern JSClassID Asset_class_id;

  template<class T>
  inline T* object_of(JSValue val);

  template <>
  inline html::document* object_of<html::document>(JSValue val) {
    return (html::document*)(html::node*)JS_GetOpaque(val, Document_class_id);
  }

  template <>
  inline html::element* object_of<html::element>(JSValue val) {
    return (html::element*)(html::node*)JS_GetOpaque(val, Element_class_id);
  }

  template <>
  inline html::node* object_of<html::node>(JSValue val) {
    return (html::node*)JS_GetOpaque(val, Node_class_id);
  }

  template <>
  inline html::text* object_of<html::text>(JSValue val) {
    return (html::text*)(html::node*)JS_GetOpaque(val, Text_class_id);
  }

  template <>
  inline html::comment* object_of<html::comment>(JSValue val) {
    return (html::comment*)(html::node*)JS_GetOpaque(val, Comment_class_id);
  }


  template <>
  inline html::event* object_of<html::event>(JSValue val) {
    return (html::event*)JS_GetOpaque(val, Event_class_id);
  }

  template <>
  inline som_asset_t* object_of<som_asset_t>(JSValue val) {
    return (som_asset_t*)JS_GetOpaque(val, Asset_class_id);
  }

  string css_to_camel_case(chars s);

}

#endif