#include "xdom.h"
#include "xom.h"
#include "xconsole.h"

namespace qjs {

  JSClassID Console_class_id = 0;

  /*bool xconsole::assert_(xcontext& c, xconsole* pc, bool r, slice<JSValue> argv)
  {
    if (!r && argv.length) {
      if (c.isa<tool::string>(argv[0])) {
        c.print_ln(html::OS_ERROR,c.format(c.get<string>(argv[0])(),argv(1)));
      }
      else {
        array<tool::ustring> strings;
        for (auto v : argv) strings.push( c.get<ustring>(v) );
        c.print_ln(html::OS_ERROR, strings());
      }
      return true;
    }
    return true;
  }*/

/*  bool test(xcontext& c, xconsole* pc)
  {
    return true;
  }*/


  bool xconsole::print(xcontext& c, html::OUTPUT_SEVERITY severity, slice<hvalue> argv)
  {
    return c.log(severity, argv);
  }

  bool print(xcontext& c, xconsole* pc, array<ustring> argv) {
    ustring msg;
    for (auto s : argv) {
      if (msg.length()) msg += WCHARS(",");
      msg += s;
    }
    msg += WCHARS("\n");
    c.pview()->do_debug_print(html::OT_TIS, html::OS_INFO, msg);
    return true;
    //return pc->print(c, html::OS_INFO, argv());
  }

  bool print_out(xcontext& c, xconsole* pc, int subs, int kind, array<ustring> argv) {
    ustring msg;
    for (auto s : argv) {
      if (msg.length()) msg += WCHARS(",");
      msg += s;
    }
    msg += WCHARS("\n");
    c.pview()->do_debug_print(subs, kind, msg);
    return true;
    //return pc->print(c, html::OS_INFO, argv());
  }


  JSOM_PASSPORT_BEGIN(Console_def, qjs::xconsole)
    JSOM_FUNC_DEF("log", xconsole::log),
    JSOM_FUNC_DEF("warn", xconsole::warn),
    JSOM_FUNC_DEF("error", xconsole::error),
    JSOM_FUNC_DEF("print", print),
    JSOM_FUNC_DEF("out", print_out),
    //JSOM_FUNC_DEF("assert", xconsole::assert_),
  JSOM_PASSPORT_END

  void xconsole::init_class(JSContext* ctx)
  {
    xcontext c(ctx);

    JS_NewClassID(&Console_class_id);

    static JSClassDef Console_class = {
      "Console",
      [](JSRuntime *rt, JSValue val) { // finalizer
        xconsole* pc = (xconsole *)JS_GetOpaque(val, Console_class_id);
        if (pc) {
          pc->release();
        }
      }
    };

    JS_NewClass(JS_GetRuntime(c), Console_class_id, &Console_class);
    JSValue console_proto = JS_NewObject(c);

    auto list = Console_def();
    JS_SetPropertyFunctionList(c, console_proto, list.start, list.length);

    static auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
    {
      JSValue obj = JS_UNDEFINED;
      JSValue proto;
      /* using new_target to get the prototype is necessary when the class is extended. */
      proto = JS_GetPropertyStr(ctx, new_target, "prototype");
      if (JS_IsException(proto))
        goto fail;
      obj = JS_NewObjectProtoClass(ctx, proto, Console_class_id);
      JS_FreeValue(ctx, proto);
      if (JS_IsException(obj))
        goto fail;
      return obj;
    fail:
      JS_FreeValue(ctx, obj);
      return JS_EXCEPTION;
    };

    hvalue console_class = JS_NewCFunction2(c, ctor, "Console", 2, JS_CFUNC_constructor, 0);
    JS_SetConstructor(c, console_class, console_proto);
    JS_SetClassProto(c, Console_class_id, console_proto);
  }

}