
#include "xdom.h"
#include "xom.h"
#include "xcolor.h"

namespace qjs
{
  using namespace tool;

  JSClassID Color_class_id = 0;

  /*
  ustring cl_item(xcontext& c, html::class_list_provider* sp, int n) {
    html::element* pe = static_cast<html::element*>(sp);
    return pe->atts.classes()[n];
  }

  bool cl_contains(xcontext& c, html::class_list_provider* sp, ustring cls) {
    html::element* pe = static_cast<html::element*>(sp);
    return pe->atts.classes().contains(cls());
  }

  bool cl_add(xcontext& c, html::class_list_provider* sp, array<ustring> classes)
  {
    html::element* pe = static_cast<html::element*>(sp);
    auto existing_classes = pe->atts.classes();
    array<ustring> to_add;
    for (auto c1 : classes) {
      if (existing_classes.contains(c1))
        continue;
      to_add.push(c1);
    }
    if (to_add.length() == 0)
      return false;
    tool::ustring cls = trim(pe->attr_class()());
    for (auto c1 : to_add) {
      if (cls.length()) cls += WCHARS(" ");
      cls += c1;
    }
    pe->set_attr(html::attr::a_class, cls, c.pview());
    return true;
  }

  bool cl_remove(xcontext& c, html::class_list_provider* sp, array<ustring> classes)
  {
    html::element* pe = static_cast<html::element*>(sp);
    auto existing_classes = pe->atts.classes();
    array<ustring> to_be_there;
    for (auto c1 : existing_classes) {
      if (classes().contains(c1))
        continue;
      to_be_there.push(c1);
    }
    if (existing_classes.length == to_be_there.length())
      return false;
    tool::ustring cls;
    for (auto c1 : to_be_there) {
      if (cls.length()) cls += WCHARS(" ");
      cls += c1;
    }
    pe->set_attr(html::attr::a_class, cls, c.pview());
    return true;
  }

  bool cl_toggle(xcontext& c, html::class_list_provider* sp, ustring cls, tristate_v onoff) {

    html::element* pe = static_cast<html::element*>(sp);

    if (onoff.is_undefined())
      onoff = !pe->atts.has_class(cls);

    ustring nc;

    if (onoff)
      goto ADD_CLASS;
    else
      goto REMOVE_CLASS;

  REMOVE_CLASS:

    if (pe->atts.remove_class(cls, nc)) {
      if (nc.length())
        pe->set_attr(html::attr::a_class, nc, c.pview());
      else
        pe->remove_attr(html::attr::a_class, c.pview());
    }

    return pe->atts.has_class(cls);

  ADD_CLASS:

    if (pe->atts.add_class(cls, nc))
      pe->set_attr(html::attr::a_class, nc, c.pview());

    return pe->atts.has_class(cls);

  }

  int cl_length(xcontext& c, html::class_list_provider* sp) {
    html::element* pe = static_cast<html::element*>(sp);
    auto existing_classes = pe->atts.classes();
    return existing_classes.size();
  }

  ustring cl_get_value(xcontext& c, html::class_list_provider* sp) {
    html::element* pe = static_cast<html::element*>(sp);
    return pe->attr_class();
  }

  void cl_set_value(xcontext& c, html::class_list_provider* sp, ustring val) {
    html::element* pe = static_cast<html::element*>(sp);
    if (val.length())
      pe->set_attr(html::attr::a_class, val, c.pview());
    else
      pe->remove_attr(html::attr::a_class, c.pview());
  }

  array<ustring> cl_entries(xcontext& c, html::class_list_provider* sp) {
    html::element* pe = static_cast<html::element*>(sp);
    array<ustring> out;
    for (auto c1 : pe->atts.classes())
      out.push(c1);
    return out;
  }
  */

  double color_r(xcontext& c, gool::argb cv) { return cv.red / 255.0; }
  double color_g(xcontext& c, gool::argb cv) { return cv.green / 255.0; }
  double color_b(xcontext& c, gool::argb cv) { return cv.blue / 255.0; }
  double color_a(xcontext& c, gool::argb cv) { return cv.alfa / 255.0; }

  uint color_R(xcontext& c, gool::argb cv) { return cv.red; }
  uint color_G(xcontext& c, gool::argb cv) { return cv.green; }
  uint color_B(xcontext& c, gool::argb cv) { return cv.blue; }
  uint color_A(xcontext& c, gool::argb cv) { return cv.alfa; }

  /*void color_set_r(xcontext& c, hvalue cv, double v) {
    gool::argb co = conv<gool::argb>::unwrap(c, cv);
    co.red = (gool::argb::channel_t)tool::limit(uint(v * 255.0 + 0.5),0u,255u);
    JS_SetOpaque(cv, (void*)(color)co);
  }
  void color_set_g(xcontext& c, hvalue cv, double v) {
    gool::argb co = conv<gool::argb>::unwrap(c, cv);
    co.green = (gool::argb::channel_t)tool::limit(uint(v * 255.0 + 0.5), 0u, 255u);
    JS_SetOpaque(cv, (void*)(color)co);
  }
  void color_set_b(xcontext& c, hvalue cv, double v) {
    gool::argb co = conv<gool::argb>::unwrap(c, cv);
    co.blue = (gool::argb::channel_t)tool::limit(uint(v * 255.0 + 0.5), 0u, 255u);
    JS_SetOpaque(cv, (void*)(color)co);
  }
  void color_set_a(xcontext& c, hvalue cv, double v) {
    gool::argb co = conv<gool::argb>::unwrap(c, cv);
    co.alfa = (gool::argb::channel_t)tool::limit(uint(v * 255.0 + 0.5), 0u, 255u);
    JS_SetOpaque(cv, (void*)(color)co);
  }*/

  array<float> color_hsva(xcontext& c, gool::argb cv) {
    gool::hsv h = cv;
    return { h.h, h.s, h.v, cv.alfa / 255.0f };
  }

  array<float> color_hsla(xcontext& c, gool::argb cv) {
    gool::hsl h = cv;
    return { h.h, h.s, h.l, cv.alfa / 255.0f };
  }

  string color_to_string(xcontext& c, gool::argb cv, string format) {
    string sv;
    if (format.is_undefined()) {
      if (cv.is_opaque())
        sv = string::format("#%02x%02x%02x", cv.red, cv.green, cv.blue);
      else 
        sv = string::format("#%02x%02x%02x%02x", cv.red, cv.green, cv.blue, cv.alfa);
    }
    else if (format == CHARS("RGB"))
      sv = string::format("#%02x%02x%02x", cv.red, cv.green, cv.blue);
    else if (format == CHARS("RGBA"))
      sv = string::format("#%02x%02x%02x%02x", cv.red, cv.green, cv.blue, cv.alfa);
    else if (format == CHARS("rgb"))
      sv = string::format("rgb(%d,%d,%d)", cv.red, cv.green, cv.blue);
    else if (format == CHARS("rgba"))
      sv = string::format("rgba(%d,%d,%d,%f)", cv.red, cv.green, cv.blue, double(255 - cv.alfa) / 255.0);
    return sv;
  }

  uint color_value_of(xcontext& c, gool::argb cv) {
    return cv.to_color();
  }

  gool::argb Color_rgba(xcontext& c, float r, float g, float b, float_v a) {
    gool::argb ret;
    ret.red = gool::argb::channel_t(r * 255.0f);
    ret.green = gool::argb::channel_t(g * 255.0f);
    ret.blue = gool::argb::channel_t(b * 255.0f);
    if(a.is_defined())
      ret.alfa = gool::argb::channel_t(a * 255.0f);
    return ret;
  }

  gool::argb Color_RGBA(xcontext& c, uint r, uint g, uint b, uint_v a) {
    gool::argb ret;
    ret.red = gool::argb::channel_t(r);
    ret.green = gool::argb::channel_t(g);
    ret.blue = gool::argb::channel_t(b);
    if (a.is_defined())
      ret.alfa = gool::argb::channel_t(a);
    return ret;
  }


  gool::argb Color_hsva(xcontext& c, float h, float s, float v, float_v a) {
    gool::hsv hsv(h, s, v);
    gool::argb ret = hsv;
    if (a.is_defined())
      ret.alfa = gool::argb::channel_t(a * 255.0f);
    return ret;
  }

  gool::argb Color_hsla(xcontext& c, float h, float s, float l, float_v a) {
    gool::hsl hsl(h, s, l);
    gool::argb ret = gool::rgb(hsl);
    if (a.is_defined())
      ret.alfa = gool::argb::channel_t(a * 255.0f);
    return ret;
  }

  JSOM_PASSPORT_BEGIN(Color_def, html::element)
    JSOM_CONST_STR("[Symbol.toStringTag]", "Graphics.Color", JS_PROP_CONFIGURABLE),

    JSOM_FUNC_DEF("toString", color_to_string),
    JSOM_FUNC_DEF("valueOf", color_value_of),

    JSOM_RO_PROP_DEF("r", color_r),
    JSOM_RO_PROP_DEF("g", color_g),
    JSOM_RO_PROP_DEF("b", color_b),
    JSOM_RO_PROP_DEF("a", color_a),

    JSOM_RO_PROP_DEF("R", color_R),
    JSOM_RO_PROP_DEF("G", color_G),
    JSOM_RO_PROP_DEF("B", color_B),
    JSOM_RO_PROP_DEF("A", color_A),

    JSOM_RO_PROP_DEF("hsv", color_hsva),
    JSOM_RO_PROP_DEF("hsl", color_hsla),

  JSOM_PASSPORT_END

  JSOM_PASSPORT_BEGIN(Color_static_def, qjs::xcontext)

    JSOM_GLOBAL_FUNC_DEF("rgb", Color_rgba),
    JSOM_GLOBAL_FUNC_DEF("RGB", Color_RGBA),
    JSOM_GLOBAL_FUNC_DEF("hsv", Color_hsva),
    JSOM_GLOBAL_FUNC_DEF("hsl", Color_hsla),

  JSOM_PASSPORT_END

  void init_Color_class(context& c, hvalue graphics)
  {
    JS_NewClassID(&Color_class_id);

    static JSClassDef Color_class = {
      "Color",
      [](JSRuntime *rt, JSValue val) { },
    };

    JS_NewClass(JS_GetRuntime(c), Color_class_id, &Color_class);
    JSValue color_proto = JS_NewObject(c);

    auto list = Color_def();
    JS_SetPropertyFunctionList(c, color_proto, list.start, list.length);

    auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
    {
      JSValue obj = JS_UNDEFINED;
      JSValue proto;
      /* using new_target to get the prototype is necessary when the class is extended. */
      proto = JS_GetPropertyStr(ctx, new_target, "prototype");
      if (JS_IsException(proto))
        goto fail;
      obj = JS_NewObjectProtoClass(ctx, proto, Color_class_id);
      JS_FreeValue(ctx, proto);
      if (JS_IsException(obj))
        goto fail;

      if(argc == 0)
        JS_SetOpaque(obj, 0);
      else if (argc == 1) {
        gool::argb c = conv<gool::argb>::unwrap(ctx, argv[0]);
        JS_SetOpaque(obj, (void*)(gool::color)c);
      } else if (argc == 3) {
        gool::argb c;
        c.red = gool::argb::channel_t(conv<double>::unwrap(ctx, argv[0]) * 255 + 0.5);
        c.green = gool::argb::channel_t(conv<double>::unwrap(ctx, argv[1]) * 255 + 0.5);
        c.blue = gool::argb::channel_t(conv<double>::unwrap(ctx, argv[2]) * 255 + 0.5);
        JS_SetOpaque(obj, (void*)(gool::color)c);
      } else if (argc == 4) {
        gool::argb c;
        c.red = gool::argb::channel_t(conv<double>::unwrap(ctx, argv[0]) * 255 + 0.5);
        c.green = gool::argb::channel_t(conv<double>::unwrap(ctx, argv[1]) * 255 + 0.5);
        c.blue = gool::argb::channel_t(conv<double>::unwrap(ctx, argv[2]) * 255 + 0.5);
        c.alfa = gool::argb::channel_t(conv<double>::unwrap(ctx, argv[3]) * 255 + 0.5);
        JS_SetOpaque(obj, (void*)(gool::color)c);
      }
      return obj;
    fail:
      JS_FreeValue(ctx, obj);
      return JS_EXCEPTION;
    };

    hvalue color_class = JS_NewCFunction2(c, ctor, "Color", 2, JS_CFUNC_constructor, 0);

    JS_DefinePropertyValueStr(c, graphics, "Color", JS_DupValue(c, color_class), JS_PROP_CONFIGURABLE);
    JS_DefinePropertyValueStr(c, c.global(), "Color", JS_DupValue(c, color_class), JS_PROP_CONFIGURABLE);

    auto static_list = Color_static_def();
    JS_SetPropertyFunctionList(c, color_class, static_list.start, static_list.length);

    JS_SetConstructor(c, color_class, color_proto);
    JS_SetClassProto(c, Color_class_id, color_proto);
  }


}