#include "xdom.h"
#include "xom.h"
#include "xclasslist.h"

namespace html {
}

namespace qjs
{
  using namespace tool;

  JSClassID ClassList_class_id = 0;

  ustring cl_item(xcontext& c, html::class_list_provider* sp, int n) {
    html::element* pe = static_cast<html::element*>(sp);
    return pe->atts.classes()[n];
  }

  bool cl_contains(xcontext& c, html::class_list_provider* sp, ustring cls) {
    html::element* pe = static_cast<html::element*>(sp);
    return pe->atts.classes().contains(cls());
  }

  bool cl_add(xcontext& c, html::class_list_provider* sp, array<ustring> classes) 
  {
    html::element* pe = static_cast<html::element*>(sp);
    auto existing_classes = pe->atts.classes();
    array<ustring> to_add;
    for (auto c1 : classes) {
      if (existing_classes.contains(c1))
        continue;
      to_add.push(c1);
    }
    if (to_add.length() == 0)
      return false;
    tool::ustring cls = trim(pe->attr_class()());
    for (auto c1 : to_add) {
      if (cls.length()) cls += WCHARS(" ");
      cls += c1;
    }
    pe->set_attr(html::attr::a_class, cls,c.pview());
    return true;
  }

  bool cl_remove(xcontext& c, html::class_list_provider* sp, array<ustring> classes)
  {
    html::element* pe = static_cast<html::element*>(sp);
    auto existing_classes = pe->atts.classes();
    array<ustring> to_be_there;
    for (auto c1 : existing_classes) {
      if (classes().contains(c1))
        continue;
      to_be_there.push(c1);
    }
    if (existing_classes.length == to_be_there.length())
      return false;
    tool::ustring cls;
    for (auto c1 : to_be_there) {
      if (cls.length()) cls += WCHARS(" ");
      cls += c1;
    }
    pe->set_attr(html::attr::a_class, cls, c.pview());
    return true;
  }

  bool cl_toggle(xcontext& c, html::class_list_provider* sp, ustring cls, tristate_v onoff) {

    html::element* pe = static_cast<html::element*>(sp);

    if (onoff.is_undefined())
      onoff = !pe->atts.has_class(cls);

    ustring nc;

    if (onoff)
      goto ADD_CLASS;
    else
      goto REMOVE_CLASS;

  REMOVE_CLASS:

    if (pe->atts.remove_class(cls, nc)) {
      if (nc.length())
        pe->set_attr(html::attr::a_class, nc, c.pview());
      else
        pe->remove_attr(html::attr::a_class, c.pview());
    }

    return pe->atts.has_class(cls);

  ADD_CLASS:

    if (pe->atts.add_class(cls, nc)) 
      pe->set_attr(html::attr::a_class, nc, c.pview());

    return pe->atts.has_class(cls);
  
  }

  int cl_length(xcontext& c, html::class_list_provider* sp) {
    html::element* pe = static_cast<html::element*>(sp);
    auto existing_classes = pe->atts.classes();
    return existing_classes.size();
  }

  ustring cl_get_value(xcontext& c, html::class_list_provider* sp) {
    html::element* pe = static_cast<html::element*>(sp);
    return pe->attr_class();
  }

  void cl_set_value(xcontext& c, html::class_list_provider* sp, ustring val) {
    html::element* pe = static_cast<html::element*>(sp);
    if (val.length())
      pe->set_attr(html::attr::a_class, val, c.pview());
    else
      pe->remove_attr(html::attr::a_class, c.pview());
  }

  array<ustring> cl_entries(xcontext& c, html::class_list_provider* sp) {
    html::element* pe = static_cast<html::element*>(sp);
    array<ustring> out;
    for (auto c1 : pe->atts.classes())
      out.push(c1);
    return out;
  }


  JSOM_PASSPORT_BEGIN(ClassList_def, html::element)
    JSOM_CONST_STR("[Symbol.toStringTag]", "Element.ClassList", JS_PROP_CONFIGURABLE),
    JSOM_FUNC_DEF("item", cl_item),
    JSOM_FUNC_DEF("contains", cl_contains),
    JSOM_FUNC_DEF("add", cl_add),
    JSOM_FUNC_DEF("remove", cl_remove),
    JSOM_FUNC_DEF("toggle", cl_toggle),
    JSOM_RO_PROP_DEF("length", cl_length),
    JSOM_PROP_DEF("value", cl_get_value, cl_set_value),
    JSOM_FUNC_DEF("entries", cl_entries),
    //JSOM_FUNC_DEF("replace", cl_replace),
    //JSOM_FUNC_DEF("supports", cl_supports),
    //JSOM_FUNC_DEF("entries", cl_entries)
  JSOM_PASSPORT_END


  void init_ClassList_class(context& c)
  {
    JS_NewClassID(&ClassList_class_id);

    static JSClassDef ClassList_class = {
      "ClassList",
      [](JSRuntime *rt, JSValue val)
      {
        html::element* pe = (html::element*)JS_GetOpaque(val,ClassList_class_id);  //object_of<html::element>(val);
        if (pe)
          pe->release();
      },
    };

    JS_NewClass(JS_GetRuntime(c), ClassList_class_id, &ClassList_class);
    JSValue style_proto = JS_NewObject(c);

    auto list = ClassList_def();
    JS_SetPropertyFunctionList(c, style_proto, list.start, list.length);

    auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
    {
      JSValue obj = JS_UNDEFINED;
      JSValue proto;
      /* using new_target to get the prototype is necessary when the class is extended. */
      proto = JS_GetPropertyStr(ctx, new_target, "prototype");
      if (JS_IsException(proto))
        goto fail;
      obj = JS_NewObjectProtoClass(ctx, proto, ClassList_class_id);
      JS_FreeValue(ctx, proto);
      if (JS_IsException(obj))
        goto fail;
      JS_SetOpaque(obj, 0);
      return obj;
    fail:
      //js_free(ctx, s);
      JS_FreeValue(ctx, obj);
      return JS_EXCEPTION;
    };

    hvalue classlist_class = JS_NewCFunction2(c, ctor, "ClassList", 2, JS_CFUNC_constructor, 0);

    hvalue element_class = c.get_prop<hvalue>("Element", c.global());
    assert(element_class);

    JS_DefinePropertyValueStr(c, element_class, "ClassList", JS_DupValue(c, classlist_class), JS_PROP_CONFIGURABLE);

    //auto static_list = ClassList_static_def();
    //JS_SetPropertyFunctionList(c, classlist_class, static_list.start, static_list.length);

    JS_SetConstructor(c, classlist_class, style_proto);
    JS_SetClassProto(c, ClassList_class_id, style_proto);
  }


}