#pragma once

#ifndef __xdomjs_xchildlist_h__
#define __xdomjs_xchildlist_h__

#include "xcontext.h"
#include "xconv.h"
#include "xnodelist.h"

namespace qjs
{
  using namespace html;

  struct child_list_value_iterator : public iterator
  {
    int index;
    helement pe;

    child_list_value_iterator(child_list_provider* nl) : pe(static_cast<element*>(nl)), index(-1) {}

    virtual hvalue next(xcontext& c) override
    {
      hvalue obj = JS_NewObject(c);
      if (++index < pe->n_children())
        c.set_prop(c.known_atoms().value, obj, pe->child(index));
      else
        c.set_prop(c.known_atoms().done, obj, true);
      return obj;
    }
  };

  extern JSClassID ElementList_class_id;

  template <> struct conv<child_list_provider*>
  {
    static child_list_provider* unwrap(JSContext * ctx, JSValueConst v)
    {
      child_list_provider* nl = element_ptr_of(ctx, v);
      if (!nl)
        throw qjs::om::type_error("ElementList was deleted");
      return nl;
    }
    static child_list_provider* try_unwrap(JSContext * ctx, const JSValueConst& v, int argc = 0)
    {
      child_list_provider* nl = element_ptr_of(ctx, v);
      if (!nl) return nullptr;
      return nl;
    }
    static JSValue wrap(JSContext * ctx, child_list_provider* nl) noexcept
    {
      if (!nl)
        return JS_NULL;
      xcontext c(ctx);
      html::node* pn = static_cast<html::element*>(nl);
      JSValue child_list_obj = JS_NewObjectClass(ctx, ElementList_class_id);
      pn->add_ref();
      JS_SetOpaque(child_list_obj, pn);
      return child_list_obj;
    }
    static bool isa(JSContext * ctx, JSValueConst v) { return JS_GetOpaque(v, ElementList_class_id) != NULL; }
  };

}

#endif
