#include "xdom.h"
#include "xom.h"
#include "xcontext.h"
#include "xchildren.h"

namespace qjs {

  using namespace html;
  using namespace tool;

  JSClassID ElementList_class_id = 0;
  
  uint child_list_length(xcontext& c, child_list_provider* nl)
  {
    return uint(static_cast<element*>(nl)->n_children());
  }

  hnode child_list_item(xcontext& c, child_list_provider* nl, uint n)
  {
    return n < uint(static_cast<element*>(nl)->n_children()) ? static_cast<element*>(nl)->child(int(n)) : nullptr;
  }

  hvalue child_list_iterator(xcontext& c, child_list_provider* nl)
  {
    return make_iterator(c, new child_list_value_iterator(nl));
  }

  int child_list_get_own_property(JSContext *ctx, JSPropertyDescriptor *desc, JSValueConst obj, JSAtom prop)
  {
    element* nl = (element*)(node*)JS_GetOpaque(obj, ElementList_class_id);
    if (!nl)
      return FALSE;

    uint n;
    if (!JS_AtomIsArrayIndex(ctx, &n, prop))
      return FALSE;
    if (n >= uint(nl->n_children()))
      return FALSE;
    if (desc) {
      desc->flags = JS_PROP_C_W_E;
      desc->getter = JS_UNDEFINED;
      desc->setter = JS_UNDEFINED;
      desc->value = conv<node*>::wrap(ctx, nl->child(n));
    }
    return TRUE;
  }

  JSClassExoticMethods ElementList_exotic_methods =
  {
    &child_list_get_own_property, // int(*get_own_property)(JSContext *ctx, JSPropertyDescriptor *desc, JSValueConst obj, JSAtom prop);
    NULL, // int(*get_own_property_names)(JSContext *ctx, JSPropertyEnum **ptab, uint32_t *plen, JSValueConst obj);
    /* return < 0 if exception, or TRUE/FALSE */
    NULL, //&element_delete_property,
    NULL, //&element_define_own_property,
    NULL, //&element_has_property,
    NULL, //&element_get_property,
    NULL, //&element_set_property, //&element_set_property
  };

  JSOM_PASSPORT_BEGIN(ElementList_def, html::element)
    JSOM_CONST_STR("[Symbol.toStringTag]", "ElementList", JS_PROP_CONFIGURABLE),
    JSOM_RO_PROP_DEF("length", child_list_length),
    JSOM_FUNC_DEF("item", child_list_item),
    JSOM_FUNC_DEF("[Symbol.iterator]", child_list_iterator),
    JSOM_PASSPORT_END

  void init_ElementList_class(context& c)
    {
      JS_NewClassID(&ElementList_class_id);

      static JSClassDef ElementList_class = {
        "ElementList",
        [](JSRuntime *rt, JSValue val)
        {
          node* pe = (node*)JS_GetOpaque(val, ElementList_class_id);
          if (pe) pe->release();
        },
        NULL,
        NULL,
        &ElementList_exotic_methods
      };

      JS_NewClass(JS_GetRuntime(c), ElementList_class_id, &ElementList_class);
      JSValue node_proto = JS_NewObject(c);

      auto list = ElementList_def();
      JS_SetPropertyFunctionList(c, node_proto, list.start, list.length);

      auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
      {
        return JS_EXCEPTION;
      };

      hvalue node_class = JS_NewCFunction2(c, ctor, "ElementList", 2, JS_CFUNC_constructor, 0);

      JS_DefinePropertyValueStr(c, c.global(), "ElementList", JS_DupValue(c, node_class), JS_PROP_WRITABLE | JS_PROP_CONFIGURABLE);

      JS_SetConstructor(c, node_class, node_proto);
      JS_SetClassProto(c, ElementList_class_id, node_proto);

    }

  
}