
#include "xdom.h"
#include "xom.h"
#include "xview.h"

#ifdef AUDIO_SUPPORT

#include "tool/tl_audio.h"

namespace qjs
{
  using namespace html;
  using namespace tool;

  JSClassID Audio_class_id = 0;

  struct xaudio : public tool::audio {

    typedef tool::audio super;

    weak_handle<document> pdoc;

    xaudio(xcontext& c) : pdoc(c.pdoc()) {}
    virtual ~xaudio() {}

    //JSValue      obj = JS_UNINITIALIZED;
    ustring      url;
    hvalue       onprogress;
    hvalue       onstop;
    function<void(xcontext&)> whenstop;

    array<byte>  this_data;
    mm_file      file_data;
    bytes        data;

    virtual void on_heartbit() override
    {
      if (!pdoc) { stop(); return; }
      super::on_heartbit();
      if (!onprogress) return;
      handle<xaudio> self = this;
      xcontext c(pdoc);
      c.pview()->async([self]() -> bool {
        xcontext c(self->pdoc);
        hvalue dummy;
        try { c.call(dummy, self->onprogress, JS_UNDEFINED); }
        catch (qjs::exception) { c.report_exception(); }
        return true;
      });
    }

    virtual void on_stop() override {
      if (!pdoc) { return; }
      super::on_stop();
      handle<xaudio> self = this;
      xcontext c(pdoc);
      c.pview()->async([self]() -> bool {
        xcontext c(self->pdoc);
        hvalue dummy;
        try { 
          self->whenstop(c);
          if(self->onstop)
            c.call(dummy, self->onstop, JS_UNDEFINED); 
        }
        catch (qjs::exception) { 
          c.report_exception(); 
        }
        //self->stop();
        self->onprogress.clear();
        self->onstop.clear();
        self->whenstop = nullptr;
        return true;
      });
    }

    bool stop() override {
      auto r = super::stop();
      release(); // we've done with the instance
      return r;
    }
  };

  typedef handle<xaudio> haudio;

  template <> struct conv<haudio>
  {
    static haudio unwrap(JSContext * ctx, JSValueConst v, int argc = 0)
    {
      haudio pr = (xaudio*)JS_GetOpaque(v, Audio_class_id);
      return pr;
    }

    static JSValue wrap(JSContext * ctx, haudio pr) noexcept
    {
      if (!pr)
        return JS_NULL;
      //if (pr->obj)
      //  return pr->obj;
      JSValue obj = JS_NewObjectClass(ctx, Audio_class_id);
      pr->add_ref();
      JS_SetOpaque(obj,pr.ptr());
      return obj;
    }
    static bool isa(JSContext * ctx, JSValueConst v) { return JS_GetOpaque(v, Audio_class_id) != NULL; }
  };

  hvalue audio_load(xcontext& c, string url) {

    if (url().starts_with(WCHARS("file:"))) 
    {
      JSValue resolving_callbacks[2] = { JS_UNINITIALIZED, JS_UNINITIALIZED };
      hvalue promise = JS_NewPromiseCapability(c, resolving_callbacks);

      hvalue   resolver = resolving_callbacks[0];
      hvalue   rejector = resolving_callbacks[1];
      hcontext hc = c.pdoc()->ns;
      ustring  path = url::file_url_to_path(url());

      c.pview()->async([resolver, rejector, hc, path]() -> bool {

        xcontext c(hc);
        haudio ha = new xaudio(c);
        bool r;
        try {
          if (ha->file_data.open(path))
          {
            ha->data = ha->file_data.bytes();
            c.call(r, resolver, JS_UNDEFINED, ha);
          }
          else 
            c.call(r, rejector, JS_UNDEFINED, c.val(404));
        }
        catch (qjs::exception) {
          c.report_exception();
        }
        return true; // consumed
      });
      return promise;
    }
    else {
      handle<request> hrq = new request(url, RESOURCE_DATA_TYPE::DATA_SOUND);

      hrq->dst = c.pdoc();
      hrq->dst_view = c.pview();

      JSValue resolving_callbacks[2] = { JS_UNINITIALIZED, JS_UNINITIALIZED };
      hvalue promise = JS_NewPromiseCapability(c, resolving_callbacks);

      hvalue   resolver = resolving_callbacks[0];
      hvalue   rejector = resolving_callbacks[1];
      hcontext hc = c.pdoc()->ns;

      hrq->add([resolver, rejector, hc](request* prq)->bool {
        xcontext c(hc);
        try {
          bool r;
          if (prq->success_flag) {
            haudio ha = new xaudio(c);
            ha->this_data.transfer_from(prq->data);
            ha->data = ha->this_data();
            c.call(r, resolver, JS_UNDEFINED, ha);
          }
          else // if (prq->status < 100 || prq->status >= 600 || prq->data.length() == 0)
            c.call(r, rejector, JS_UNDEFINED, c.val(prq->status));
        }
        catch (qjs::exception) {
          c.report_exception();
        }
        return true; // consumed
      });

      c.pview()->load_data(hrq);

      return promise;
    }
  }

  hvalue audio_play(xcontext& c, haudio ha, float_v progress) {

    JSValue resolving_callbacks[2] = { JS_UNINITIALIZED, JS_UNINITIALIZED };
    hvalue promise = JS_NewPromiseCapability(c, resolving_callbacks);

    hvalue   resolver = resolving_callbacks[0];
    hvalue   rejector = resolving_callbacks[1];
    hcontext hc = c.pdoc()->ns;

    ha->whenstop = ([resolver, rejector,ha](xcontext& c) {
      try {
        bool r;
        c.call(r, resolver, JS_UNDEFINED, ha);
      }
      catch (qjs::exception) {
        c.report_exception();
      }
      return true; // consumed
    });

    tool::audio::result_e result = ha->play(ha->data);
    if (result == tool::audio::success)
      ha->add_ref();
    else 
    {
      try {
        bool r;
        c.call(r, rejector, JS_UNDEFINED, c.val((int)result));
      }
      catch (qjs::exception) {
        c.report_exception();
      }
    }
    return promise;
  }

  bool audio_stop(xcontext& c, haudio ha) {
    return ha->stop();
  }


  float audio_get_volume(xcontext& c, haudio ha) {
    float v = 0;
    ha->get_volume(v);
    return v;
  }

  bool audio_set_volume(xcontext& c, haudio ha, float v) {
    return ha->set_volume(v);
  }

  bool audio_pause(xcontext& c, haudio ha) {
    return ha->pause();
  }

  bool audio_resume(xcontext& c, haudio ha) {
    return ha->resume();
  }

  hvalue audio_get_progress(xcontext& c, haudio ha) {
    float v = 0;
    if(ha->get_position(v))
      return c.val(v);
    return JS_UNDEFINED;
  }

  bool audio_set_progress(xcontext& c, haudio ha, float v) {
    //return ha->set_volume(v);
    return false;
  }
  
  JSOM_PASSPORT_BEGIN(Audio_def, xaudio)
    JSOM_CONST_STR("[Symbol.toStringTag]", "Audio", JS_PROP_CONFIGURABLE),
    JSOM_FUNC_DEF("play", audio_play),
    JSOM_FUNC_DEF("stop", audio_stop),
    JSOM_FUNC_DEF("pause", audio_pause),
    JSOM_FUNC_DEF("resume", audio_resume),
    JSOM_PROP_DEF("progress", audio_get_progress, audio_set_progress),
    JSOM_PROP_DEF("volume", audio_get_volume, audio_set_volume),
  JSOM_PASSPORT_END

  JSOM_PASSPORT_BEGIN(Audio_static_def, xcontext)
    JSOM_GLOBAL_FUNC_DEF("load", audio_load),
  JSOM_PASSPORT_END


  void init_Audio_class(context& c)
  {
    JS_NewClassID(&Audio_class_id);

    static JSClassDef Audio_class = {
      "Audio",
      [](JSRuntime *rt, JSValue val)
      {
        xaudio* pe = (xaudio*)JS_GetOpaque(val,Audio_class_id);
        if (pe) {
          //pe->obj = JS_UNINITIALIZED;
          pe->release();
        }
      }, 
      [](JSRuntime *rt, JSValueConst val, JS_MarkFunc *mark_func) {
        xaudio* pe = (xaudio*)JS_GetOpaque(val,Audio_class_id);  
        JS_MarkValue(rt, pe->onprogress, mark_func);
        JS_MarkValue(rt, pe->onstop, mark_func);
      }
    };

    JS_NewClass(JS_GetRuntime(c), Audio_class_id, &Audio_class);
    JSValue audio_proto = JS_NewObject(c);

    auto list = Audio_def();
    JS_SetPropertyFunctionList(c, audio_proto, list.start, list.length);

    auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
    {
      return JS_UNDEFINED;
#if 0
      JSValue obj = JS_UNDEFINED;
      JSValue proto;
      html::helement el;
      string   type;
      xcontext c(ctx);
      handle<xaudio> htz;
      handle<xtok_stream> ps;

      /* using new_target to get the prototype is necessary when the class is extended. */
      proto = JS_GetPropertyStr(ctx, new_target, "prototype");
      if (JS_IsException(proto))
        goto fail;
      obj = JS_NewObjectProtoClass(ctx, proto, Audio_class_id);
      JS_FreeValue(ctx, proto);
      if (JS_IsException(obj))
        goto fail;

      el = argc > 0 ? c.get<helement>(argv[0]) : nullptr;
      if (!el) {
        JS_ThrowTypeError(ctx, "not a DOM element");
        goto fail;
      }

      ps = new element_xtok_stream(el);

      type = argc > 1 ? c.get<string>(argv[1]) : string();
      if (type.like("text/htm*") || type == CHARS("text/svg") || type.like("text/xml*")) {
        htz = new xaudio_markup(ps);
      }
      else if (type.like("text/*") || type.like("*/json") || type.like("*script") || type.like("application/*")) {
        htz = new xaudio_source(ps, nullptr, type == CHARS("text/css"));
      }
      else {
        JS_ThrowTypeError(ctx, "not supported mime type");
        goto fail;
      }

      JS_SetOpaque(obj, htz.detach());
      return obj;
    fail:
      //js_free(ctx, s);
      JS_FreeValue(ctx, obj);
      return JS_EXCEPTION;
#endif
    };


    hvalue audio_class = JS_NewCFunction2(c, ctor, "Audio", 2, JS_CFUNC_constructor, 0);
    auto Audio_statics = Audio_static_def();
    JS_SetPropertyFunctionList(c, audio_class, Audio_statics.start, Audio_statics.length);
    JS_DefinePropertyValueStr(c, c.global(), "Audio", JS_DupValue(c, audio_class), JS_PROP_CONFIGURABLE);

    JS_SetConstructor(c, audio_class, audio_proto);
    JS_SetClassProto(c, Audio_class_id, audio_proto);
  }

}

#endif