#include "xdom.h"
#include "xom.h"
#include "xattributeslist.h"

namespace qjs
{
  using namespace tool;

  JSClassID AttributeList_class_id = 0;

  hvalue atts_get_item(xcontext& c, html::attribute_list_provider* sp, uint n) {
    html::element* pe = static_cast<html::element*>(sp);
    if (n >= pe->atts.length()) return JS_NULL;
    hvalue attr = JS_NewObject(c);
    c.set_prop(c.known_atoms().name, attr, pe->atts.name(int(n)));
    c.set_prop(c.known_atoms().value, attr, pe->atts.value(int(n)));
    return attr;
  }

  hvalue atts_get_named_item(xcontext& c, html::attribute_list_provider* sp, string name) {
    html::element* pe = static_cast<html::element*>(sp);
    ustring v;
    if(!pe->atts.get(name,v)) 
      return JS_NULL;
    hvalue attr = JS_NewObject(c);
    c.set_prop(c.known_atoms().name, attr, name);
    c.set_prop(c.known_atoms().value, attr, v);
    return attr;
  }

  bool atts_remove(xcontext& c, html::attribute_list_provider* sp, string name)
  {
    html::element* pe = static_cast<html::element*>(sp);
    return pe->remove_attr(name, c.pview());
  }

  uint atts_length(xcontext& c, html::attribute_list_provider* sp) {
    html::element* pe = static_cast<html::element*>(sp);
    return uint(pe->atts.length());
  }

  /*array<ustring> cl_entries(xcontext& c, html::attribute_list_provider* sp) {
    html::element* pe = static_cast<html::element*>(sp);
    array<ustring> out;
    for (auto c1 : pe->atts.classes())
      out.push(c1);
    return out;
  }*/

  hvalue atts_iterator(xcontext& c, html::attribute_list_provider* nl)
  {
    return make_iterator(c, new attribute_list_value_iterator(nl));
  }

  JSOM_PASSPORT_BEGIN(AttributeList_def, html::element)
    JSOM_CONST_STR("[Symbol.toStringTag]", "Element.AttributeList", JS_PROP_CONFIGURABLE),
    JSOM_RO_PROP_DEF("length", atts_length),
    JSOM_FUNC_DEF("item", atts_get_item),
    JSOM_FUNC_DEF("getNamedItem", atts_get_named_item),
    //JSOM_FUNC_DEF("setNamedItem", atts_set_named_item),
    JSOM_FUNC_DEF("[Symbol.iterator]", atts_iterator),
  JSOM_PASSPORT_END

  int atts_has_property(JSContext *ctx, JSValueConst obj, JSAtom atom)
  {
    xcontext c(ctx);
    html::attribute_list_provider* sp = conv<html::attribute_list_provider*>::unwrap(ctx, obj, 0);
    html::element* pe = static_cast<html::element*>(sp);
    atom_chars ac(c, atom);
    return pe->atts.exist(ac) ? 1 : 0;
  }
  /*JSValue  atts_get_property(JSContext *ctx, JSValueConst obj, JSAtom atom, JSValueConst receiver)
  {
    xcontext c(ctx);
    html::attribute_list_provider* sp = conv<html::attribute_list_provider*>::unwrap(ctx, obj, 0);
    html::element* pe = static_cast<html::element*>(sp);
    atom_chars ac(c, atom);
    ustring v;
    if (pe->atts.get(ac, v))
      return conv<ustring>::wrap(ctx, v);
    return JS_UNDEFINED;
  }
  int      atts_set_property(JSContext *ctx, JSValueConst obj, JSAtom atom, JSValueConst value, JSValueConst receiver, int flags)
  {
    xcontext c(ctx);
    html::attribute_list_provider* sp = conv<html::attribute_list_provider*>::unwrap(ctx, obj, 0);
    html::element* pe = static_cast<html::element*>(sp);
    atom_chars ac(c, atom);
    if (value == JS_UNDEFINED)
      pe->remove_attr(ac, c.pview());
    else {
      ustring v = conv<ustring>::unwrap(c, value, 0);
      pe->set_attr(ac, v, c.pview());
    }
    return 1;
  }*/

  int atts_get_own_property(JSContext *ctx, JSPropertyDescriptor *desc, JSValueConst obj, JSAtom prop)
  {
    xcontext c(ctx);
    html::attribute_list_provider* sp = conv<html::attribute_list_provider*>::unwrap(ctx, obj, 0);
    html::element* pe = static_cast<html::element*>(sp);
    atom_chars ac(c, prop);
    ustring v;
    if (pe->atts.get(ac, v)) {
      if (desc) {
        desc->flags = JS_PROP_C_W_E;
        desc->getter = JS_UNDEFINED;
        desc->setter = JS_UNDEFINED;
        desc->value = JS_UNDEFINED;
        desc->value = conv<ustring>::wrap(ctx, v);
      }
      return TRUE;
    }
    return FALSE;
  }

  int atts_define_own_property(JSContext *ctx, JSValueConst this_obj, JSAtom prop, JSValueConst val, JSValueConst getter, JSValueConst setter, int flags)
  {
    xcontext c(ctx);
    html::attribute_list_provider* sp = conv<html::attribute_list_provider*>::unwrap(ctx, this_obj, 0);
    html::element* pe = static_cast<html::element*>(sp);
    atom_chars ac(c, prop);
    if (val == JS_UNDEFINED)
      pe->remove_attr(ac, c.pview());
    else {
      ustring v = conv<ustring>::unwrap(c, val, 0);
      pe->set_attr(ac, v, c.pview());
    }
    return 1;
  }

  int atts_delete_property(JSContext *ctx, JSValueConst obj, JSAtom prop) {
    xcontext c(ctx);
    html::attribute_list_provider* sp = conv<html::attribute_list_provider*>::unwrap(ctx, obj, 0);
    html::element* pe = static_cast<html::element*>(sp);
    atom_chars ac(c, prop);
    pe->remove_attr(ac, c.pview());
    return 1;
  }

  /*JSClassExoticMethods AttributeList_exotic_methods =
  {
    NULL, // int(*get_own_property)(JSContext *ctx, JSPropertyDescriptor *desc, JSValueConst obj, JSAtom prop);
    NULL, // int(*get_own_property_names)(JSContext *ctx, JSPropertyEnum **ptab, uint32_t *plen, JSValueConst obj);
    NULL, //&element_delete_property,
    NULL, //&element_define_own_property,
    &atts_has_property,
    &atts_get_property,
    &atts_set_property, 
  };*/

  JSClassExoticMethods AttributeList_exotic_methods =
  {
    &atts_get_own_property, // int(*get_own_property)(JSContext *ctx, JSPropertyDescriptor *desc, JSValueConst obj, JSAtom prop);
    NULL, // int(*get_own_property_names)(JSContext *ctx, JSPropertyEnum **ptab, uint32_t *plen, JSValueConst obj);
    /* return < 0 if exception, or TRUE/FALSE */
    &atts_delete_property,
    &atts_define_own_property,
    &atts_has_property, //&element_has_property,
    NULL, //&element_get_property,
    NULL, //&element_set_property, //&element_set_property
  };


  void init_AttributeList_class(context& c)
  {
    JS_NewClassID(&AttributeList_class_id);

    static JSClassDef AttributeList_class = {
      "AttributeList",
      [](JSRuntime *rt, JSValue val)
      {
        html::element* pe = (html::element*)JS_GetOpaque(val,AttributeList_class_id);  //object_of<html::element>(val);
        if (pe)
          pe->release();
      },
      nullptr, //gc_mark;
      nullptr, //JSClassCall *call;
      &AttributeList_exotic_methods
    };

    JS_NewClass(JS_GetRuntime(c), AttributeList_class_id, &AttributeList_class);
    JSValue attributes_proto = JS_NewObject(c);

    auto list = AttributeList_def();
    JS_SetPropertyFunctionList(c, attributes_proto, list.start, list.length);

    auto ctor = [](JSContext *ctx, JSValueConst new_target, int argc, JSValueConst *argv) -> JSValue
    {
      JSValue obj = JS_UNDEFINED;
      return JS_EXCEPTION;
    };

    hvalue attributes_class = JS_NewCFunction2(c, ctor, "AttributeList", 2, JS_CFUNC_constructor, 0);

    hvalue element_class = c.get_prop<hvalue>("Element", c.global());
    assert(element_class);

    JS_DefinePropertyValueStr(c, element_class, "AttributeList", JS_DupValue(c, attributes_class), JS_PROP_CONFIGURABLE);

    JS_SetConstructor(c, attributes_class, attributes_proto);
    JS_SetClassProto(c, AttributeList_class_id, attributes_proto);
  }


}