#ifndef __xdom_xview_h__
#define __xdom_xview_h__

#include "html/html.h"
#include "tiscript/include/cs.h"

namespace tis {
  using namespace tool;
  using namespace gool;
  // using namespace html;

  enum ELEMENT_INTERFACE_IDs {
    ATTRIBUTE_IFACE,
    STYLE_IFACE,
    STATE_IFACE,
    EXTENDERS_IFACE,
    // GRAPHICS_IFACE
    INTERFACE_IDs_SIZE
  };

  class xview;

  struct gfx_ctl : public resource {
    handle<html::element>  self;
    handle<html::graphics> gfx;
    gfx_ctl() : gfx(0) {}
  };

  class xvm : public VM {
    typedef VM super;

  public:
    // xview*          current_view;
    dispatch *viewDispatch;
    dispatch *elementDispatch;
    dispatch *nodeDispatch;
    dispatch *eventDispatch;
    dispatch *sciterDispatch;
    dispatch *requestDispatch;
    dispatch *graphicsDispatch;
    dispatch *pathDispatch;
    dispatch *textDispatch;
    dispatch *imageDispatch;

    dispatch *selectionDispatch;
    dispatch *transactDispatch;

    dispatch *tokenizerDispatch;

#ifdef SUPPORT_SPELL
    dispatch *spellDispatch;
#endif
#ifdef SUPPORT_DLL_LOAD
    dispatch *libDispatch;
#endif
#ifdef AUDIO_SUPPORT
    dispatch *audioDispatch;
#endif

    // pvalue          behaviorObject;
    // pvalue          elementListObject;
    // pvalue          nodeListObject;

    value elementListObject;
    value nodeListObject;

#ifdef PAGER_SUPPORT
    dispatch *pagerDispatch;
#endif
    // dispatch*       richtextDispatch;

    dispatch *elementInterfaces[INTERFACE_IDs_SIZE];

    tool::array<xview *> views;
    xview *              owning_view;
    xview *              _current_view;

    xvm(unsigned int features = 0xFFFFFFFF, long size = TISCRIPT_HEAP_SIZE,
        long expandSize = TISCRIPT_EXPAND_SIZE,
        long stackSize  = TISCRIPT_STACK_SIZE)
        : VM(features, size, expandSize, stackSize), owning_view(nullptr),
          _current_view(nullptr) {
      // current_view = 0;
      viewDispatch    = 0;
      elementDispatch = 0;
      nodeDispatch    = 0;
      eventDispatch   = 0;
      // richtextDispatch = 0;
      transactDispatch = 0;
      // behaviorDispatch = 0;
      sciterDispatch    = 0;
      requestDispatch   = 0;
      graphicsDispatch  = 0;
      pathDispatch      = 0;
      imageDispatch     = 0;
      // richtextDispatch = 0;
      // behaviorObject.pin(this);
      elementListObject = UNDEFINED_VALUE;
      nodeListObject    = UNDEFINED_VALUE;
#ifdef SUPPORT_SPELL
      spellDispatch = 0;
#endif
#ifdef SUPPORT_DLL_LOAD
      libDispatch = 0;
#endif
#ifdef PAGER_SUPPORT
      pagerDispatch = 0;
#endif
      init();
    }
    void init();
    void init_view_class();
    void init_element_class();
    void init_node_class();
    // void    init_behavior_class();
    void init_element_attributes_class();
    void init_element_state_class();
    void init_element_styles_class();
    void init_richtext_class();
    void init_selection_class();
    void init_graphics_class();
    void init_image_class();
    void init_event_class();
    void init_sciter_class();
    void init_tokenizer_class();
//#ifdef WEBSOCKETS_SUPPORT
//    void init_websocket_class();
//#endif
#ifdef SUPPORT_SPELL
    void init_spell_class();
#endif
#ifdef PAGER_SUPPORT
    void init_pager_class();
#endif
#ifdef SUPPORT_DLL_LOAD
    void init_lib_class();
#endif

#ifdef AUDIO_SUPPORT
    void init_audio_class();
#endif

    virtual void                GC_started();
    //virtual tool::async::tasks *get_tasks() override;

    ~xvm() {}

    virtual void final_release() {
      async::dispatch::shutdown_current();
    }

    virtual bool post(function<bool(void)> &&pc);
    virtual bool send(function<bool(void)> &&pc);

    virtual tool::ustring resolve_url(const tool::ustring &base,
                                      const tool::ustring &relative);
    virtual stream *      open_stream(const tool::ustring &url, bool as_text);

    xview *         current_view();
    html::document *current_doc();
    virtual int     pixels_per_inch() override;
    virtual bool    resolveNamedColor(value tuple, uint* pout) override;

    virtual bool has_log_values() override;
    virtual bool log_values(slice<value> list, value mode = UNDEFINED_VALUE, value location = UNDEFINED_VALUE, bool as_stringizer = false) override;

    virtual tool::ustring lang();

    virtual tool::value x_value_to_value(value v) override;
    virtual value       x_value_to_value(tool::value v) override;

    virtual value process_vnode(value factory, value atts, value kids, value states, html::hnode& pexisting_node, html::hnode parent);

    static xvm *create() { 
      return new xvm(); 
    }

  };

  value CSF_$_global(xvm *c);
  value CSF_$$_global(xvm *c);

  extern value          element_object_nc(xvm *c, html::element *b);
  extern value          element_object(xvm *c, html::element *b);
  extern html::element *element_ptr(xvm *c, value obj);

  // struct xrequest : html::pump::request
  //{
  //  pvalue          callback_obj;
  //
  //  xrequest( xvm* pvm, const string& url )
  //    :callback_obj(pvm)
  //    , html::pump::request(url, html::DATA_RAW_DATA) {}
  //
  //  virtual ~xrequest( ) {/* callback_obj.unpin();*/ }
  //};

  struct virtual_console_stream : public tis::stream {
    array<wchar> putbuf;
    array<wchar> getbuf;
    int          channel;
    xview *      p_view;

    virtual_console_stream() : p_view(0), channel(0) {}
    virtual_console_stream(xview *pv, int ch) : p_view(pv), channel(ch) {}

    // bool callback( const tool::value& p1, const tool::value& p2, tool::value&
    // r );

    virtual int  get();
    virtual bool put(int ch);

            void flush();

  };

  struct blackhole_stream : public tis::stream {
    virtual int  get() { return 0; }
    virtual bool put(int ch) { return true; }
    blackhole_stream() {}
  };

  struct console_stream : public tis::stream {
    bool  initialized;
    wchar to_wchar(char c) {
      wchar wc = c;
#ifdef WINDOWS
      MultiByteToWideChar(CP_OEMCP, 0, &c, 1, &wc, 1);
#endif
      return wc;
    }
    char to_char(wchar wc) {
      char c = '?';
#ifdef WINDOWS
      WideCharToMultiByte(CP_OEMCP, 0, &wc, 1, &c, 1, 0, 0);
#else
      c = char(wc);
#endif
      return c;
    }

    virtual int get() {
      int c = getchar();
      return c != EOF ? to_wchar(char(c)) : EOS;
    }
    virtual bool put(int ch) {
#ifdef WINDOWS
      if (!initialized) {
        AllocConsole();
#pragma warning(push)
#pragma warning(disable : 4996)
        freopen("conin$", "r", stdin);
        freopen("conout$", "w", stdout);
        freopen("conout$", "w", stderr);
#pragma warning(pop)
      }
#endif
      putchar(to_char(wchar(ch)));
      return true;
    }
    console_stream() : initialized(false) {}
  };

  extern blackhole_stream blackhole;
  extern console_stream   console;

  struct vsubscription {
    ustring    name;
    ustring    ns;
    tis::value fcn;

    bool match(wchars selector, tis::value fn = 0) const;
  };

  class xview : public html::view, tis::loader {
  public:
    typedef html::view super;

    pvalue view_obj;
    pvalue event_obj;
    pvalue param;

    handle<xvm>  vm;
    tristate_v   owns_vm;
    html::event *pevt;
    value        evt_group;

    string home_url;

    virtual_console_stream vstdin;
    virtual_console_stream vstdout;
    virtual_console_stream vstderr;

    pvalue          graphics_obj; // Graphics instace for direct drawing.
    handle<gfx_ctl> graphics_ctl; // Graphics context.

    pvalue                dialog_retval;
    array<html::helement> deletion_queue;

    unsigned int last_gc_generation; // used executed by on_gc

    xview(const window_params& params) : super(params), evt_group(UNDEFINED_VALUE), last_gc_generation(0) {
      // is_unloading = false;
      // root_obj = 0;
      view_obj  = 0;
      event_obj = 0;
      pevt      = 0;
      param     = 0;

      if (!params.owns_vm) {
        if (params.parent)
          vm = params.parent.ptr_of<xview>()->vm;
        else {
          VM *thread_vm = VM::get_current();
          if (thread_vm && thread_vm->is_of_type<xvm>())
            vm = static_cast<xvm *>(thread_vm);
        }
      }
      if (!vm)
        vm = new xvm();

      if (vm) 
      {
        if (vm->views.size() == 0) {
          // very first view in the VM
          vm->owning_view = this;
          vm->enableDebug = !!params.debug_mode.val(html::view::default_debug_mode) || debug_mode();
          owns_vm = true;
          vm->set_loader(this);

          bind_vm_console();
        }


#ifdef _DEBUG
        assert(vm->views.get_index(this) < 0); // start needs to be called precisely once.
#endif
        vm->views.push(this);
        view_obj.pin(vm, CsMakeCPtrObject(vm, vm->viewDispatch, this));
        event_obj.pin(vm, CsMakeCPtrObject(vm, vm->eventDispatch, this));
        dialog_retval.pin(vm);
        dialog_retval = NOTHING_VALUE;
        param.pin(vm, value_to_value(vm, params.window_parameters));
      }
    }

    virtual ~xview() { /*purge_deleted_elements();*/ }

    virtual bool can_use_feature(uint flag) override { return vm ? vm->can_use_feature(flag) : false; }

    /*virtual void start(const window_params& params) override {

      if (!params.owns_vm) {
        if (params.parent)
          vm = params.parent.ptr_of<xview>()->vm;
        else {
          VM *thread_vm = VM::get_current();
          if (thread_vm && thread_vm->is_of_type<xvm>())
            vm = static_cast<xvm *>(thread_vm);
        }
      }
      if (!vm) {
        vm = new xvm();
        vm->owning_view = this;
        vm->enableDebug = !!params.debug_mode.val(html::view::default_debug_mode) || debug_mode();
        owns_vm = true;
        vm->set_loader(this);

        bind_vm_console();
      }

      if (vm) {
#ifdef _DEBUG
        assert(vm->views.get_index(this) < 0); // start needs to be called precisely once.
#endif
        vm->views.push(this);
        view_obj.pin(vm, CsMakeCPtrObject(vm, vm->viewDispatch, this));
        event_obj.pin(vm, CsMakeCPtrObject(vm, vm->eventDispatch, this));
        dialog_retval.pin(vm);
        dialog_retval = NOTHING_VALUE;
        param.pin(vm, value_to_value(vm, params.window_parameters));
      }
      super::start(params);
    }*/

    void bind_vm_console() {
      vstdin.p_view = this; vstdin.channel = 0; vm->standardInput = &vstdin;
      vstdout.p_view = this; vstdout.channel = 1; vm->standardOutput = &vstdout;
      vstderr.p_view = this; vstderr.channel = 2; vm->standardError = &vstderr;
    }

    void enqueue_for_deletion(html::element *pb);
    virtual void purge_deleted_elements();

    virtual void debug_mode(bool onoff) { 
      super::debug_mode(onoff); 
      if (vm) 
        vm->enableDebug = onoff;
    }
    virtual bool debug_mode() const { return super::debug_mode(); }

    virtual void stop() override {
      super::stop();
      if (doc()) on_unload(doc());

      if(view_obj.is_set())
        CsSetCObjectValue(view_obj, 0);
      event_obj.unpin();
      view_obj.unpin();
      param.unpin();
      if (vm) {
        index_t idx = vm->views.get_index(this);
        if (idx >= 0) vm->views.remove(idx);
        if (owns_vm) {
          if (vm->views.size()) {
            xview *next = vm->views.first();
            vm->set_loader(next);
            vm->owning_view    = next;
            next->owns_vm      = true;
            next->bind_vm_console();
          } else {
            vm->owning_view = nullptr;
            vm->set_loader();
            vm->standardInput  = &blackhole;
            vm->standardOutput = &blackhole;
            vm->standardError  = &blackhole;
          }
#ifdef _DEBUG
          CsDumpSymbolTable(vm);
#endif
        }
        purge_deleted_elements();
      }
      vm = 0;
    }
      
    virtual tool::ustring do_resolve_url(const tool::ustring &base,
                                         const tool::ustring &relative) {
      tool::string _base     = url::escape(base);
      tool::string _relative = url::escape(relative);
      return url::unescape(html::combine_url(_base, _relative));
    }
    virtual tis::stream *do_open_stream(const tool::ustring &uri,
                                        bool                 as_text) {
      handle<html::pump::request> prq =
          new html::pump::request(url::escape(uri), html::DATA_RAW_DATA);
      if (load_data(prq, true)) {
        if (as_text) {
          tis::string_stream_sd *ps = new tis::string_stream_sd(prq->data());
          ps->name                  = prq->url;
          return ps;
        } else {
          tis::binary_i_stream *ps =
              new tis::binary_i_stream(prq->data, prq->url);
          return ps;
        }
      }
      return 0;
      // stream*
      // VM::open( const tool::ustring& url )
    }

    static xview *get(HWINDOW hwnd);
      
    static void set_init_script(const char* script_text);

    //virtual bool wants_idle() override { return need_polling(); }
    //virtual bool exec_idle() { return poll(); }

    //virtual void start_polling() override { request_idle(); }
    //virtual void stop_polling() override {}

    void run(stream &in, html::hdocument pd,int line_no = 1);
    value eval(stream &in, html::hdocument pd, int line_no = 1);
    bool invoke_event_function(html::hdocument pd, html::event &evt, html::element *b, value b_obj, value selector);
    bool invoke_event_function(html::hdocument pd, value obj, value selector, value arg = 0);
    // bool    invoke_function(const string& name, value* argv, int argc, value&
    // ret);

    bool send_notification(html::hdocument pd, value obj, value selector, value &result);
    bool send_notification(html::hdocument pd, value obj, value selector, value p, value &result);
    bool send_notification(html::hdocument pd, value obj, value selector, value p1, value p2, value &result);

    virtual bool handle_on_idle() override;

    virtual bool load_script(html::document *root, const string &url, const string &mime_type, wchars text);
    virtual bool include_script(html::document *root, const string &url, const string &mime_type = string());

    // SSX stuff:
    virtual bool mount_component(html::helement component);

    virtual bool ask_unload(html::document *,
                            view::UNLOAD_REASON reason) override;
    virtual bool on_unload(html::document *) override;
    virtual void on_load_end(html::document *d, bool existing_doc_replaced) override;
    virtual void on_load_start(html::document *d) override;
    virtual void on_element_removed(html::element *psb) override;
    virtual void on_element_removing(html::element *psb) override;

    virtual void on_style_resolved(handle<html::element> psb,
                                   const html::style *   prev_style) override;
    void process_prototype(handle<html::element> psb, const string &name,
                           const string &prev_name);
    void process_handlers(handle<html::element>       psb,
                          const html::handler_list_v &handler_list);

#ifdef _DEBUG 
    virtual void dbg_print_stack_trace() override {
      CsStackTrace(vm);
    };
#endif // _DEBUG 

    // virtual bool postprocess_loaded_data(html::pump::request* prq) override;

    virtual bool on(html::view &v, html::element *self,
                    html::event_behavior &evt) override;
    virtual bool on(html::view &v, html::element *self,
                    html::event_mouse &evt) override {
      return super::on(v, self, evt);
    }

    virtual bool on_element_event(html::element *    b,
                                  html::event_mouse &evt) override;
    virtual bool on_element_event(html::element *  b,
                                  html::event_key &evt) override;
    virtual bool on_element_event(html::element *    b,
                                  html::event_focus &evt) override;
    virtual bool on_element_event(html::element *     b,
                                  html::event_scroll &evt) override;
    virtual bool on_element_event(html::element *       b,
                                  html::event_behavior &evt) override;
    virtual bool on_element_event(html::element *      b,
                                  html::event_command &evt) override;
    virtual bool on_element_event(html::element *       b,
                                  html::event_exchange &evt) override;
    virtual bool on_element_event(html::element *      b,
                                  html::event_gesture &evt) override;
    virtual bool on_element_timer(html::element *b, 
                                  html::timer_def &td) override;
    virtual bool on_element_data_arrived(html::element *      b,
                                         html::pump::request *prq) override;

    virtual void on_data_request_notify(html::element *self, pump::request *rq) override;
    virtual void on_data_arrived_notify(html::element *self, pump::request *rq) override;

    virtual bool on_element_draw_background(html::graphics *pg,
                                            html::element *el, point pos);
    virtual bool on_element_draw_foreground(html::graphics *pg,
                                            html::element *el, point pos);
    virtual bool on_element_draw_content(html::graphics *pg, html::element *el,
                                         point pos);
    virtual bool on_element_draw_outline(html::graphics *pg, html::element *el,
                                         point pos);

    virtual bool hit_test_element(html::element *b, point zpt);

    // virtual bool block_is_focusable(html::element* b);

    // virtual bool do_load_data(html::pump::request* rq) override;
    // virtual bool on_load_data(html::pump::request* rq) override;
    // virtual bool on_data_loaded(html::pump::request* rq);

    virtual bool send_behavior_event(html::event_behavior &evt) override;
    virtual void dispatch_posted_event(handle<html::posted_event> pe) override;

    // virtual bool timer_id_are_equal(html::TIMER_KIND kind, html::timer_id
    // id1, html::timer_id id2);

    virtual string get_sciter_home();

    // virtual void on_element_draw_background(html::element *b, gool::surface&
    // sf, const gool::rect& rcborder);  virtual void
    // on_element_draw_content(html::element *b, gool::surface& sf, const
    // gool::rect& rc);  virtual void on_element_draw_foreground(html::element
    // *b, gool::surface& sf, const gool::rect& rcborder);
    virtual void on_element_client_size_changed(html::element *b) override;
    virtual void on_element_visibility_changed(html::element *b, bool on_off) override;
    virtual bool may_have_on_size_handler(html::element *b) override;

    virtual void on_size(gool::size sz);
    virtual void on_move();
    virtual void on_state_changed();
    virtual void on_element_behavior_changed(html::element *b,
                                             const string & old_names,
                                             const string & new_names) override;
    virtual bool on_move_request(gool::rect &rc) override;
    virtual bool on_size_request(int side_id, gool::rect &rc) override;

    virtual void on_start_ui_replacement(tristate_v sizing = tristate_v()) override;
    virtual void on_end_ui_replacement(tristate_v sizing = tristate_v()) override;

    virtual bool on_activate(html::ACTIVATE_MODE am);

    virtual void on_gc();

    // value get_graphics(html::graphics* pg, html::element *b);
    virtual void commit_drawing_buffers();
    // void  release_graphics(const graphics_state& gs);

    virtual bool call_behavior_method(html::element *b, const char *name,
                                      const tool::value *argv, size_t argc,
                                      tool::value &retval) override {
      return super::call_behavior_method(b, name, argv, argc, retval);
    }

    /*virtual bool call_behavior_method(html::element *b, tis::VM *c,
                                      tis::value  tag,
                                      tis::value &retval) override {
      return super::call_behavior_method(b, c, tag, retval);
    }*/

    virtual bool call_behavior_method(html::method_params *p) override;
    virtual bool call_behavior_method(html::element *b, html::method_params *p) override;
    virtual bool get_element_value(html::helement b, tool::value &v,bool ignore_text_value) override;
    virtual bool set_element_value(html::helement b, const tool::value &v, bool ignore_text_value) override;

    virtual bool get_element_property(html::helement b, wchars name, ustring &v) override;

    //        void setup_window(html::document* d);

    void post_event(html::posted_event& evt, bool only_if_not_exist = false) {
      if (only_if_not_exist) {
        for (auto& he : posted_events) {
          if (*he == evt)
            return;
        }
      }
      posted_events.push(new html::posted_event(evt));
      request_idle();
    }

    virtual void on_dpi_changed(size dpi, rect proposed_window_rect) override;
    virtual bool on_media_changed() override {
      super::on_media_changed();
      fire_event(WCHARS("mediachange"));
      return true;
    }

    // void subscribe(wchars selector, tis::value fun);
    // void unsubscribe(wchars selector, tis::value fun);
    // bool each_handler(wchars selector, function<bool(vsubscription&)> oneach
    // );
    bool fire_event(wchars name, function<tis::value()> param = nullptr);

    virtual bool trayicon_notify(point screen_pt, uint buttons, html::mouse_events evt) override;

  };

  inline bool has_object(const html::node *b) { return b->obj != 0; }

  value element_object(xvm *pvm, html::element *b);
  value element_object_nc(
      xvm *          pvm,
      html::element *b); // returns 0 if there is no scripting expando created.
  html::element *block_ptr(xvm *c, value obj);

  value attributes_object(xvm *c, html::element *b);
  value style_object(xvm *c, html::element *b);

  uint event_handler_sym_mask(value sym);
  bool will_handle(xvm *c, html::element *self, uint event_mask);

  xview *xview_ptr(xvm *c, value obj);
  xview *xview_ptr(xvm *c);

  /*struct  input_utf8_stream: public stream
  {
    bool  auto_delete;
    const byte* start;
    const byte* ptr;
    const byte* end;
    ustring name;
    input_utf8_stream(const byte *str, size_t len, const ustring& id, bool
  auto_del = false): name(id), auto_delete(auto_del)
    {
      start = ptr = str;
      end = str + len;
    }
    virtual int get();
    virtual const wchar* stream_name() const { return name; }

    virtual bool delete_on_close() { return auto_delete; }

  };

  struct  input_utf8_buffered_stream: public input_utf8_stream
  {
    tool::array<byte> buffer;
    input_utf8_buffered_stream(tool::array<byte>& buf, const ustring& id):
  input_utf8_stream( buf.head(), buf.size(), id, true)
    {
      buffer.swap(buf);
    }
  };*/

#define C_METHOD_ENTRY_X(name, fcn) c_method(name, (c_method_t)fcn)
#define VP_METHOD_ENTRY_X(name, get, set) vp_method(name, (vp_get_t)get, (vp_set_t)set)
#define CONSTANT_ENTRY_X(name, val) constant(name, val)

#define CHECK_FEATURE(f)                                                       \
  if ((c->features & f) == 0) return c->undefinedValue;

  // extern value            cvt_json_value_to_value(VM *c, const
  // sciter::value_t& v );  extern sciter::value_t  cvt_value_to_json_value(VM
  // *c, value v );

  extern bool call_element_method(xvm *c, html::element *self,
                                  const char *sname, int argc,
                                  const tool::value *argv, tool::value &retval);
  extern bool call_element_function(xvm *c, html::element *self,
                                    const char *sname, int argc,
                                    const tool::value *argv,
                                    tool::value &      retval);

  // value parse_response(xvm* vm, html::request* rq );

  struct auto_graphics {
    pvalue  graphics_obj;
    gfx_ctl graphics_ctl;
    uint    nlayers;
    auto_graphics(xvm *c, html::graphics *pg, html::element *b) {
      value val = CsMakeCPtrObject(c, c->graphicsDispatch, &graphics_ctl);
      graphics_obj.pin(c, val);
      graphics_ctl.gfx  = pg;
      graphics_ctl.self = b;
      nlayers           = pg->n_layers();
    }

    ~auto_graphics() {
      while (graphics_ctl.gfx->n_layers() > nlayers)
        graphics_ctl.gfx->pop_layer();
      CsSetCObjectValue(graphics_obj, nullptr);
    }
  };

} // namespace tis

#endif
