#include "xsciter.h"

namespace tis {

  static uint firstId = 0;

#define SYMDEF(s) #s,
  static const char *names[] = {
#include "xsymbols.inl"
  };
#undef SYMDEF

  struct init_symbols {
    init_symbols() {
      firstId = symbol_table()[names[0]];
      for (int n = 1; n < items_in(names); ++n)
        (void)symbol_table()[names[n]];
      firstId = firstId;
    }
  };

  init_symbols initializer;

  uint get_sym_id(value sym) {
    assert(firstId);
    uint r = to_symbol(sym) - firstId;
    if (r > items_in(names)) return uint(-1);
    return r;
  }

  uint get_sym_id(symbol_t sym, uint defval) {
    assert(firstId);
    uint r = sym - firstId;
    if (r > items_in(names)) return defval;
    return r;
  }

  value get_sym_by_id(uint id) {
    assert(firstId);
    assert(id < items_in(names));
    return CsSymbol(id + firstId);
  }

} // namespace tis
