#include "xsciter.h"
#include "xview.h"
#ifdef WINDOWS
#include <shellapi.h>
#include "win/win-delayload.h"
#endif
//#include "tiscript.h"
#include "xevent.h"

static void *p_ver_info = 0;

static uint ver[4] = {SCITER_VERSION};

uint module_version(bool major) {
  if (major)
    return ver[0] << 16 | ver[1];
  else
    return ver[2] << 16 | ver[3];
}

namespace tis {
#include "sciter-revision.h"
  /*bool virtual_console_stream::callback( const tool::value& p1, const
  tool::value& p2, tool::value& r )
  {
    if( p_view )
      return p_view->host_callback( channel, p1, p2, r );
    return false;
  }*/

  int virtual_console_stream::get() {
    return tis::stream::EOS;
    /*if( getbuf.size() == 0 )
    {
      tool::value p1, p2, r;
      if(callback( p1, p2, r ))
      {
        if( r.is_string() )
        {
          const wchar* pc = r.get(W(""));
          while( *pc ) { getbuf.push( *pc ); ++pc; }
          if(getbuf.size())
            return getbuf.pop();
        }
      }
      return tis::stream::EOS;
    }
    return getbuf.pop();*/
  }

  bool virtual_console_stream::put(int ch) {
    //The below is an attempt to support stdout.print("foo") printout (without CRLF) 
    //The logic shall be changed in order it to work, too busy now.
    
#pragma TODO("better support of stdout.print() for async case")
    //if (putbuf.is_empty() || putbuf.last() == '\n')
    //   p_view->post([this]() -> bool { this->flush(); return true; });
    putbuf.push(wchar(ch));
    if (putbuf.last() == '\n')
      this->flush();
    return true;
  }

  void virtual_console_stream::flush() {
    if (putbuf.is_empty())
      return;
    putbuf.push(0);
    putbuf.pop();

    if (p_view) {
      xview *cv = p_view->vm->current_view();
      if (cv)
        cv->debug_print(html::OT_TIS,
          channel == 1 ? html::OS_INFO : html::OS_ERROR,
          putbuf());
      else
        p_view->debug_print(html::OT_TIS,
          channel == 1 ? html::OS_INFO : html::OS_ERROR,
          putbuf());
    }
    else
      debug_print(html::OT_TIS, channel == 1 ? html::OS_INFO : html::OS_ERROR,
        putbuf());
    putbuf.clear();
  }

  console_stream   console;
  blackhole_stream blackhole;

  void xvm::init() {
  // if(!viewDispatch)
  //{
  // dialogRetVal = NOTHING_VALUE;
#ifdef XSCITER
    standardInput  = &blackhole;
    standardOutput = &blackhole;
    standardError  = &blackhole;
#else
    standardInput  = &console;
    standardOutput = &console;
    standardError  = &console;
#endif

    init_event_class();

    init_node_class();
    init_element_class();
    init_element_attributes_class();
    init_element_styles_class();
    init_element_state_class();
    init_graphics_class();
    init_image_class();
    // init_behavior_class();
    init_richtext_class();
    init_selection_class();
    init_sciter_class();
    init_view_class();
    init_tokenizer_class();
#if defined(AUDIO_SUPPORT)
    init_audio_class();
#endif

#if defined(SUPPORT_SPELL)
    init_spell_class();
#endif
#if defined(SUPPORT_DLL_LOAD)
    init_lib_class();
#endif
//#ifdef WEBSOCKETS_SUPPORT
//    init_websocket_class();
//#endif
    // load promise:
    tool::bytes     data = app()->get_resource(W("promise.bc"));
    binary_i_stream ins(data, W("promise.tis"), false);
    CsLoadObjectStream(&globalScope, &ins);
    // array<wchar>  wdata;
    // tool::from_utf8(data, wdata);
    // if( wdata.length() )
    //  CsEvalString(&this->globalScope,this->globalScope.globals,wdata.cbegin(),wdata.length());
  }

  bool xvm::post(tool::function<bool(void)> &&pc) {
    // if( super::post(pc) )
    //  return true;

    /*xview *pcv = current_view();
    if (pcv) {
      pcv->async(std::move(pc));
      return true;
    }*/

    if (!owning_view) {
      assert(false);
      return false;
    }
    owning_view->async(std::move(pc));
    return true;
  }

  bool xvm::send(function<bool()> &&pc) {
    if (VM::get_current() == this) return pc();

#ifdef _DEBUG
    // most probably: Sciter API access from worker thread:
    // note: Sciter API access from worker thread is supported but may
    // lead to non-effective execution as **each** API call is posted
    // sepearately. More effective way is to use GUI_CODE_START/GUI_CODE_END
    // blocks for multiple DOM access calls from worker threads.
    dbg_printf("WARNING: xvm::send() execution from non-GUI thread\n");
#endif

    if (!owning_view) return false;

    owning_view->async(std::move(pc), true);
    return true;
  }

  static value CSF_userName(xvm *c) {
    if (c->features & FEATURE_SYSINFO) {
      bool full = false;
      CsParseArguments(c, "**|B", &full);
      ustring us = tool::environment::user_name();
      return string_to_value(c, us);
    }
    return UNDEFINED_VALUE;
  }

  static value CSF_machineName(xvm *c) {
    if (c->features & FEATURE_SYSINFO) {
      bool full = false;
      CsParseArguments(c, "**|B", &full);
      ustring us = tool::environment::machine_name(full);
      return string_to_value(c, us);
    }
    return UNDEFINED_VALUE;
  }

  static value CSF_launch(xvm *c) {
    if (c->features & FEATURE_SYSINFO) {
      wchar *path     = 0;
      int_t  path_len = 0;
      CsParseArguments(c, "**S#", &path, &path_len);

      if (path && path_len) {
#if defined(WINDOWS)
        tool::tstring    tname(path, path_len);
        SHELLEXECUTEINFO sei;
        memzero(sei);
        sei.cbSize = sizeof(sei);

        sei.lpVerb = TEXT("open");
        sei.lpFile = tname;
        sei.nShow  = SW_SHOWNORMAL;

        ShellExecuteEx(&sei);

        return (uint_ptr)sei.hInstApp > 32 ? TRUE_VALUE : FALSE_VALUE;
#elif defined(OSX)
        string u8 = u8::cvt(wchars(path, path_len));
        return system(string::format("open \"%s\"", u8.c_str())) >= 0
                   ? TRUE_VALUE
                   : FALSE_VALUE;
#elif defined(WINDOWLESS)				   
        string u8 = u8::cvt(wchars(path, path_len));
        return system(string::format("open \"%s\"", u8.c_str())) >= 0
                   ? TRUE_VALUE
                   : FALSE_VALUE;
#else
        // return system( ustring::utf8(wchars(path,path_len)) ) >= 0 ?
        // TRUE_VALUE: FALSE_VALUE;
        GdkScreen *screen = gdk_screen_get_default();
        GError *   perr   = 0;
        bool r = gtk_show_uri(screen, string(wchars(path, path_len)),
                            GDK_CURRENT_TIME, &perr);

        if(!r)
          return system( u8::cvt(wchars(path,path_len)) + " &" ) >= 0 ?
             TRUE_VALUE: FALSE_VALUE;

        return TRUE_VALUE;
#endif
      }
    }
    return UNDEFINED_VALUE;
  }


  static value CSF_requestQuit(xvm *c) {
    // if(c->features & FEATURE_STANDALONE)
    //{
    //  return CsMakeInteger(MessagePump());
    //}
    int_t retval = 0;
    CsParseArguments(c, "**|i", &retval);
#ifdef WINDOWS
    PostQuitMessage(retval);
#endif
    return UNDEFINED_VALUE;
  }

  static value CSF_version(xvm *c, value obj) {
    return CsMakeString(c,WCHARS(SCITER_VERSION_FULL_STR));
  }
  

  /* constants */
  static constant constants[] = {
      CONSTANT_ENTRY_X("VERSION", int_value(0)),
      CONSTANT_ENTRY_X("REVISION", int_value(0)),
      CONSTANT_ENTRY_X("BUILD", int_value(SCITER_REVISION)),
      CONSTANT_ENTRY_X("LICENSEE", symbol_value("public")),
      CONSTANT_ENTRY_X(0, 0)};

  /* methods */
  static c_method methods[] = {C_METHOD_ENTRY_X("requestQuit", CSF_requestQuit),
                               C_METHOD_ENTRY_X("userName", CSF_userName),
                               C_METHOD_ENTRY_X("machineName", CSF_machineName),
                               C_METHOD_ENTRY_X("launch", CSF_launch),

                               C_METHOD_ENTRY_X(0, 0)};

  /* properties */
  static vp_method properties[] = {
    VP_METHOD_ENTRY_X("version", CSF_version, 0),
    VP_METHOD_ENTRY_X(0, 0, 0)
  };

  //|
  //| Request object
  //|

  value CsRequestObject(xvm *c, html::request *prq) {
    if (!prq->obj) {
      prq->obj = CsMakeCObject(c, c->requestDispatch);
      CsSetCObjectValue(prq->obj, prq);
      prq->add_ref();
    }
    return prq->obj;
  }

  inline html::request *request_ptr(xvm *c, value obj) {
    assert(CsGetDispatch(obj) == c->requestDispatch);
    if (!CsIsType(obj, c->requestDispatch)) return nullptr;
    return static_cast<html::request *>(CsCObjectValue(obj));
  }

  static void RequestRelease(VM *c, value obj) {
    html::request *prq = request_ptr(static_cast<xvm *>(c), obj);
    if (prq) {
      prq->obj = 0;
      CsSetCObjectValue(obj, 0);
      prq->release();
    }
  }

  static void RequestScan(VM *c, value obj) {
    html::request *p = request_ptr(static_cast<xvm *>(c), obj);
    if (p) p->obj = CsCopyValue(c, p->obj);
    CsCObjectScan(c, obj);
  }

  static int_t RequestHash(value obj) {
    // its address is a perfect hash
    return (int)(int64)CsCObjectValue(obj);
  }

  static bool RequestPrint(VM *c, value val, stream *s, bool toLocale) {
    html::request *p = request_ptr(static_cast<xvm *>(c), val);
    if (p) {
      s->put_str("Request(");
      s->put_str(p->url);
      s->put_str(")");
    } else
      s->put_str("Request()");
    return true;
  }

  static value CSF_request_fulfill(xvm *c) {
    value  obj;
    value  data = 0;
    wchars mime;
    // value sym = sym_luma;
    CsParseArguments(c, "V=*V=S#", &obj, c->requestDispatch, &data,
                     &CsByteVectorDispatch, &mime.start, &mime.length);
    html::request *prq = request_ptr(c, obj);
    if (!prq) return FALSE_VALUE;

    if (prq->consumed) return NULL_VALUE;

    prq->data              = CsByteVectorBytes(data);
    prq->data_content_type = string(mime);
    prq->done_with_success(200);

    return obj;
  }

  value parse_response(xvm *vm, html::request *rq, uint of);

  static value CSF_request_reject(xvm *c) {
    value obj;
    int_t status = 0;
    CsParseArguments(c, "V=*I", &obj, c->requestDispatch, &status);
    html::request *prq = request_ptr(c, obj);
    if (!prq) return FALSE_VALUE;

    if (prq->consumed) return NULL_VALUE;

    prq->done_with_failure(uint(status));

    return obj;
  }

  static value CSF_request_then(xvm *c) {
    pvalue obj(c);
    pvalue onsucc(c);
    pvalue onfail(c);
    CsParseArguments(c, "V=*V|V", &obj.val, c->requestDispatch, &onsucc.val,
                     &onfail.val);
    html::request *prq = request_ptr(c, obj);
    if (!prq) return obj;

    auto on_data_ready_async = [obj, onsucc,
                                onfail](html::request *xrq) -> bool {
      xvm *vm = static_cast<xvm *>(onsucc.pvm);
      TRY {
        if (xrq->success_flag) {
          auto_scope as(vm, CsMethodP(onsucc.val)
                                ? CsMethodNamespace(onsucc.val)
                                : CsGlobalScope(vm)->globals);
          value data = parse_response(vm, xrq, xrq->data_represantaion_hint);
          CsSendMessage(vm, obj, onsucc, 2, data, CsMakeInteger(xrq->status));
        } else if (onfail.is_alive()) {
          auto_scope as(vm, CsMethodP(onfail.val)
                                ? CsMethodNamespace(onfail.val)
                                : CsGlobalScope(vm)->globals);

          ustring errm = ustring::format(W("%d"), xrq->status);
          value   errv = 0;
          PROTECT_VM(errv);
          errv = string_to_value(vm, errm);
          // errdata = CsMakeObject(c, c->objectObject);
          // CsSetProperty(c, errdata, "status", CsMakeInteger(xrq->status));
          // CsSetProperty(c, errdata, "response", val.val);
          errv = CsError(vm, CsErrHTTPError, errv, obj);
          CsSendMessage(vm, obj, onfail, 1, errv);
        }
      }
      CATCH_ERROR(e) {
        if (e.number == 0) // close() called
          return true;
        else
          tis::CsHandleUnhandledError(vm);
      }
      return true;
    };
    prq->add(on_data_ready_async);
    return obj;
  }

  static value CSF_request_catch(xvm *c) {
    pvalue obj(c);
    pvalue onfail(c);
    CsParseArguments(c, "V=*V", &obj.val, c->requestDispatch, &onfail.val);
    html::request *prq = request_ptr(c, obj);
    if (!prq) return obj;

    auto on_data_ready_async = [obj, onfail](html::request *xrq) -> bool {
      TRY {
        if (!xrq->success_flag && onfail.is_alive()) {
          xvm *      vm = static_cast<xvm *>(onfail.pvm);
          auto_scope as(vm, CsMethodP(onfail.val)
                                ? CsMethodNamespace(onfail.val)
                                : CsGlobalScope(vm)->globals);
          CsSendMessage(vm, obj, onfail, 1, CsMakeInteger(xrq->status));
        }
      }
      CATCH_ERROR(e) {
        xvm *vm = static_cast<xvm *>(onfail.pvm);
        if (e.number == 0) // close() called
          return true;
        else
          tis::CsHandleUnhandledError(vm);
      }
      return true;
    };
    prq->add(on_data_ready_async);
    return obj;
  }

  static value CSF_request_finally(xvm *c) {
    pvalue obj(c);
    pvalue onfinally(c);
    CsParseArguments(c, "V=*V", &obj.val, c->requestDispatch, &onfinally.val);
    html::request *prq = request_ptr(c, obj);
    if (!prq) return obj;

    auto on_data_ready_async = [obj, onfinally](html::request *xrq) -> bool {
      TRY {
        if (onfinally.is_alive()) {
          xvm *      vm = static_cast<xvm *>(onfinally.pvm);
          auto_scope as(vm, CsMethodP(onfinally.val)
                                ? CsMethodNamespace(onfinally.val)
                                : CsGlobalScope(vm)->globals);
          CsSendMessage(vm, obj, onfinally, 1, CsMakeInteger(xrq->status));
        }
      }
      CATCH_ERROR(e) {
        xvm *vm = static_cast<xvm *>(onfinally.pvm);
        if (e.number == 0) // close() called
          return true;
        else
          tis::CsHandleUnhandledError(vm);
      }
      return true;
    };
    prq->add(on_data_ready_async);
    return obj;
  }

  static value CSF_response(xvm *c, value obj) {
    html::request *prq = request_ptr(c, obj);
    if (!prq) CsThrowKnownError(c, CsErrGenericError, "inactive request");
    return parse_response(c, prq, prq->data_represantaion_hint);
  }

  static value CSF_status(xvm *c, value obj) {
    html::request *prq = request_ptr(c, obj);
    if (!prq) CsThrowKnownError(c, CsErrGenericError, "inactive request");
    return CsMakeInteger(int_t(prq->status));
  }

  static value CSF_responseData(xvm *c, value obj) {
    html::request *prq = request_ptr(c, obj);
    if (!prq) CsThrowKnownError(c, CsErrGenericError, "inactive request");
    value data = CsMakeByteVector(c, prq->data);
    PROTECT(data);
    value mime = CsMakeString(c, prq->data_content_type());
    CsSetByteVectorType(data, mime);
    return data;
  }

  static value CSF_responseMimeType(xvm *c, value obj) {
    html::request *prq = request_ptr(c, obj);
    if (!prq) CsThrowKnownError(c, CsErrGenericError, "inactive request");
    return CsMakeString(c, prq->data_content_type());
  }

  static value CSF_requestedDataType(xvm *c, value obj) {
    html::request *prq = request_ptr(c, obj);
    if (!prq) CsThrowKnownError(c, CsErrGenericError, "inactive request");
    return CsMakeInteger(prq->data_type);
  }

  static value CSF_isConsumed(xvm *c, value obj) {
    html::request *prq = request_ptr(c, obj);
    if (!prq) CsThrowKnownError(c, CsErrGenericError, "inactive request");
    return CsMakeBoolean(prq->consumed.val(0) != 0);
  }

  static value CSF_isSucceeded(xvm *c, value obj) {
    html::request *prq = request_ptr(c, obj);
    if (!prq) CsThrowKnownError(c, CsErrGenericError, "inactive request");
    return CsMakeBoolean(prq->success_flag);
  }

  value element_object(xvm *pvm, html::element *b);

  static value CSF_destination(xvm *c, value obj) {
    html::request *prq = request_ptr(c, obj);
    if (!prq) CsThrowKnownError(c, CsErrGenericError, "inactive request");
    return prq->dst ? element_object(c, prq->dst) : NULL_VALUE;
  }

  static value CSF_requestUrl(xvm *c, value obj) {
    html::request *prq = request_ptr(c, obj);
    if (!prq) CsThrowKnownError(c, CsErrGenericError, "inactive request");
    return CsMakeString(c, prq->url);
  }

  static value CSF_responseUrl(xvm *c, value obj) {
    html::request *prq = request_ptr(c, obj);
    if (!prq) CsThrowKnownError(c, CsErrGenericError, "inactive request");
    return CsMakeString(c, prq->content_url);
  }

  static value CSF_responseEncoding(xvm *c, value obj) {
    html::request *prq = request_ptr(c, obj);
    if (!prq) CsThrowKnownError(c, CsErrGenericError, "inactive request");
    return CsMakeString(c, prq->data_content_encoding);
  }

  static value CSF_responseHeaders(xvm *c, value obj) {
    html::request *prq = request_ptr(c, obj);
    if (!prq) CsThrowKnownError(c, CsErrGenericError, "inactive request");
    value map = CsMakeObject(c, c->objectObject);
    value key;
    PROTECT(map,key);
    for (int n = 0; n < prq->rs_headers.size(); ++n) {
      key = CsMakeString(c, prq->rs_headers.key(n));
      value val = CsMakeString(c, prq->rs_headers.value(n));
      CsSetObjectProperty(c, map, key, val);
    }
    return map;
  }

  static value CSF_requestHeaders(xvm *c, value obj) {
    html::request *prq = request_ptr(c, obj);
    if (!prq) CsThrowKnownError(c, CsErrGenericError, "inactive request");
    value map = CsMakeObject(c, c->objectObject);
    value key;
    PROTECT(map, key);
    for (int n = 0; n < prq->rq_headers.size(); ++n) {
      key = CsMakeString(c, prq->rq_headers.key(n));
      value val = CsMakeString(c, prq->rq_headers.value(n));
      CsSetObjectProperty(c, map, key, val);
    }
    return map;
  }



  /* constants */
  static constant request_constants[] = {
      CONSTANT_ENTRY_X("DATA_HTML", int_value(html::DATA_HTML)),
      CONSTANT_ENTRY_X("DATA_IMAGE", int_value(html::DATA_IMAGE)),
      CONSTANT_ENTRY_X("DATA_STYLE", int_value(html::DATA_STYLE)),
      CONSTANT_ENTRY_X("DATA_CURSOR", int_value(html::DATA_CURSOR)),
      CONSTANT_ENTRY_X("DATA_FONT", int_value(html::DATA_FONT)),
      CONSTANT_ENTRY_X("DATA_SOUND", int_value(html::DATA_SOUND)),
      CONSTANT_ENTRY_X("DATA_RAW_DATA", int_value(html::DATA_RAW_DATA)),

      CONSTANT_ENTRY_X(0, 0)};

  /* methods */
  static c_method request_methods[] = {

      C_METHOD_ENTRY_X("fulfill", CSF_request_fulfill),
      C_METHOD_ENTRY_X("reject", CSF_request_reject),

      C_METHOD_ENTRY_X("then", CSF_request_then),
      C_METHOD_ENTRY_X("catch", CSF_request_catch),
      C_METHOD_ENTRY_X("finally", CSF_request_finally),

      C_METHOD_ENTRY_X(0, 0)};

  /* properties */
  static vp_method request_properties[] = {
      VP_METHOD_ENTRY_X("response", CSF_response, 0),
      VP_METHOD_ENTRY_X("responseData", CSF_responseData, 0),
      VP_METHOD_ENTRY_X("responseMimeType", CSF_responseMimeType, 0),
      VP_METHOD_ENTRY_X("responseUrl", CSF_responseUrl, 0),
      VP_METHOD_ENTRY_X("responseEncoding", CSF_responseEncoding, 0),
      VP_METHOD_ENTRY_X("responseHeaders", CSF_responseHeaders, 0),

      VP_METHOD_ENTRY_X("status", CSF_status, 0),

      VP_METHOD_ENTRY_X("requestDataType", CSF_requestedDataType, 0),
      VP_METHOD_ENTRY_X("requestUrl", CSF_requestUrl, 0),
      VP_METHOD_ENTRY_X("requestHeaders", CSF_requestHeaders, 0),

      VP_METHOD_ENTRY_X("isConsumed", CSF_isConsumed, 0),
      VP_METHOD_ENTRY_X("isSucceeded", CSF_isSucceeded, 0),

      VP_METHOD_ENTRY_X("destination", CSF_destination, 0),
      // VP_METHOD_ENTRY_X("receivedData",      CSF_receivedData,      0),
      VP_METHOD_ENTRY_X(0, 0, 0)};

  void xvm::init_sciter_class() {

    constants[0].val = int_value(module_version(true));
    constants[1].val = int_value(module_version(false));

    {
      /* create the 'Sciter' type */
      dispatch *pd = CsEnterCPtrObjectType(CsGlobalScope(this), "Sciter",methods, properties, constants);
      if (!pd) CsInsufficientMemory(this);

      sciterDispatch           = pd;
      sciterDispatch->baseType = &CsCObjectDispatch;
    }

    {
      /* create the 'Request' type */
      dispatch *pd = CsEnterCPtrObjectType(CsGlobalScope(this), "Request",request_methods, request_properties,request_constants);
      if (!pd) CsInsufficientMemory(this);

      requestDispatch           = pd;
      requestDispatch->baseType = &CsCObjectDispatch;

      requestDispatch->destroy = RequestRelease;

      requestDispatch->scan  = RequestScan;
      requestDispatch->hash  = RequestHash;
      requestDispatch->print = RequestPrint;
    }
  }

#if 0
  tool::tristate_v CsGetNativeBehaviorProperty(xvm* c, html::ctl* behavior, value tag, value* pval)
  {
    if (auto pp = behavior->asset_get_passport()) {
      for (uint n = 0; n < pp->n_properties; ++n) {
        if (pp->properties[n].name == tag) {
          tool::value tval;
          if (pp->properties[n].getter(behavior, &tval)) {
            *pval = value_to_value(c, tval);
            return TRUE;
          }
          return FALSE;
        }
      }
    }
    if (behavior->next)
      return CsGetNativeBehaviorProperty(c, behavior->next, tag, pval);
    return tristate_v();
  }

  tool::tristate_v CsSetNativeBehaviorProperty(xvm* c, html::ctl* behavior, value tag, value val)
  {
    if (auto pp = behavior->asset_get_passport()) {
      for (uint n = 0; n < pp->n_properties; ++n) {
        if (pp->properties[n].name == tag) {
          tool::value tval = value_to_value(c, val);
          return pp->properties[n].setter(behavior, &tval);
        }
      }
    }
    if (behavior->next)
      return CsSetNativeBehaviorProperty(c, behavior->next, tag, val);
    return tristate_v();
  }

  tristate_v CsNativeBehaviorCall(xvm *c, html::ctl* behavior, value tag, value *pretval) {
    if (auto pp = behavior->asset_get_passport()) {
      for (uint n = 0; n < pp->n_methods; ++n) {
        if (pp->methods[n].name == tag) {

          tool::value argv[8];
          uint argc = (uint)min(8, CsArgCnt(c) - 2);

          for (uint i = 0; i < argc; ++i)
            argv[i] = value_to_value(c, CsGetArg(c, i + 3));
          tool::value retval;
          tristate_v r = pp->methods[n].func(behavior, argc, argv, &retval);
          if (r.val())
            *pretval = value_to_value(c, retval);
          return r;
        }
      }
    }
    if (behavior->next)
      return CsNativeBehaviorCall(c, behavior->next, tag, pretval);
    return tristate_v();
  }
#endif 

}

/*tiscript_VM* TISAPI create_sciter_vm(uint features, uint heap_size, uint
stack_size)
{
  tis::xvm* pvm = new tis::xvm(features,heap_size,stack_size);
  pvm->add_ref();
  return (tiscript_VM*)pvm;
}*/
