#include "xsciter.h"
#include "xview.h"
#include "xdom.h"

namespace tis {
  // using namespace tis;
  // using namespace html;

  value node_object(xvm *pvm, html::node *n) {
    if (!n) return NULL_VALUE;

    if (n->is_element()) return element_object(pvm, n->cast<html::element>());

    if (!has_object(n)) {
      n->obj = CsMakeCPtrObject(pvm, pvm->nodeDispatch, n);
      n->add_ref();
    }
    return n->obj;
  }
  html::node *node_ptr(xvm *c, value obj) {
    dispatch *pd = CsGetDispatch(obj);
    if (pd != c->nodeDispatch && pd != c->elementDispatch)
      CsThrowKnownError(c, CsErrUnexpectedTypeError, obj, "Node");
    html::node *n = static_cast<html::node *>(CsCObjectValue(obj));
    // b could be null if called from GCing constructor.
    // assert(b);
    return n;
  }

  html::node *node_ptr_no_throw(xvm *c, value obj) {
    dispatch *pd = CsQuickGetDispatch(obj);
    if (pd != c->nodeDispatch && pd != c->elementDispatch) return 0;
    html::node *n = static_cast<html::node *>(CsCObjectValue(obj));
    return n;
  }

  value node_list(xvm *c, slice<html::hnode> nodes) {
    value vec = CsMakeVector(c, nodes.size());
    PROTECT(vec);
    for (int n = 0; n < nodes.size(); ++n) {
      value vn = node_object(c, nodes[n]);
      CsSetVectorElement(c, vec, n, vn);
    }
    return vec;
  }

  void destroy_node(xvm *c, value obj) {
    html::node *b = node_ptr(c, obj);
    CsSetCObjectValue(obj, 0);
    b->obj = 0;
    b->release();
  }

  /* method handlers */
  static value CSF_createText(xvm *c) {
    wchars text;
    CsParseArguments(c, "**S#", &text.start, &text.length);
    tool::handle<html::node> n = new html::text(text);
    return node_object(c, n);
  }

  static value CSF_createComment(xvm *c) {
    wchars text;
    CsParseArguments(c, "**S#", &text.start, &text.length);
    tool::handle<html::node> n = new html::comment(text);
    return node_object(c, n);
  }

  extern value CSF_createElement(xvm *c);

  static value CSF_clone(xvm *c) {
    value obj;
    CsParseArguments(c, "V=*", &obj, c->nodeDispatch);

    tool::handle<html::node> self = node_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    return node_object(c, self->clone());
  }

  static value CSF_remove(xvm *c) {
    value obj;
    CsParseArguments(c, "V=*|B", &obj, c->nodeDispatch);

    tool::handle<html::node> self = node_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    self->remove(true);
    return obj;
  }

  static value CSF_detach(xvm *c) {
    value obj;
    CsParseArguments(c, "V=*|B", &obj, c->nodeDispatch);

    tool::handle<html::node> self = node_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;

    self->remove(false);
    return obj;
  }

  value CSF_node_insertNodeBefore(xvm *c) {
    value obj, owhat;
    CsParseArguments(c, "V=*V=", &obj, c->nodeDispatch, &owhat,
                     c->nodeDispatch);

    tool::handle<html::node> self = node_ptr(c, obj);
    tool::handle<html::node> what = node_ptr(c, owhat);
    if (!self || !what) return UNDEFINED_VALUE;
    if (self->parent) {
      html::view *pv = self->parent->pview();
      self->parent->insert(self->node_index, what, pv);
    }
    return obj;
  }

  value CSF_node_insertNodeAfter(xvm *c) {
    value obj, owhat;
    CsParseArguments(c, "V=*V=", &obj, c->nodeDispatch, &owhat,
                     c->nodeDispatch);

    tool::handle<html::node> self = node_ptr(c, obj);
    tool::handle<html::node> what = node_ptr(c, owhat);
    if (!self || !what) return UNDEFINED_VALUE;
    if (self->parent) {
      html::view *pv = self->parent->pview();
      self->parent->insert(self->node_index + 1, what, pv);
    }
    return obj;
  }

  value CSF_node_marks(xvm *c, value obj) {
    html::node *self = node_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    if (!self->is_text()) return UNDEFINED_VALUE;

    // html::text* pt =

    return NULL_VALUE;
  }

  /*value CSF_node_mark(xvm *c) {
    value    obj;
    int_t start; int_t end;
    //wchars mark;
    value marks;
    CsParseArguments(c,"V=*IIV",&obj,c->nodeDispatch,&start,&end,&marks);
    tool::handle<html::node> self = node_ptr(c,obj);
    if(!self || !self->is_text())
      return obj;

    uint cm;
    if( CsStringP(marks) )
      cm = html::register_span_class(string(CsStringChars(marks)));
    else if( CsVectorP(marks) )
    {
      array<char> buffer;
      int n = CsVectorSize(c,marks);
      for(int i = 0; i < n; ++i)
      {
        if(i) buffer.push(CHARS(" "));
        string nm = value_to_string(CsVectorElement(c,marks,i));
        buffer.push(nm());
      }
      cm = html::register_span_class(string(buffer()));
    } else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, marks, " is not a string or
  array of strings");
    self.ptr_of<html::text>()->set_mark(start,end,html::char_mark(cm));
    html::element* p = self->nearest_text_box();
    if(p) p->drop_layout();
    return obj;
  }

  value CSF_node_unmark(xvm *c) {
    value    obj;
    int_t start = 0; int_t end = -1; int_t mark = html::char_mark(~0);
    CsParseArguments(c,"V=*|I|I|I",&obj,c->nodeDispatch,&start,&end,&mark);
    tool::handle<html::node> self = node_ptr(c,obj);
    if(!self || !self->is_text())
      return obj;
    if( end < 0 ) end = self.ptr_of<html::text>()->chars.size();
    self.ptr_of<html::text>()->reset_mark(start,end,html::char_mark(mark));
    html::element* p = self->nearest_text_box();
    if(p) p->drop_layout();
    return obj;
  } */

  value CSF_node_nextNode(xvm *c, value obj) {
    html::node *self = node_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::node *n = self->next_node();
    if (!n) return NULL_VALUE;
    return node_object(c, n);
  }

  value CSF_node_prevNode(xvm *c, value obj) {
    html::node *self = node_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::node *n = self->prev_node();
    if (!n) return NULL_VALUE;
    return node_object(c, n);
  }

  value CSF_node_nodeIndex(xvm *c, value obj) {
    html::node *self = node_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    return CsMakeInteger(self->node_index);
  }

  value CSF_node_isText(xvm *c, value obj) {
    html::node *self = node_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    return self->is_text() ? TRUE_VALUE : FALSE_VALUE;
  }

  value CSF_node_isComment(xvm *c, value obj) {
    html::node *self = node_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    return self->is_comment() ? TRUE_VALUE : FALSE_VALUE;
  }

  value CSF_node_isElement(xvm *c, value obj) {
    html::node *self = node_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    return self->is_element() ? TRUE_VALUE : FALSE_VALUE;
  }

  static value CSF_text(xvm *c, value obj) {
    html::node *self = node_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    if (self->is_text() || self->is_comment())
      return CsMakeString(c, self->cast<html::text>()->chars());
    return UNDEFINED_VALUE;
  }

  static value CSF_set_text(xvm *c, value obj, value val) {
    html::node *self = node_ptr(c, obj);
    if (!self) return val;
    if (!self->is_text() && !self->is_comment()) return val;

    if (!CsStringP(val)) val = CsToString(c, val);

    wchars t                        = CsStringChars(val);
    self->cast<html::text>()->chars = t;

    if (self->parent) {
      html::view *pv = self->parent->pview();
      if (pv) pv->add_to_update(self->parent, html::CHANGES_MODEL);
    }
    return val;
  }

  static value CSF_parent(xvm *c, value obj) {
    html::node *self = node_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    if (!self->parent || !self->is_connected())
      return NULL_VALUE;
    return element_object(c, self->parent);
  }

  /*static value CSF_node_length(xvm *c,value obj)
  {
    html::node* self = node_ptr(c,obj);
    if( !self )
      return UNDEFINED_VALUE;
    auto bme = self->end_pos();
    return CsMakeInteger(bme.after_it? (bme.pos + 1):bme.pos);
  }*/

  static value CSF_commonParent(xvm *c) {
    value obj = 0, objOther = 0;
    CsParseArguments(c, "V=*V=", &obj, c->nodeDispatch, &objOther,
                     c->nodeDispatch);

    html::hnode self = node_ptr(c, obj);
    if (!self) return UNDEFINED_VALUE;
    html::hnode other = node_ptr(c, objOther);
    if (!other) return UNDEFINED_VALUE;

    html::helement root = html::node::find_common_parent(self, other);
    if (!root) return NULL_VALUE;

    return element_object(c, root);
  }

  /* element methods */
  static c_method methods[] = {
      // C_METHOD_ENTRY_X( "this",    CSF_ctor    ),

      C_METHOD_ENTRY_X("createText", CSF_createText),
      C_METHOD_ENTRY_X("createComment", CSF_createComment),
      C_METHOD_ENTRY_X("createElement", CSF_createElement),

      C_METHOD_ENTRY_X("clone", CSF_clone),
      C_METHOD_ENTRY_X("remove", CSF_remove),
      C_METHOD_ENTRY_X("detach", CSF_detach),
      // C_METHOD_ENTRY_X( "swap",    CSF_swap ),

      C_METHOD_ENTRY_X("insertNodeBefore", CSF_node_insertNodeBefore),
      C_METHOD_ENTRY_X("insertNodeAfter", CSF_node_insertNodeAfter),

      C_METHOD_ENTRY_X("commonParent", CSF_commonParent),

      C_METHOD_ENTRY_X(0, 0)};

  /* Element properties */
  static vp_method properties[] = {
      VP_METHOD_ENTRY_X("parent", CSF_parent, 0),
      VP_METHOD_ENTRY_X("isElement", CSF_node_isElement, 0),
      VP_METHOD_ENTRY_X("isText", CSF_node_isText, 0),
      VP_METHOD_ENTRY_X("isComment", CSF_node_isComment, 0),
      VP_METHOD_ENTRY_X("nodeIndex", CSF_node_nodeIndex, 0),
      VP_METHOD_ENTRY_X("nextNode", CSF_node_nextNode, 0),
      VP_METHOD_ENTRY_X("priorNode", CSF_node_prevNode, 0),
      VP_METHOD_ENTRY_X("text", CSF_text, CSF_set_text),
      VP_METHOD_ENTRY_X("marks", CSF_node_marks, 0),
      // VP_METHOD_ENTRY_X( "length",              CSF_node_length,      0),
      VP_METHOD_ENTRY_X(0, 0, 0)};

  static constant constants[] = {CONSTANT_ENTRY_X(0, 0)};

  value NodeCopy(VM *c, value obj) {
    html::node *p = node_ptr(static_cast<xvm *>(c), obj);
    if (p) {
      p->obj = CsDefaultCopy(c, obj);
      return p->obj;
    }
    // assert(false);
    // may happen if GC occurs inside new Element(... some allocations ...)
    return CsDefaultCopy(c, obj);
  }

  int_t NodeHash(value obj) {
    // its address is a perfect hash
    return (int_t)obj;
  }

  bool NodePrint(xvm *c, value val, stream *s) {
    html::node *p = node_ptr(static_cast<xvm *>(c), val);
    if (p) {
      s->put_str("\"");
      s->put_str(p->cast<html::text>()->chars.head(),
                 p->cast<html::text>()->chars.tail());
      s->put_str("\"");
    } else
      s->put_str("unknown");
    return true;
  }

  bool NodePrintType(xvm *c, value val, stream *s) {

    html::node *p = node_ptr(static_cast<xvm *>(c), val);
    s->put_str("Node(");
    if (p) {
      s->put_str("\"");
      s->put_str(p->cast<html::text>()->chars.head(),p->cast<html::text>()->chars.tail());
      s->put_str("\"");
    }
    else
      s->put_str("unknown");
    s->put_str(")");
    return true;
  }

  void xvm::init_node_class() {
    dispatch *pd = CsEnterCPtrObjectType(CsGlobalScope(this), "Node", methods, properties);

    /* create the 'Node' type */
    if (!pd) CsInsufficientMemory(this);

    pd->copy     = NodeCopy;
    pd->hash     = NodeHash;
    pd->print    = (print_t)NodePrint;
    pd->printType = (print_t)NodePrintType;
    pd->baseType = &CsCObjectDispatch;

    pd->destroy = (destructor_t)destroy_node;

    nodeDispatch = pd;

    // CsEnterConstants(this, pd->obj, constants );
  }

} // namespace tis