#ifndef __xmorpher_h__
#define __xmorpher_h__

#include "xdom.h"
#include "xview.h"

namespace tis {
  void object_to_attribute_bag(VM *c, value o, html::attribute_bag &atts);
  void object_to_attribute_bag_v(VM *c, value o, html::attribute_bag_v &atts);
  //void CSF_make_element(xvm *c, value tuple, tool::handle<html::element> &b);
  void update_element_atts_states(xview *pv, html::helement pel, tis::value pn);
}

namespace html 
{
  using namespace tool;
  using namespace tis;

  tool::ustring node_key(html::context&, node* pn);
  node::NODE_TYPE node_type(html::context&, node* pn);
  uint node_tag(html::context&, node* pn);

  ustring_chars node_text(html::context& pv, node* pn);
  uint          node_size(html::context&, node* pn);
  node*         node_child(html::context& pv, node* pn, uint i);
  hnode         node_new_to_old(html::context& pv, hnode nn, hnode parent);
  void          node_remove_child(html::context&, node* pn, uint i);
  bool          node_auto_removed_when_inserted(html::context&, node* pn);
  node*         node_for_children_update(html::context&, node* pn);
  const attribute_bag& node_atts(html::context&, node* pn);
  bool          node_states(html::context&, node* pn, attribute_bag_v&);
  node*         node_element_expand(html::context& pv, node* new_node, hnode& old_node, hnode parent);
  void          update_element_atts_states(html::context& pv, element* old_node, node* new_node, bool is_root);
  uint64        node_factory(html::context& pv, node* pn);
  bool          node_equal(html::context& pv, hnode a, hnode b);
  
  inline node::NODE_TYPE node_type(html::context&, tis::value pn) {
    if (CsTupleP(pn)) return html::node::ELEMENT;
    return html::node::TEXT;
  }

  inline uint node_tag(html::context&, tis::value pn) {
    if (CsTupleP(pn)) {
      tis::value vn = CsVNodeTag(pn);
      string tag = value_to_string(vn);
      return html::tag::symbol(tag, true);
    }
    return 0;
  }

  inline tool::ustring node_key(html::context& pv, tis::value pn) {
    if (node_type(pv,pn) == html::node::ELEMENT) {
      tis::value vatts = CsTupleElement(pn, 0);
      if (CsObjectP(vatts)) {
        VM* c = VM::get_current();
        ustring key;
        if (CsGetProperty(c, vatts, "id", key))
          return key;
        if (CsGetProperty(c, vatts, "key", key))
          return key;

        auto tag = node_tag(pv,pn);
        if (tag == html::tag::T_OPTION || tag == html::tag::T_BUTTON) {
          if (CsGetProperty(c, vatts, "value", key))
            return key;
        }
        //if (CsGetProperty(c, vatts, "name", key))
        //  return key;
      }
    }
    return ustring();
  }

  inline ustring_chars node_text(html::context& pv, tis::value pn) {
    if (CsStringP(pn))
      return ustring_chars(CsStringChars(pn));
    return ustring_chars(value_to_string(((tis::xview*)pv.pview())->vm, pn));
  }
  inline uint node_size(html::context&, tis::value pn) {
    if (CsTupleP(pn)) {
      tis::value vn = CsTupleElement(pn, 1);
      if (CsVectorP(vn))
        return (uint)CsVectorSizeI(vn);
    }
    return 0;
  }

  inline tis::value node_child(html::context& pv, tis::value &pn, uint i) {
    if (!CsTupleP(pn))
      return 0;
    tis::value vkids = CsVNodeKids(pn);
    if (!CsVectorP(vkids))
      return 0;
    uint length = (uint)CsVectorSizeI(vkids);
    if (i >= length)
      return 0;

    tis::value vchild = CsVectorElementI(vkids, int(i));

    if (CsVNodeP(vchild) || CsStringP(vchild))
      return vchild;

    xview* pxv = (xview *)pv.pview();
    PROTECT_P(pxv->vm, pn);
    if (vchild == FALSE_VALUE || vchild == UNDEFINED_VALUE || vchild == NOTHING_VALUE)
      return CsMakeCharString(pxv->vm, nullptr, 0);
    return CsToString(pxv->vm,vchild);
  }

  inline tis::value node_child_ex(context& pv, tis::value &pn, uint i, hnode parent) {
    return node_child(pv,pn,i);
  }

  inline void node_remove_child(html::context&, tis::value pn, uint i) {
    if (CsTupleP(pn)) {
      tis::value vn = CsTupleElement(pn, 1);
      if (CsVectorP(vn) && (i < (uint)CsVectorSizeI(vn)))
        CsVectorRemoveI(vn, int(i));
    }
  }

  inline attribute_bag node_atts(html::context&, tis::value pn) {
    html::attribute_bag atts;
    if (CsTupleP(pn)) {
      tis::value vn = CsTupleElement(pn, 0);
      if (CsObjectP(vn))
        object_to_attribute_bag(VM::get_current(), vn, atts);
    }
    return atts;
  }

  inline bool node_states(html::context&, tis::value pn, attribute_bag_v& states) {
    if (CsTupleP(pn) && CsTupleSize(pn) >= 3) {
      tis::value vn = CsTupleElement(pn, 2);
      if (CsObjectP(vn)) {
        object_to_attribute_bag_v(VM::get_current(), vn, states);
        return true;
      }
    }
    return false;
  }

  inline uint64 node_factory(html::context& pv, tis::value pn) {
    assert(pv);
    assert(pn);
    if (CsTupleP(pn)) {
      tis::value tn = CsTupleName(pn);
      if (CsClassP(tn))
        return tn;
    } 
    return 0;
  }

  inline tis::value node_element_expand(html::context& pv, tis::value new_node, html::hnode& old_node, html::hnode parent)
  { 
    if (old_node && !old_node->is_element())
      return new_node;
    if (!CsVNodeP(new_node))
      return new_node;
    
    tis::value vn = CsTupleName(new_node);
    //string tagname = value_to_string(vn);
    //if (to_upper(tagname[0]) != tagname[0])
    //  return new_node; // that is a literal dom element like <div>
    if (CsSymbolP(vn))
      return new_node;
    
    assert(!old_node || old_node->is_element());
    assert(CsMethodP(vn) || CsClassP(vn));

    // otherwise it is a component, class or function: <Div>
    tis::xview* pxv = (tis::xview*)pv.pview();

    return pxv->vm->process_vnode(vn, 
      CsVNodeAtts(new_node),
      CsVNodeKids(new_node),
      CsVNodeStates(new_node),
      old_node,
      parent);
    //return node_element_expand(pv, r, old_node,parent);
  }

  inline hnode node_new_to_old(html::context& pv, tis::value nn, html::hnode parent) {
    auto nt = node_type(pv,nn);
    if (nt == html::node::TEXT)
      return new html::text(node_text(pv,nn));

    ElementCreatorCtx ctx((xview*)pv.pview(), nn, parent);
    html::helement el = ctx.make();
    return el;
  }

  inline bool node_new_to_old_ex(html::context& pv, tis::value& vdom_parent, uint child_index, html::hnode dom_parent, hnode& dom_child) {
    tis::value nn = node_child(pv, vdom_parent, child_index);
    auto nt = node_type(pv,nn);
    if (nt == html::node::TEXT) {
      dom_child = new html::text(node_text(pv, nn));
      return false;
    }

    ElementCreatorCtx ctx((xview*)pv.pview(), nn, dom_parent);
    dom_child = ctx.make();
    if (!dom_child) {
      if (CsVectorP(ctx.tuple)) // we've got fragment list 
      {
        tis::xview* pxv = (tis::xview*)pv.pview();
        PROTECT_P(pxv->vm, vdom_parent);
        CsSetVNodeKids(vdom_parent, CsVectorInsertReplace(pxv->vm, CsVNodeKids(vdom_parent), child_index, ctx.tuple));
        return true;
      }
    }
    return false;
   
  }

  inline bool node_auto_removed_when_inserted(tis::value nn) { return false; }

  inline tis::value node_for_children_update(html::context&, tis::value pn) {
    return pn;
  }

  inline void update_element_atts_states(html::context& pv, element* pel, tis::value pn, bool is_root)
  {
    tis::update_element_atts_states((tis::xview*)pv.pview(), pel, pn);
  }

  template<class A, class B>
  bool strong_identity(html::context& c, A a, B b) {
    if (node_tag(c,a) != node_tag(c,b))
      return false;
    ustring aid = node_key(c,a);
    ustring bid = node_key(c,b);
    if ((aid.is_defined() || bid.is_defined()) && (aid != bid))
      return false;
    return true;
  }

  inline bool node_equal(html::context& pv, tis::value a, html::hnode b)
  {
    node::NODE_TYPE nta = node_type(pv,a);
    if (nta != node_type(pv,b))
      return false;

    if (nta == html::node::NODE_TYPE::TEXT)
      return node_text(pv, a) == node_text(pv, b) ? true : false;

    if (nta != html::node::NODE_TYPE::ELEMENT)
      return false;

    tis::value vtag = CsVNodeTag(a);
    if(!CsSymbolP(vtag))
    {
      assert(CsMethodP(vtag) || CsClassP(vtag));
      tis::xview* pxv = (tis::xview*)pv.pview();
      if (tis::value eobj = element_object_nc(pxv->vm, b.ptr_of<element>())) {
        tis::value factorydef;
        if (CsEntityMeta(pxv->vm, eobj, sym_factory, factorydef)) {
          //dispatch* pda = CsGetDispatch(a);
          //dispatch* pdb = CsGetDispatch(factorydef);
          assert(CsVNodeP(a));
          assert(CsVNodeP(factorydef));
          if (CsVNodeTag(a) != CsVNodeTag(factorydef))
            return false;
          ustring aid = node_key(pv,a);
          ustring bid = node_key(pv,factorydef);
          if ((aid.is_defined() || bid.is_defined()) && (aid != bid))
            return false;
          return true;

        }
      }
      return false;
    }
    return strong_identity(pv,a, b);
  }

  
}

#endif
