#ifndef __xgraphics_h__
#define __xgraphics_h__

#include <math.h>

#include "xview.h"

//#include "gool_agg2d.h"
//#define pix_format agg::pix_format_bgra32

namespace tis {

  using namespace gool;

  inline gfx_ctl *graphics_ptr(value obj) {
    return (gfx_ctl *)CsCObjectValue(obj);
  }

  /*struct path_ctl : public resource {
    handle<gool::path> path;
    // handle<gool::path::sink> sink;  // path.reset(sink);
    path_ctl(xvm *c, gool::path *pp = nullptr) 
    {
      if (pp) {
        this->path = pp;
      } else if(auto a = app()) {
        this->path = a->create_path();
      }
    }
  };*/

  inline gool::path *path_ptr(value obj) {
    return (gool::path *)CsCObjectValue(obj);
  }

  struct text_ctl : public resource {
    handle<text_layout> tl;
    text_ctl(html::element* phost, wchars t, wchars cls) {
      if (html::view* pv = phost->pview())
      {
        tl = pv->create_text_layout(t);
        if (cls) tl->set_class(cls);
        tl->set_host(phost);
      }
    }

    void set_text(xview &v, const ustring &t) {
      tl->set_text(t());
    }

    virtual ~text_ctl() { tl = nullptr; }
  };

  inline text_ctl *text_ptr(value obj) {
    return (text_ctl *)CsCObjectValue(obj);
  }

  /*struct gool::image : public virtual  resource {
    handle<gool::image> img;
    string              url;

    gool::image() {}
    gool::image(const string &uri, gool::image *bi = 0) : url(uri), img(bi) {}

    static gool::image *create(gool::size sz, gool::argb clr) {
      gool::image *xim = new gool::image();
      if (!xim) return 0;

      gool::bitmap *bmp = new gool::bitmap(sz, true, true);
      bmp->clear(clr);
      xim->img = bmp;
      return xim;
    }

    static gool::image *create(tool::bytes data, html::document *pd) {
      gool::image *xim = new gool::image();
      if (!xim) return 0;
      handle<gool::image> img = gool::image::create(data, string(), pd);
      if (img) xim->img = img;
      return xim;
    }

    bool set_data(tool::array<byte> &data, const string &url, html::document *pd);
    bool set_data(const gool::bitmap *pbmp);

    // virtual bool on_data_arrived ( tool::array<byte>& data, const string& url
    // );  virtual void on_image_arrived(html::document* pd, gool::image* pimg);

    bool is_valid() const { return !!img; }
  };*/

  inline gool::image *image_ptr(xvm *c, value obj) {
    assert(CsGetDispatch(obj) == c->imageDispatch);
    if (!CsIsBaseType(obj, c->imageDispatch)) return 0;
    return static_cast<gool::image *>(CsCObjectValue(obj));
  }

  inline value image_object(xvm *c, gool::image *pimg) {
    pimg->add_ref();
    return CsMakeCPtrObject(c, c->imageDispatch, pimg);
  }

  inline value path_object(xvm *c, gool::path *pctl) {
    pctl->add_ref();
    return CsMakeCPtrObject(c, c->pathDispatch, pctl);
  }

} // namespace tis

#endif
